/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.AbstractMatlabTableModel;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.DoerCompletionObserver;
import com.mathworks.mlwidgets.array.InvertableRunnable;
import com.mathworks.mlwidgets.array.MatlabEvalDoer;
import com.mathworks.mlwidgets.array.UndoerCompletionObserver;
import com.mathworks.mlwidgets.array.ValueMetaInfo;
import com.mathworks.mlwidgets.array.ValueTableModel;
import com.mathworks.mlwidgets.array.VarEditorDataProxy;
import com.mathworks.mlwidgets.array.WorkspaceUndoManager;
import com.mathworks.mlwidgets.array.data.CategoricalScalar;
import com.mathworks.mlwidgets.array.data.DatetimeScalar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.spreadsheet.AbstractSpreadsheetTable;
import com.mathworks.widgets.spreadsheet.IAsynchronousContentAccessor;
import com.mathworks.widgets.spreadsheet.IMultipleBlockValueSetter;
import com.mathworks.widgets.spreadsheet.SpreadsheetUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class TabularObjectTableModel
extends AbstractMatlabTableModel
implements IMultipleBlockValueSetter,
IAsynchronousContentAccessor {
    private static int sNextHashValue = 0;
    private static final Map<Integer, String> ASSIGNMENT_HASH = new Hashtable<Integer, String>();
    private String fPastedString = null;
    private PasteType fInsertState = PasteType.PASTE;
    protected VarEditorDataProxy fDataProxy = null;
    private ActionListener fOpenActionListener;

    public TabularObjectTableModel(WorkspaceVariable workspaceVariable, VarEditorDataProxy varEditorDataProxy) {
        this(new ValueTableModel(workspaceVariable, true), workspaceVariable, true, varEditorDataProxy);
        assert (workspaceVariable.getWorkspaceID() == 0);
    }

    public TabularObjectTableModel(WorkspaceVariable workspaceVariable, VarEditorDataProxy varEditorDataProxy, boolean bl) {
        this(new ValueTableModel(workspaceVariable, true), workspaceVariable, true, varEditorDataProxy);
        if (!bl) assert (workspaceVariable.getWorkspaceID() == 0);
    }

    protected TabularObjectTableModel(ValueTableModel valueTableModel, WorkspaceVariable workspaceVariable, boolean bl, VarEditorDataProxy varEditorDataProxy) {
        super(valueTableModel, workspaceVariable, bl);
        this.fDataProxy = varEditorDataProxy;
    }

    public void printSetup(int n, int n2, int n3, int n4) {
        if (this.fModel instanceof ValueTableModel) {
            ((ValueTableModel)this.fModel).printSetup(n, n2 > this.getLastDataRow() ? this.getLastDataRow() : n2, n3, n4 > this.getLastDataColumn() ? this.getLastDataColumn() : n4);
        }
    }

    void rename(String string) {
        this.setVariableName(string);
        if (this.fModel instanceof ValueTableModel) {
            ((ValueTableModel)this.fModel).setVariableName(string);
        }
    }

    @Override
    public void clearRegion(int[] nArray, int[] nArray2) {
        List list = AbstractSpreadsheetTable.getSelectionIntervals((int[])nArray);
        List list2 = AbstractSpreadsheetTable.getSelectionIntervals((int[])nArray2);
        if (list.isEmpty() || list2.isEmpty()) {
            return;
        }
        this.fDataProxy.clearRegion(this.getVariable(), list, list2, this.fUndoManager);
    }

    @Override
    public boolean isRegionDeletable(int[] nArray, int[] nArray2, int n) {
        return false;
    }

    @Override
    public void deleteRegion(int[] nArray, int[] nArray2, int n) {
    }

    @Override
    public boolean areRowsInsertable(int[] nArray) {
        return false;
    }

    @Override
    public void insertRows(int[] nArray) {
    }

    @Override
    public void deleteRows(int[] nArray) {
    }

    @Override
    public boolean areColumnsInsertable(int[] nArray) {
        return false;
    }

    @Override
    public void insertColumns(int[] nArray) {
    }

    @Override
    public void deleteColumns(int[] nArray) {
    }

    @Override
    public boolean isRegionInsertable(int[] nArray, int[] nArray2, int n) {
        return false;
    }

    @Override
    public void insertRegion(int[] nArray, int[] nArray2, int n) {
    }

    public void deleteTableObjectColumns(List<int[]> list) {
        this.fDataProxy.deleteTableObjectColumns(this.getVariable(), list, this.fUndoManager);
    }

    public void deleteTableObjectRows(List<int[]> list) {
        this.fDataProxy.deleteTableObjectRows(this.getVariable(), list, this.fUndoManager);
    }

    void setVariableUnits(String string, int n) {
        this.fDataProxy.setMetadata(this.getVariable(), n + 1, "Units", string, this.fUndoManager);
    }

    public String getPasteErrorString() {
        return ArrayUtils.getResource("dataset.PasteGeneralIncompatability");
    }

    public void evalMatlabString(String string, boolean bl) {
        this.evalMatlabString(string, bl, false, null);
    }

    public void evalMatlabString(String string, boolean bl, Runnable runnable) {
        this.evalMatlabString(string, bl, false, runnable);
    }

    public void evalMatlabString(String string, boolean bl, boolean bl2) {
        this.evalMatlabString(string, bl, bl2, null);
    }

    public void evalMatlabString(String string, boolean bl, boolean bl2, Runnable runnable) {
        MatlabEvalDoer matlabEvalDoer = new MatlabEvalDoer(this.getVariableName(), string, bl2, bl, this.fUndoManager, WorkspaceUndoManager.getNewKey(this.fUndoManager));
        if (runnable != null) {
            matlabEvalDoer.setRunnableToExecuteAtEnd(runnable);
        }
        matlabEvalDoer.run();
    }

    void setVariableDescription(String string, int n) {
        this.fDataProxy.setMetadata(this.getVariable(), n + 1, "VarDescription", string, this.fUndoManager);
    }

    void setVariableFormat(String string) {
        this.fDataProxy.setMetadata(this.getVariable(), 1, "Format", string, this.fUndoManager);
    }

    String getVariableFormat(String string) {
        String string2 = null;
        try {
            string2 = (String)Matlab.mtFeval((String)"eval", (Object[])new Object[]{"variableEditorMetadata(" + string + ");"}, (int)1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    void setObservationName(String string, int n) {
        this.fDataProxy.renameRow(this.getVariable(), n + 1, string, this.fUndoManager);
    }

    void sortAscending(String[] stringArray) {
        this.sort(stringArray, true);
    }

    private void sort(String[] stringArray, boolean bl) {
        this.fDataProxy.sort(this.getVariable(), stringArray, bl, this.fUndoManager);
    }

    void sortDescending(String[] stringArray) {
        this.sort(stringArray, false);
    }

    protected void toCategorical(String string) {
        String string2 = this.getVariableName() + "." + string + " = categorical(" + this.getVariableName() + "." + string + ");";
        this.evalMatlabString(string2, true, false);
    }

    private int createHashValueForPaste(Object[][] objectArray) {
        StringBuilder stringBuilder = new StringBuilder("{");
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object[] objectArray2 = objectArray[i];
            int n2 = objectArray2.length;
            for (int j = 0; j < n2; ++j) {
                String string;
                Object object = objectArray2[j];
                String string2 = string = object == null ? "null" : object.toString();
                if (!string.isEmpty()) {
                    block6: {
                        try {
                            Double.parseDouble(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (string.matches("^'.*'$")) break block6;
                            string = "'" + StringUtils.quoteSingleQuotes((String)string) + "'";
                        }
                    }
                    stringBuilder.append(string);
                }
                if (j < n2 - 1) {
                    stringBuilder.append(", ");
                    continue;
                }
                if (i >= n - 1) continue;
                stringBuilder.append(';');
            }
        }
        stringBuilder.append('}');
        this.fPastedString = stringBuilder.toString();
        return TabularObjectTableModel.putStringIntoHashTable(this.fPastedString);
    }

    public void setValuesAt(Object[][] objectArray, int n, int n2) {
        if (objectArray != null && objectArray.length > 0) {
            int n3 = this.createHashValueForPaste(objectArray);
            WorkspaceUndoManager.UndoKey undoKey = WorkspaceUndoManager.getNewKey(this.fUndoManager);
            ArrayList<int[]> arrayList = new ArrayList<int[]>();
            arrayList.add(new int[]{n, n});
            ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
            arrayList2.add(new int[]{n2, n2});
            new SetValuesAtDoer(this.getVariableName(), arrayList, arrayList2, Integer.toString(n3), this.fInsertState, undoKey).run();
        }
    }

    public void setValuesAt(Object[][] objectArray, List<int[]> list, List<int[]> list2) {
        if (objectArray != null && objectArray.length > 0) {
            int n = this.createHashValueForPaste(objectArray);
            WorkspaceUndoManager.UndoKey undoKey = WorkspaceUndoManager.getNewKey(this.fUndoManager);
            new SetValuesAtDoer(this.getVariableName(), list, list2, Integer.toString(n), this.fInsertState, undoKey).run();
        }
    }

    int[] getVariableGridSize() {
        return new int[]{this.fModel.getRowCount(), this.fModel.getColumnCount()};
    }

    void setInsertState(PasteType pasteType) {
        this.fInsertState = pasteType;
    }

    void evalMatlabPasteExpression(String string) {
        WorkspaceUndoManager.UndoKey undoKey = WorkspaceUndoManager.getNewKey(this.fUndoManager);
        new DatasetPasteDoer(this.getVariableName(), string, undoKey, null).run();
    }

    void evalMatlabPasteExpression(String string, Runnable runnable) {
        WorkspaceUndoManager.UndoKey undoKey = WorkspaceUndoManager.getNewKey(this.fUndoManager);
        new DatasetPasteDoer(this.getVariableName(), string, undoKey, runnable).run();
    }

    private static int putStringIntoHashTable(String string) {
        int n = sNextHashValue++;
        ASSIGNMENT_HASH.put(n, string);
        return n;
    }

    public static String getHashedAssignmentRHS(int n) {
        String string = ASSIGNMENT_HASH.get(n);
        ASSIGNMENT_HASH.remove(n);
        return string;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (ASSIGNMENT_HASH != null) {
            ASSIGNMENT_HASH.clear();
        }
    }

    void move(int n, int n2) {
        this.fDataProxy.moveColumn(this.getVariable(), n, n2, this.fUndoManager);
    }

    public void setValueMetaInfo(ValueMetaInfo valueMetaInfo) {
        ((ValueTableModel)this.fModel).setValueMetaInfo(valueMetaInfo);
    }

    public boolean areValuesSettable(int n, int n2, int n3, int n4) {
        return true;
    }

    @Override
    protected String getIndexingOpenToken() {
        return "(";
    }

    @Override
    protected String getIndexingCloseToken() {
        return ")";
    }

    @Override
    protected String getEmptyValueConstructor() {
        return "";
    }

    public Class<?> getColumnClass(int n) {
        Object object = this.getValueAt(0, n);
        if (object instanceof CategoricalScalar) {
            return CategoricalScalar.class;
        }
        if (object instanceof DatetimeScalar) {
            return DatetimeScalar.class;
        }
        return Object.class;
    }

    public void setOpenActionListener(ActionListener actionListener) {
        this.fOpenActionListener = actionListener;
    }

    boolean openVariable(final String string) {
        if (this.fOpenActionListener != null) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    TabularObjectTableModel.this.fOpenActionListener.actionPerformed(new ActionEvent(this, 1001, string));
                }
            });
            return true;
        }
        return false;
    }

    private static class PasteDoerCompletionObserver
    extends DoerCompletionObserver {
        private final Runnable iSelectionCallback;

        PasteDoerCompletionObserver(InvertableRunnable invertableRunnable, WorkspaceUndoManager workspaceUndoManager, Runnable runnable) {
            super(invertableRunnable, workspaceUndoManager);
            this.iSelectionCallback = runnable;
        }

        @Override
        public void completed(int n, Object object) {
            super.completed(n, object);
            if (this.iSelectionCallback != null && Matlab.getExecutionStatus((int)n) == 0) {
                this.iSelectionCallback.run();
            }
        }
    }

    private class MatlabEvalUndoer
    implements InvertableRunnable {
        private final WorkspaceUndoManager.UndoKey iKey;
        private final String iEvalStr;
        private final String iVarName;

        MatlabEvalUndoer(String string, String string2, WorkspaceUndoManager.UndoKey undoKey) {
            this.iEvalStr = string2;
            this.iKey = undoKey;
            this.iVarName = string;
        }

        @Override
        public void run() {
            if (TabularObjectTableModel.this.fUndoManager != null) {
                TabularObjectTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            String string = WorkspaceUndoManager.UndoKey.translateKeyForMatlab(this.iKey);
            TabularObjectTableModel.this.getUserActionMCR().eval(this.iVarName + " = arrayviewfunc('retrieveAndClearValue', " + string + ");", TabularObjectTableModel.this.getRefreshErrorDialogCO(TabularObjectTableModel.this.getPasteErrorString(), new UndoerCompletionObserver(TabularObjectTableModel.this.fUndoManager)));
        }

        @Override
        public InvertableRunnable getInverse() {
            return new DatasetPasteDoer(this.iVarName, this.iEvalStr, this.iKey);
        }
    }

    private class DatasetPasteDoer
    implements InvertableRunnable {
        private final WorkspaceUndoManager.UndoKey iKey;
        private final String iEvalStr;
        private final String iVarName;
        private Runnable iSelectionCallback;

        DatasetPasteDoer(String string, String string2, WorkspaceUndoManager.UndoKey undoKey, Runnable runnable) {
            this.iEvalStr = string2;
            this.iKey = undoKey;
            this.iVarName = string;
            this.iSelectionCallback = runnable;
        }

        DatasetPasteDoer(String string, String string2, WorkspaceUndoManager.UndoKey undoKey) {
            this.iEvalStr = string2;
            this.iKey = undoKey;
            this.iVarName = string;
        }

        @Override
        public void run() {
            if (TabularObjectTableModel.this.fUndoManager != null) {
                TabularObjectTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            String string = WorkspaceUndoManager.UndoKey.translateKeyForMatlab(this.iKey);
            String string2 = "arrayviewfunc('storeValue'," + string + "," + this.iVarName + ");";
            TabularObjectTableModel.this.getUserActionMCR().eval(string2 + this.iEvalStr, TabularObjectTableModel.this.getRefreshErrorDialogCO(TabularObjectTableModel.this.getPasteErrorString(), new PasteDoerCompletionObserver((InvertableRunnable)this, TabularObjectTableModel.this.fUndoManager, this.iSelectionCallback)));
        }

        @Override
        public InvertableRunnable getInverse() {
            return new MatlabEvalUndoer(this.iVarName, this.iEvalStr, this.iKey);
        }
    }

    private class SetValuesAtUndoer
    implements InvertableRunnable {
        private final String iVarName;
        private final List<int[]> iRowIntervals;
        private final List<int[]> iColumnIntervals;
        private PasteType iInsertState = PasteType.PASTE;
        private final WorkspaceUndoManager.UndoKey iKey;

        SetValuesAtUndoer(String string, List<int[]> list, List<int[]> list2, String string2, PasteType pasteType, WorkspaceUndoManager.UndoKey undoKey) {
            this.iVarName = string;
            this.iRowIntervals = list;
            this.iColumnIntervals = list2;
            this.iInsertState = pasteType;
            this.iKey = undoKey;
        }

        @Override
        public void run() {
            if (TabularObjectTableModel.this.fUndoManager != null) {
                TabularObjectTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            String string = WorkspaceUndoManager.UndoKey.translateKeyForMatlab(this.iKey);
            TabularObjectTableModel.this.getUserActionMCR().eval(this.iVarName + " = arrayviewfunc('undoHashedAssignment', " + string + ");", TabularObjectTableModel.this.getRefreshErrorDialogCO(TabularObjectTableModel.this.getPasteErrorString(), new UndoerCompletionObserver(TabularObjectTableModel.this.fUndoManager)));
        }

        @Override
        public InvertableRunnable getInverse() {
            return new SetValuesAtDoer(this.iVarName, this.iRowIntervals, this.iColumnIntervals, null, this.iInsertState, this.iKey);
        }
    }

    protected class SetValuesAtDoer
    implements InvertableRunnable {
        private final String iVarName;
        private String iHashValue;
        private final WorkspaceUndoManager.UndoKey iKey;
        private final List<int[]> iRowIntervals;
        private final List<int[]> iColumnIntervals;
        private PasteType iInsertState = PasteType.PASTE;

        protected SetValuesAtDoer(String string, List<int[]> list, List<int[]> list2, String string2, PasteType pasteType, WorkspaceUndoManager.UndoKey undoKey) {
            this.iVarName = string;
            this.iHashValue = string2;
            this.iRowIntervals = list;
            this.iColumnIntervals = list2;
            this.iInsertState = pasteType;
            this.iKey = undoKey;
        }

        @Override
        public void run() {
            if (TabularObjectTableModel.this.fUndoManager != null) {
                TabularObjectTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            if (this.iHashValue == null) {
                this.iHashValue = Integer.toString(TabularObjectTableModel.putStringIntoHashTable(TabularObjectTableModel.this.fPastedString));
            }
            String string = WorkspaceUndoManager.UndoKey.translateKeyForMatlab(this.iKey);
            String string2 = "arrayviewfunc('storeValue'," + string + "," + this.iVarName + ");";
            int n = this.iColumnIntervals.get(0)[0];
            int n2 = this.iColumnIntervals.get(0)[1] - this.iColumnIntervals.get(0)[0] + 1;
            int n3 = this.iRowIntervals.get(0)[0];
            int n4 = this.iRowIntervals.get(0)[1] - this.iRowIntervals.get(0)[0] + 1;
            String string3 = this.getEvalStringForPaste(n, n2, n3, n4);
            TabularObjectTableModel.this.getUserActionMCR().eval(string2 + string3, TabularObjectTableModel.this.getRefreshErrorDialogCO(TabularObjectTableModel.this.getPasteErrorString(), new DoerCompletionObserver(this, TabularObjectTableModel.this.fUndoManager)));
        }

        protected String getEvalStringForPaste(int n, int n2, int n3, int n4) {
            int n5;
            int n6 = this.iInsertState == PasteType.INSERTCOLUMNS_RIGHT ? n2 + 1 : 1;
            int n7 = n5 = this.iInsertState == PasteType.INSERTROWS_BELOW ? n4 + 1 : 1;
            String string = this.iInsertState == PasteType.INSERTCOLUMNS || this.iInsertState == PasteType.INSERTCOLUMNS_RIGHT ? this.iVarName + " = variableEditorInsert(" + this.iVarName + ",'columns'," + Integer.toString(n3 + n5) + "," + Integer.toString(n + n6) + "," + "eval(com.mathworks.mlwidgets.array.TabularObjectTableModel.getHashedAssignmentRHS(" + this.iHashValue + ").toString));" : (this.iInsertState == PasteType.INSERTROWS || this.iInsertState == PasteType.INSERTROWS_BELOW ? this.iVarName + " = variableEditorInsert(" + this.iVarName + ",'rows'," + Integer.toString(n3 + n5) + "," + Integer.toString(n + n6) + "," + "eval(com.mathworks.mlwidgets.array.TabularObjectTableModel.getHashedAssignmentRHS(" + this.iHashValue + ").toString));" : this.iVarName + " = variableEditorPaste(" + this.iVarName + "," + SpreadsheetUtils.getSelectionString(this.iRowIntervals, (int)-1) + "," + SpreadsheetUtils.getSelectionString(this.iColumnIntervals, (int)-1) + "," + "eval(com.mathworks.mlwidgets.array.TabularObjectTableModel.getHashedAssignmentRHS(" + this.iHashValue + ").toString));");
            return string;
        }

        @Override
        public InvertableRunnable getInverse() {
            return new SetValuesAtUndoer(this.iVarName, this.iRowIntervals, this.iColumnIntervals, this.iHashValue, this.iInsertState, this.iKey);
        }
    }

    public static enum PasteType {
        PASTE(false),
        INSERTROWS(true),
        INSERTCOLUMNS(true),
        INSERTROWS_BELOW(true),
        INSERTCOLUMNS_RIGHT(true);

        private final boolean iInsert;

        private PasteType(boolean bl) {
            this.iInsert = bl;
        }

        public boolean isInsert() {
            return this.iInsert;
        }
    }
}

