/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.CommonInsDelToolsetSupplier;
import com.mathworks.mlwidgets.array.FormatToolsetSupplierFactory;
import com.mathworks.mlwidgets.array.ISortLabelProvider;
import com.mathworks.mlwidgets.array.ISortProvider;
import com.mathworks.mlwidgets.array.ITableController;
import com.mathworks.mlwidgets.array.ITransposeProvider;
import com.mathworks.mlwidgets.array.ValueEditorProvider;
import com.mathworks.mlwidgets.array.VariableCodeGenProvider;
import com.mathworks.mlwidgets.array.VariableCreationSupplier;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingAdapter;
import com.mathworks.services.settings.SettingChangeEvent;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingListener;
import com.mathworks.toolstrip.components.TSButton;
import com.mathworks.toolstrip.components.TSCheckBox;
import com.mathworks.toolstrip.components.TSLabel;
import com.mathworks.toolstrip.components.TSTextField;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.util.Disposable;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import com.mathworks.widgets.datatransfer.VariableIdentifierProvider;
import com.mathworks.widgets.desk.DTToolstripFactory;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.spreadsheet.IRegionOpProvider;
import com.mathworks.widgets.spreadsheet.ISpreadsheetSelectionController;
import com.mathworks.widgets.spreadsheet.RangeSelectionModel;
import com.mathworks.widgets.spreadsheet.SpreadsheetActions;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nullable;

class VariableToolFactory {
    private VariableToolFactory() {
    }

    static void getTools(String string, Object object, TSToolSet tSToolSet, TSToolSet tSToolSet2) {
        Object object2;
        VariableToolFactory.setupPrintOptions(object, tSToolSet);
        VariableToolFactory.setupRangeSelection(string, object, tSToolSet);
        if (object instanceof IRegionOpProvider) {
            object2 = (IRegionOpProvider)object;
            tSToolSet.addSupplier("insert", (TSToolSet.ToolSupplier)new InsertToolsetSupplier(tSToolSet, (IRegionOpProvider)object2, ArrayUtils.getResource("insert.Title"), new IRegionOpProvider.Scope[]{IRegionOpProvider.Scope.ROWS, IRegionOpProvider.Scope.ROWS_BELOW, IRegionOpProvider.Scope.COLUMNS, IRegionOpProvider.Scope.COLUMNS_TO_THE_RIGHT}));
            tSToolSet.addSupplier("delete", (TSToolSet.ToolSupplier)new DeleteToolsetSupplier(tSToolSet, (IRegionOpProvider)object2, ArrayUtils.getResource("delete.Title"), new IRegionOpProvider.Scope[]{IRegionOpProvider.Scope.ROWS, IRegionOpProvider.Scope.COLUMNS}));
        } else {
            tSToolSet.addSupplier("insert", (TSToolSet.ToolSupplier)new InsertToolsetSupplier(tSToolSet, null, ArrayUtils.getResource("insert.Title"), new IRegionOpProvider.Scope[0]));
            tSToolSet.addSupplier("delete", (TSToolSet.ToolSupplier)new DeleteToolsetSupplier(tSToolSet, null, ArrayUtils.getResource("delete.Title"), new IRegionOpProvider.Scope[0]));
        }
        tSToolSet.addSupplier("create", (TSToolSet.ToolSupplier)new VariableCreationSupplier(object));
        VariableToolFactory.setupSorting(object, tSToolSet);
        VariableToolFactory.setupTranspose(object, tSToolSet, string);
        if (object instanceof ValueEditorProvider) {
            FormatToolsetSupplierFactory.createSupplier(tSToolSet2, (ValueEditorProvider)object, string);
        }
        if (string != null) {
            tSToolSet2.configureAndAdd("go_up", (Action)((Object)new ArrayUtils.UpAction(string)));
        }
        VariableToolFactory.setupCodeGen(object, tSToolSet2);
        object2 = DTToolstripFactory.getDocumentArrangementActions((Desktop)MatlabDesktopServices.getDesktop(), (String)"Array Editor");
        for (DTToolstripFactory.DocumentArrangement documentArrangement : DTToolstripFactory.DocumentArrangement.values()) {
            tSToolSet2.configureAndAdd(documentArrangement.name().toLowerCase(), (Action)object2.get(documentArrangement));
        }
    }

    private static void setupCodeGen(Object object, TSToolSet tSToolSet) {
        if (object instanceof VariableCodeGenProvider) {
            final VariableCodeGenProvider variableCodeGenProvider = (VariableCodeGenProvider)object;
            tSToolSet.addSupplier("codegen", new TSToolSet.ToolSupplier(){

                public JComponent createTool(TSToolSet.ToolLocation toolLocation) {
                    CodeGenCheckbox codeGenCheckbox = new CodeGenCheckbox();
                    codeGenCheckbox.setAction((Action)new MJAbstractAction(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            boolean bl = ((AbstractButton)actionEvent.getSource()).isSelected();
                            variableCodeGenProvider.codeGenSettingChanged(bl);
                        }
                    });
                    codeGenCheckbox.setSelected(variableCodeGenProvider.isCodeGenEnabled());
                    codeGenCheckbox.setText(ArrayUtils.getResource("variable.toolstrip.codegen.label"));
                    codeGenCheckbox.setToolTipText(ArrayUtils.getResource("variable.toolstrip.codegen.Description"));
                    return codeGenCheckbox;
                }
            });
        } else {
            tSToolSet.getContents().removeTool("codegen_section", new TSToolSetContents.Dependency[]{new TSToolSetContents.Dependency("variable_view_toolset")});
        }
    }

    private static void setupPrintOptions(Object object, TSToolSet tSToolSet) {
        tSToolSet.configureAndAdd("print", (Action)new ChildAction(SpreadsheetActions.getPrintAction((Object)object)));
        tSToolSet.configureAndAdd("print_all", SpreadsheetActions.getPrintAction((Object)object));
        tSToolSet.configureAndAdd("print_selection", SpreadsheetActions.getPrintSelectionAction((Object)object));
        tSToolSet.configureAndAdd("page_setup", SpreadsheetActions.getPageSetupAction((Object)object));
    }

    private static void setupRangeSelection(final String string, Object object, TSToolSet tSToolSet) {
        if (object instanceof ISpreadsheetSelectionController) {
            final ISpreadsheetSelectionController iSpreadsheetSelectionController = (ISpreadsheetSelectionController)object;
            tSToolSet.addSupplier("row_range", new TSToolSet.ToolSupplier(){

                public JComponent createTool(TSToolSet.ToolLocation toolLocation) {
                    return new RangeSelectionTextField(string, IRegionOpProvider.Scope.ROWS, iSpreadsheetSelectionController.getSpreadsheetRowSelectionModel());
                }
            });
            tSToolSet.addSupplier("column_range", new TSToolSet.ToolSupplier(){

                public JComponent createTool(TSToolSet.ToolLocation toolLocation) {
                    return new RangeSelectionTextField(string, IRegionOpProvider.Scope.COLUMNS, iSpreadsheetSelectionController.getSpreadsheetColumnSelectionModel());
                }
            });
        } else {
            tSToolSet.addSupplier("row_range_label", new TSToolSet.ToolSupplier(){

                public JComponent createTool(TSToolSet.ToolLocation toolLocation) {
                    TSLabel tSLabel = new TSLabel(ArrayUtils.getResource("variable.toolstrip.rows.label"));
                    tSLabel.setForeground(Color.GRAY);
                    return tSLabel;
                }
            });
            tSToolSet.addSupplier("column_range_label", new TSToolSet.ToolSupplier(){

                public JComponent createTool(TSToolSet.ToolLocation toolLocation) {
                    TSLabel tSLabel = new TSLabel(ArrayUtils.getResource("variable.toolstrip.columns.label"));
                    tSLabel.setForeground(Color.GRAY);
                    return tSLabel;
                }
            });
        }
    }

    private static void setupSorting(Object object, TSToolSet tSToolSet) {
        if (object instanceof ISortProvider) {
            SortAction sortAction = new SortAction((ISortProvider)object, ITableController.SortDirection.ASCENDING);
            tSToolSet.configureAndAdd("sort", (Action)((Object)sortAction));
            tSToolSet.addListDecorator("sort", (TSToolSet.ListDecorator)sortAction);
            SortAction sortAction2 = new SortAction((ISortProvider)object, ITableController.SortDirection.ASCENDING);
            tSToolSet.configureAndAdd("sort_ascending", (Action)((Object)sortAction2));
            SortAction sortAction3 = new SortAction((ISortProvider)object, ITableController.SortDirection.DESCENDING);
            tSToolSet.configureAndAdd("sort_descending", (Action)((Object)sortAction3));
            if (object instanceof ISortLabelProvider) {
                ISortLabelProvider iSortLabelProvider = (ISortLabelProvider)object;
                sortAction2.setName(iSortLabelProvider.getSortLabel(ITableController.SortDirection.ASCENDING));
                sortAction3.setName(iSortLabelProvider.getSortLabel(ITableController.SortDirection.DESCENDING));
                sortAction.setTip(iSortLabelProvider.getSortTooltip(ITableController.SortDirection.ASCENDING));
            }
        }
    }

    private static void setupTranspose(Object object, TSToolSet tSToolSet, String string) {
        if (object instanceof ITransposeProvider) {
            TransposeVariableAction transposeVariableAction = new TransposeVariableAction((ITransposeProvider)object);
            tSToolSet.configureAndAdd("transpose", (Action)((Object)transposeVariableAction));
            transposeVariableAction.setTip(ArrayUtils.getResource("transpose.Tooltip", string));
        }
    }

    private static double[] getSelectedIntervalsFromMatlab(IRegionOpProvider.Scope scope, String string, String string2) {
        try {
            if (scope == IRegionOpProvider.Scope.ROWS) {
                return (double[])Matlab.mtEvalNoBreakpoints((String)("arrayviewfunc('getSelectionIntervals'," + string + ",'" + string2 + "','rows')"), (int)1);
            }
            return (double[])Matlab.mtEvalNoBreakpoints((String)("arrayviewfunc('getSelectionIntervals'," + string + ",'" + string2 + "','columns')"), (int)1);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static class DeleteToolsetSupplier
    extends CommonInsDelToolsetSupplier {
        DeleteToolsetSupplier(TSToolSet tSToolSet, IRegionOpProvider iRegionOpProvider, String string, IRegionOpProvider.Scope[] scopeArray) {
            super(tSToolSet, iRegionOpProvider, string, scopeArray, "delete");
        }

        @Override
        MJAbstractAction getActionForScope(IRegionOpProvider.Scope scope) {
            return (MJAbstractAction)this.fRegionOpProvider.getDeleteAction(scope, 0);
        }
    }

    private static class InsertToolsetSupplier
    extends CommonInsDelToolsetSupplier {
        InsertToolsetSupplier(TSToolSet tSToolSet, IRegionOpProvider iRegionOpProvider, String string, IRegionOpProvider.Scope[] scopeArray) {
            super(tSToolSet, iRegionOpProvider, string, scopeArray, "insert");
        }

        @Override
        MJAbstractAction getActionForScope(IRegionOpProvider.Scope scope) {
            return (MJAbstractAction)this.fRegionOpProvider.getInsertAction(scope, 0);
        }
    }

    private static class RangeSelectionTextField
    extends TSTextField
    implements ChangeListener,
    FocusListener,
    ActionListener,
    Disposable {
        private final IRegionOpProvider.Scope iOrientation;
        private final RangeSelectionModel iModel;
        private final String iVarName;
        private MatlabWorker<List<int[]>> iSelectionParseWorker;

        RangeSelectionTextField(String string, IRegionOpProvider.Scope scope, RangeSelectionModel rangeSelectionModel) {
            super("", 7);
            this.iOrientation = scope;
            this.iVarName = string;
            this.iModel = rangeSelectionModel;
            rangeSelectionModel.addSelectionRangeListener((ChangeListener)this);
            this.addFocusListener(this);
            this.addActionListener(this);
            if (Matlab.isMatlabAvailable()) {
                this.iSelectionParseWorker = new MatlabWorker<List<int[]>>(){

                    public List<int[]> runOnMatlabThread() {
                        double[] dArray = VariableToolFactory.getSelectedIntervalsFromMatlab(RangeSelectionTextField.this.iOrientation, RangeSelectionTextField.this.iVarName, RangeSelectionTextField.this.getText());
                        if (dArray == null) {
                            return null;
                        }
                        ArrayList<int[]> arrayList = new ArrayList<int[]>();
                        for (int i = 0; i < dArray.length / 2; ++i) {
                            arrayList.add(new int[]{(int)dArray[i] - 1, (int)dArray[i + dArray.length / 2] - 1});
                        }
                        return arrayList;
                    }

                    public void runOnAWTEventDispatchThread(List<int[]> list) {
                        RangeSelectionTextField.this.setSelectionIntervals(list);
                    }
                };
                this.stateChanged(null);
            }
        }

        private void setSelectionIntervals(List<int[]> list) {
            if (list == null) {
                this.setText(this.iModel.getSelectionRangeString());
                return;
            }
            this.iModel.setSelectionIntervals(list);
            this.setText(this.iModel.getSelectionRangeString());
        }

        @Override
        public void stateChanged(@Nullable ChangeEvent changeEvent) {
            this.setText(this.iModel.getSelectionRangeString());
        }

        public void dispose() {
            this.iModel.removeSelectionRangeListener((ChangeListener)this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.iSelectionParseWorker != null && !this.iModel.getSelectionRangeString().equals(this.getText())) {
                this.iSelectionParseWorker.start();
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.setText(this.iModel.getSelectionRangeString());
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary() && this.iSelectionParseWorker != null && !this.iModel.getSelectionRangeString().equals(this.getText())) {
                this.iSelectionParseWorker.start();
            }
        }

        public void setText(String string) {
            super.setText(string);
            int n = this.getFontMetrics(this.getFont()).stringWidth(string);
            if (n > this.getWidth()) {
                this.setToolTipText(string);
            } else {
                this.setToolTipText(null);
            }
        }
    }

    private static class SortAction
    extends MJAbstractAction
    implements TSToolSet.ListDecorator,
    ListActionListener {
        private ISortProvider fProvider = null;
        private final ITableController.SortDirection fSortDirection;

        private SortAction(ISortProvider iSortProvider, ITableController.SortDirection sortDirection) {
            super("sort");
            if (iSortProvider instanceof VariableIdentifierProvider) {
                final VariableIdentifierProvider variableIdentifierProvider = (VariableIdentifierProvider)iSortProvider;
                variableIdentifierProvider.addVariableIdentifierListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        if (!listSelectionEvent.getValueIsAdjusting()) {
                            SortAction.this.setEnabled(SortAction.isEnabled(variableIdentifierProvider));
                        }
                    }
                });
                this.setEnabled(SortAction.isEnabled(variableIdentifierProvider));
            }
            this.fProvider = iSortProvider;
            this.fSortDirection = sortDirection;
        }

        private static boolean isEnabled(VariableIdentifierProvider variableIdentifierProvider) {
            VariableIdentifier variableIdentifier = variableIdentifierProvider.getVariableIdentifier();
            String string = variableIdentifier.getVariable();
            if (string == null) {
                string = variableIdentifier.getExpression();
            }
            boolean bl = false;
            if (string != null && variableIdentifierProvider instanceof ISortProvider) {
                bl = ((ISortProvider)variableIdentifierProvider).isSortEnabledForSelection();
            }
            return bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof TSButton) {
                this.doSort(this.fSortDirection);
            }
        }

        private void doSort(ITableController.SortDirection sortDirection) {
            if (this.fProvider != null) {
                this.fProvider.sortRows(sortDirection);
            }
        }

        public void decorateList(PopupList popupList) {
            boolean bl = false;
            if (this.fProvider != null && this.fProvider instanceof VariableIdentifierProvider) {
                bl = SortAction.isEnabled((VariableIdentifierProvider)this.fProvider);
            }
            for (int i = 0; i < popupList.getModel().getSize(); ++i) {
                ListItem listItem = (ListItem)popupList.getModel().getElementAt(i);
                listItem.setAttribute((Attribute)ListItem.ENABLED_STATE, (Object)bl);
            }
            popupList.addListActionListener((ListActionListener)this);
        }

        public void listItemSelected(ListActionEvent listActionEvent) {
            ListItem listItem = listActionEvent.getListItem();
            String string = listItem.getName();
            if (string.contains("descending")) {
                this.doSort(ITableController.SortDirection.DESCENDING);
            } else {
                this.doSort(ITableController.SortDirection.ASCENDING);
            }
        }
    }

    private static class TransposeVariableAction
    extends MJAbstractAction {
        private ITransposeProvider fProvider = null;

        private TransposeVariableAction(ITransposeProvider iTransposeProvider) {
            super("transpose");
            this.setEnabled(true);
            this.fProvider = iTransposeProvider;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fProvider.transposeVariable();
        }
    }

    private static class CodeGenCheckbox
    extends TSCheckBox
    implements Disposable {
        private SettingListener iSettingListener = new SettingAdapter(){

            public void settingChanged(final SettingChangeEvent settingChangeEvent) {
                MJUtilities.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CodeGenCheckbox.this.setSelected((Boolean)((Setting)settingChangeEvent.getSource()).get());
                        }
                        catch (SettingException settingException) {
                            throw new RuntimeException(settingException);
                        }
                    }
                });
            }
        };

        private CodeGenCheckbox() {
            ArrayUtils.addCodeGenerationSettingListener(this.iSettingListener);
        }

        public void dispose() {
            ArrayUtils.removeCodeGenerationSettingListener(this.iSettingListener);
        }
    }
}

