/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.DefaultObjectConverter;
import com.jidesoft.converter.EnumConverter;
import com.jidesoft.converter.IntegerConverter;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;
import com.mathworks.mlwidgets.configeditor.data.PublishOptions;
import com.mathworks.util.ArrayUtils;

public class ConfigurationJideUtils {
    private static boolean sConvertersInited = false;

    private ConfigurationJideUtils() {
    }

    public static void initConverters() {
        if (!sConvertersInited) {
            ObjectConverterManager.registerConverter(Boolean.class, (ObjectConverter)new BooleanConverter(), (ConverterContext)new ConverterContext("matlabBoolean"));
            ObjectConverterManager.registerConverter(Integer.class, (ObjectConverter)new IntegerWithInfinityConverter(), (ConverterContext)new ConverterContext("integerWithInfinity"));
            ObjectConverterManager.registerConverter(PublishOptions.FigureCaptureMethod.class, (ObjectConverter)new FigureCaptureMethodConverter(), (ConverterContext)new ConverterContext("figureCaptureMethod"));
            ObjectConverterManager.registerConverter(PublishOptions.FileFormat.class, (ObjectConverter)new FileFormatConverter(), (ConverterContext)new ConverterContext("fileFormat"));
            ObjectConverterManager.registerConverter(PublishOptions.ImageFormat.class, (ObjectConverter)new ImageFormatConverter(), (ConverterContext)new ConverterContext("imageFormat"));
            sConvertersInited = true;
        }
    }

    private static class CustomEnumConverter
    extends EnumConverter {
        private Object[] fObjects;
        private String[] fStrings;

        private CustomEnumConverter(Object[] objectArray, Class<?> clazz) {
            super("customConverter", clazz, ArrayUtils.EmptyObjects.OBJECT, ArrayUtils.EmptyObjects.STRING);
            this.fObjects = objectArray;
            this.fStrings = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                this.fStrings[i] = objectArray.toString();
            }
        }

        public Object[] getObjects() {
            return this.fObjects;
        }

        public String[] getStrings() {
            return this.fStrings;
        }
    }

    public static class ImageFormatWithDefaultSupportConverter
    extends CustomEnumConverter {
        private final PublishOptions.ImageFormat[] fDefaultFormats;
        private final ImageFormatConverter fUntranslatedImageFormatConverter;

        public ImageFormatWithDefaultSupportConverter(PublishOptions.ImageFormat[] imageFormatArray, PublishOptions.ImageFormat[] imageFormatArray2) {
            super((Object[])imageFormatArray2, PublishOptions.ImageFormat.class);
            this.fUntranslatedImageFormatConverter = new ImageFormatConverter(imageFormatArray2);
            this.fDefaultFormats = imageFormatArray;
        }

        public Object fromString(String string, ConverterContext converterContext) {
            return string.equals(PublishOptions.ImageFormat.getDefaultImageDisplayText(this.fDefaultFormats)) ? PublishOptions.ImageFormat.DEFAULT : this.fUntranslatedImageFormatConverter.fromString(string, converterContext);
        }

        public String toString(Object object, ConverterContext converterContext) {
            return object == PublishOptions.ImageFormat.DEFAULT ? PublishOptions.ImageFormat.getDefaultImageDisplayText(this.fDefaultFormats) : this.fUntranslatedImageFormatConverter.toString(object, converterContext);
        }
    }

    public static class ImageFormatConverter
    extends CustomEnumConverter {
        public static final String CONTEXT = "imageFormat";

        public ImageFormatConverter() {
            this(PublishOptions.ImageFormat.values());
        }

        private ImageFormatConverter(PublishOptions.ImageFormat[] imageFormatArray) {
            super((Object[])imageFormatArray, PublishOptions.ImageFormat.class);
        }

        public Object fromString(String string, ConverterContext converterContext) {
            return PublishOptions.ImageFormat.lookupFromFileExtension(string);
        }

        public String toString(Object object, ConverterContext converterContext) {
            return ((PublishOptions.ImageFormat)((Object)object)).getFileExtension();
        }
    }

    public static class FileFormatConverter
    extends CustomEnumConverter {
        public static final String CONTEXT = "fileFormat";

        public FileFormatConverter() {
            super((Object[])PublishOptions.getSupportedOutputFormats(), PublishOptions.FileFormat.class);
        }

        public Object fromString(String string, ConverterContext converterContext) {
            return PublishOptions.FileFormat.lookupFromFileExtension(string);
        }

        public String toString(Object object, ConverterContext converterContext) {
            return ((PublishOptions.FileFormat)((Object)object)).getFileExtension();
        }
    }

    public static class FigureCaptureMethodConverter
    extends CustomEnumConverter {
        public static final String CONTEXT = "figureCaptureMethod";

        public FigureCaptureMethodConverter() {
            super((Object[])PublishOptions.FigureCaptureMethod.values(), PublishOptions.FigureCaptureMethod.class);
        }

        public Object fromString(String string, ConverterContext converterContext) {
            return PublishOptions.FigureCaptureMethod.lookupFromFunctionName(string);
        }

        public String toString(Object object, ConverterContext converterContext) {
            return ((PublishOptions.FigureCaptureMethod)((Object)object)).getFunctionName();
        }
    }

    public static class IntegerWithInfinityConverter
    extends IntegerConverter {
        public static final String CONTEXT = "integerWithInfinity";

        public Object fromString(String string, ConverterContext converterContext) {
            Integer n = string.toLowerCase().contains("inf") ? Integer.valueOf(-1) : super.fromString(string, converterContext);
            return n == null || n instanceof Integer && n < 0 ? Integer.valueOf(-1) : n;
        }

        public String toString(Object object, ConverterContext converterContext) {
            return object.equals(-1) ? "Inf" : super.toString(object, converterContext);
        }
    }

    public static class BooleanConverter
    extends DefaultObjectConverter {
        public static final String CONTEXT = "matlabBoolean";

        public Object fromString(String string, ConverterContext converterContext) {
            return Boolean.valueOf(string);
        }

        public String toString(Object object, ConverterContext converterContext) {
            return object.toString();
        }
    }
}

