/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.data;

import com.mathworks.jmi.MLFileUtils;
import com.mathworks.mlwidgets.configeditor.ConfigurationUtils;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationNameUtils;
import com.mathworks.widgets.Tokenizer;
import com.mathworks.widgets.TokenizerFactory;
import com.mathworks.widgets.text.mcode.MTokenContext;
import com.mathworks.widgets.text.mcode.MTokenManager;
import java.io.File;
import java.rmi.server.UID;

public class RunConfiguration
extends AbstractFileConfiguration {
    public static final String MATLAB_EXPRESSION_PROP = "matlab.expression";
    public static final AbstractFileConfiguration.Type<RunConfiguration> TYPE = new AbstractFileConfiguration.Type<RunConfiguration>(){

        @Override
        public String getName() {
            return "run_configuration";
        }

        @Override
        public RunConfiguration create(File file) {
            String string = ConfigurationNameUtils.generateConfigurationName(file);
            String string2 = ConfigurationUtils.generateDefaultMatlabExpression(file);
            return new RunConfiguration(string, file, string2);
        }
    };
    private String fMatlabExpression;

    public RunConfiguration(String string, File file, String string2) {
        this(string, file, string2, new UID().toString());
    }

    public RunConfiguration(String string, File file, String string2, String string3) {
        super(string, file, string3);
        this.checkMATLABExpression(string2);
        this.fMatlabExpression = string2;
    }

    @Override
    public AbstractFileConfiguration.Type getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        return this.getName() + ", " + this.getAssociatedPathAndFileName();
    }

    @Override
    public boolean isFileValid() {
        return this.getAssociatedFile().isFile() && MLFileUtils.isMFile((String)this.getAssociatedFile().getName());
    }

    private void checkMATLABExpression(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The Run Configurations MATLAB expression cannot be null.");
        }
    }

    public String getMatlabExpression() {
        return this.fMatlabExpression;
    }

    public String getMatlabExpressionToRun() {
        Tokenizer.TokenInfo tokenInfo = null;
        for (Tokenizer.TokenInfo tokenInfo2 : TokenizerFactory.getMTokenizer().tokenize(this.fMatlabExpression)) {
            if (MTokenManager.getInstance().isCommentToken(tokenInfo2.getTokenID()) || MTokenManager.getInstance().getWhitespaceToken().equals(tokenInfo2.getTokenID()) || tokenInfo2.getTokenID().getNumericID() == MTokenContext.NEWLINE.getNumericID()) continue;
            tokenInfo = tokenInfo2;
            break;
        }
        return tokenInfo == null ? "" : this.fMatlabExpression.substring(tokenInfo.getOffset()).trim();
    }

    public void setMatlabExpression(String string) {
        this.checkMATLABExpression(string);
        String string2 = this.fMatlabExpression;
        this.fMatlabExpression = string;
        this.getSupport().firePropertyChange(MATLAB_EXPRESSION_PROP, string2, this.fMatlabExpression);
    }
}

