/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.plugin;

import ca.odell.glazedlists.EventList;
import com.mathworks.mlservices.MatlabExecutionErrorHandler;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.ui.UiSupport;
import com.mathworks.util.Log;
import java.awt.Component;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public abstract class ConfigurationPlugin<E extends AbstractFileConfiguration> {
    private final AbstractFileConfiguration.Type<E> fType;
    private final String fName;
    private final int fPluginImportance;
    private UiSupport<E> fUiSupport;
    private PersistenceSupport<E> fPersistenceSupport;

    public ConfigurationPlugin(AbstractFileConfiguration.Type<E> type, String string, int n) {
        this.fType = type;
        this.fName = string;
        this.fPluginImportance = n;
    }

    public abstract void doConfigurationAction(E var1, Component var2, MatlabExecutionErrorHandler var3);

    public abstract UiSupport<E> createUISupport();

    public abstract PersistenceSupport<E> createPersistenceSupport();

    public AbstractFileConfiguration.Type<E> getConfigurationType() {
        return this.fType;
    }

    public String getName() {
        return this.fName;
    }

    public abstract LoadBundle<E> pluginsFirstLoad();

    public int getPluginImportance() {
        return this.fPluginImportance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LoadBundle<E> load() {
        FileReader fileReader = null;
        LoadBundle<E> loadBundle = null;
        try {
            if (this.getPersistenceSupport().getStorageFile().exists()) {
                fileReader = this.getPersistenceSupport().createReader();
                loadBundle = this.getPersistenceSupport().retrieve(fileReader);
            } else {
                loadBundle = this.pluginsFirstLoad();
            }
            IOUtils.closeQuietly((Reader)fileReader);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        finally {
            IOUtils.closeQuietly(fileReader);
        }
        return loadBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void persist(EventList<E> eventList, Map<File, E> map) {
        FileWriter fileWriter = null;
        try {
            fileWriter = this.getPersistenceSupport().createWriter();
            this.getPersistenceSupport().persist(eventList, map, fileWriter);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        finally {
            IOUtils.closeQuietly((Writer)fileWriter);
        }
    }

    public UiSupport<E> getUISupport() {
        if (this.fUiSupport == null) {
            this.fUiSupport = this.createUISupport();
        }
        return this.fUiSupport;
    }

    public PersistenceSupport<E> getPersistenceSupport() {
        if (this.fPersistenceSupport == null) {
            this.fPersistenceSupport = this.createPersistenceSupport();
        }
        return this.fPersistenceSupport;
    }

    public static class LoadBundle<E extends AbstractFileConfiguration> {
        private final EventList<E> fConfiguraitonsList;
        private final Map<File, E> fMostRecentlyActionedConfigurations;

        public LoadBundle(EventList<E> eventList, Map<File, E> map) {
            this.fConfiguraitonsList = eventList;
            this.fMostRecentlyActionedConfigurations = map;
        }

        public EventList<E> getConfiguraitonsList() {
            return this.fConfiguraitonsList;
        }

        public Map<File, E> getMostRecentlyActionedConfigurations() {
            return this.fMostRecentlyActionedConfigurations;
        }
    }

    public static abstract class PersistenceSupport<E extends AbstractFileConfiguration> {
        private final File fStorageFile;

        public PersistenceSupport(File file) {
            this.fStorageFile = file;
        }

        public File getStorageFile() {
            return this.fStorageFile;
        }

        protected FileReader createReader() throws Exception {
            return new FileReader(this.getStorageFile());
        }

        protected FileWriter createWriter() throws Exception {
            return new FileWriter(this.getStorageFile());
        }

        protected abstract LoadBundle<E> retrieve(FileReader var1) throws Exception;

        protected abstract void persist(EventList<E> var1, Map<File, E> var2, FileWriter var3) throws Exception;
    }
}

