/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.ui;

import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.data.RunConfiguration;
import com.mathworks.mlwidgets.configeditor.ui.ComponentDetailsEditor;
import com.mathworks.mlwidgets.text.mcode.MatlabMKit;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.validation.DefaultValidatable;
import com.mathworks.mwswing.validation.Validatable;
import com.mathworks.mwswing.validation.ValidatableTextField;
import com.mathworks.mwswing.validation.Validity;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.text.MWEditorUI;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Utilities;

public abstract class AbstractRunConfigurationDetailsEditor<E extends RunConfiguration>
implements ComponentDetailsEditor<E>,
PropertyChangeListener {
    protected MJPanel fEditorComponent = new MJPanel();
    private E fCurrentConfiguration;
    protected final ValidatableTextField fName = new ValidatableTextField((Validatable)new DefaultValidatable(Validity.WARNING));
    protected final SyntaxTextPane fMatlabExpression = new SyntaxTextPane();
    private DocumentListener fNameDocumentListener;
    private DocumentListener fMatlabExpressionDocumentListener;
    private boolean fShouldPropogateEvents = false;

    public AbstractRunConfigurationDetailsEditor() {
        this.init();
    }

    protected void init() {
        this.initSyntaxTextPane();
        this.initNames();
        this.initListeners();
        this.initLayout();
    }

    private void initSyntaxTextPane() {
        this.fMatlabExpression.registerEditorKit(SyntaxTextPane.M_MIME_TYPE, (EditorKit)((Object)new CustomMKit()));
        this.fMatlabExpression.setContentType(SyntaxTextPane.M_MIME_TYPE);
        this.fMatlabExpression.setShowLineNumbers(false, false);
    }

    private void initNames() {
        this.fEditorComponent.setName("ConfigurarationDetailsPanel");
        this.fName.setName("NameField");
        this.fMatlabExpression.setName("MATLABExpressionTextArea");
    }

    private void initListeners() {
        this.fNameDocumentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AbstractRunConfigurationDetailsEditor.this.doConfigurationNameChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                AbstractRunConfigurationDetailsEditor.this.doConfigurationNameChanged();
            }
        };
        this.fName.getDocument().addDocumentListener(this.fNameDocumentListener);
        this.fMatlabExpressionDocumentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AbstractRunConfigurationDetailsEditor.this.doMATLABExpressionChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                AbstractRunConfigurationDetailsEditor.this.doMATLABExpressionChanged();
            }
        };
        this.fMatlabExpression.getDocument().addDocumentListener(this.fMatlabExpressionDocumentListener);
    }

    protected abstract void initLayout();

    public int getMLintBarWidthIncludingSpacer_px() {
        return ((MWEditorUI)Utilities.getEditorUI((JTextComponent)this.fMatlabExpression)).getRightPanel().getPreferredSize().width;
    }

    private void doConfigurationNameChanged() {
        if (this.fShouldPropogateEvents) {
            ((AbstractFileConfiguration)this.fCurrentConfiguration).setName(this.fName.getText());
        }
    }

    private void doMATLABExpressionChanged() {
        if (this.fShouldPropogateEvents) {
            ((RunConfiguration)this.fCurrentConfiguration).setMatlabExpression(this.fMatlabExpression.getText());
        }
    }

    private void uninstallPropertyChangeListener() {
        if (this.fCurrentConfiguration != null) {
            ((AbstractFileConfiguration)this.fCurrentConfiguration).removePropertyChangeListener(this);
        }
    }

    @Override
    public void cleanup() {
        this.uninstallPropertyChangeListener();
        this.fName.getDocument().removeDocumentListener(this.fNameDocumentListener);
        this.fMatlabExpression.getDocument().removeDocumentListener(this.fMatlabExpressionDocumentListener);
        this.fMatlabExpression.cleanup();
    }

    @Override
    public void edit(E e) {
        this.uninstallPropertyChangeListener();
        this.fCurrentConfiguration = e;
        this.fShouldPropogateEvents = false;
        this.fName.setText(e == null ? "" : ((AbstractFileConfiguration)e).getName(), e != null);
        this.fMatlabExpression.setText(e == null ? "" : ((RunConfiguration)e).getMatlabExpression());
        this.fName.setEditable(e != null);
        this.fName.setEnabled(e != null);
        this.fMatlabExpression.setEditable(e != null);
        this.fMatlabExpression.setEnabled(e != null);
        this.fShouldPropogateEvents = true;
        if (this.fCurrentConfiguration != null) {
            ((AbstractFileConfiguration)this.fCurrentConfiguration).addPropertyChangeListener(this);
        }
    }

    @Override
    public Component getEditorComponent() {
        return this.fEditorComponent;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fShouldPropogateEvents = false;
        if (propertyChangeEvent.getPropertyName().equals("name") && !this.fName.getText().equals(((AbstractFileConfiguration)this.fCurrentConfiguration).getName())) {
            this.fName.setText(((AbstractFileConfiguration)this.fCurrentConfiguration).getName());
        }
        this.fShouldPropogateEvents = true;
    }

    private static class CustomMKit
    extends MatlabMKit {
        private CustomMKit() {
        }

        public String getContentType() {
            return SyntaxTextPane.M_MIME_TYPE;
        }
    }
}

