/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.archive;

import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.FileSystemTransaction;
import com.mathworks.matlab.api.explorer.MountLevel;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlwidgets.explorer.extensions.archive.CommonsCompressZipInput;
import com.mathworks.mlwidgets.explorer.extensions.archive.StreamingZipInput;
import com.mathworks.mlwidgets.explorer.extensions.archive.ZipFileList;
import com.mathworks.mlwidgets.explorer.extensions.archive.ZipFileTransaction;
import com.mathworks.mlwidgets.explorer.extensions.archive.ZipInput;
import com.mathworks.mlwidgets.explorer.model.DefaultRecursiveSearchList;
import com.mathworks.util.Holder;
import com.mathworks.util.ObjectPool;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.util.ThrowableClosure;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ZipFileSystem
implements FileSystem {
    private final FileSystemEntry fZipFile;
    private final MountLevel fMountLevel;
    private final ObjectPool<ZipInput> fInputs;
    private final InputFailoverChain fFailoverChain;
    private long fLastFlushTime;
    private Map<FileLocation, FileSystemEntry> fEntries;

    public ZipFileSystem(FileSystemEntry fileSystemEntry, MountLevel mountLevel) throws IOException {
        this.fZipFile = fileSystemEntry;
        this.fMountLevel = mountLevel;
        this.fFailoverChain = new InputFailoverChain(fileSystemEntry, mountLevel);
        this.fInputs = new ObjectPool((ReturnRunnable)new ReturnRunnable<ZipInput>(){

            public ZipInput run() {
                return ZipFileSystem.this.fFailoverChain.createInput();
            }
        }, (Predicate)new Predicate<ZipInput>(){

            public boolean accept(ZipInput zipInput) {
                return !zipInput.isLocked();
            }
        }, (ParameterRunnable)new ParameterRunnable<ZipInput>(){

            public void run(ZipInput zipInput) {
                try {
                    zipInput.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }, Integer.valueOf(4));
        try {
            this.ensureValid();
        }
        catch (RuntimeException runtimeException) {
            throw new IOException(runtimeException);
        }
    }

    public void close() {
        this.fInputs.dispose();
    }

    private void ensureValid() throws IOException {
        this.getEntries(new Predicate<FileSystemEntry>(){

            public boolean accept(FileSystemEntry fileSystemEntry) {
                return false;
            }
        });
    }

    public FileSystemEntry getEntry(FileLocation fileLocation) throws IOException {
        if (fileLocation.equals((Object)FileLocation.ROOT)) {
            return new FileSystemEntry((FileSystem)this, FileLocation.ROOT, false, true, this.fZipFile.getSize(), System.currentTimeMillis(), this.fZipFile.getMode());
        }
        return this.find(fileLocation);
    }

    public InputStream getInputStream(FileLocation fileLocation) throws IOException {
        return this.tryGetInputStreamWithKnownInputTypes(fileLocation);
    }

    public boolean exists(FileLocation fileLocation) {
        try {
            if (fileLocation.equals((Object)FileLocation.ROOT)) {
                return true;
            }
            this.find(fileLocation);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public FileSystemEntry followShortcutOrLink(FileSystemEntry fileSystemEntry) throws IOException {
        return fileSystemEntry;
    }

    public FileList getList(FileLocation fileLocation) throws IOException {
        return new ZipFileList(this, fileLocation);
    }

    public FileList search(FileLocation fileLocation, SearchCriteria searchCriteria, Predicate<FileSystemEntry> predicate) throws IOException {
        return new DefaultRecursiveSearchList((FileSystem)this, fileLocation, searchCriteria, predicate);
    }

    public boolean isReadOnly(FileLocation fileLocation) {
        return false;
    }

    public FileSystemTransaction createTransaction() throws IOException {
        return new ZipFileTransaction(this, this.fZipFile);
    }

    public String encodeName(String string) {
        return string;
    }

    public String decodeName(String string) {
        return string;
    }

    private synchronized FileSystemEntry find(FileLocation fileLocation) throws IOException {
        if (this.fEntries != null) {
            FileSystemEntry fileSystemEntry = this.fEntries.get(fileLocation);
            if (fileSystemEntry == null) {
                throw new IOException("File does not exist: " + fileLocation);
            }
            return fileSystemEntry;
        }
        FindHelper findHelper = new FindHelper(fileLocation);
        this.getEntries(findHelper);
        return findHelper.getResult();
    }

    synchronized void flushEntries() {
        this.fEntries = null;
        this.fLastFlushTime = System.currentTimeMillis();
        this.fInputs.flush();
    }

    synchronized long getLastFlushTime() {
        return this.fLastFlushTime;
    }

    synchronized void getEntries(final Predicate<FileSystemEntry> predicate) throws IOException {
        block5: {
            block4: {
                if (this.fEntries != null) break block4;
                final HashMap<FileLocation, FileSystemEntry> hashMap = new HashMap<FileLocation, FileSystemEntry>();
                final Holder holder = new Holder();
                holder.set((Object)false);
                this.tryGetEntriesWithKnownInputTypes(new Predicate<FileSystemEntry>(){

                    public boolean accept(FileSystemEntry fileSystemEntry) {
                        hashMap.put(fileSystemEntry.getLocation(), fileSystemEntry);
                        boolean bl = predicate.accept((Object)fileSystemEntry);
                        if (!bl) {
                            holder.set((Object)true);
                        }
                        return bl;
                    }
                });
                if (((Boolean)holder.get()).booleanValue()) break block5;
                this.fEntries = hashMap;
                HashMap<FileLocation, Long> hashMap2 = new HashMap<FileLocation, Long>();
                for (FileSystemEntry fileSystemEntry : this.fEntries.values()) {
                    hashMap2.put(fileSystemEntry.getLocation(), fileSystemEntry.getDateModified().getTime());
                }
                for (FileSystemEntry fileSystemEntry : new ArrayList<FileSystemEntry>(this.fEntries.values())) {
                    Long l = (Long)hashMap2.get(fileSystemEntry.getLocation());
                    for (FileLocation fileLocation = fileSystemEntry.getLocation(); fileLocation != null && !fileLocation.equals((Object)FileLocation.ROOT); fileLocation = fileLocation.getParent()) {
                        if (this.fEntries.containsKey(fileLocation)) continue;
                        FileSystemEntry fileSystemEntry2 = new FileSystemEntry((FileSystem)this, fileLocation, false, true, 0L, l.longValue(), 0L);
                        this.fEntries.put(fileLocation, fileSystemEntry2);
                        if (((Boolean)holder.get()).booleanValue()) continue;
                        holder.set((Object)(!predicate.accept((Object)fileSystemEntry2) ? 1 : 0));
                    }
                }
                break block5;
            }
            for (FileSystemEntry fileSystemEntry : this.fEntries.values()) {
                if (!predicate.accept((Object)fileSystemEntry)) break;
            }
        }
    }

    private void tryGetEntriesWithKnownInputTypes(final Predicate<FileSystemEntry> predicate) throws IOException {
        this.tryWithKnownInputTypes(new ThrowableClosure<Void, ZipInput, IOException>(){

            public Void run(ZipInput zipInput) throws IOException {
                zipInput.getEntries(ZipFileSystem.this, (Predicate<FileSystemEntry>)predicate);
                return null;
            }
        });
    }

    private InputStream tryGetInputStreamWithKnownInputTypes(final FileLocation fileLocation) throws IOException {
        return this.tryWithKnownInputTypes(new ThrowableClosure<InputStream, ZipInput, IOException>(){

            public InputStream run(ZipInput zipInput) throws IOException {
                return zipInput.getInputStream(fileLocation);
            }
        });
    }

    private <T> T tryWithKnownInputTypes(ThrowableClosure<T, ZipInput, IOException> throwableClosure) throws IOException {
        IOException iOException;
        ZipInput zipInput;
        Object object = null;
        do {
            zipInput = (ZipInput)this.fInputs.acquire();
            try {
                object = throwableClosure.run((Object)zipInput);
                this.fInputs.release((Object)zipInput);
                iOException = null;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            if (iOException == null) break;
            this.fInputs.flush();
        } while (this.fFailoverChain.nextInput(zipInput));
        if (this.fMountLevel.equals((Object)MountLevel.LOCK_FREE)) {
            this.fInputs.flush();
        }
        if (iOException != null) {
            throw iOException;
        }
        return (T)object;
    }

    private class FindHelper
    implements Predicate<FileSystemEntry> {
        private final FileLocation iLocation;
        private boolean iExistsAsImplicitFolder;
        private long iDateModified;
        private FileSystemEntry iResult;

        FindHelper(FileLocation fileLocation) {
            this.iLocation = fileLocation;
        }

        public boolean accept(FileSystemEntry fileSystemEntry) {
            if (fileSystemEntry.getLocation().equals((Object)this.iLocation)) {
                this.iResult = fileSystemEntry;
                return false;
            }
            if (fileSystemEntry.getLocation().hasPrefix(this.iLocation)) {
                this.iExistsAsImplicitFolder = true;
                if (fileSystemEntry.getDateModified().getTime() > this.iDateModified) {
                    this.iDateModified = fileSystemEntry.getDateModified().getTime();
                }
            }
            return true;
        }

        public FileSystemEntry getResult() throws IOException {
            if (this.iResult != null) {
                return this.iResult;
            }
            if (this.iExistsAsImplicitFolder) {
                return new FileSystemEntry((FileSystem)ZipFileSystem.this, this.iLocation, false, true, 0L, this.iDateModified, 0L);
            }
            throw new IOException("File does not exist: " + this.iLocation);
        }
    }

    private static class InputFailoverChain {
        private final Iterator<Class<? extends ZipInput>> fInputFailoverChain;
        private final FileSystemEntry fZipFile;
        private Class<? extends ZipInput> fInputClass;
        private int fForceStreamingThreads;

        InputFailoverChain(FileSystemEntry fileSystemEntry, MountLevel mountLevel) {
            this.fZipFile = fileSystemEntry;
            ArrayList<Class<CommonsCompressZipInput>> arrayList = new ArrayList<Class<CommonsCompressZipInput>>();
            if (fileSystemEntry.isReal() && mountLevel.equals((Object)MountLevel.LOCK_ALLOWED)) {
                arrayList.add(CommonsCompressZipInput.class);
            } else {
                arrayList.add(StreamingZipInput.class);
                arrayList.add(CommonsCompressZipInput.class);
            }
            this.fInputFailoverChain = arrayList.iterator();
        }

        public synchronized void setForceStreaming(boolean bl) {
            this.fForceStreamingThreads += bl ? 1 : -1;
        }

        public synchronized ZipInput createInput() {
            if (this.fForceStreamingThreads > 0) {
                return new StreamingZipInput(this.fZipFile);
            }
            if (this.fInputClass == null) {
                this.fInputClass = this.fInputFailoverChain.next();
            }
            try {
                return this.fInputClass.getConstructor(FileSystemEntry.class).newInstance(this.fZipFile);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }

        public synchronized boolean nextInput(ZipInput zipInput) {
            if (this.fInputClass != null && !zipInput.getClass().equals(this.fInputClass)) {
                return true;
            }
            if (this.fInputFailoverChain.hasNext()) {
                this.fInputClass = null;
                return true;
            }
            return false;
        }
    }
}

