/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.basic;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.mlwidgets.explorer.extensions.basic.TransferFileGroup;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.actions.StatusReceiver;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationContext;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.util.UiFileTransfer;
import com.mathworks.mlwidgets.explorer.util.UiFileTransferType;
import com.mathworks.mlwidgets.explorer.widgets.table.FileTable;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.datatransfer.MJDataFlavor;
import com.mathworks.mwswing.datatransfer.MJTransferable;
import com.mathworks.util.FileUtils;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.grouptable.GroupingTable;
import com.mathworks.widgets.grouptable.transfer.ReceiveHandler;
import com.mathworks.widgets.grouptable.transfer.SendHandler;
import com.mathworks.widgets.grouptable.transfer.Transfer;
import com.mathworks.widgets.grouptable.transfer.TransferUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FileTransferHandler
implements SendHandler<FileSystemEntry>,
ReceiveHandler<FileSystemEntry> {
    private final NavigationContext fContext;
    private int fForeignAction = -1;
    public static final DataFlavor sTransferDocumentGroupFlavor;

    public FileTransferHandler(NavigationContext navigationContext) {
        this.fContext = navigationContext;
    }

    public boolean accept(List<FileSystemEntry> list) {
        return true;
    }

    public boolean moveByDefault() {
        return true;
    }

    public boolean supportsMove() {
        return true;
    }

    public boolean supportsCopy() {
        return true;
    }

    public Transferable wrap(GroupingTable<FileSystemEntry> groupingTable, List<FileSystemEntry> list, boolean bl) {
        List<File> list2 = FileTransferHandler.entriesToFiles(list);
        return TransferUtils.combineFlavors((Transferable[])new Transferable[]{MJDataFlavor.encodeJavaFileListFlavor((File[])list2.toArray(new File[list2.size()])), new MJTransferable((Object)new TransferFileGroup(this.fContext.getLocation(), list), sTransferDocumentGroupFlavor)});
    }

    public boolean accept(FileSystemEntry fileSystemEntry, Transfer transfer, boolean bl) {
        try {
            FileSystemEntry fileSystemEntry2 = this.getRealTarget(fileSystemEntry, bl);
            if (fileSystemEntry2 == null) {
                return false;
            }
            if (!MJDataFlavor.isDecodableFileFlavor((Transferable)transfer.getData())) {
                return false;
            }
            boolean bl2 = false;
            boolean bl3 = fileSystemEntry2.isFolder();
            boolean bl4 = FileTransferHandler.transferContains(fileSystemEntry2, transfer);
            boolean bl5 = FileTransferHandler.transferContainsAnyChildren(fileSystemEntry2, transfer);
            boolean bl6 = FileTransferHandler.transferContainsAncestor(fileSystemEntry2, transfer);
            return !(!bl3 && !bl2 || bl4 || bl6 || bl5 && !bl);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public Status transfer(GroupingTable<FileSystemEntry> groupingTable, FileSystemEntry fileSystemEntry, Transfer transfer, boolean bl, boolean bl2, boolean bl3) {
        try {
            List list;
            FileSystemEntry fileSystemEntry2 = this.getRealTarget(fileSystemEntry, true);
            assert (fileSystemEntry2 != null);
            boolean bl4 = this.fContext.getLocation().equals((Object)fileSystemEntry2.getLocation());
            int n = groupingTable.getGroupingModel().rowIndexOf((Object)fileSystemEntry);
            boolean bl5 = n > -1 && groupingTable.getRowAt(n).isExpanded();
            TransferFileGroup transferFileGroup = null;
            if (transfer.isDataFlavorAvailable(sTransferDocumentGroupFlavor)) {
                transferFileGroup = (TransferFileGroup)transfer.getTransferData(sTransferDocumentGroupFlavor);
            }
            if (transferFileGroup == null) {
                list = transfer.getFileTransferList();
                transferFileGroup = new TransferFileGroup(null, FileTransferHandler.filesToEntries(list));
            } else if (!bl3 && (!transferFileGroup.isAllReal() && (fileSystemEntry == null || fileSystemEntry.isReal()) || transferFileGroup.isAllReal() && fileSystemEntry != null && !fileSystemEntry.isReal())) {
                bl = false;
            }
            list = new Status(ExplorerResources.getString(bl ? "progress.move" : "progress.copy"), true);
            StatusReceiver statusReceiver = bl4 || bl5 ? new SelectOnFinishReceiver((FileTable)groupingTable, (Status)list) : new StatusReceiver((Status)list);
            UiFileTransfer uiFileTransfer = new UiFileTransfer((Component)groupingTable, bl ? UiFileTransferType.MOVE : UiFileTransferType.COPY, fileSystemEntry2.getSystem(), fileSystemEntry2.getLocation(), transferFileGroup.getFiles(), statusReceiver);
            new Thread(uiFileTransfer).start();
            return list;
        }
        catch (IOException iOException) {
            return Status.COMPLETED;
        }
    }

    private static boolean transferContains(FileSystemEntry fileSystemEntry, Transfer transfer) {
        if (fileSystemEntry.isFolder()) {
            File file = new File(fileSystemEntry.getLocation().toString());
            List list = transfer.getFileTransferList();
            if (list != null) {
                for (File file2 : list) {
                    if (file2.getParentFile() == null || !file2.equals(file)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private FileSystemEntry getRealTarget(FileSystemEntry fileSystemEntry, boolean bl) throws IOException {
        if (fileSystemEntry == null) {
            return this.fContext.getLocationEntry();
        }
        if (fileSystemEntry.isFolder()) {
            return fileSystemEntry;
        }
        return bl ? fileSystemEntry.getSystem().getEntry(fileSystemEntry.getLocation().getParent()) : null;
    }

    private static boolean transferContainsAnyChildren(FileSystemEntry fileSystemEntry, Transfer transfer) {
        if (fileSystemEntry.isFolder()) {
            File file = new File(fileSystemEntry.getLocation().toString());
            List list = transfer.getFileTransferList();
            if (list != null) {
                for (File file2 : list) {
                    if (file2.getParentFile() == null || !file2.getParentFile().equals(file)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean transferContainsAncestor(FileSystemEntry fileSystemEntry, Transfer transfer) {
        if (fileSystemEntry.isFolder()) {
            File file = new File(fileSystemEntry.getLocation().toString());
            List list = transfer.getFileTransferList();
            if (list != null) {
                for (File file2 : list) {
                    if (!FileTransferHandler.isAncestor(file2, file)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isAncestor(File file, File file2) {
        return file != null && file2 != null && file2.getParentFile() != null && (file.equals(file2.getParentFile()) || FileTransferHandler.isAncestor(file, file2.getParentFile()));
    }

    public boolean shouldForceCopy(Transfer transfer) {
        boolean bl = false;
        if (PlatformInfo.isWindows()) {
            if (this.fForeignAction == -1) {
                this.fForeignAction = 1;
                bl = true;
            } else {
                List list = transfer.getFileTransferList();
                if (!list.isEmpty() && !FileUtils.getParent((File)((File)list.get(0))).equals(FileUtils.getParent((File)new File(this.fContext.getLocation().toString())))) {
                    bl = true;
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private static List<File> entriesToFiles(List<FileSystemEntry> list) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (FileSystemEntry fileSystemEntry : list) {
            arrayList.add(fileSystemEntry.getLocation().toFile());
        }
        return arrayList;
    }

    private static List<FileSystemEntry> filesToEntries(List<File> list) {
        ArrayList<FileSystemEntry> arrayList = new ArrayList<FileSystemEntry>();
        for (File file : list) {
            if (file.toString().isEmpty()) continue;
            try {
                arrayList.add(RealFileSystem.getInstance().getEntry(new FileLocation(file)));
            }
            catch (IOException iOException) {}
        }
        return arrayList;
    }

    static {
        try {
            sTransferDocumentGroupFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=com.mathworks.mlwidgets.explorer.extensions.basic.TransferFileGroup");
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    private class SelectOnFinishReceiver
    extends StatusReceiver<FileLocation> {
        private int iIndex;
        private final FileTable iTable;

        SelectOnFinishReceiver(FileTable fileTable, Status status) {
            super(status);
            this.iTable = fileTable;
        }

        @Override
        public boolean receive(FileLocation fileLocation) {
            try {
                final FileSystemEntry fileSystemEntry = FileTransferHandler.this.fContext.getSystem().getEntry(fileLocation);
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SelectOnFinishReceiver.this.iTable.doWhenReady(fileSystemEntry, new ParameterRunnable<Integer>(){

                            public void run(Integer n) {
                                if (SelectOnFinishReceiver.this.iIndex++ == 0) {
                                    SelectOnFinishReceiver.this.iTable.clearSelection();
                                }
                                SelectOnFinishReceiver.this.iTable.getSelectionModel().addSelectionInterval(n, n);
                                Rectangle rectangle = SelectOnFinishReceiver.this.iTable.getVisibleRect();
                                Rectangle rectangle2 = SelectOnFinishReceiver.this.iTable.getCellRect(n, 0, true);
                                SelectOnFinishReceiver.this.iTable.scrollRectToVisible(new Rectangle((int)rectangle.getX(), (int)rectangle2.getY(), (int)rectangle.getWidth(), (int)rectangle2.getHeight()));
                            }
                        });
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
    }
}

