/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.matlab;

import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.FileDecorations;
import com.mathworks.matlab.api.explorer.FileDecorators;
import com.mathworks.matlab.api.explorer.FileInfoProvider;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.editorfs.EditorFileSystem;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.services.SystemServices;
import com.mathworks.util.DeferrableRetriever;
import com.mathworks.util.ParameterRunnable;
import java.io.IOException;
import java.util.Date;

public class EditorFileInfoProvider
implements FileInfoProvider {
    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return EditorFileSystem.getInstance().isDirty(fileSystemEntry.getLocation());
    }

    public void configureDecorations(final FileSystemEntry fileSystemEntry, FileDecorators fileDecorators, FileDecorations fileDecorations) {
        fileDecorators.set(CoreFileDecoration.DISPLAY_DATE, (DeferrableRetriever)new DeferrableRetriever<String>(){

            public void run(ParameterRunnable<String> parameterRunnable, Runnable runnable) {
                try {
                    parameterRunnable.run((Object)SystemServices.formatDateTime((Date)RealFileSystem.getInstance().getEntry(fileSystemEntry.getLocation()).getDateModified()));
                }
                catch (IOException iOException) {
                    runnable.run();
                }
            }
        });
        fileDecorators.set(CoreFileDecoration.DISPLAY_SIZE, (DeferrableRetriever)new DeferrableRetriever<Long>(){

            public void run(ParameterRunnable<Long> parameterRunnable, Runnable runnable) {
                try {
                    parameterRunnable.run((Object)RealFileSystem.getInstance().getEntry(fileSystemEntry.getLocation()).getSize());
                }
                catch (IOException iOException) {
                    runnable.run();
                }
            }
        });
    }
}

