/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.actions;

import com.mathworks.matlab.api.explorer.ActionConfiguration;
import com.mathworks.matlab.api.explorer.ActionDefinition;
import com.mathworks.matlab.api.explorer.ActionInputSource;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.CoreMenuSectionID;
import com.mathworks.matlab.api.explorer.MenuSection;
import com.mathworks.mlwidgets.explorer.model.actions.ActionConfigurationImpl;
import com.mathworks.mlwidgets.explorer.model.actions.CoreActionDefinition;
import com.mathworks.mlwidgets.explorer.model.actions.CoreMenuSection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class ActionRegistryImpl {
    private final Map<String, ActionConfigurationImpl> fActions;
    private final List<ActionDefinition> fActionRegistrationOrder;
    private final List<ActionDefinition> fActionDisplayOrder;
    private final ActionInputSource fSource;

    ActionRegistryImpl(ActionInputSource actionInputSource) {
        this.fSource = actionInputSource;
        this.fActions = new HashMap<String, ActionConfigurationImpl>();
        this.fActionDisplayOrder = new ArrayList<ActionDefinition>();
        this.fActionRegistrationOrder = new ArrayList<ActionDefinition>();
        for (CoreActionID coreActionID : CoreActionID.values()) {
            this.getAction(coreActionID);
        }
    }

    synchronized ActionConfigurationImpl defineAction(ActionDefinition actionDefinition) {
        ActionConfigurationImpl actionConfigurationImpl = this.fActions.get(actionDefinition.getId());
        if (actionConfigurationImpl == null) {
            actionConfigurationImpl = new ActionConfigurationImpl(actionDefinition, this.fSource);
            this.fActions.put(actionDefinition.getId(), actionConfigurationImpl);
            this.fActionDisplayOrder.add(actionDefinition);
            this.fActionRegistrationOrder.add(actionDefinition);
        }
        return actionConfigurationImpl;
    }

    synchronized ActionConfigurationImpl getAction(CoreActionID coreActionID) {
        ActionDefinition actionDefinition = CoreActionDefinition.valueOf(coreActionID.toString()).getDefinition();
        ActionConfigurationImpl actionConfigurationImpl = this.getAction(actionDefinition.getId());
        return actionConfigurationImpl == null ? this.defineAction(actionDefinition) : actionConfigurationImpl;
    }

    public synchronized ActionConfigurationImpl getAction(String string) {
        return this.fActions.get(string);
    }

    synchronized ActionConfigurationImpl getConfiguration(ActionDefinition actionDefinition) {
        return this.fActions.get(actionDefinition.getId());
    }

    public synchronized MenuSection getMenuSection(CoreMenuSectionID coreMenuSectionID) {
        return CoreMenuSection.valueOf(coreMenuSectionID.toString()).getSection();
    }

    public synchronized MenuSection getMenuSection(String string) {
        for (ActionConfigurationImpl actionConfigurationImpl : this.fActions.values()) {
            ActionDefinition actionDefinition = actionConfigurationImpl.getDefinition();
            if (actionDefinition.getMenuSection() == null || !actionDefinition.getMenuSection().getId().equals(string)) continue;
            return actionDefinition.getMenuSection();
        }
        throw new IllegalArgumentException("Menu section not found: " + string);
    }

    synchronized void setActionPosition(ActionDefinition actionDefinition, ActionDefinition actionDefinition2) {
        this.defineAction(actionDefinition);
        this.defineAction(actionDefinition2);
        ActionDefinition actionDefinition3 = this.getLaterRegisteredAction(actionDefinition, actionDefinition2);
        ActionDefinition actionDefinition4 = actionDefinition3.equals(actionDefinition) ? actionDefinition2 : actionDefinition;
        this.fActionDisplayOrder.remove(actionDefinition3);
        int n = this.fActionDisplayOrder.indexOf(actionDefinition4);
        if (actionDefinition3.equals(actionDefinition2)) {
            this.fActionDisplayOrder.add(n + 1, actionDefinition3);
        } else {
            this.fActionDisplayOrder.add(n, actionDefinition3);
        }
    }

    private synchronized ActionDefinition getLaterRegisteredAction(ActionDefinition actionDefinition, ActionDefinition actionDefinition2) {
        int n;
        int n2 = this.fActionRegistrationOrder.indexOf(actionDefinition);
        return n2 > (n = this.fActionRegistrationOrder.indexOf(actionDefinition2)) && n2 >= 0 ? actionDefinition : actionDefinition2;
    }

    synchronized List<ActionDefinition> getActions() {
        ArrayList<ActionDefinition> arrayList = new ArrayList<ActionDefinition>();
        for (ActionDefinition actionDefinition : this.fActionDisplayOrder) {
            if (this.getConfiguration(actionDefinition) == null) continue;
            arrayList.add(actionDefinition);
        }
        return arrayList;
    }

    synchronized ActionRegistry getBinding(ActionProvider actionProvider) {
        return new ProviderBinding(actionProvider);
    }

    private class ProviderBinding
    implements ActionRegistry {
        private final ActionProvider iProvider;

        ProviderBinding(ActionProvider actionProvider) {
            this.iProvider = actionProvider;
        }

        public ActionConfiguration defineAction(ActionDefinition actionDefinition) {
            return ActionRegistryImpl.this.defineAction(actionDefinition).getBinding(this.iProvider);
        }

        public ActionConfiguration getAction(CoreActionID coreActionID) {
            return ActionRegistryImpl.this.getAction(coreActionID).getBinding(this.iProvider);
        }

        public ActionConfiguration getAction(String string) {
            return ActionRegistryImpl.this.getAction(string).getBinding(this.iProvider);
        }

        public MenuSection getMenuSection(CoreMenuSectionID coreMenuSectionID) {
            return ActionRegistryImpl.this.getMenuSection(coreMenuSectionID);
        }

        public MenuSection getMenuSection(String string) {
            return ActionRegistryImpl.this.getMenuSection(string);
        }

        public void setActionPosition(ActionDefinition actionDefinition, ActionDefinition actionDefinition2) {
            ActionRegistryImpl.this.setActionPosition(actionDefinition, actionDefinition2);
        }
    }
}

