/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.realfs;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.AbstractFileList;
import com.mathworks.mlwidgets.explorer.model.ExplorerPrefs;
import com.mathworks.mlwidgets.explorer.model.realfs.StatToEntryAdapter;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.io.IOException;

public class RealFileList
extends AbstractFileList {
    private final FileLocation fLocation;
    private static Boolean sWindowsHiddenFilePreference;

    RealFileList(FileSystem fileSystem, FileLocation fileLocation) throws IOException {
        super(fileSystem, fileLocation);
        this.fLocation = fileLocation;
    }

    public static synchronized boolean shouldIncludeHiddenFiles() {
        if (PlatformInfo.isUnix()) {
            try {
                return (Boolean)ExplorerPrefs.ShowHiddenFiles.get();
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        if (null == sWindowsHiddenFilePreference) {
            sWindowsHiddenFilePreference = NativeJava.checkWindowsHiddenFilePreference();
        }
        return sWindowsHiddenFilePreference;
    }

    public void readFilesAndFolders(AsyncReceiver<FileSystemEntry> asyncReceiver) throws IOException {
        NativeJava.listFiles((String)this.fLocation.toString(), (AsyncReceiver)new StatToEntryAdapter(this.fLocation, this.getClosedFlag(), asyncReceiver));
        asyncReceiver.finished();
    }
}

