/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.table;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mlwidgets.explorer.model.ExplorerPrefs;
import com.mathworks.mlwidgets.explorer.model.table.UiFileList;
import com.mathworks.services.settings.SettingAdapter;
import com.mathworks.services.settings.SettingChangeEvent;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingListener;
import com.mathworks.util.Disposable;
import com.mathworks.util.ExecutorServiceFactory;
import com.mathworks.util.FileSystemAdapter;
import com.mathworks.util.FileSystemListener;
import com.mathworks.util.FileSystemUtils;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class RefreshDaemon
implements Disposable {
    private volatile ScheduledExecutorService fTimer = null;
    private volatile boolean fDisposed = false;
    private final List<UiFileList> fListingsToRefresh;
    private final SettingListener fChangeListener;
    private final SettingListener fHiddenFileListener;
    private final FileSystemListener fFileSystemListener;
    private final Object fTimerLock = new Object();

    public RefreshDaemon() {
        this.fListingsToRefresh = new CopyOnWriteArrayList<UiFileList>();
        this.fChangeListener = new SettingAdapter(){

            public void settingChanged(SettingChangeEvent settingChangeEvent) {
                RefreshDaemon.this.initializeTimer();
            }
        };
        this.fHiddenFileListener = new SettingAdapter(){

            public void settingChanged(SettingChangeEvent settingChangeEvent) {
                for (UiFileList uiFileList : RefreshDaemon.this.fListingsToRefresh) {
                    uiFileList.refresh();
                }
            }
        };
        try {
            ExplorerPrefs.AutoRefreshInterval.addListener(this.fChangeListener);
            ExplorerPrefs.AutoRefresh.addListener(this.fChangeListener);
            if (PlatformInfo.isUnix()) {
                ExplorerPrefs.ShowHiddenFiles.addListener(this.fHiddenFileListener);
            }
        }
        catch (SettingException settingException) {
            RefreshDaemon.handle(settingException);
        }
        this.fFileSystemListener = this.createFileSystemListener();
        FileSystemUtils.getFileSystemNotifier().addFileSystemListener(this.fFileSystemListener);
        this.initializeTimer();
    }

    public void register(UiFileList uiFileList) {
        this.fListingsToRefresh.add(uiFileList);
    }

    public void unregister(UiFileList uiFileList) {
        this.fListingsToRefresh.remove(uiFileList);
    }

    private FileSystemListener createFileSystemListener() {
        return new FileSystemAdapter(){

            public void fileCreated(File file) {
                if (file != null) {
                    RefreshDaemon.this.refresh(file);
                }
            }

            public void fileMoved(File file, File file2) {
                if (file != null) {
                    RefreshDaemon.this.refresh(file);
                }
                if (file2 != null) {
                    RefreshDaemon.this.refresh(file2);
                }
            }

            public void fileDeleted(File file) {
                if (file != null) {
                    RefreshDaemon.this.refresh(file);
                }
            }

            public void fileChanged(File file) {
                if (file != null) {
                    RefreshDaemon.this.refresh(file);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeTimer() {
        Object object = this.fTimerLock;
        synchronized (object) {
            if (this.fDisposed) {
                return;
            }
            this.clearCurrentTimer();
            try {
                if (((Boolean)ExplorerPrefs.AutoRefresh.get()).booleanValue()) {
                    long l = ((Integer)ExplorerPrefs.AutoRefreshInterval.get()).intValue();
                    this.fTimer = ExecutorServiceFactory.createScheduledExecutorService((String)("Explorer Refresh Service " + this.hashCode()), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            for (UiFileList uiFileList : RefreshDaemon.this.fListingsToRefresh) {
                                uiFileList.refresh();
                            }
                        }
                    }, (long)l, (TimeUnit)TimeUnit.SECONDS);
                }
            }
            catch (SettingException settingException) {
                RefreshDaemon.handle(settingException);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCurrentTimer() {
        Object object = this.fTimerLock;
        synchronized (object) {
            if (this.fTimer == null) {
                return;
            }
            this.fTimer.shutdown();
        }
    }

    public void dispose() {
        if (this.fDisposed) {
            return;
        }
        this.fDisposed = true;
        FileSystemUtils.getFileSystemNotifier().removeFileSystemListener(this.fFileSystemListener);
        this.clearCurrentTimer();
        try {
            ExplorerPrefs.AutoRefreshInterval.removeListener(this.fChangeListener);
            ExplorerPrefs.AutoRefresh.removeListener(this.fChangeListener);
            ExplorerPrefs.ShowHiddenFiles.removeListener(this.fHiddenFileListener);
        }
        catch (SettingException settingException) {
            RefreshDaemon.handle(settingException);
        }
    }

    private void refresh(File file) {
        FileLocation fileLocation = new FileLocation(file);
        for (UiFileList uiFileList : this.fListingsToRefresh) {
            if (!fileLocation.hasPrefix(uiFileList.getLocationEntry().getLocation())) continue;
            uiFileList.refresh();
        }
    }

    private static void handle(SettingException settingException) {
        throw new RuntimeException(settingException);
    }
}

