/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.util;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.util.TriggerRunnable;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;

public final class MatlabThreadContext {
    private final Queue<Operation> fQueue = new LinkedList<Operation>();
    private final Matlab fMatlab = new Matlab();
    private boolean fOwnsMatlabThread;

    public static Invoker getDedicatedInvoker() {
        return new Invoker(){

            @Override
            public void invoke(Runnable runnable) {
                new Thread(runnable).start();
            }
        };
    }

    public static Invoker getAwtEventThreadInvoker() {
        return new Invoker(){

            @Override
            public void invoke(Runnable runnable) {
                SwingUtilities.invokeLater(runnable);
            }
        };
    }

    public void runWithDirectMatlabAccess(Invoker invoker, TriggerRunnable triggerRunnable) {
        if (!NativeMatlab.nativeIsMatlabThread()) {
            throw new IllegalStateException("This method must be called from the MATLAB thread.");
        }
        this.fOwnsMatlabThread = true;
        invoker.invoke((Runnable)triggerRunnable);
        try {
            while (!triggerRunnable.await(50L, TimeUnit.MILLISECONDS)) {
                Operation operation = this.dequeue();
                while (operation != null) {
                    MatlabThreadContext.runOnMatlabThread(operation);
                    operation = this.dequeue();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
        finally {
            this.fOwnsMatlabThread = false;
        }
    }

    public void evalAndWait(String string) throws Exception {
        this.waitFor(new Operation(OperationType.EVAL, string, 0));
    }

    public Object evalAndWait(String string, int n) throws Exception {
        return this.waitFor(new Operation(OperationType.EVAL, string, n));
    }

    public Object fevalAndWait(String string, Object[] objectArray, int n) throws Exception {
        return this.waitFor(new Operation(OperationType.FEVAL, string, objectArray, n));
    }

    public void evalConsoleOutputAndWait(String string) throws Exception {
        this.waitFor(new Operation(OperationType.EVAL_CONSOLE_OUTPUT, string, new Object[0], 0));
    }

    public void fevalConsoleOutputAndWait(String string, Object[] objectArray, int n) throws Exception {
        this.waitFor(new Operation(OperationType.FEVAL_CONSOLE_OUTPUT, string, objectArray, n));
    }

    private Object waitFor(Operation operation) throws Exception {
        if (this.fOwnsMatlabThread) {
            if (NativeMatlab.nativeIsMatlabThread()) {
                throw new IllegalStateException("This method is intended to be called on a background thread, so as not to lock up MATLAB or the UI.");
            }
            this.enqueue(operation);
        } else {
            this.runFromNonMatlabThread(operation);
        }
        return operation.getResultOrThrowException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(Operation operation) {
        Queue<Operation> queue = this.fQueue;
        synchronized (queue) {
            this.fQueue.offer(operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Operation dequeue() {
        Queue<Operation> queue = this.fQueue;
        synchronized (queue) {
            if (!this.fQueue.isEmpty()) {
                return this.fQueue.poll();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runOnMatlabThread(Operation operation) {
        block9: {
            if (!NativeMatlab.nativeIsMatlabThread()) {
                throw new IllegalStateException("runOnMatlabThread was called on " + Thread.currentThread() + " rather than the MATLAB thread");
            }
            try {
                if (operation.getType() == OperationType.EVAL || operation.getType() == OperationType.EVAL_CONSOLE_OUTPUT) {
                    operation.setResult(Matlab.mtEval((String)operation.getCommand(), (int)operation.getReturnValueCount()));
                    break block9;
                }
                if (operation.getType() == OperationType.FEVAL) {
                    operation.setResult(Matlab.mtFeval((String)operation.getCommand(), (Object[])operation.getArgs(), (int)operation.getReturnValueCount()));
                    break block9;
                }
                if (operation.getType() == OperationType.FEVAL_CONSOLE_OUTPUT) {
                    operation.setResult(Matlab.mtFevalConsoleOutput((String)operation.getCommand(), (Object[])operation.getArgs(), (int)operation.getReturnValueCount()));
                    break block9;
                }
                throw new IllegalStateException("runOnMatlabThread does not handle " + (Object)((Object)operation.getType()));
            }
            catch (Exception exception) {
                operation.setException(exception);
            }
            finally {
                operation.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFromNonMatlabThread(Operation operation) {
        if (NativeMatlab.nativeIsMatlabThread()) {
            throw new IllegalStateException("runOnMatlabThread cannot be called on the MATLAB thread");
        }
        try {
            final Object[] objectArray = new Object[1];
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            CompletionObserver completionObserver = new CompletionObserver(){

                public void completed(int n, Object object) {
                    objectArray[0] = object;
                    countDownLatch.countDown();
                }
            };
            if (operation.getType() == OperationType.EVAL) {
                this.fMatlab.eval(operation.getCommand(), completionObserver);
            } else if (operation.getType() == OperationType.FEVAL) {
                this.fMatlab.feval(operation.getCommand(), operation.getArgs(), operation.getReturnValueCount(), completionObserver);
            } else if (operation.getType() == OperationType.EVAL_CONSOLE_OUTPUT) {
                this.fMatlab.evalConsoleOutput(operation.getCommand(), completionObserver);
            } else if (operation.getType() == OperationType.FEVAL_CONSOLE_OUTPUT) {
                this.fMatlab.fevalConsoleOutput(operation.getCommand(), operation.getArgs(), operation.getReturnValueCount(), completionObserver);
            } else {
                throw new IllegalStateException("runOnNonMatlabThread does not handle " + (Object)((Object)operation.getType()));
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException(interruptedException);
            }
            operation.setResult(objectArray[0]);
        }
        finally {
            operation.finish();
        }
    }

    private static final class Operation {
        private final OperationType fType;
        private final String fCommand;
        private final Object[] fArgs;
        private final int fReturnValueCount;
        private final CountDownLatch fLatch;
        private Object fResult;
        private Exception fException;

        Operation(OperationType operationType, String string, int n) {
            this(operationType, string, null, n);
        }

        Operation(OperationType operationType, String string, Object[] objectArray, int n) {
            this.fType = operationType;
            this.fCommand = string;
            this.fArgs = (Object[])objectArray.clone();
            this.fReturnValueCount = n;
            this.fLatch = new CountDownLatch(1);
        }

        Object getResultOrThrowException() throws Exception {
            try {
                this.fLatch.await();
            }
            catch (InterruptedException interruptedException) {
                throw new IllegalStateException(interruptedException);
            }
            if (this.fException != null) {
                throw this.fException;
            }
            return this.fResult;
        }

        OperationType getType() {
            return this.fType;
        }

        String getCommand() {
            return this.fCommand;
        }

        Object[] getArgs() {
            return (Object[])this.fArgs.clone();
        }

        int getReturnValueCount() {
            return this.fReturnValueCount;
        }

        void setResult(Object object) {
            this.fResult = object;
        }

        void setException(Exception exception) {
            this.fException = exception;
        }

        void finish() {
            this.fLatch.countDown();
        }
    }

    private static enum OperationType {
        EVAL,
        FEVAL,
        EVAL_CONSOLE_OUTPUT,
        FEVAL_CONSOLE_OUTPUT;

    }

    public static interface Task {
        public void run(MatlabThreadContext var1);
    }

    public static interface Invoker {
        public void invoke(Runnable var1);
    }
}

