/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.util;

import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.ParameterRunnable;
import java.io.IOException;

final class NonStrictList
implements FileList {
    private final FileSystem fSystem;
    private final FileLocation fLocation;
    private final Object fLock;
    private FileList fList;

    NonStrictList(FileSystem fileSystem, FileLocation fileLocation) {
        this.fSystem = fileSystem;
        this.fLocation = fileLocation;
        this.fLock = new Object();
    }

    public FileSystemEntry getLocationEntry() {
        FileList fileList = this.getList();
        if (fileList != null) {
            return fileList.getLocationEntry();
        }
        return new FileSystemEntry(this.fSystem, this.fLocation, true, true, 0L, 0L, 0L);
    }

    public boolean exists(FileLocation fileLocation) {
        FileList fileList = this.getList();
        return fileList != null && fileList.exists(fileLocation);
    }

    public void readFilesAndFolders(AsyncReceiver<FileSystemEntry> asyncReceiver) throws IOException {
        FileList fileList = this.getList();
        if (fileList == null) {
            asyncReceiver.finished();
        } else {
            fileList.readFilesAndFolders(asyncReceiver);
        }
    }

    public void readFolders(AsyncReceiver<FileSystemEntry> asyncReceiver) throws IOException {
        FileList fileList = this.getList();
        if (fileList == null) {
            asyncReceiver.finished();
        } else {
            fileList.readFolders(asyncReceiver);
        }
    }

    public boolean hasFolders() throws IOException {
        FileList fileList = this.getList();
        return fileList != null && fileList.hasFolders();
    }

    public boolean isEmpty() throws IOException {
        FileList fileList = this.getList();
        return fileList == null || fileList.isEmpty();
    }

    public void pause(ParameterRunnable<Runnable> parameterRunnable) {
        FileList fileList = this.getList();
        if (fileList != null) {
            fileList.pause(parameterRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.fLock;
        synchronized (object) {
            FileList fileList = this.fList;
            if (fileList != null) {
                fileList.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileList getList() {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fList != null) {
                return this.fList;
            }
            try {
                this.fList = this.fSystem.getList(this.fLocation);
                this.fList.readFilesAndFolders((AsyncReceiver)new AsyncReceiver<FileSystemEntry>(){

                    public boolean receive(FileSystemEntry fileSystemEntry) {
                        return true;
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.fList;
        }
    }
}

