/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.widgets.address;

import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.ExplorerPrefs;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.navigation.InvalidLocationException;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationContext;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationHistory;
import com.mathworks.mlwidgets.explorer.model.table.UiFileList;
import com.mathworks.mlwidgets.explorer.util.MenuUtils;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBar;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarButton;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBarIcon;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.PopupMenuCustomizer;
import com.mathworks.services.settings.SettingException;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

final class AddressBarButtonUtils {
    private AddressBarButtonUtils() {
    }

    static AddressBarButton createHistoryButton(final JComponent jComponent, final AddressBar addressBar) {
        AddressBarButton addressBarButton = new AddressBarButton(addressBar, AddressBarIcon.getDownArrow(), jComponent, false, new PopupMenuCustomizer(){

            public void customize(JPopupMenu jPopupMenu) {
                LinkedList<MJMenuItem> linkedList = new LinkedList<MJMenuItem>();
                for (final NavigationHistory.HistoryItem historyItem : addressBar.getHistory().getRestorableItems()) {
                    CopyableMenuItem copyableMenuItem = new CopyableMenuItem(historyItem.toString());
                    copyableMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                historyItem.restore();
                            }
                            catch (InvalidLocationException invalidLocationException) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        MJOptionPane.showMessageDialog((Component)jComponent, (Object)MessageFormat.format(ExplorerResources.getString("changedir.error"), "'" + historyItem.toString() + "'"), (String)ExplorerResources.getString("changedir.error.title"), (int)2);
                                    }
                                });
                            }
                        }
                    });
                    linkedList.add(copyableMenuItem);
                }
                MenuUtils.createScrollingMenu(jComponent, jPopupMenu, linkedList, jComponent.getWidth() - 6, false);
            }
        });
        addressBarButton.getComponent().setName("HistoryButton");
        return addressBarButton;
    }

    static AddressBarButton createPathExtensionButton(final JComponent jComponent, final AddressBar addressBar, final FileLocation fileLocation) {
        AddressBarButton addressBarButton = new AddressBarButton(addressBar, AddressBarIcon.getLeftArrow(), new PopupMenuCustomizer(){

            public void customize(JPopupMenu jPopupMenu) {
                NavigationContext navigationContext = addressBar.getContext();
                LinkedList<MJMenuItem> linkedList = new LinkedList<MJMenuItem>();
                for (FileLocation fileLocation3 = fileLocation; fileLocation3 != null; fileLocation3 = fileLocation3.getParent()) {
                    String string = addressBar.getContext().getSystem().decodeName(fileLocation3.getName());
                    if (string.length() <= 0) continue;
                    CopyableMenuItem copyableMenuItem = new CopyableMenuItem(string, UiFileSystemUtils.getIconEvenIfNonExistent(navigationContext.getSystem(), fileLocation3, navigationContext.getExtensions()));
                    final FileLocation fileLocation2 = fileLocation3;
                    linkedList.add(copyableMenuItem);
                    copyableMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                addressBar.getContext().setLocation(fileLocation2);
                            }
                            catch (InvalidLocationException invalidLocationException) {
                                // empty catch block
                            }
                        }
                    });
                }
                MenuUtils.createScrollingMenu(jComponent, jPopupMenu, linkedList);
            }
        });
        addressBarButton.getComponent().setName("PathPrefixExtensionButton");
        return addressBarButton;
    }

    private static boolean hasFolders(FileList fileList) {
        try {
            return fileList.hasFolders();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static AddressBarButton createBreadcrumbButton(JComponent jComponent, final AddressBar addressBar, FileLocation[] fileLocationArray, final FileLocation fileLocation, final FileLocation fileLocation2, boolean bl, boolean bl2) {
        final NavigationContext navigationContext = addressBar.getContext();
        boolean bl3 = !bl2 && fileLocation2 == null && (addressBar.getContext().isSearching() || !AddressBarButtonUtils.hasFolders(navigationContext.getList()));
        String string = addressBar.getContext().getSystem().decodeName(fileLocation.getName());
        final boolean bl4 = string.length() > 0 && (!fileLocation.equals((Object)FileLocation.ROOT) || addressBar.isRootVisible());
        AddressBarButton addressBarButton = new AddressBarButton(addressBar, bl4 ? AddressBarButtonUtils.getBreadcrumbLabel(jComponent, addressBar, fileLocationArray, fileLocation, bl) : null, bl3 ? null : AddressBarIcon.getDownArrow(), bl3 ? null : AddressBarIcon.getRightArrow(), true, new Runnable(){

            @Override
            public void run() {
                try {
                    if (bl4) {
                        navigationContext.setLocation(fileLocation);
                    }
                }
                catch (InvalidLocationException invalidLocationException) {
                    // empty catch block
                }
            }
        }, new PopupMenuCustomizer(){

            public void customize(JPopupMenu jPopupMenu) {
                DocumentLocationMenuGenerator documentLocationMenuGenerator = new DocumentLocationMenuGenerator(addressBar, fileLocation);
                MenuUtils.createScrollingMenu(addressBar.getComponent(), jPopupMenu, documentLocationMenuGenerator, !addressBar.isSortedAlphabetically() ? null : new AlphabeticalComparator(), new DocumentLocationToMenuItemConverter(addressBar, fileLocation2, documentLocationMenuGenerator), 0);
            }
        });
        addressBarButton.getComponent().setName("PathComponentButton_" + string);
        return addressBarButton;
    }

    static Icon getCurrentLocationIcon(AddressBar addressBar) {
        return AddressBarButtonUtils.getLocationIcon(addressBar, addressBar.getContext().getLocation());
    }

    static Icon getLocationIcon(AddressBar addressBar, FileLocation fileLocation) {
        NavigationContext navigationContext = addressBar.getContext();
        return UiFileSystemUtils.getIconEvenIfNonExistent(navigationContext.getSystem(), fileLocation, navigationContext.getExtensions());
    }

    private static String getBreadcrumbLabel(JComponent jComponent, AddressBar addressBar, FileLocation[] fileLocationArray, FileLocation fileLocation, boolean bl) {
        String string = addressBar.getContext().getSystem().decodeName(fileLocation.getName());
        if (fileLocation.isUrl()) {
            try {
                FileSystemEntry fileSystemEntry = addressBar.getContext().getSystem().getEntry(fileLocation);
                string = (String)UiFileSystemUtils.getDecorationSynchronously(fileSystemEntry, CoreFileDecoration.DISPLAY_NAME, addressBar.getContext().getExtensions());
                if (string == null) {
                    string = fileLocation.toString();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!bl || fileLocationArray.length > 1) {
            return string;
        }
        int n = (int)(new MJLabel(AddressBarButtonUtils.getCurrentLocationIcon(addressBar)).getPreferredSize().getWidth() + AddressBarButtonUtils.createPathExtensionButton(jComponent, addressBar, fileLocation).getComponent().getPreferredSize().getWidth() + new MJLabel(AddressBarIcon.getRightArrow()).getPreferredSize().getWidth() + AddressBarButtonUtils.createHistoryButton(jComponent, addressBar).getComponent().getPreferredSize().getWidth()) + 18;
        int n2 = (int)new MJLabel(string).getPreferredSize().getWidth();
        String string2 = string;
        for (int i = 4; i < string.length() && n2 + n > jComponent.getWidth(); ++i) {
            string2 = string.substring(0, string.length() - i) + "...";
            n2 = (int)new MJLabel(string2).getPreferredSize().getWidth();
        }
        return string2;
    }

    private static class CopyableMenuItem
    extends MJMenuItem {
        CopyableMenuItem(String string) {
            super(string);
        }

        CopyableMenuItem(String string, Icon icon) {
            super(string, icon);
        }

        public String toString() {
            return this.getText();
        }
    }

    private static class AlphabeticalComparator
    implements Comparator<FileSystemEntry> {
        private AlphabeticalComparator() {
        }

        @Override
        public int compare(FileSystemEntry fileSystemEntry, FileSystemEntry fileSystemEntry2) {
            return fileSystemEntry.getSystem().decodeName(fileSystemEntry.getName()).compareToIgnoreCase(fileSystemEntry2.getSystem().decodeName(fileSystemEntry2.getName()));
        }
    }

    private static class DocumentLocationToMenuItemConverter
    implements Converter<FileSystemEntry, MJMenuItem> {
        private final AddressBar fAddressBar;
        private final FileLocation fLocationToHighlight;
        private final Converter<FileLocation, Icon> fIconRetriever;

        DocumentLocationToMenuItemConverter(AddressBar addressBar, FileLocation fileLocation, Converter<FileLocation, Icon> converter) {
            this.fAddressBar = addressBar;
            this.fLocationToHighlight = fileLocation;
            this.fIconRetriever = converter;
        }

        public MJMenuItem convert(final FileSystemEntry fileSystemEntry) {
            Icon icon = (Icon)this.fIconRetriever.convert((Object)fileSystemEntry.getLocation());
            CopyableMenuItem copyableMenuItem = new CopyableMenuItem(this.fAddressBar.getContext().getSystem().decodeName(fileSystemEntry.getName()), icon);
            if (this.fLocationToHighlight != null && fileSystemEntry.getLocation().equals((Object)this.fLocationToHighlight)) {
                copyableMenuItem.setFont(copyableMenuItem.getFont().deriveFont(1));
            }
            copyableMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        DocumentLocationToMenuItemConverter.this.fAddressBar.getContext().setLocation(fileSystemEntry.getLocation());
                    }
                    catch (InvalidLocationException invalidLocationException) {
                        // empty catch block
                    }
                }
            });
            return copyableMenuItem;
        }
    }

    private static class DocumentLocationMenuGenerator
    implements ParameterRunnable<AsyncReceiver<FileSystemEntry>>,
    Converter<FileLocation, Icon> {
        private final AddressBar fAddressBar;
        private final UiFileList fList;
        private final Map<FileLocation, Icon> fIcons;

        DocumentLocationMenuGenerator(AddressBar addressBar, FileLocation fileLocation) {
            this.fAddressBar = addressBar;
            FileList fileList = null;
            try {
                fileList = this.fAddressBar.getContext().getSystem().getList(fileLocation);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fList = new UiFileList(this.fAddressBar.getRequestQueue(), fileList, false, true, this.fAddressBar.getRefreshDaemon());
            this.fIcons = new HashMap<FileLocation, Icon>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Icon convert(FileLocation fileLocation) {
            Map<FileLocation, Icon> map = this.fIcons;
            synchronized (map) {
                return this.fIcons.get(fileLocation);
            }
        }

        public void run(final AsyncReceiver<FileSystemEntry> asyncReceiver) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DocumentLocationMenuGenerator.this.fList.read(new AsyncReceiver<FileSystemEntry>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public boolean receive(FileSystemEntry fileSystemEntry) {
                            Icon icon = (Icon)UiFileSystemUtils.getDecorationSynchronously(DocumentLocationMenuGenerator.this.fList, fileSystemEntry, CoreFileDecoration.ICON, false, DocumentLocationMenuGenerator.this.fAddressBar.getContext().getExtensions());
                            Map map = DocumentLocationMenuGenerator.this.fIcons;
                            synchronized (map) {
                                try {
                                    if (DocumentLocationMenuGenerator.this.fIcons.size() < (Integer)ExplorerPrefs.CurrentFolderSize.get()) {
                                        DocumentLocationMenuGenerator.this.fIcons.put(fileSystemEntry.getLocation(), icon);
                                    }
                                }
                                catch (SettingException settingException) {
                                    throw new RuntimeException(settingException);
                                }
                            }
                            return asyncReceiver.receive((Object)fileSystemEntry);
                        }
                    });
                }
            };
            if (this.fAddressBar.getContext().supportsAsyncFileSystemAccess()) {
                new Thread(runnable).start();
            } else {
                runnable.run();
            }
        }
    }
}

