/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.widgets.address;

import com.jidesoft.hints.AbstractListIntelliHints;
import com.jidesoft.popup.JidePopup;
import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationContext;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.Combiner;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.RequestAggregator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class DocumentIntelliHints {
    private static MJTextField sField;

    private DocumentIntelliHints() {
    }

    public static synchronized void install(NavigationContext navigationContext, MJTextField mJTextField, ParameterRunnable<String> parameterRunnable) {
        sField = mJTextField;
        new FileSystemHints(navigationContext, parameterRunnable);
        sField = null;
    }

    private static class HintReceiver
    extends AsyncReceiver<FileLocation> {
        private final FileSystemHints fHints;
        private final String fPrefix;
        private final String fLocation;
        private final RequestAggregator<ListAdd> fAggregator;
        private boolean fDead;
        private List<Object> fListData;

        HintReceiver(RequestAggregator<ListAdd> requestAggregator, FileSystemHints fileSystemHints, String string) {
            this.fHints = fileSystemHints;
            this.fAggregator = requestAggregator;
            int n = string.lastIndexOf(File.separator);
            this.fLocation = n > 0 ? string.substring(0, n + 1) : string;
            this.fPrefix = string;
            this.fListData = new Vector<Object>();
        }

        public String getPrefix() {
            return this.fPrefix;
        }

        public String getLocation() {
            return this.fLocation;
        }

        public void finished() {
            this.fAggregator.runWhenIdle(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (HintReceiver.this.fListData.isEmpty()) {
                                HintReceiver.this.fHints.setListData(new Object[0]);
                            }
                        }
                    });
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            FileList fileList = null;
            try {
                if (!FileLocation.isUrlString((String)this.fLocation)) {
                    fileList = this.fHints.getContext().getSystem().getList(new FileLocation(this.fLocation));
                    fileList.readFolders(FileSystemUtils.createEntryAdapter(this));
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (IOException iOException) {
            }
            finally {
                this.finished();
                if (fileList != null) {
                    fileList.close();
                }
            }
        }

        public void kill() {
            this.fDead = true;
        }

        public boolean receive(final FileLocation fileLocation) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!HintReceiver.this.fDead) {
                        boolean bl = fileLocation.toString().startsWith(HintReceiver.this.fPrefix);
                        if (!bl && PlatformInfo.isWindows()) {
                            bl = fileLocation.toString().toUpperCase().startsWith(HintReceiver.this.fPrefix.toUpperCase());
                        }
                        if (bl) {
                            HintReceiver.this.fAggregator.request((Runnable)new ListAdd(HintReceiver.this, HintReceiver.this.fListData, HintReceiver.this.fHints, fileLocation.toString()));
                        }
                    }
                }
            });
            return !this.fDead;
        }

        public boolean isDead() {
            return this.fDead;
        }
    }

    private static class FileSystemHints
    extends AbstractListIntelliHints {
        private final NavigationContext fContext;
        private final ParameterRunnable<String> fAcceptHandler;
        private final RequestAggregator<ListAdd> fAggregator;
        private JidePopup fPopup;
        private HintReceiver fReceiver;
        private boolean fBypassUpdate;
        private HintsList fList;

        FileSystemHints(NavigationContext navigationContext, ParameterRunnable<String> parameterRunnable) {
            super((JTextComponent)sField);
            this.fContext = navigationContext;
            this.fAcceptHandler = parameterRunnable;
            this.fAggregator = new RequestAggregator((Combiner)new Combiner<ListAdd, Runnable>(){

                public Runnable combine(List<ListAdd> list) {
                    return new ListAdd(list);
                }
            });
            this.createList();
            this.fList.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (FileSystemHints.this.getList().getSelectedValue() != null && FileSystemHints.this.getList().getSelectedValue().toString().trim().length() > 0) {
                        FileSystemHints.this.fAcceptHandler.run((Object)FileSystemHints.this.getList().getSelectedValue().toString());
                    }
                }
            });
            KeyEventDispatcher keyEventDispatcher = new KeyEventDispatcher(){

                @Override
                public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                    if (FileSystemHints.this.isHintsPopupVisible() && keyEvent.getKeyCode() == 10 && FileSystemHints.this.getList().getSelectedValue() != null) {
                        FileSystemHints.this.fList.processKeyEvent(new KeyEvent((Component)((Object)FileSystemHints.this.getList()), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar()));
                        return true;
                    }
                    if (FileSystemHints.this.isHintsPopupVisible() && keyEvent.getKeyCode() == 9 && FileSystemHints.this.fList.getModel().getSize() > 0) {
                        if (keyEvent.getID() == 401) {
                            int n = FileSystemHints.this.fList.getSelectedIndex();
                            if (keyEvent.isShiftDown()) {
                                if (n - 1 < 0) {
                                    FileSystemHints.this.fList.setSelectedIndex(FileSystemHints.this.fList.getModel().getSize() - 1);
                                } else {
                                    FileSystemHints.this.fList.setSelectedIndex(n - 1);
                                }
                            } else if (n + 1 >= FileSystemHints.this.fList.getModel().getSize()) {
                                FileSystemHints.this.fList.setSelectedIndex(0);
                            } else {
                                FileSystemHints.this.fList.setSelectedIndex(n + 1);
                            }
                        }
                        return true;
                    }
                    return false;
                }
            };
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.addKeyEventDispatcher(keyEventDispatcher);
        }

        public synchronized JList createList() {
            if (this.fList == null) {
                this.fList = new HintsList(sField);
            }
            return this.fList;
        }

        public void acceptHint(Object object) {
            if (object != null) {
                this.fAcceptHandler.run((Object)object.toString());
            }
        }

        protected JidePopup createPopup() {
            JidePopup jidePopup;
            this.fPopup = jidePopup = super.createPopup();
            return jidePopup;
        }

        public boolean updateHints(Object object) {
            if (!this.fBypassUpdate) {
                if (this.fReceiver != null) {
                    this.fReceiver.kill();
                }
                this.fReceiver = new HintReceiver(this.fAggregator, this, this.getTextComponent().getText());
                this.fReceiver.start();
            }
            return this.fList.getModel().getSize() > 0;
        }

        public NavigationContext getContext() {
            return this.fContext;
        }

        public void setListData(Object[] objectArray) {
            this.fList.setListData(objectArray);
            this.fList.setVisibleRowCount(Math.min(10, objectArray.length));
            super.setListData(objectArray);
            if (objectArray.length == 0) {
                this.hideHintsPopup();
            } else if (!this.fPopup.isShowing()) {
                this.fBypassUpdate = true;
                this.showHintsPopup();
                this.fBypassUpdate = false;
            } else {
                this.fPopup.packPopup();
            }
        }

        public HintsList getList() {
            return this.fList;
        }
    }

    private static class ListAdd
    implements Runnable {
        private final FileSystemHints fHints;
        private final List<Object> fObjects;
        private final List<Object> fListData;
        private final HintReceiver fReceiver;

        ListAdd(HintReceiver hintReceiver, List<Object> list, FileSystemHints fileSystemHints, Object object) {
            this.fHints = fileSystemHints;
            this.fObjects = new Vector<Object>();
            this.fObjects.add(object);
            this.fListData = list;
            this.fReceiver = hintReceiver;
        }

        ListAdd(List<ListAdd> list) {
            this.fObjects = new Vector<Object>();
            FileSystemHints fileSystemHints = null;
            List<Object> list2 = null;
            HintReceiver hintReceiver = null;
            for (ListAdd listAdd : list) {
                if (listAdd.fReceiver.isDead()) continue;
                this.fObjects.addAll(listAdd.fObjects);
                fileSystemHints = listAdd.fHints;
                list2 = listAdd.fListData;
                hintReceiver = listAdd.fReceiver;
            }
            this.fHints = fileSystemHints;
            this.fListData = list2;
            this.fReceiver = hintReceiver;
        }

        @Override
        public void run() {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (ListAdd.this.fReceiver != null && !ListAdd.this.fReceiver.isDead()) {
                        ListAdd.this.fListData.addAll(ListAdd.this.fObjects);
                        int n = ListAdd.this.fHints.getList().getSelectedIndex();
                        Collections.sort(ListAdd.this.fListData, new Comparator<Object>(){

                            @Override
                            public int compare(Object object, Object object2) {
                                return object.toString().compareToIgnoreCase(object2.toString());
                            }
                        });
                        ListAdd.this.fHints.setListData(ListAdd.this.fListData.toArray());
                        if (n >= 0 && n < ListAdd.this.fListData.size()) {
                            ListAdd.this.fHints.getList().setSelectedIndex(n);
                        }
                    }
                }
            });
        }
    }

    private static class HintsList
    extends MJList {
        private final MJTextField fField;

        HintsList(MJTextField mJTextField) {
            this.fField = mJTextField;
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            super.processKeyEvent(keyEvent);
        }

        public Dimension getPreferredScrollableViewportSize() {
            if (this.getModel().getSize() == 0) {
                return new Dimension(0, 0);
            }
            this.setVisibleRowCount(Math.min(10, this.getModel().getSize()));
            return new Dimension(Math.max(this.fField.getWidth(), (int)super.getPreferredScrollableViewportSize().getWidth()), (int)super.getPreferredScrollableViewportSize().getHeight());
        }
    }
}

