/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.widgets.address;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Paint;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

final class SearchButton {
    private final MJButton fButton;
    private final Runnable fActionCode;
    private boolean fRoundedOnLeft;
    private boolean fPressed;

    SearchButton(Icon icon, Runnable runnable) {
        this.fActionCode = runnable;
        this.fButton = new MJButton(icon){

            public void paint(Graphics graphics) {
                Cloneable cloneable;
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setColor(this.getParent().getBackground());
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                boolean bl = false;
                if (pointerInfo != null && pointerInfo.getLocation() != null) {
                    bl = true;
                    cloneable = new Point(pointerInfo.getLocation());
                    SwingUtilities.convertPointFromScreen((Point)cloneable, (Component)((Object)this));
                    if (!this.contains((Point)cloneable)) {
                        bl = false;
                    }
                }
                graphics2D.setColor(UIManager.getColor("control"));
                graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
                if (!MJUtilities.isHighContrast()) {
                    GradientPaint gradientPaint;
                    GradientPaint gradientPaint2;
                    cloneable = new RoundRectangle2D.Double(-3.0, 0.0, this.getWidth() + 2, this.getHeight() / 2, 5.0, 5.0);
                    RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(-3.0, (float)this.getHeight() / 2.0f, this.getWidth() + 2, (float)(this.getHeight() - 1) / 2.0f, 5.0, 5.0);
                    Rectangle2D.Double double_2 = new Rectangle2D.Double(-3.0, (double)this.getHeight() / 2.0 - 3.5, this.getWidth() + 2, 2.5);
                    Rectangle2D.Double double_3 = new Rectangle2D.Double(-3.0, (double)this.getHeight() / 2.0, this.getWidth() + 2, 2.5);
                    if (SearchButton.this.fPressed && bl) {
                        gradientPaint2 = SearchButton.createVerticalGradient(((RoundRectangle2D.Double)cloneable).getBounds2D(), new Color(230, 240, 249), new Color(197, 208, 219));
                        gradientPaint = SearchButton.createVerticalGradient(double_.getBounds2D(), new Color(158, 175, 186), new Color(193, 204, 212));
                    } else {
                        gradientPaint2 = SearchButton.createVerticalGradient(((RoundRectangle2D.Double)cloneable).getBounds2D(), new Color(237, 239, 243), new Color(223, 228, 243));
                        gradientPaint = bl ? SearchButton.createVerticalGradient(double_.getBounds2D(), new Color(193, 200, 220), new Color(231, 234, 241)) : SearchButton.createVerticalGradient(double_.getBounds2D(), new Color(212, 218, 239), new Color(237, 240, 246));
                    }
                    Paint paint = graphics2D.getPaint();
                    graphics2D.setPaint(gradientPaint2);
                    graphics2D.fill((Shape)((Object)cloneable));
                    graphics2D.fill(double_2);
                    graphics2D.setPaint(gradientPaint);
                    graphics2D.fill(double_);
                    graphics2D.fill(double_3);
                    graphics2D.setPaint(paint);
                }
                cloneable = SearchButton.this.fRoundedOnLeft ? new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() + 2, this.getHeight() - 1, 5.0, 5.0) : new RoundRectangle2D.Double(-3.0, 0.0, this.getWidth() + 2, this.getHeight() - 1, 5.0, 5.0);
                if (bl && MJUtilities.isHighContrast()) {
                    graphics2D.setStroke(new BasicStroke(2.0f));
                }
                if (SearchButton.this.fPressed && bl) {
                    graphics2D.setColor(ColorUtils.convertToCurrentColorScheme((Color)new Color(113, 123, 146), (Color)UIManager.getColor("control")));
                    graphics2D.draw((Shape)((Object)cloneable));
                } else {
                    graphics2D.setColor(ColorUtils.convertToCurrentColorScheme((Color)new Color(168, 173, 185), (Color)UIManager.getColor("control")));
                    graphics2D.draw((Shape)((Object)cloneable));
                }
                this.getIcon().paintIcon((Component)((Object)this), graphics2D, this.getWidth() / 2 - this.getIcon().getIconWidth() / 2, this.getHeight() / 2 - this.getIcon().getIconHeight() / 2);
                graphics2D.dispose();
            }

            public Dimension getPreferredSize() {
                return new Dimension(22, 22);
            }
        };
        this.fButton.setBorder(null);
        this.fButton.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                SearchButton.this.fButton.revalidate();
                SearchButton.this.fButton.repaint();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                SearchButton.this.fPressed = true;
                SearchButton.this.fButton.revalidate();
                SearchButton.this.fButton.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                SearchButton.this.fPressed = false;
                SearchButton.this.fButton.revalidate();
                SearchButton.this.fButton.repaint();
            }
        });
        this.fButton.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                SearchButton.this.fButton.revalidate();
                SearchButton.this.fButton.repaint();
            }
        });
        this.fButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchButton.this.fActionCode.run();
            }
        });
    }

    public void setIcon(Icon icon) {
        this.fButton.setIcon(icon);
        this.fButton.revalidate();
        this.fButton.repaint();
    }

    public void setToolTipText(String string) {
        this.fButton.setToolTipText(string);
    }

    public void setRoundedOnLeft(boolean bl) {
        this.fRoundedOnLeft = bl;
    }

    public JComponent getComponent() {
        return this.fButton;
    }

    private static GradientPaint createVerticalGradient(Rectangle2D rectangle2D, Color color, Color color2) {
        return new GradientPaint((int)rectangle2D.getX(), (int)rectangle2D.getY(), color, (int)rectangle2D.getX(), (int)(rectangle2D.getY() + rectangle2D.getHeight() - 1.0), color2);
    }
}

