/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.mathworks.mlwidgets.workspace.WorkspaceFilter;
import java.util.Vector;

public class PlotArgDescriptor {
    private String name;
    private String axis;
    private String label;
    private RequiredType required;
    private DependentType dependent;
    private int[] numDimensions;

    public PlotArgDescriptor(String string, int[] nArray) {
        this(string, null, null, RequiredType.REQUIRED, DependentType.DEPENDENT, nArray);
    }

    public PlotArgDescriptor(String string, String string2, String string3, RequiredType requiredType, DependentType dependentType, int[] nArray) {
        this.name = string;
        this.axis = string2;
        this.label = string3;
        this.required = requiredType;
        this.dependent = dependentType;
        this.numDimensions = nArray;
    }

    public String getName() {
        return this.name;
    }

    public String getAxis() {
        return this.axis;
    }

    public String getLabel() {
        return this.label;
    }

    public RequiredType getRequired() {
        return this.required;
    }

    public DependentType getDependent() {
        return this.dependent;
    }

    public int[] getNumDimensions() {
        return this.numDimensions;
    }

    public String toString() {
        return this.name;
    }

    public static PlotArgDescriptor[] createFromVarInfo(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        int n;
        boolean bl = true;
        Vector<PlotArgDescriptor> vector = new Vector<PlotArgDescriptor>();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!WorkspaceFilter.getNumericFilter().accept((Object)stringArray3[i]) && !WorkspaceFilter.getLogicalFilter().accept((Object)stringArray3[i])) continue;
            if (WorkspaceFilter.getScalarFilter().accept((Object)stringArray2[i])) {
                n = 0;
            } else if (WorkspaceFilter.getRowFilter().accept((Object)stringArray2[i]) || WorkspaceFilter.getColumnFilter().accept((Object)stringArray2[i])) {
                n = 1;
                bl = false;
            } else if (WorkspaceFilter.get2DFilter().accept((Object)stringArray2[i])) {
                n = 2;
                bl = false;
            } else {
                byte[] byArray = stringArray2[i].getBytes();
                n = 0;
                for (int j = 0; j < byArray.length; ++j) {
                    if (byArray[j] != 120) continue;
                    ++n;
                }
                bl = false;
            }
            vector.add(new PlotArgDescriptor(stringArray[i], new int[]{n}));
        }
        if (bl) {
            return null;
        }
        PlotArgDescriptor[] plotArgDescriptorArray = new PlotArgDescriptor[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            plotArgDescriptorArray[n] = (PlotArgDescriptor)vector.get(n);
        }
        return plotArgDescriptorArray;
    }

    public static class DependentType {
        public static final DependentType DEPENDENT = new DependentType();
        public static final DependentType INDEPENDENT = new DependentType();
        public static final DependentType PRESENTATION = new DependentType();

        private DependentType() {
        }
    }

    public static class RequiredType {
        public static final RequiredType REQUIRED = new RequiredType();
        public static final RequiredType OPTIONAL = new RequiredType();

        private RequiredType() {
        }
    }
}

