/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.mathworks.mlwidgets.graphics.PlotCatalogPanel;
import com.mathworks.mlwidgets.graphics.PlotMetadata;
import com.mathworks.mlwidgets.graphics.PlotSignature;
import com.mathworks.mlwidgets.graphics.PlotWidgetsResources;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.util.PlatformInfo;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class PlotTypeCombo
extends MJComboBox {
    protected static PlotSignature[] DEFAULT_PLOT_TYPES = new PlotSignature[]{PlotMetadata.getPlotSignature("plot"), PlotMetadata.getPlotSignature("bar"), PlotMetadata.getPlotSignature("scatter"), PlotMetadata.getPlotSignature("contour"), PlotMetadata.getPlotSignature("imagesc"), PlotMetadata.getPlotSignature("surf"), PlotMetadata.getPlotSignature("mesh")};
    protected static final String CATALOG_ITEM = PlotWidgetsResources.getBundle().getString("PlotTypeCombo.catalogitem");
    protected PlotCatalogPanel fPlotCatalog = null;
    private Hashtable icons = new Hashtable();
    private PlotSignature prevPlotType = PlotMetadata.getPlotSignature("plot");

    public PlotTypeCombo() {
        this(DEFAULT_PLOT_TYPES);
    }

    public PlotTypeCombo(PlotSignature[] plotSignatureArray) {
        if (PlatformInfo.getAppearance() == 1) {
            this.setUI((ComboBoxUI)((Object)new ThinArrowWindowsComboBoxUI()));
        }
        this.setEditable(false);
        this.setMaximumRowCount(8);
        this.setRenderer(new PlotTypeComboRenderer());
        for (int i = 0; i < plotSignatureArray.length; ++i) {
            this.addItem(plotSignatureArray[i]);
        }
        this.addItem(CATALOG_ITEM);
    }

    public void addItem(PlotSignature plotSignature) {
        super.addItem((Object)plotSignature);
        URL uRL = plotSignature.getLargeIconURL();
        this.icons.put(plotSignature, new ImageIcon(uRL));
    }

    public void insertItemAt(PlotSignature plotSignature, int n) {
        super.insertItemAt((Object)plotSignature, n);
        URL uRL = plotSignature.getLargeIconURL();
        this.icons.put(plotSignature, new ImageIcon(uRL));
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2 && !itemEvent.getItem().equals(CATALOG_ITEM)) {
            this.prevPlotType = (PlotSignature)itemEvent.getItem();
        }
        super.fireItemStateChanged(itemEvent);
    }

    protected void fireActionEvent() {
        if (this.getSelectedItem().equals(CATALOG_ITEM)) {
            this.setPopupVisible(false);
            PlotSignature plotSignature = this.launchCatalog();
            if (plotSignature != null) {
                this.handleCatalogResults(plotSignature);
            } else {
                this.setSelectedItem(this.prevPlotType);
            }
        }
        super.fireActionEvent();
    }

    protected PlotSignature launchCatalog() {
        MJDialog mJDialog;
        if (this.fPlotCatalog == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.fPlotCatalog = new PlotCatalogPanel();
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        MJOptionPane mJOptionPane = new MJOptionPane((Object)this.fPlotCatalog, -1, 0, null, new Object[]{PlotWidgetsResources.getBundle().getString("PlotTypeCombo.catalog.button.ok"), PlotWidgetsResources.getBundle().getString("PlotTypeCombo.catalog.button.cancel")}, (Object)PlotWidgetsResources.getBundle().getString("PlotTypeCombo.catalog.button.ok"));
        try {
            mJDialog = (MJDialog)mJOptionPane.createDialog((Component)this.getTopLevelAncestor(), PlotWidgetsResources.getBundle().getString("PlotTypeCombo.catalog.title"));
        }
        catch (HeadlessException headlessException) {
            return null;
        }
        mJDialog.setMinimumSize(new Dimension(440, 250));
        mJDialog.setResizable(true);
        mJDialog.setModal(true);
        mJDialog.pack();
        mJDialog.show();
        int n = -1;
        if (!(mJOptionPane.getValue() instanceof String)) {
            return null;
        }
        String string = (String)mJOptionPane.getValue();
        Object[] objectArray = mJOptionPane.getOptions();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!objectArray[i].equals(string)) continue;
            n = i;
            break;
        }
        if (n == 0) {
            return this.fPlotCatalog.getPlotType();
        }
        return null;
    }

    protected void handleCatalogResults(PlotSignature plotSignature) {
        if (!this.containsPlotType(plotSignature)) {
            this.insertItemAt(plotSignature, this.getItemCount() - 1);
        }
        this.setSelectedItem(plotSignature);
    }

    protected boolean containsPlotType(PlotSignature plotSignature) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!this.getItemAt(i).equals(plotSignature)) continue;
            return true;
        }
        return false;
    }

    public void updateUI() {
        Object var1_1 = null;
        if (PlatformInfo.getAppearance() == 1) {
            this.setUI((ComboBoxUI)((Object)new ThinArrowWindowsComboBoxUI()));
        } else {
            super.updateUI();
        }
    }

    public static class BlankIcon
    implements Icon {
        private int fWidth;
        private int fHeight;

        public BlankIcon(int n, int n2) {
            this.fWidth = n;
            this.fHeight = n2;
        }

        public BlankIcon() {
            this(20, 0);
        }

        @Override
        public int getIconHeight() {
            return this.fHeight;
        }

        @Override
        public int getIconWidth() {
            return this.fWidth;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }

    static class ThinArrowWindowsComboBoxUI
    extends WindowsComboBoxUI {
        ThinArrowWindowsComboBoxUI() {
        }

        protected LayoutManager createLayoutManager() {
            return new ThinArrowLayoutManager();
        }

        protected JComboBox localGetComboBox() {
            return this.comboBox;
        }

        protected JButton localGetArrowButton() {
            return this.arrowButton;
        }

        protected Component localGetEditor() {
            return this.editor;
        }

        protected Rectangle localGetRectangleForCurrentValue() {
            return this.rectangleForCurrentValue();
        }

        public class ThinArrowLayoutManager
        extends BasicComboBoxUI.ComboBoxLayoutManager {
            public ThinArrowLayoutManager() {
                super((BasicComboBoxUI)((Object)ThinArrowWindowsComboBoxUI.this));
            }

            @Override
            public void layoutContainer(Container container) {
                Component component;
                JComboBox jComboBox = (JComboBox)container;
                int n = jComboBox.getWidth();
                int n2 = jComboBox.getHeight();
                Insets insets = ThinArrowWindowsComboBoxUI.this.localGetComboBox().getInsets();
                int n3 = 17;
                int n4 = n2 - (insets.top + insets.bottom);
                JButton jButton = ThinArrowWindowsComboBoxUI.this.localGetArrowButton();
                if (jButton != null) {
                    if (jComboBox.getComponentOrientation().isLeftToRight()) {
                        jButton.setBounds(n - (insets.right + n3), insets.top, n3, n4);
                    } else {
                        jButton.setBounds(insets.left, insets.top, n3, n4);
                    }
                }
                if ((component = ThinArrowWindowsComboBoxUI.this.localGetEditor()) != null) {
                    Rectangle rectangle = ThinArrowWindowsComboBoxUI.this.localGetRectangleForCurrentValue();
                    component.setBounds(rectangle);
                }
            }
        }
    }

    class PlotTypeComboRenderer
    extends BasicComboBoxRenderer {
        public PlotTypeComboRenderer() {
            if (!PlatformInfo.isMacintosh()) {
                this.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            }
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (!PlatformInfo.isMacintosh()) {
                Icon icon = (Icon)PlotTypeCombo.this.icons.get(object);
                if (icon == null) {
                    icon = new BlankIcon(60, 46);
                }
                this.setIcon(icon);
            }
            return component;
        }
    }
}

