/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.DocPage;
import com.mathworks.help.helpui.DocUrlParser;
import com.mathworks.html.ChildUrlRelativizer;
import com.mathworks.html.FileUrl;
import com.mathworks.html.Url;
import com.mathworks.html.UrlBuilder;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.mlwidgets.help.AddOnFileProvider;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractAddOnFileProvider
implements AddOnFileProvider {
    @Override
    public List<File> getSearchPath() {
        if (Matlab.isMatlabAvailable()) {
            try {
                List list = MatlabPath.getSearchPathEntries();
                ArrayList<File> arrayList = new ArrayList<File>();
                for (MatlabPath.PathEntry pathEntry : list) {
                    File file = pathEntry.getCurrentlyResolvedPath();
                    if (AbstractAddOnFileProvider.isPathUnderToolboxOrHelp(file)) continue;
                    arrayList.add(file);
                }
                return arrayList;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private static boolean isPathUnderToolboxOrHelp(File file) {
        if (file == null || !Matlab.isMatlabAvailable()) {
            return false;
        }
        String string = Matlab.matlabRoot();
        if (string == null) {
            return false;
        }
        FileUrl fileUrl = new FileUrl(file);
        FileUrl fileUrl2 = (FileUrl)UrlBuilder.fromFile((File)new File(string)).append(new String[]{"toolbox"}).toUrl();
        if (new ChildUrlRelativizer((Url)fileUrl2).isChild((Url)fileUrl)) {
            return true;
        }
        DocUrlParser docUrlParser = DocCenterDocConfig.getInstance().getDocUrlParser();
        DocPage docPage = docUrlParser.resolve((Url)fileUrl);
        if (docPage != null) {
            return true;
        }
        return AbstractAddOnFileProvider.isFileUnderSupportPackage(file, docUrlParser);
    }

    private static boolean isFileUnderSupportPackage(File file, DocUrlParser docUrlParser) {
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        while (file != null) {
            File file2 = new File(file, "help");
            if (docUrlParser.isAlternateDocRoot(file2)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }
}

