/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.ContextHelpProvider;
import com.mathworks.mwswing.MJAbstractAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class ContextHelpDispatcher
extends MouseInputAdapter {
    private JFrame fFrame;
    private JDialog fDialog;
    private MJAbstractAction fToggleAction;
    private InputMap fInputMap;
    private JComponent fGlassPane;
    private Component fContentPane;
    private Component fSaveGlassPane;
    private boolean fIsActive;
    private boolean fHelpFound;
    private boolean fSaveGlassVisible;
    private boolean fAnyHeavyweights;
    private List fSavedCursors;
    private Iterator fCursorsIterator;
    private static Cursor sHelpCursor;
    private static Cursor sHelpFoundCursor;
    private static Icon sHelpIcon;
    private static final KeyStroke ACTIVATION_STROKE;
    private static final KeyStroke DEACTIVATION_STROKE;
    private static final String TOGGLE_HELP_ACTION = "toggle-help-action";

    public ContextHelpDispatcher(JFrame jFrame) {
        this.fFrame = jFrame;
        JRootPane jRootPane = jFrame.getRootPane();
        this.addKeyBindings(jRootPane);
    }

    public ContextHelpDispatcher(JDialog jDialog) {
        this.fDialog = jDialog;
        JRootPane jRootPane = jDialog.getRootPane();
        this.addKeyBindings(jRootPane);
    }

    private void addKeyBindings(JComponent jComponent) {
        InputMap inputMap = jComponent.getInputMap(2);
        this.fInputMap = new ComponentInputMap(jComponent);
        this.fInputMap.setParent(inputMap);
        this.fInputMap.put(ACTIVATION_STROKE, TOGGLE_HELP_ACTION);
        jComponent.setInputMap(2, this.fInputMap);
        ActionMap actionMap = jComponent.getActionMap();
        actionMap.put(TOGGLE_HELP_ACTION, (Action)this.getToggleAction());
    }

    public void setActive(boolean bl) {
        if (bl == this.fIsActive) {
            return;
        }
        if (bl) {
            this.fInputMap.remove(ACTIVATION_STROKE);
            this.fInputMap.put(DEACTIVATION_STROKE, TOGGLE_HELP_ACTION);
            WindowAdapter windowAdapter = new WindowAdapter(){

                @Override
                public void windowDeactivated(WindowEvent windowEvent) {
                    ContextHelpDispatcher.this.setActive(false);
                    if (ContextHelpDispatcher.this.fFrame != null) {
                        ContextHelpDispatcher.this.fFrame.removeWindowListener(this);
                    } else if (ContextHelpDispatcher.this.fDialog != null) {
                        ContextHelpDispatcher.this.fDialog.removeWindowListener(this);
                    }
                }
            };
            if (this.fFrame != null) {
                this.fFrame.addWindowListener(windowAdapter);
            } else if (this.fDialog != null) {
                this.fDialog.addWindowListener(windowAdapter);
            }
            if (this.fFrame != null) {
                this.fSaveGlassPane = this.fFrame.getGlassPane();
            } else if (this.fDialog != null) {
                this.fSaveGlassPane = this.fDialog.getGlassPane();
            }
            if (this.fSaveGlassPane != null) {
                this.fSaveGlassVisible = this.fSaveGlassPane.isVisible();
            }
            if (this.fGlassPane == null) {
                this.fGlassPane = new JPanel();
                this.fGlassPane.setOpaque(false);
                this.fGlassPane.addMouseListener(this);
                this.fGlassPane.addMouseMotionListener(this);
            }
            if (this.fFrame != null) {
                this.fFrame.setGlassPane(this.fGlassPane);
                this.fContentPane = this.fFrame.getContentPane();
            } else if (this.fDialog != null) {
                this.fDialog.setGlassPane(this.fGlassPane);
                this.fContentPane = this.fDialog.getContentPane();
            }
            this.fGlassPane.setVisible(true);
            this.fGlassPane.setCursor(ContextHelpDispatcher.getHelpCursor());
            this.fHelpFound = false;
            this.fAnyHeavyweights = this.addHeavyweightListeners(this.fContentPane, false);
        } else {
            this.fInputMap.remove(DEACTIVATION_STROKE);
            this.fInputMap.put(ACTIVATION_STROKE, TOGGLE_HELP_ACTION);
            if (this.fFrame != null) {
                this.fFrame.setGlassPane(this.fSaveGlassPane);
            } else if (this.fDialog != null) {
                this.fDialog.setGlassPane(this.fSaveGlassPane);
            }
            if (this.fSaveGlassPane != null) {
                this.fSaveGlassPane.setVisible(this.fSaveGlassVisible);
                this.fSaveGlassPane = null;
            }
            if (this.fAnyHeavyweights) {
                this.fCursorsIterator = this.fSavedCursors.iterator();
                this.removeHeavyweightListeners(this.fContentPane, false);
                this.fSavedCursors.clear();
            }
        }
        this.fIsActive = bl;
        if (this.fToggleAction != null) {
            this.fToggleAction.setSelected(bl);
        }
    }

    public boolean isActive() {
        return this.fIsActive;
    }

    public MJAbstractAction getToggleAction() {
        if (this.fToggleAction == null) {
            this.fToggleAction = new ToggleAction();
        }
        return this.fToggleAction;
    }

    static void showHelp(Component component, int n, int n2) {
        ContextHelpProvider contextHelpProvider = ContextHelpDispatcher.getHelpProvider(component, n, n2);
        if (contextHelpProvider != null) {
            String string = contextHelpProvider.getTopicMap(component, n, n2);
            String string2 = contextHelpProvider.getTopicKey(component, n, n2);
            if (string != null && string2 != null) {
                MLHelpServices.cshDisplayTopic((Object)SwingUtilities.windowForComponent(component), (String)string, (String)string2);
            }
        }
    }

    static ContextHelpProvider getHelpProvider(Component component, int n, int n2) {
        ContextHelpProvider contextHelpProvider = null;
        for (Component component2 = component; component2 != null && contextHelpProvider == null; component2 = component2.getParent()) {
            Object object;
            if (component2 instanceof ContextHelpProvider) {
                contextHelpProvider = (ContextHelpProvider)((Object)component2);
            } else if (component2 instanceof JComponent && (object = ((JComponent)component2).getClientProperty("Context Help Provider")) instanceof ContextHelpProvider) {
                contextHelpProvider = (ContextHelpProvider)object;
            }
            if (contextHelpProvider == null || contextHelpProvider.hasHelp(component, n, n2)) continue;
            contextHelpProvider = null;
        }
        return contextHelpProvider;
    }

    private boolean addHeavyweightListeners(Component component, boolean bl) {
        Container container;
        boolean bl2;
        boolean bl3 = false;
        boolean bl4 = bl2 = !component.isLightweight();
        if (bl2 || bl) {
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
            if (this.fSavedCursors == null) {
                this.fSavedCursors = new ArrayList();
            }
            this.fSavedCursors.add(component.getCursor());
            component.setCursor(ContextHelpDispatcher.getHelpCursor());
            if (!bl2) {
                container = this.getHeavyAncestor(component);
                container.setEnabled(false);
            }
            bl3 = true;
            bl = true;
        }
        if (component instanceof Container) {
            container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                if (!this.addHeavyweightListeners(container.getComponent(i), bl)) continue;
                bl3 = true;
            }
        }
        return bl3;
    }

    private void removeHeavyweightListeners(Component component, boolean bl) {
        Serializable serializable;
        boolean bl2;
        boolean bl3 = bl2 = !component.isLightweight();
        if (bl2 || bl) {
            component.removeMouseListener(this);
            component.removeMouseMotionListener(this);
            if (this.fCursorsIterator.hasNext()) {
                serializable = (Cursor)this.fCursorsIterator.next();
                if (serializable == sHelpCursor || serializable == sHelpFoundCursor) {
                    component.setCursor(null);
                } else {
                    component.setCursor((Cursor)serializable);
                }
            }
            if (!bl2) {
                serializable = this.getHeavyAncestor(component);
                ((Component)serializable).setEnabled(true);
            }
            bl = true;
        }
        if (component instanceof Container) {
            serializable = (Container)component;
            int n = ((Container)serializable).getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.removeHeavyweightListeners(((Container)serializable).getComponent(i), bl);
            }
        }
    }

    private Container getHeavyAncestor(Component component) {
        Container container;
        for (container = component.getParent(); container.isLightweight() && container != null; container = container.getParent()) {
        }
        return container;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = mouseEvent.getComponent() == this.fGlassPane;
        MouseEvent mouseEvent2 = bl2 ? this.translateEvent(mouseEvent) : mouseEvent;
        ContextHelpProvider contextHelpProvider = ContextHelpDispatcher.getHelpProvider(mouseEvent2.getComponent(), mouseEvent2.getX(), mouseEvent2.getY());
        boolean bl3 = bl = contextHelpProvider != null;
        if (bl != this.fHelpFound) {
            this.fHelpFound = bl;
            if (bl2) {
                this.fGlassPane.setCursor(bl ? ContextHelpDispatcher.getHelpFoundCursor() : ContextHelpDispatcher.getHelpCursor());
            } else {
                mouseEvent2.getComponent().setCursor(bl ? ContextHelpDispatcher.getHelpFoundCursor() : ContextHelpDispatcher.getHelpCursor());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2 = mouseEvent.getComponent() == this.fGlassPane ? this.translateEvent(mouseEvent) : mouseEvent;
        ContextHelpDispatcher.showHelp(mouseEvent2.getComponent(), mouseEvent2.getX(), mouseEvent2.getY());
        mouseEvent.consume();
        this.setActive(false);
    }

    MouseEvent translateEvent(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Point point2 = SwingUtilities.convertPoint(this.fGlassPane, point, this.fContentPane);
        Component component = SwingUtilities.getDeepestComponentAt(this.fContentPane, point2.x, point2.y);
        return SwingUtilities.convertMouseEvent(this.fGlassPane, mouseEvent, component);
    }

    private static Cursor getHelpCursor() {
        if (sHelpCursor == null) {
            ImageIcon imageIcon = new ImageIcon(ContextHelpDispatcher.class.getResource("resources/help_cursor.gif"));
            sHelpCursor = Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), new Point(0, 0), "Help Cursor");
        }
        return sHelpCursor;
    }

    private static Cursor getHelpFoundCursor() {
        if (sHelpFoundCursor == null) {
            ImageIcon imageIcon = new ImageIcon(ContextHelpDispatcher.class.getResource("resources/help_found_cursor.gif"));
            sHelpFoundCursor = Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), new Point(0, 0), "Help Found Cursor");
        }
        return sHelpFoundCursor;
    }

    static {
        ACTIVATION_STROKE = KeyStroke.getKeyStroke(112, 1);
        DEACTIVATION_STROKE = KeyStroke.getKeyStroke(27, 0);
    }

    private class ToggleAction
    extends MJAbstractAction {
        ToggleAction() {
            super(ResourceBundle.getBundle("com.mathworks.mlwidgets.help.resources.RES_HelpInfo").getString("action.ContextSensitiveHelp"));
            if (sHelpIcon == null) {
                sHelpIcon = new ImageIcon(ContextHelpDispatcher.class.getResource("resources/context_help.gif"));
            }
            this.setButtonOnlyIcon(sHelpIcon);
            this.setSelected(ContextHelpDispatcher.this.fIsActive);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContextHelpDispatcher.this.setActive(!ContextHelpDispatcher.this.fIsActive);
        }
    }
}

