/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.DocRoot;
import com.mathworks.help.helpui.buildtools.BaseCodeJavaScriptBuilder;
import com.mathworks.help.helpui.search.index.DocCenterIndexMergeTool;
import com.mathworks.helpsearch.DocumentationQuery;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.facets.Facetable;
import com.mathworks.html.Url;
import com.mathworks.html.UrlBuilder;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.ClassicHelpDataAccessor;
import com.mathworks.mlwidgets.help.DemosData;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.mlwidgets.help.HelpInfoItem;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.util.productinfo.Product;
import com.mathworks.mlwidgets.util.productinfo.ProductInfoUtils;
import com.mathworks.product.util.ProductIdentifier;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocCenterUtils {
    private static DependencyProvider sDependencyProvider = new DefaultDependencyProvider();

    private DocCenterUtils() {
    }

    public static String getReleaseFromUrl(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("^.*(R20\\d\\d[ab]).*$");
        Matcher matcher = pattern.matcher(charSequence);
        String string = null;
        if (matcher.find()) {
            string = matcher.group(1);
        }
        return string;
    }

    private static DocRoot<? extends Url> getDocUrlBuilder() {
        return DocCenterUtils.getDependencyProvider().getDocUrlBuilder();
    }

    @Deprecated
    public static String buildDocCenterFacetSearchUrl(String string, InformationType informationType) {
        DocRoot<? extends Url> docRoot = DocCenterUtils.getDocUrlBuilder();
        DocumentationQuery documentationQuery = new DocumentationQuery(string, new Facetable[]{informationType});
        return docRoot.buildSearchPageUrl(documentationQuery, 1).toString();
    }

    @Deprecated
    public static String buildDocCenterSearchUrl(String string) {
        DocRoot<? extends Url> docRoot = DocCenterUtils.getDocUrlBuilder();
        return docRoot.buildSearchPageUrl(string).toString();
    }

    public static Collection<ProductIdentifier> getSelectedInstalledProductIdentifiers() {
        return DocCenterUtils.getDependencyProvider().getSelectedInstalledProducts();
    }

    public static Collection<ProductIdentifier> getSelectedUninstalledProductIdentifiers() {
        return DocCenterUtils.getDependencyProvider().getSelectedUninstalledProducts();
    }

    private static Collection<ProductIdentifier> getProductIdentifiersFromProductList(String[] stringArray) {
        EnumSet<ProductIdentifier> enumSet = EnumSet.noneOf(ProductIdentifier.class);
        for (String string : stringArray) {
            ProductIdentifier productIdentifier = ProductIdentifier.get((String)string);
            if (productIdentifier == null) continue;
            enumSet.add(productIdentifier);
        }
        return enumSet;
    }

    public static boolean hasClassicDoc() {
        return DocCenterUtils.hasThirdPartyDoc() || DocCenterUtils.hasThirdPartyDemos();
    }

    private static boolean hasThirdPartyDoc() {
        HelpInfoItem[] helpInfoItemArray = ClassicHelpDataAccessor.getInstalledProductHelpInfo();
        return helpInfoItemArray.length > 0;
    }

    static boolean hasThirdPartyDemos() {
        return DemosData.hasThirdPartyDemos();
    }

    public static void buildSharedDocCenterFiles() throws IOException {
        DocCenterUtils.mergeDocCenterIndexes();
        DocCenterUtils.buildBaseCodeJavaScript();
    }

    public static void mergeDocCenterIndexes() throws IOException {
        File file = new File(MLHelpServices.getDocRoot());
        new DocCenterIndexMergeTool(file).doMerge();
    }

    public static void buildBaseCodeJavaScript() throws IOException {
        File file = new File(MLHelpServices.getDocRoot());
        new BaseCodeJavaScriptBuilder(file).buildJavaScriptFile();
    }

    public static String getExamplesUrlForDemoCommand(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        string = string.trim();
        string2 = string2.trim();
        if (string.isEmpty() && string2.isEmpty()) {
            string2 = "matlab";
        } else if ((string.equals("matlab") || string.equals("simulink")) && string2.isEmpty()) {
            string2 = string;
            string = "";
        }
        Product product = ProductInfoUtils.getProductByFirstMatch(string2, string);
        if (product != null && product.getDocDir() != null) {
            DocRoot<? extends Url> docRoot = DocCenterUtils.getDocUrlBuilder();
            String string3 = product.getDocDir();
            String string4 = "/examples.html";
            return docRoot.buildGlobalPageUrl(string3 + string4).toString();
        }
        return null;
    }

    @Deprecated
    public static String getBaseUrlWithAnchor(String string) {
        if (string == null) {
            return null;
        }
        try {
            Url url = Url.parse((String)string);
            UrlBuilder urlBuilder = UrlBuilder.fromString((String)url.getBaseUrl());
            return urlBuilder.setTarget(url.getTarget()).toString();
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }

    private static synchronized void setDependencyProvider(DependencyProvider dependencyProvider) {
        sDependencyProvider = dependencyProvider;
    }

    private static synchronized DependencyProvider getDependencyProvider() {
        return sDependencyProvider;
    }

    private static class DefaultDependencyProvider
    implements DependencyProvider {
        private DefaultDependencyProvider() {
        }

        @Override
        public DocRoot<? extends Url> getDocUrlBuilder() {
            return DocCenterDocConfig.getInstance().getDocRoot();
        }

        @Override
        public Collection<ProductIdentifier> getSelectedInstalledProducts() {
            return HelpPrefs.getSelectedInstalledProducts();
        }

        @Override
        public Collection<ProductIdentifier> getSelectedUninstalledProducts() {
            return HelpPrefs.getSelectedUninstalledProducts();
        }
    }

    public static interface DependencyProvider {
        public DocRoot<? extends Url> getDocUrlBuilder();

        public Collection<ProductIdentifier> getSelectedInstalledProducts();

        public Collection<ProductIdentifier> getSelectedUninstalledProducts();
    }
}

