/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.DocLocation;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.html.LanguageLocale;
import com.mathworks.util.LanguageUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class DocLocaleValidator {
    private static final Set<Locale> FORCE_ENGLISH_SET = new HashSet<Locale>();
    private final DocLocation fDocLocation;
    private final Locale fLocale;
    private final Set<LanguageLocale> fAllowedLanguageLocales;

    public DocLocaleValidator(String string) {
        this(HelpPrefs.getDocLocation(string));
    }

    public DocLocaleValidator(DocLocation docLocation) {
        this(docLocation, LanguageUtils.getHelpLocale());
    }

    public DocLocaleValidator(DocLocation docLocation, Locale locale) {
        this.fDocLocation = docLocation;
        this.fLocale = locale;
        this.fAllowedLanguageLocales = this.initAllowedLanguageLocales();
    }

    private Set<LanguageLocale> initAllowedLanguageLocales() {
        if (!this.canOverrideDocLocale()) {
            return EnumSet.of(LanguageLocale.ENGLISH);
        }
        LanguageLocale languageLocale = LanguageLocale.fromLocale(this.fLocale);
        if (languageLocale != null) {
            return EnumSet.of(languageLocale, LanguageLocale.ENGLISH);
        }
        return EnumSet.of(LanguageLocale.ENGLISH);
    }

    public Collection<LanguageLocale> getAllowedLanguageLocales() {
        return Collections.unmodifiableSet(this.fAllowedLanguageLocales);
    }

    private boolean canOverrideDocLocale() {
        return !DocLocaleValidator.isEnglish(this.fLocale) && !this.isForceEnglish() && this.isMatlabAvailable() && this.isLocalizedDocInstalled(this.fLocale);
    }

    private static boolean isEnglish(Locale locale) {
        return locale.getLanguage().equalsIgnoreCase(Locale.ENGLISH.getLanguage());
    }

    private boolean isForceEnglish() {
        return FORCE_ENGLISH_SET.contains(this.fLocale) && this.fDocLocation == DocLocation.INSTALLED;
    }

    boolean isLocaleForcedEnglish(Locale locale) {
        return DocLocaleValidator.isEnglish(locale) && this.isForceEnglish();
    }

    public boolean isAllowed(LanguageLocale languageLocale) {
        return languageLocale != null && this.fAllowedLanguageLocales.contains((Object)languageLocale);
    }

    protected boolean isMatlabAvailable() {
        return Matlab.isMatlabAvailable();
    }

    protected boolean isLocalizedDocInstalled(Locale locale) {
        return HelpPrefs.isLocalizedDocInstalled(locale);
    }

    static {
        FORCE_ENGLISH_SET.add(Locale.SIMPLIFIED_CHINESE);
        FORCE_ENGLISH_SET.add(Locale.KOREA);
    }
}

