/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlwidgets.explorer.model.navigation.InvalidLocationException;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationContext;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationListener;
import com.mathworks.mlwidgets.explorer.model.treefs.TreeModelAdapter;
import com.mathworks.mlwidgets.explorer.widgets.address.AddressBar;
import com.mathworks.mlwidgets.help.ClassicHelpPanel;
import com.mathworks.mlwidgets.help.HelpPanelAddressNavigation;
import com.mathworks.mlwidgets.help.HelpSynchronizer;
import com.mathworks.mlwidgets.help.HelpTreeItem;
import com.mathworks.mlwidgets.help.HelpTreeUtils;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.HtmlConversionUtils;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJTree;
import com.mathworks.util.Cache;
import com.mathworks.util.Converter;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class HelpPanelBreadCrumbTrail
extends MJToolBar
implements HelpPanelAddressNavigation {
    private final NavigationContext fNavigationContext;
    private final TreeModelAdapter fTreeModelAdapter;
    private final FileLocationToDisplayNameConverter fDisplayNameConverter;
    private final ClassicHelpPanel fHelpPanel;

    public HelpPanelBreadCrumbTrail(ClassicHelpPanel classicHelpPanel, MJTree mJTree) {
        this.setName("Help Panel Bread Crumb Trail");
        this.getAccessibleContext().setAccessibleName("Help Panel Bread Crumb Trail");
        mJTree.setName("Bread Crumb Trail Tree");
        mJTree.getAccessibleContext().setAccessibleName("Bread Crumb Trail Tree");
        mJTree.setRootVisible(false);
        mJTree.getSelectionModel().setSelectionMode(1);
        TreeModel treeModel = mJTree.getModel();
        this.setFloatable(false);
        this.fHelpPanel = classicHelpPanel;
        HtmlConversionUtils.setFileNotFoundTemplate(this.fHelpPanel.getHTMLRenderer(), HTMLUtils.getLocalizedClassicDocFilename(Matlab.matlabRoot() + "/toolbox/local/helperr.html"));
        TreePathToIconConverter treePathToIconConverter = new TreePathToIconConverter();
        this.fDisplayNameConverter = new FileLocationToDisplayNameConverter();
        this.fTreeModelAdapter = new TreeModelAdapter(treeModel, (JTree)mJTree, treePathToIconConverter, this.fDisplayNameConverter);
        this.fNavigationContext = this.fTreeModelAdapter.getNavigationContext();
        this.fNavigationContext.addNavigationListener(new BreadCrumbNavigationListener());
        AddressBar addressBar = new AddressBar(this.fNavigationContext, 20);
        addressBar.setSortedAlphabetically(false);
        addressBar.setRootVisible(false);
        addressBar.getComponent().setName("Location AddressBar");
        addressBar.getComponent().getAccessibleContext().setAccessibleName(HTMLUtils.sRes.getString("icecontainer.acc.address_label_location"));
        addressBar.getComponent().setBorder(new EmptyBorder(0, 3, 0, 3));
        this.add(addressBar.getComponent());
    }

    public NavigationContext getNavigationContext() {
        return this.fNavigationContext;
    }

    public TreeModelAdapter getTreeModelAdapter() {
        return this.fTreeModelAdapter;
    }

    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        dimension.height = this.getPreferredSize().height;
        return dimension;
    }

    private void showUrlInBrowser(String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showUrlInBrowserMethod(string);
        } else {
            SwingUtilities.invokeLater(new ShowUrlInBrowserThread(string));
        }
    }

    private void showUrlInBrowserMethod(String string) {
        if (string.startsWith("linkerr:")) {
            HtmlConversionUtils.setFileNotFoundText(this.fHelpPanel.getHTMLRenderer(), string.substring(8));
        } else {
            this.fHelpPanel.setCurrentLocation(string);
        }
    }

    private void addUrlToBreadCrumbMethod(String string, String string2) {
        try {
            String string3 = HTMLUtils.getCanonicalUrl(string2);
            FileLocation fileLocation = new FileLocation(string3);
            if (!fileLocation.isUrl()) {
                fileLocation = new FileLocation("file:///" + string3);
            }
            this.fDisplayNameConverter.setTitle(fileLocation, string);
            this.fNavigationContext.setLocation(fileLocation);
        }
        catch (InvalidLocationException invalidLocationException) {
            throw new IllegalStateException(invalidLocationException);
        }
    }

    @Override
    public void setHelpSynchronizer(HelpSynchronizer helpSynchronizer) {
    }

    @Override
    public MJToolBar getToolBar() {
        return this;
    }

    @Override
    public void addUrlToAddressNavigation(String string, String string2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.addUrlToBreadCrumbMethod(string, string2);
        } else {
            SwingUtilities.invokeLater(new AddUrlToBreadCrumbThread(string, string2));
        }
    }

    private class BreadCrumbNavigationListener
    implements NavigationListener {
        private BreadCrumbNavigationListener() {
        }

        @Override
        public void navigationChange(FileLocation fileLocation, FileLocation fileLocation2) {
            String string = HelpPanelBreadCrumbTrail.this.fHelpPanel.getCurrentLocation();
            if (string != null && (fileLocation2.equals((Object)new FileLocation(string)) || HTMLUtils.isTargetOnPage(string, fileLocation2.toString()))) {
                return;
            }
            if (fileLocation2.isUrl()) {
                HelpPanelBreadCrumbTrail.this.showUrlInBrowser(fileLocation2.toString());
            }
        }

        @Override
        public void searchStarted(SearchCriteria searchCriteria) {
        }

        @Override
        public void searchEnded() {
        }
    }

    private static class FileLocationToDisplayNameConverter
    implements Converter<FileLocation, String> {
        private final Cache<FileLocation, String> fTitles = new Cache((Cache.Loader)new Cache.Loader<FileLocation, String>(){

            public String load(FileLocation fileLocation) throws IOException {
                return null;
            }
        }, 1024);

        private FileLocationToDisplayNameConverter() {
        }

        void setTitle(FileLocation fileLocation, String string) {
            this.fTitles.set((Object)fileLocation, (Object)string);
        }

        public String convert(FileLocation fileLocation) {
            try {
                String string = (String)this.fTitles.get((Object)fileLocation);
                if (string != null) {
                    return string;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return fileLocation.toString();
        }
    }

    private static class TreePathToIconConverter
    implements Converter<TreePath, Icon> {
        private TreePathToIconConverter() {
        }

        public Icon convert(TreePath treePath) {
            Icon icon = null;
            Object object = treePath.getLastPathComponent();
            if (object instanceof TreeNode) {
                TreeNode treeNode = (TreeNode)object;
                while (treeNode != null) {
                    HelpTreeItem helpTreeItem = HelpTreeUtils.getItemForTreeNode(treeNode);
                    if (helpTreeItem != null) {
                        icon = helpTreeItem.getIcon();
                        if (icon != null) break;
                        treeNode = treeNode.getParent();
                        continue;
                    }
                    treeNode = treeNode.getParent();
                }
            }
            return icon;
        }
    }

    private class AddUrlToBreadCrumbThread
    implements Runnable {
        private String fTitle;
        private String fUrl;

        AddUrlToBreadCrumbThread(String string, String string2) {
            this.fTitle = string;
            this.fUrl = string2;
        }

        @Override
        public void run() {
            HelpPanelBreadCrumbTrail.this.addUrlToBreadCrumbMethod(this.fTitle, this.fUrl);
        }
    }

    private class ShowUrlInBrowserThread
    implements Runnable {
        private String fUrl;

        ShowUrlInBrowserThread(String string) {
            this.fUrl = string;
        }

        @Override
        public void run() {
            HelpPanelBreadCrumbTrail.this.showUrlInBrowserMethod(this.fUrl);
        }
    }
}

