/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.DocConfig;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceDataRetriever;
import com.mathworks.helpsearch.reference.ReferenceEntity;
import com.mathworks.helpsearch.reference.ReferenceEntityRequest;
import com.mathworks.helpsearch.reference.ReferenceRequest;
import com.mathworks.html.Url;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.mlwidgets.help.DocCenterReferenceRetrievalStrategy;
import com.mathworks.mlwidgets.help.DocCommandArgumentBuilder;
import com.mathworks.mlwidgets.help.HelpTextBuilder;
import com.mathworks.mlwidgets.help.RefTypeGroup;
import com.mathworks.mlwidgets.help.ReferenceEntityMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HelpTopic {
    private static final String MUPAD_SHORTNAME = "mupad";
    private static final Pattern TOPIC_PRODUCT_PATTERN = Pattern.compile("^([^/]+)/(.+)$");
    private static final ReferenceEntityRequest.Precision PRECISION = ReferenceEntityRequest.Precision.IGNORE_PACKAGE;
    private final DocConfig<? extends Url> fDocConfig;
    private final String fProductShortName;
    private final String fTopic;
    private RefEntityLookupStrategy fRefTypeStrategy;
    private boolean fPreferMappedEntities = false;
    private String fHelpText;
    private String fDocCommandArg;

    public HelpTopic(String string) {
        this(DocCenterDocConfig.getInstance(), string);
    }

    public HelpTopic(String string, RefEntityType refEntityType) {
        this(string);
        this.useRefEntityTypes(refEntityType);
    }

    public HelpTopic(DocConfig<? extends Url> docConfig, String string) {
        this.fDocConfig = docConfig;
        String[] stringArray = HelpTopic.splitTopic(string, this.fDocConfig.getDocumentationSet());
        this.fProductShortName = stringArray[0];
        this.fTopic = stringArray[1].replaceAll("[\\\\/>]", ".");
    }

    public HelpTopic methodOrProperty(boolean bl) {
        this.fRefTypeStrategy = new InferRefTypesStrategy(bl);
        return this;
    }

    public HelpTopic useRefTypeGroup(RefTypeGroup refTypeGroup) {
        return this.useRefEntityTypes(refTypeGroup.getTypes());
    }

    public HelpTopic useRefEntityTypes(RefEntityType ... refEntityTypeArray) {
        return this.useRefEntityTypes(Arrays.asList(refEntityTypeArray));
    }

    public HelpTopic useRefEntityTypes(Collection<RefEntityType> collection) {
        this.fRefTypeStrategy = new ExplicitRefTypesStrategy(collection);
        return this;
    }

    public HelpTopic preferInformalTopics(boolean bl) {
        this.fPreferMappedEntities = bl;
        return this;
    }

    private Map<String, Collection<RefEntityType>> createSingleEntryMap(Collection<RefEntityType> collection) {
        HashMap<String, Collection<RefEntityType>> hashMap = new HashMap<String, Collection<RefEntityType>>();
        hashMap.put(this.fTopic, Collections.unmodifiableCollection(collection));
        return hashMap;
    }

    private boolean isMupad() {
        return this.fProductShortName != null && this.fProductShortName.equalsIgnoreCase(MUPAD_SHORTNAME);
    }

    private static String[] splitTopic(String string, DocumentationSet documentationSet) {
        Matcher matcher = TOPIC_PRODUCT_PATTERN.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            DocProduct docProduct = documentationSet.getProductByShortName(string2);
            if (docProduct != null) {
                return new String[]{string2, matcher.group(2)};
            }
            if (string2.equalsIgnoreCase(MUPAD_SHORTNAME)) {
                return new String[]{MUPAD_SHORTNAME, matcher.group(2)};
            }
        }
        return new String[]{null, string};
    }

    public List<ReferenceData> getReferenceData() {
        return this.getReferenceData(false);
    }

    public String getProductShortName() {
        return this.fProductShortName;
    }

    public String getTopic() {
        return this.fTopic;
    }

    public synchronized String getHelpText(boolean bl) {
        if (this.fHelpText == null) {
            this.fHelpText = new HelpTextBuilder(this, bl).getHelpText();
        }
        return this.fHelpText;
    }

    public synchronized String getDocCommandArgument() {
        if (this.fDocCommandArg == null) {
            List<ReferenceData> list = this.getReferenceData(true);
            this.fDocCommandArg = DocCommandArgumentBuilder.buildDocCommandArgument(list, this.getProductShortName(), this.getTopic());
        }
        return this.fDocCommandArg;
    }

    private List<ReferenceData> getReferenceData(boolean bl) {
        List<ReferenceRequest> list = this.createReferenceRequests(bl);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getReferenceData(list);
    }

    private List<ReferenceRequest> createReferenceRequests(boolean bl) {
        LinkedList<ReferenceRequest> linkedList = new LinkedList<ReferenceRequest>();
        Map<String, Collection<RefEntityType>> map = this.getRefTypeStrategy().getEntitiesToQuery();
        boolean bl2 = this.isMupad();
        for (Map.Entry<String, Collection<RefEntityType>> entry : map.entrySet()) {
            ReferenceEntityRequest referenceEntityRequest;
            String string = entry.getKey();
            Collection<RefEntityType> collection = entry.getValue();
            if (!(bl || this.fProductShortName == null || this.fProductShortName.isEmpty() || bl2)) {
                referenceEntityRequest = this.fDocConfig.getDocumentationSet();
                DocProduct docProduct = referenceEntityRequest.getProductByShortName(this.fProductShortName);
                if (docProduct == null) continue;
                linkedList.add((ReferenceRequest)new ReferenceEntityRequest(string, PRECISION, docProduct, collection));
                continue;
            }
            referenceEntityRequest = new ReferenceEntityRequest(string, PRECISION, collection);
            referenceEntityRequest.setMatchCase(bl2);
            linkedList.add((ReferenceRequest)referenceEntityRequest);
        }
        return linkedList;
    }

    private RefEntityLookupStrategy getRefTypeStrategy() {
        RefEntityLookupStrategy refEntityLookupStrategy = this.fRefTypeStrategy == null ? new InferRefTypesStrategy(false) : this.fRefTypeStrategy;
        return new RefEntityMappingStrategy(refEntityLookupStrategy, this.fPreferMappedEntities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReferenceData> getReferenceData(List<ReferenceRequest> list) {
        LinkedList<ReferenceData> linkedList = new LinkedList<ReferenceData>();
        ReferenceDataRetriever referenceDataRetriever = this.getReferenceDataRetriever();
        try {
            for (ReferenceRequest referenceRequest : list) {
                linkedList.addAll(referenceDataRetriever.getReferenceData(referenceRequest));
            }
        }
        finally {
            HelpTopic.cleanup(referenceDataRetriever);
        }
        return linkedList;
    }

    protected ReferenceDataRetriever getReferenceDataRetriever() {
        return DocCenterReferenceRetrievalStrategy.createDataRetriever(this.fDocConfig);
    }

    private static void cleanup(ReferenceDataRetriever referenceDataRetriever) {
        try {
            referenceDataRetriever.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class RefEntityMappingStrategy
    implements RefEntityLookupStrategy {
        private final RefEntityLookupStrategy iRealStrategy;
        private final boolean iPreferMappedEntities;

        private RefEntityMappingStrategy(RefEntityLookupStrategy refEntityLookupStrategy, boolean bl) {
            this.iRealStrategy = refEntityLookupStrategy;
            this.iPreferMappedEntities = bl;
        }

        @Override
        public Map<String, Collection<RefEntityType>> getEntitiesToQuery() {
            Map<String, Collection<RefEntityType>> map = this.iRealStrategy.getEntitiesToQuery();
            LinkedHashMap<String, Collection<RefEntityType>> linkedHashMap = new LinkedHashMap<String, Collection<RefEntityType>>();
            if (!this.iPreferMappedEntities) {
                linkedHashMap.putAll(map);
            }
            ReferenceEntityMap referenceEntityMap = ReferenceEntityMap.getInstance();
            for (Map.Entry<String, Collection<RefEntityType>> entry : map.entrySet()) {
                RefEntityType refEntityType;
                Collection<RefEntityType> collection = entry.getValue();
                RefEntityType refEntityType2 = refEntityType = collection.size() == 1 ? collection.iterator().next() : null;
                List<ReferenceEntity> list = referenceEntityMap.mapEntity(entry.getKey());
                if (list.isEmpty()) continue;
                for (ReferenceEntity referenceEntity : list) {
                    linkedHashMap.put(referenceEntity.getName(), Arrays.asList(referenceEntity.getType()));
                }
            }
            if (this.iPreferMappedEntities) {
                linkedHashMap.putAll(map);
            }
            return Collections.unmodifiableMap(linkedHashMap);
        }
    }

    private class ExplicitRefTypesStrategy
    implements RefEntityLookupStrategy {
        private final Collection<RefEntityType> iTypes;

        private ExplicitRefTypesStrategy(Collection<RefEntityType> collection) {
            this.iTypes = EnumSet.copyOf(collection);
        }

        @Override
        public Map<String, Collection<RefEntityType>> getEntitiesToQuery() {
            return HelpTopic.this.createSingleEntryMap(this.iTypes);
        }
    }

    private class InferRefTypesStrategy
    implements RefEntityLookupStrategy {
        private final boolean iMethodOrProperty;

        private InferRefTypesStrategy(boolean bl) {
            this.iMethodOrProperty = bl;
        }

        @Override
        public Map<String, Collection<RefEntityType>> getEntitiesToQuery() {
            return HelpTopic.this.createSingleEntryMap(this.getRefTypeGroup().getTypes());
        }

        private RefTypeGroup getRefTypeGroup() {
            if (HelpTopic.this.isMupad()) {
                return RefTypeGroup.MUPAD;
            }
            return this.iMethodOrProperty ? RefTypeGroup.CLASS_ENTITY : RefTypeGroup.EXCLUDE_MUPAD;
        }
    }

    private static interface RefEntityLookupStrategy {
        public Map<String, Collection<RefEntityType>> getEntitiesToQuery();
    }
}

