/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search;

import com.mathworks.search.BooleanSearchOperator;
import com.mathworks.search.SearchField;
import java.util.Collection;
import java.util.EnumSet;

public enum DocSearchField implements SearchField<DocSearchField>
{
    TITLE("title", true, true, true),
    SECTION("section", true, true, true),
    BODY("body", true, true, true),
    SUBSECTION("subsection", true, false, true),
    REFPAGE_SUMMARY("ref_summary", true, true, true),
    REFERENCE_PAGE("reference", true, true, false),
    STUDENT_PAGE("student", true, true, false),
    RELATIVE_PATH("relative_path", false, true, false),
    ANCHOR("anchor", false, true, false),
    FILENAME("filename", true, true, false),
    PRODUCT_SHORTNAME("shortname", true, true, false),
    REFPAGE_FUNCTION_NAME("ref_function", true, true, false),
    REFPAGE_ENTITY("ref_entity", true, true, true),
    RESULT_TYPE("type", true, true, false),
    CHARSET("charset", false, true, false);

    private String fFieldName;
    private boolean fIndexed;
    private boolean fStored;
    private boolean fAnalyzed;

    private DocSearchField(String string2, boolean bl, boolean bl2, boolean bl3) {
        this.fFieldName = string2;
        this.fIndexed = bl;
        this.fStored = bl2;
        this.fAnalyzed = bl3;
    }

    public String getFieldName() {
        return this.fFieldName;
    }

    public boolean isIndexed() {
        return this.fIndexed;
    }

    public boolean isStored() {
        return this.fStored;
    }

    public boolean isAnalyzed() {
        return this.fAnalyzed;
    }

    public float getWeight() {
        return 1.0f;
    }

    public BooleanSearchOperator getBooleanOperator() {
        return BooleanSearchOperator.SHOULD_OCCUR;
    }

    public DocSearchField getSearchField() {
        return this;
    }

    public static Collection<DocSearchField> getDefaultFields() {
        return EnumSet.of(TITLE, BODY);
    }

    public static DocSearchField getFieldByName(String string) {
        for (DocSearchField docSearchField : DocSearchField.values()) {
            if (!docSearchField.getFieldName().equals(string)) continue;
            return docSearchField;
        }
        return null;
    }
}

