/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search;

import com.mathworks.search.BooleanSearchOperator;
import com.mathworks.search.CompoundSearchExpression;
import com.mathworks.search.ExactPhraseSearchExpression;
import com.mathworks.search.PartialWordSearchExpression;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchVisitor;
import com.mathworks.search.SimpleSearchExpression;
import com.mathworks.search.WildcardSearchExpression;
import java.util.Iterator;

public class OnlineSearchStringVisitor
implements SearchVisitor {
    private String fSearchString;

    public void visit(SimpleSearchExpression simpleSearchExpression) {
        this.setSearchString(simpleSearchExpression.getSearchString(), simpleSearchExpression.getBooleanOperator());
    }

    public void visit(PartialWordSearchExpression partialWordSearchExpression) {
        this.setSearchString(partialWordSearchExpression.getSearchString() + "%2a", partialWordSearchExpression.getBooleanOperator());
    }

    public void visit(WildcardSearchExpression wildcardSearchExpression) {
        String string = wildcardSearchExpression.getSearchString();
        int n = string.indexOf(42);
        if (n > -1) {
            string = string.substring(0, n) + "%2a";
        }
        this.setSearchString(string, wildcardSearchExpression.getBooleanOperator());
    }

    public void visit(ExactPhraseSearchExpression exactPhraseSearchExpression) {
        String string = exactPhraseSearchExpression.getSearchString().replaceAll("\\s+", "-");
        this.setSearchString(string, exactPhraseSearchExpression.getBooleanOperator());
    }

    public void visit(CompoundSearchExpression compoundSearchExpression) throws SearchException {
        StringBuilder stringBuilder = new StringBuilder("(");
        Iterator iterator = compoundSearchExpression.getExpressions().iterator();
        while (iterator.hasNext()) {
            SearchExpression searchExpression = (SearchExpression)iterator.next();
            searchExpression.accept((SearchVisitor)this);
            stringBuilder.append(this.getSearchString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        this.setSearchString(stringBuilder.toString(), compoundSearchExpression.getBooleanOperator());
    }

    public String getSearchString() {
        return this.fSearchString;
    }

    private void setSearchString(String string, BooleanSearchOperator booleanSearchOperator) {
        this.fSearchString = booleanSearchOperator.equals((Object)BooleanSearchOperator.MUST_NOT_OCCUR) ? "-" + string : string;
    }
}

