/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

class LuceneIndexUtils {
    private static final Set<String> SENTENCE_BREAK_TAGS = new HashSet<String>();
    private static final Set<String> NO_SPACE_TAGS;

    private LuceneIndexUtils() {
    }

    static boolean isSentenceBreakTag(String string) {
        return SENTENCE_BREAK_TAGS.contains(string.toUpperCase(Locale.ENGLISH));
    }

    static boolean isWordBreakTag(String string) {
        String string2 = string.toUpperCase(Locale.ENGLISH);
        return !NO_SPACE_TAGS.contains(string2) && !SENTENCE_BREAK_TAGS.contains(string2);
    }

    static {
        SENTENCE_BREAK_TAGS.add("H1");
        SENTENCE_BREAK_TAGS.add("H2");
        SENTENCE_BREAK_TAGS.add("H3");
        SENTENCE_BREAK_TAGS.add("H4");
        SENTENCE_BREAK_TAGS.add("BR");
        SENTENCE_BREAK_TAGS.add("P");
        SENTENCE_BREAK_TAGS.add("HR");
        SENTENCE_BREAK_TAGS.add("TABLE");
        SENTENCE_BREAK_TAGS.add("TR");
        SENTENCE_BREAK_TAGS.add("TD");
        SENTENCE_BREAK_TAGS.add("DIV");
        SENTENCE_BREAK_TAGS.add("PRE");
        SENTENCE_BREAK_TAGS.add("LI");
        NO_SPACE_TAGS = new HashSet<String>();
        NO_SPACE_TAGS.add("TT");
        NO_SPACE_TAGS.add("A");
        NO_SPACE_TAGS.add("B");
        NO_SPACE_TAGS.add("I");
        NO_SPACE_TAGS.add("SPAN");
    }
}

