/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;

public class MWHitCollector
extends Collector {
    private static final HitInfo[] EMPTY_ARRAY = new HitInfo[0];
    private SortedSet<HitInfo> fHitSet = new TreeSet<HitInfo>();
    private HitInfo[] fInfos = EMPTY_ARRAY;
    private Scorer fScorer;
    private int fDocBase;

    public void setScorer(Scorer scorer) throws IOException {
        this.fScorer = scorer;
    }

    public void collect(int n) {
        if (this.finishedCollecting()) {
            throw new IllegalStateException("Cannot add more search results.");
        }
        try {
            this.fHitSet.add(new HitInfo(this.fDocBase + n, this.fScorer.score()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setNextReader(AtomicReaderContext atomicReaderContext) throws IOException {
        this.fDocBase = atomicReaderContext.docBase;
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    private void finishCollecting() {
        if (this.fHitSet != null) {
            this.fInfos = this.fHitSet.toArray(this.fInfos);
            this.fHitSet = null;
        }
    }

    private boolean finishedCollecting() {
        return this.fHitSet == null;
    }

    int getNumResults() {
        this.finishCollecting();
        return this.fInfos.length;
    }

    Document getDocument(IndexSearcher indexSearcher, int n) throws IOException {
        this.finishCollecting();
        return indexSearcher.doc(this.getDocId(n));
    }

    int getDocId(int n) {
        this.finishCollecting();
        return this.fInfos[n].getDocNum();
    }

    float getScore(int n) {
        this.finishCollecting();
        return this.fInfos[n].getScore();
    }

    private class HitInfo
    implements Comparable<HitInfo> {
        private int iDocNum;
        private float iScore;

        private HitInfo(int n, float f) {
            this.iDocNum = n;
            this.iScore = f;
        }

        private int getDocNum() {
            return this.iDocNum;
        }

        private float getScore() {
            return this.iScore;
        }

        @Override
        public int compareTo(HitInfo hitInfo) {
            int n = new Float(hitInfo.getScore()).compareTo(Float.valueOf(this.getScore()));
            if (n == 0) {
                return hitInfo.getDocNum() - this.getDocNum();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof HitInfo) {
                HitInfo hitInfo = (HitInfo)object;
                return hitInfo.getDocNum() == this.getDocNum();
            }
            return false;
        }
    }
}

