/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import com.mathworks.search.SearchField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public class SuggestionProvider {
    private static final Pattern FIND_LAST_WORD_PATTERN = Pattern.compile("^(.*\\s+)(\\w+)$");
    private IndexReader fReader;
    private SearchField fField;

    public SuggestionProvider(IndexReader indexReader, SearchField searchField) {
        this.fReader = indexReader;
        this.fField = searchField;
    }

    private IndexReader getIndexReader() {
        return this.fReader;
    }

    public Collection<String> getSuggestions(String string, int n) {
        try {
            string = string.trim();
            Matcher matcher = FIND_LAST_WORD_PATTERN.matcher(string);
            if (matcher.find()) {
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                return this.getSuggestionsForLastWord(string2, string3, n);
            }
            return this.getSuggestionsForSingleWord(string, n);
        }
        catch (IOException iOException) {
            return Collections.emptyList();
        }
    }

    private Collection<String> getSuggestionsForSingleWord(String string, int n) throws IOException {
        Collection<Term> collection = this.getSuggestedTerms(string, n);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Term term : collection) {
            arrayList.add(term.text());
        }
        return arrayList;
    }

    private Collection<String> getSuggestionsForLastWord(String string, String string2, int n) throws IOException {
        String[] stringArray = string.split("\\s+");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        SortedMap<Integer, DocsEnum> sortedMap = this.getFullWordTermDocs(stringArray);
        if (sortedMap.firstKey() == 0) {
            return Collections.emptyList();
        }
        Collection<DocsEnum> collection = sortedMap.values();
        Collection<Term> collection2 = this.getSuggestedTerms(string2, Integer.MAX_VALUE);
        SuggestionsMap suggestionsMap = new SuggestionsMap(n);
        for (Term term : collection2) {
            if (hashSet.contains(term.text())) continue;
            IndexReader indexReader = this.getIndexReader();
            int n2 = SuggestionProvider.intersectTermDocs(collection, MultiFields.getTermDocsEnum((IndexReader)indexReader, (Bits)MultiFields.getLiveDocs((IndexReader)indexReader), (String)this.fField.getFieldName(), (BytesRef)term.bytes()));
            if (n2 > 0) {
                String string3 = string + term.text();
                suggestionsMap.add(new Suggestion(string3, n2), string3);
            }
            collection = this.getFullWordTermDocs(stringArray).values();
        }
        return suggestionsMap.values();
    }

    private SortedMap<Integer, DocsEnum> getFullWordTermDocs(String[] stringArray) throws IOException {
        TreeMap<Integer, DocsEnum> treeMap = new TreeMap<Integer, DocsEnum>();
        IndexReader indexReader = this.getIndexReader();
        for (String string : stringArray) {
            Term term = new Term(this.fField.getFieldName(), string);
            treeMap.put(indexReader.docFreq(term), MultiFields.getTermDocsEnum((IndexReader)indexReader, (Bits)MultiFields.getLiveDocs((IndexReader)indexReader), (String)this.fField.getFieldName(), (BytesRef)term.bytes()));
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Term> getSuggestedTerms(String string, int n) throws IOException {
        BytesRef bytesRef;
        string = string.trim();
        SuggestionsMap suggestionsMap = new SuggestionsMap(n);
        String string2 = this.fField.getFieldName();
        IndexReader indexReader = this.getIndexReader();
        Terms terms = ((AtomicReaderContext)indexReader.leaves().get(0)).reader().terms(string2);
        TermsEnum termsEnum = terms.iterator(null);
        boolean bl = false;
        while ((bytesRef = termsEnum.next()) != null) {
            if (!SuggestionProvider.shouldAcceptTerm(bytesRef, string)) {
                if (!bl) continue;
                break;
            }
            bl = true;
            Term term = new Term(string2, bytesRef.utf8ToString());
            Suggestion suggestion = new Suggestion(bytesRef.utf8ToString(), indexReader.docFreq(term));
            suggestionsMap.add(suggestion, term);
        }
        return suggestionsMap.values();
    }

    private static boolean shouldAcceptTerm(BytesRef bytesRef, String string) {
        return bytesRef != null && bytesRef.utf8ToString().startsWith(string);
    }

    private static int intersectTermDocs(Collection<DocsEnum> collection, DocsEnum docsEnum) throws IOException {
        ArrayList<DocsEnum> arrayList = new ArrayList<DocsEnum>(collection);
        arrayList.add(docsEnum);
        int n = 0;
        int n2 = SuggestionProvider.getNextCommonTermDoc(arrayList, 0);
        while (n2 > -1) {
            ++n;
            n2 = SuggestionProvider.getNextCommonTermDoc(arrayList, n2 + 1);
        }
        return n;
    }

    private static int getNextCommonTermDoc(Iterable<DocsEnum> iterable, int n) throws IOException {
        int n2 = SuggestionProvider.getInitialMatchCandidate(iterable, n);
        boolean bl = false;
        while (!bl) {
            bl = true;
            Iterator<DocsEnum> iterator = iterable.iterator();
            while (iterator.hasNext() && bl) {
                DocsEnum docsEnum = iterator.next();
                int n3 = docsEnum.docID();
                if (n3 >= n2) continue;
                if (docsEnum.advance(n2) != Integer.MAX_VALUE) {
                    int n4 = docsEnum.docID();
                    bl = n4 == n2;
                    n2 = n4;
                    continue;
                }
                return -1;
            }
        }
        return n2;
    }

    private static int getInitialMatchCandidate(Iterable<DocsEnum> iterable, int n) throws IOException {
        int n2 = n;
        for (DocsEnum docsEnum : iterable) {
            int n3 = docsEnum.docID();
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private static class Suggestion
    implements Comparable<Suggestion> {
        private final String iText;
        private final int iNumDocs;

        private Suggestion(String string, int n) {
            this.iText = string;
            this.iNumDocs = n;
        }

        private String getText() {
            return this.iText;
        }

        private int getNumDocs() {
            return this.iNumDocs;
        }

        @Override
        public int compareTo(Suggestion suggestion) {
            if (this.getNumDocs() == suggestion.getNumDocs()) {
                return this.getText().compareTo(suggestion.getText());
            }
            return this.getNumDocs() < suggestion.getNumDocs() ? 1 : -1;
        }
    }

    private static class SuggestionsMap<E> {
        private final int iMaxSize;
        private final SortedMap<Suggestion, E> iMap = new TreeMap<Suggestion, E>();

        private SuggestionsMap(int n) {
            this.iMaxSize = n;
        }

        private void add(Suggestion suggestion, E e) {
            this.iMap.put(suggestion, e);
            if (this.iMap.size() > this.iMaxSize) {
                this.iMap.remove(this.iMap.lastKey());
            }
        }

        private Collection<E> values() {
            return this.iMap.values();
        }
    }
}

