/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.BasicHtmlActions;
import com.mathworks.html.DefaultHtmlActionLabels;
import com.mathworks.html.FindInPageHandler;
import com.mathworks.html.HtmlActionGroup;
import com.mathworks.html.HtmlActionGroups;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.HtmlPanel;
import com.mathworks.html.StandardHtmlActionId;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.MatlabFindHandler;
import com.mathworks.mlwidgets.html.MatlabHtmlActionId;
import com.mathworks.mlwidgets.html.MatlabHtmlActionUtils;
import com.mathworks.mlwidgets.html.MatlabSaveFileSelector;
import com.mathworks.mlwidgets.html.MatlabSelectedTextAction;
import com.mathworks.mlwidgets.html.MatlabViewSourceHandler;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Action;

public class MJHtmlPanelActions
implements HtmlActions {
    private final BasicHtmlActions fUnderlyingActions;
    private final HtmlActionGroup fMatlabHtmlActionGroup;
    private final MatlabFindHandler fFindHandler;

    public MJHtmlPanelActions(HtmlPanel htmlPanel) {
        this.fUnderlyingActions = new BasicHtmlActions((HtmlComponent)htmlPanel, (BasicHtmlActions.BasicHtmlActionLabels)new DefaultHtmlActionLabels(), (BasicHtmlActions.ActionAdapter)new MJAbstractActionAdapter((HtmlComponent)htmlPanel));
        this.fFindHandler = new MatlabFindHandler((HtmlComponent)htmlPanel);
        this.fUnderlyingActions.setFindInPageHandler((FindInPageHandler)this.fFindHandler);
        this.fUnderlyingActions.setViewSourceHandler((BasicHtmlActions.ViewSourceHandler)new MatlabViewSourceHandler((HtmlComponent)htmlPanel));
        this.fUnderlyingActions.setSaveFileSelector((BasicHtmlActions.SaveFileSelector)new MatlabSaveFileSelector((HtmlComponent)htmlPanel));
        this.fMatlabHtmlActionGroup = MJHtmlPanelActions.createMatlabActionGroup((HtmlComponent)htmlPanel);
    }

    private static HtmlActionGroup createMatlabActionGroup(HtmlComponent htmlComponent) {
        Map<String, MJAbstractAction> map = MJHtmlPanelActions.createMatlabActions(htmlComponent);
        return new HtmlActionGroup("MatlabActions", map);
    }

    private static Map<String, MJAbstractAction> createMatlabActions(HtmlComponent htmlComponent) {
        LinkedHashMap<String, MJAbstractAction> linkedHashMap = new LinkedHashMap<String, MJAbstractAction>();
        MJHtmlPanelActions.addMatlabAction(linkedHashMap, MatlabHtmlActionId.EVALUATE_SELECTION, new EvaluateSelectionAction(htmlComponent));
        MJHtmlPanelActions.addMatlabAction(linkedHashMap, MatlabHtmlActionId.HELP_ON_SELECTION, new ConsoleEvalAction(htmlComponent, "help-on-selection", "doc "));
        MJHtmlPanelActions.addMatlabAction(linkedHashMap, MatlabHtmlActionId.OPEN_SELECTION, new ConsoleEvalAction(htmlComponent, "open-selection", "open "));
        return linkedHashMap;
    }

    private static void addMatlabAction(Map<String, MJAbstractAction> map, MatlabHtmlActionId matlabHtmlActionId, MJAbstractAction mJAbstractAction) {
        MJAbstractAction mJAbstractAction2 = MatlabHtmlActionUtils.decorateCustomAction(matlabHtmlActionId.toString(), (Action)mJAbstractAction);
        map.put(matlabHtmlActionId.toString(), mJAbstractAction2);
    }

    public HtmlActionGroups getCustomActionGroups() {
        HtmlActionGroups htmlActionGroups = new HtmlActionGroups();
        HtmlActionGroups htmlActionGroups2 = this.fUnderlyingActions.getCustomActionGroups();
        HtmlActionGroups htmlActionGroups3 = MJHtmlPanelActions.wrapCustomActionGroups(htmlActionGroups2);
        htmlActionGroups.addAllCustomActionGroups(htmlActionGroups3);
        htmlActionGroups.addCustomActionGroup(this.fMatlabHtmlActionGroup);
        return htmlActionGroups;
    }

    private static HtmlActionGroups wrapCustomActionGroups(HtmlActionGroups htmlActionGroups) {
        HtmlActionGroups htmlActionGroups2 = new HtmlActionGroups();
        for (HtmlActionGroup htmlActionGroup : htmlActionGroups.getAllGroups()) {
            HtmlActionGroup htmlActionGroup2 = MJHtmlPanelActions.wrapCustomActionGroup(htmlActionGroup);
            htmlActionGroups2.addCustomActionGroup(htmlActionGroup2);
        }
        return htmlActionGroups2;
    }

    private static HtmlActionGroup wrapCustomActionGroup(HtmlActionGroup htmlActionGroup) {
        Map map = htmlActionGroup.getAllActions();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : map.entrySet()) {
            MJAbstractAction mJAbstractAction = MatlabHtmlActionUtils.decorateCustomAction((String)entry.getKey(), (Action)entry.getValue());
            linkedHashMap.put(entry.getKey(), mJAbstractAction);
        }
        return new HtmlActionGroup(htmlActionGroup.getName(), linkedHashMap);
    }

    public Map<StandardHtmlActionId, ? extends Action> getBasicActions() {
        return this.fUnderlyingActions.getBasicActions();
    }

    public void removeNavigationActions() {
        this.fUnderlyingActions.removeNavigationActions();
    }

    Collection<Action> getAllActions() {
        ArrayList<? extends Action> arrayList = new ArrayList<Action>();
        arrayList.addAll(this.getBasicActions().values());
        HtmlActionGroups htmlActionGroups = this.getCustomActionGroups();
        arrayList.addAll(htmlActionGroups.getAllActions());
        return Collections.unmodifiableCollection(arrayList);
    }

    public void dispose() {
        this.fUnderlyingActions.dispose();
        this.fFindHandler.dispose();
    }

    private static class MJHtmlPanelPrintAction
    extends MJAbstractAction {
        private final HtmlComponent iHtmlComponent;

        private MJHtmlPanelPrintAction(HtmlComponent htmlComponent) {
            this.iHtmlComponent = htmlComponent;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.iHtmlComponent.print((HtmlDataListener)new PrintFailureListener());
        }

        private class PrintFailureListener
        implements HtmlDataListener<Boolean> {
            private PrintFailureListener() {
            }

            public void dataRetrieved(Boolean bl) {
                if (!bl.booleanValue()) {
                    String string = HTMLUtils.sRes.getString("print.system_browser_failed");
                    MJOptionPane.showMessageDialog((Component)MJHtmlPanelPrintAction.this.iHtmlComponent.getComponent(), (Object)string);
                }
            }
        }
    }

    private static class ConsoleEvalAction
    extends MatlabSelectedTextAction {
        private final String iCommandPrefix;

        protected ConsoleEvalAction(HtmlComponent htmlComponent, String string, String string2) {
            super(htmlComponent, string);
            this.iCommandPrefix = string2;
        }

        @Override
        protected void execute(String string) {
            String string2 = this.iCommandPrefix + "'" + StringUtils.quoteSingleQuotes((String)string) + "'";
            MLExecuteServices.consoleEval((String)string2);
        }
    }

    private static class EvaluateSelectionAction
    extends MatlabSelectedTextAction {
        protected EvaluateSelectionAction(HtmlComponent htmlComponent) {
            super(htmlComponent, "evaluate-selection");
        }

        @Override
        protected void execute(String string) {
            MLExecuteServices.executeCommand((String)string);
        }
    }

    private static class MJAbstractActionAdapter
    implements BasicHtmlActions.ActionAdapter<MJAbstractAction> {
        private final MJAbstractAction iPrintAction;

        private MJAbstractActionAdapter(HtmlComponent htmlComponent) {
            this.iPrintAction = new MJHtmlPanelPrintAction(htmlComponent);
        }

        public MJAbstractAction adaptAction(StandardHtmlActionId standardHtmlActionId, Action action) {
            Action action2 = standardHtmlActionId == StandardHtmlActionId.PRINT ? this.iPrintAction : action;
            return MatlabHtmlActionUtils.decorateStandardAction(standardHtmlActionId, action2);
        }
    }
}

