/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.BrowserNavigator;
import com.mathworks.html.LoadFailure;
import com.mathworks.html.LoadFailureHandlerMap;
import com.mathworks.html.PageLoadFailureHandler;
import com.mathworks.html.ProxySettings;
import com.mathworks.html.Url;
import com.mathworks.mlwidgets.html.HTMLUtils;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class MLLoadFailureHandlerMap
implements LoadFailureHandlerMap {
    private static final ResourceBundle PREF_RES = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");

    public PageLoadFailureHandler getHandler(LoadFailure loadFailure) {
        switch (loadFailure) {
            case PAGE_NOT_FOUND: {
                return new FileNotFoundHandler();
            }
            case PROXY_CONNECTION_FAILED: {
                return new ProxyFailureHandler();
            }
        }
        return null;
    }

    protected String getFileNotFoundHtml(Url url) {
        return HTMLUtils.getFileNotFoundText(url.toString(), null, true);
    }

    protected String getProxyFailureFormat() {
        return HTMLUtils.sRes.getString("load_failure.proxy_connection");
    }

    protected String getWebPrefsArg() {
        return PREF_RES.getString("area.web");
    }

    protected String getProxyConfigString() {
        ProxySettings proxySettings = ProxySettings.getCurrentSettings();
        String string = proxySettings.getHost();
        int n = proxySettings.getPort();
        return string + ':' + n;
    }

    private class ProxyFailureHandler
    implements PageLoadFailureHandler {
        private ProxyFailureHandler() {
        }

        public void handleLoadFailure(LoadFailure loadFailure, BrowserNavigator browserNavigator, Url url) {
            String string = MLLoadFailureHandlerMap.this.getProxyFailureFormat();
            String string2 = MLLoadFailureHandlerMap.this.getProxyConfigString();
            String string3 = MLLoadFailureHandlerMap.this.getWebPrefsArg();
            String string4 = MessageFormat.format(string, string2, string3);
            browserNavigator.setHtmlText(string4);
        }
    }

    private class FileNotFoundHandler
    implements PageLoadFailureHandler {
        private FileNotFoundHandler() {
        }

        public void handleLoadFailure(LoadFailure loadFailure, BrowserNavigator browserNavigator, Url url) {
            String string = MLLoadFailureHandlerMap.this.getFileNotFoundHtml(url);
            browserNavigator.setHtmlText(string);
        }
    }
}

