/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.BasicHtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.Url;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mwswing.FileExtensionFilter;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import java.awt.Component;
import java.io.File;
import javax.swing.SwingUtilities;

class MatlabSaveFileSelector
implements BasicHtmlActions.SaveFileSelector {
    private final HtmlComponent fParent;

    MatlabSaveFileSelector(HtmlComponent htmlComponent) {
        this.fParent = htmlComponent;
    }

    public File selectFile() {
        String string = this.getDefaultFilenameForSaveAs();
        MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform(MatlabPath.getCWD());
        mJFileChooserPerPlatform.setSelectedFile(new File(string));
        mJFileChooserPerPlatform.addChoosableFileFilter((FilePatternFilter)new FileExtensionFilter(HTMLUtils.sRes.getString("filetype.html"), new String[]{"html", "htm"}, true));
        mJFileChooserPerPlatform.showSaveDialog((Component)SwingUtilities.windowForComponent(this.fParent.getComponent()));
        if (mJFileChooserPerPlatform.getState() == 0) {
            return mJFileChooserPerPlatform.getSelectedFile();
        }
        return null;
    }

    private String getDefaultFilenameForSaveAs() {
        String string;
        String string2 = null;
        String string3 = this.fParent.getCurrentLocation();
        if (string3 != null) {
            if (string3.startsWith("text:")) {
                string = this.fParent.getTitle();
                if (string != null) {
                    string2 = string + ".html";
                }
            } else {
                try {
                    Url url = Url.parse((String)string3);
                    String[] stringArray = url.getBaseUrl().split("/");
                    return stringArray[stringArray.length - 1];
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (string2 == null || string2.length() == 0) {
            string = this.fParent.getTitle();
            string2 = string != null ? string + ".html" : "newfile.html";
        }
        return string2;
    }
}

