/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.ImportTable;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.VariableHeaderRenderer;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.table.JTableHeader;

class HeaderMouseAdapter
extends MouseAdapter {
    private VariableHeaderRenderer fHeaderRenderer;
    private JTableHeader fTableHeader;
    private int fLastColumnHeaderClick = -1;
    private static int RESIZE_REGION_SIZE = 2;
    private static final Cursor fResizeCursor = new Cursor(10);
    private static final Cursor fDefaultCursor = new Cursor(0);
    private static final Cursor fTextCursor = new Cursor(2);
    private int fMouseDownColumn = -1;

    HeaderMouseAdapter(JTableHeader jTableHeader, VariableHeaderRenderer variableHeaderRenderer) {
        this.fHeaderRenderer = variableHeaderRenderer;
        this.fTableHeader = jTableHeader;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Point point;
        int n;
        if (this.fHeaderRenderer.isHeaderEditing()) {
            this.fHeaderRenderer.fireEditingStopped();
        }
        if (this.fTableHeader.getTable().isEditing() && this.fTableHeader.getTable().getCellEditor() != null) {
            this.fTableHeader.getTable().getCellEditor().cancelCellEditing();
        }
        if ((n = this.fTableHeader.columnAtPoint(point = mouseEvent.getPoint())) < 0) {
            return;
        }
        Rectangle rectangle = this.fTableHeader.getHeaderRect(n);
        if (n == this.fMouseDownColumn && !this.fHeaderRenderer.isEditableAtPoint(point, n, this.fTableHeader.getTable().getColumnModel().getColumn(n).getHeaderValue())) {
            this.fLastColumnHeaderClick = -1;
        }
        this.fMouseDownColumn = -1;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.fHeaderRenderer.fireEditingStopped();
        if (this.fTableHeader.getTable().isEditing() && this.fTableHeader.getTable().getCellEditor() != null) {
            this.fTableHeader.getTable().getCellEditor().stopCellEditing();
        }
        super.mousePressed(mouseEvent);
        Point point = mouseEvent.getPoint();
        if (mouseEvent.getButton() == 1) {
            this.fMouseDownColumn = this.fTableHeader.columnAtPoint(point);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Object object;
        Object object2;
        int n = this.fHeaderRenderer.getHoverColumn();
        Point point = mouseEvent.getPoint();
        int n2 = this.fTableHeader.columnAtPoint(point);
        if (n2 >= 0 && (object2 = this.fTableHeader.getTable().getColumnModel().getColumn(n2).getHeaderValue()) instanceof VariableHeaderRenderer.ImportDataHeader) {
            Object object3;
            object = null;
            if (((ImportTable)((Object)this.fTableHeader.getTable())).showColumnHeaderVariableWarning(n2) && point.x - this.fTableHeader.getHeaderRect((int)n2).x >= (object3 = (Object)this.fHeaderRenderer.calculateWarningIconHorizontalPosition(this.fTableHeader.getColumnModel().getColumn(n2).getWidth(), ((VariableHeaderRenderer.ImportDataHeader)object2).getName()))[0] && point.x - this.fTableHeader.getHeaderRect((int)n2).x <= object3[1]) {
                object = ImportToolUtils.getResourceString("variablewarn.tooltip");
            }
            if (object == null) {
                object3 = (VariableHeaderRenderer.ImportDataHeader)object2;
                object = ((VariableHeaderRenderer.ImportDataHeader)object3).getName();
            }
            this.fTableHeader.setToolTipText((String)object);
        }
        if (n2 >= 0) {
            object2 = this.fTableHeader.getHeaderRect(n2);
            object = this.fHeaderRenderer.getVarNameEditorBounds(n2, this.fTableHeader.getTable().getColumnModel().getColumn(n2).getHeaderValue());
            if (((Rectangle)object).contains(new Point(point.x - ((Rectangle)object2).x + 5, point.y - ((Rectangle)object2).y)) && ((Rectangle)object).contains(new Point(point.x - ((Rectangle)object2).x - 5, point.y - ((Rectangle)object2).y))) {
                this.fTableHeader.setCursor(fTextCursor);
            } else if (point.x - ((Rectangle)object2).x <= RESIZE_REGION_SIZE && n2 > 0 || point.x - ((Rectangle)object2).x >= ((Rectangle)object2).width - RESIZE_REGION_SIZE) {
                this.fTableHeader.setCursor(fResizeCursor);
            } else {
                this.fTableHeader.setCursor(fDefaultCursor);
            }
            if (!((Rectangle)object).contains(new Point(point.x - ((Rectangle)object2).x, point.y - ((Rectangle)object2).y))) {
                n2 = -1;
            }
        } else {
            this.fTableHeader.setCursor(fDefaultCursor);
        }
        if (n2 == n) {
            return;
        }
        this.fHeaderRenderer.setHoverColumn(n2);
        object2 = this.fTableHeader.getHeaderRect(n2);
        this.fTableHeader.repaint((Rectangle)object2);
        object = this.fTableHeader.getHeaderRect(n);
        this.fTableHeader.repaint((Rectangle)object);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.fTableHeader.setCursor(new Cursor(0));
        int n = this.fHeaderRenderer.getHoverColumn();
        if (n < 0) {
            return;
        }
        Rectangle rectangle = this.fTableHeader.getHeaderRect(n);
        this.fTableHeader.setCursor(null);
        this.fHeaderRenderer.setHoverColumn(-1);
        this.fTableHeader.repaint(rectangle);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() != 1) {
            return;
        }
        Point point = mouseEvent.getPoint();
        int n = this.fTableHeader.columnAtPoint(point);
        if (n < 0) {
            return;
        }
        Rectangle rectangle = this.fTableHeader.getHeaderRect(n);
        point.x -= rectangle.x;
        point.y -= rectangle.y;
        if (n == this.fLastColumnHeaderClick && this.fHeaderRenderer.isEditableAtPoint(point, n, this.fTableHeader.getTable().getColumnModel().getColumn(n).getHeaderValue())) {
            this.fHeaderRenderer.editColumnHeaderCellAt(this.fTableHeader.getTable(), n);
        }
        this.fLastColumnHeaderClick = n;
    }
}

