/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.importtool.AbstractFileTableModel;
import com.mathworks.mlwidgets.importtool.DateCell;
import com.mathworks.mlwidgets.importtool.ImportTable;
import com.mathworks.mlwidgets.importtool.IntervalSelectionModel;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.spreadsheet.SpreadsheetColor;
import com.mathworks.widgets.spreadsheet.data.ComplexScalar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class ImportCellRenderer
extends DefaultTableCellRenderer {
    protected static Color SEL_NUM_BG_COLOR = new Color(217, 232, 243);
    protected static Color BAD_CEL_FG_COLOR = Color.BLACK;
    protected static Color DEFAULT_CELL_FG_COLOR = Color.BLACK;
    protected static Color SEL_NUM_BG_GLOW_COLOR = new Color(209, 229, 254);
    protected static Color SELECTION_BORDER_COLOR = Color.BLACK;
    protected static Color GLOWING_BORDER_COLOR = Color.BLUE;
    protected static Color TEMPORARY_SELECTION_COLOR = Color.ORANGE;
    protected static Color OVERLAY_TEXT_COLOR = Color.BLACK;
    protected static Color UNTREATED_BG_COLOR = new Color(255, 50, 50);
    protected static Color PARSED_OVERLAY_TEXT_COLOR = new Color(0, 0, 0, 200);
    protected static Color VARIABLE_NAME_HIGHLIGHT_COLOR = new Color(79, 129, 189, 128);
    protected static Color HOVER_BG_COLOR = new Color(238, 245, 255, 255);
    protected static Color TRANSITIONAL_TEXT_COLOR = new Color(153, 153, 153);
    protected static Color TRANSITIONAL_UNSEL_TEXT_COLOR = new Color(221, 221, 221);
    protected static final int BORDERWIDTH = 2;
    protected int[] fGlowBorderBounds = new int[]{-1, -1, -1, -1};
    protected int[] fHighlightBounds = new int[]{-1, -1, -1, -1};
    protected int fBorderedRow = -1;
    protected int fBorderedColumn = -1;
    protected static DecimalFormat sDecimalFormat;
    protected static NumberFormat sNumberFormat;
    protected OverlayLabel fOverlayLabel;
    private int fHoverRow = -1;
    private int fHoverColumn = -1;

    public static void setColor(String string, int n, int n2, int n3) {
        ImportCellRenderer.setColor(string, n, n2, n3, 255);
    }

    public static void setColor(String string, int n, int n2, int n3, int n4) {
        ImportCellRenderer.setColor(string, new Color(n, n2, n3, n4));
    }

    public static void setColor(String string, Color color) {
        String string2 = string.toUpperCase();
        if (string2.equals("SEL_NUM_BG_COLOR")) {
            SEL_NUM_BG_COLOR = color;
        }
        if (string2.equals("BAD_CEL_FG_COLOR")) {
            BAD_CEL_FG_COLOR = color;
        }
        if (string2.equals("DEFAULT_CELL_FG_COLOR")) {
            DEFAULT_CELL_FG_COLOR = color;
        }
        if (string2.equals("SEL_NUM_BG_GLOW_COLOR")) {
            SEL_NUM_BG_GLOW_COLOR = color;
        }
        if (string2.equals("SELECTION_BORDER_COLOR")) {
            SELECTION_BORDER_COLOR = color;
        }
        if (string2.equals("GLOWING_BORDER_COLOR")) {
            GLOWING_BORDER_COLOR = color;
        }
        if (string2.equals("TEMPORARY_SELECTION_COLOR")) {
            TEMPORARY_SELECTION_COLOR = color;
        }
        if (string2.equals("OVERLAY_TEXT_COLOR")) {
            OVERLAY_TEXT_COLOR = color;
        }
        if (string2.equals("UNTREATED_BG_COLOR")) {
            UNTREATED_BG_COLOR = color;
        }
        if (string2.equals("PARSED_OVERLAY_TEXT_COLOR")) {
            PARSED_OVERLAY_TEXT_COLOR = color;
        }
        if (string2.equals("VARIABLE_NAME_HIGHLIGHT_COLOR")) {
            VARIABLE_NAME_HIGHLIGHT_COLOR = color;
        }
        if (string2.equals("HOVER_BG_COLOR")) {
            HOVER_BG_COLOR = color;
        }
        if (string2.equals("TRANSITIONAL_TEXT_COLOR")) {
            TRANSITIONAL_TEXT_COLOR = color;
        }
        if (string2.equals("TRANSITIONAL_UNSEL_TEXT_COLOR")) {
            TRANSITIONAL_UNSEL_TEXT_COLOR = color;
        }
    }

    public static Color getColor(String string) {
        String string2 = string.toUpperCase();
        if (string2.equals("SEL_NUM_BG_COLOR")) {
            return SEL_NUM_BG_COLOR;
        }
        if (string2.equals("BAD_CEL_FG_COLOR")) {
            return BAD_CEL_FG_COLOR;
        }
        if (string2.equals("DEFAULT_CELL_FG_COLOR")) {
            return DEFAULT_CELL_FG_COLOR;
        }
        if (string2.equals("SEL_NUM_BG_GLOW_COLOR")) {
            return SEL_NUM_BG_GLOW_COLOR;
        }
        if (string2.equals("SELECTION_BORDER_COLOR")) {
            return SELECTION_BORDER_COLOR;
        }
        if (string2.equals("GLOWING_BORDER_COLOR")) {
            return GLOWING_BORDER_COLOR;
        }
        if (string2.equals("TEMPORARY_SELECTION_COLOR")) {
            return TEMPORARY_SELECTION_COLOR;
        }
        if (string2.equals("OVERLAY_TEXT_COLOR")) {
            return OVERLAY_TEXT_COLOR;
        }
        if (string2.equals("UNTREATED_BG_COLOR")) {
            return UNTREATED_BG_COLOR;
        }
        if (string2.equals("PARSED_OVERLAY_TEXT_COLOR")) {
            return PARSED_OVERLAY_TEXT_COLOR;
        }
        if (string2.equals("VARIABLE_NAME_HIGHLIGHT_COLOR")) {
            return VARIABLE_NAME_HIGHLIGHT_COLOR;
        }
        if (string2.equals("HOVER_BG_COLOR")) {
            return HOVER_BG_COLOR;
        }
        if (string2.equals("TRANSITIONAL_TEXT_COLOR")) {
            return TRANSITIONAL_TEXT_COLOR;
        }
        if (string2.equals("TRANSITIONAL_UNSEL_TEXT_COLOR")) {
            return TRANSITIONAL_UNSEL_TEXT_COLOR;
        }
        return null;
    }

    public void setHoverCell(int n, int n2) {
        this.fHoverRow = n;
        this.fHoverColumn = n2;
    }

    public int[] getHoverCell() {
        return new int[]{this.fHoverRow, this.fHoverColumn};
    }

    protected static void setHighContrast() {
        ImportCellRenderer.setHighContrast(true);
    }

    protected static void unsetHighContrast() {
        ImportCellRenderer.setHighContrast(false);
    }

    protected static void setHighContrast(boolean bl) {
        if (bl) {
            SELECTION_BORDER_COLOR = Color.white;
            BAD_CEL_FG_COLOR = Color.black;
            DEFAULT_CELL_FG_COLOR = Color.white;
            SEL_NUM_BG_COLOR = new Color(100, 100, 100);
        } else {
            SELECTION_BORDER_COLOR = Color.black;
            BAD_CEL_FG_COLOR = Color.black;
            DEFAULT_CELL_FG_COLOR = Color.black;
            SEL_NUM_BG_COLOR = new Color(217, 232, 243);
        }
    }

    protected static void createFormats() {
        if (sDecimalFormat == null) {
            sDecimalFormat = new DecimalFormat("#.###E0");
            sDecimalFormat.setGroupingUsed(false);
        }
        if (sNumberFormat == null) {
            sNumberFormat = NumberFormat.getNumberInstance(Locale.US);
            NumberFormat.getNumberInstance(Locale.US);
            sNumberFormat.setGroupingUsed(false);
            sNumberFormat.setMaximumIntegerDigits(6);
            sNumberFormat.setMaximumFractionDigits(3);
        }
    }

    public void setGlowBorderLocation(int n, int n2, int n3, int n4) {
        this.fGlowBorderBounds = new int[]{n, n2, n3, n4};
    }

    public void setHighlightLocation(int n, int n2, int n3, int n4) {
        this.fHighlightBounds = new int[]{n, n2, n3, n4};
    }

    public void setBorderedRow(int n) {
        this.fBorderedRow = n;
    }

    public void setBorderedColumn(int n) {
        this.fBorderedColumn = n;
    }

    public int getBorderedRow() {
        return this.fBorderedRow;
    }

    public int getBorderedColumn() {
        return this.fBorderedColumn;
    }

    static String formatDouble(double d) {
        if (sDecimalFormat == null || sNumberFormat == null) {
            ImportCellRenderer.createFormats();
        }
        if (Math.abs(d) > 1.0E7 && !Double.isInfinite(d) || Math.abs(d) < 0.001 && Math.abs(d) > 0.0) {
            return sDecimalFormat.format(d);
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            return d > 0.0 ? "inf" : "-inf";
        }
        return sNumberFormat.format(d);
    }

    protected void setOverlayLabel(OverlayLabel overlayLabel) {
        this.fOverlayLabel = overlayLabel;
    }

    protected OverlayLabel getOverlayLabel() {
        return this.fOverlayLabel;
    }

    static Border overlayHorizontal(CompoundBorder compoundBorder, Color color, Component component) {
        Border border = compoundBorder.getInsideBorder();
        MatteBorder matteBorder = (MatteBorder)compoundBorder.getOutsideBorder();
        MatteBorder matteBorder2 = BorderFactory.createMatteBorder(border.getBorderInsets((Component)component).top, 0, border.getBorderInsets((Component)component).bottom, 0, color);
        CompoundBorder compoundBorder2 = BorderFactory.createCompoundBorder(matteBorder, BorderFactory.createEmptyBorder(0, 2 - matteBorder.getBorderInsets((Component)component).left, 0, 2 - matteBorder.getBorderInsets((Component)component).right));
        return BorderFactory.createCompoundBorder(matteBorder2, compoundBorder2);
    }

    static Border overlayVertical(CompoundBorder compoundBorder, Color color, Component component) {
        Border border = compoundBorder.getInsideBorder();
        MatteBorder matteBorder = (MatteBorder)compoundBorder.getOutsideBorder();
        MatteBorder matteBorder2 = BorderFactory.createMatteBorder(0, border.getBorderInsets((Component)component).left, 0, border.getBorderInsets((Component)component).right, color);
        CompoundBorder compoundBorder2 = BorderFactory.createCompoundBorder(matteBorder, BorderFactory.createEmptyBorder(2 - matteBorder.getBorderInsets((Component)component).top, 0, 2 - matteBorder.getBorderInsets((Component)component).bottom, 0));
        return BorderFactory.createCompoundBorder(matteBorder2, compoundBorder2);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (this.fOverlayLabel == null) {
            this.fOverlayLabel = new OverlayLabel(jTable);
        }
        this.fOverlayLabel.setOverlayText(null, false);
        if (object != null) {
            this.fOverlayLabel.setText(object.toString());
        } else {
            this.fOverlayLabel.setText("");
        }
        this.fOverlayLabel.setTable(jTable);
        ImportTable importTable = null;
        AbstractFileTableModel abstractFileTableModel = null;
        boolean bl3 = false;
        this.fOverlayLabel.setVariableNameHighlightRow(false);
        if (jTable instanceof ImportTable) {
            importTable = (ImportTable)((Object)jTable);
            abstractFileTableModel = (AbstractFileTableModel)importTable.getModel();
            boolean bl4 = bl3 = importTable != null && importTable.isCellTemporarilySelected(n, n2);
            if (importTable.getVariableNamesHighlightRow() == n) {
                this.fOverlayLabel.setVariableNameHighlightRow(true);
            }
        }
        Color color = null;
        Color color2 = DEFAULT_CELL_FG_COLOR;
        if (bl || bl3) {
            boolean bl5;
            int n3;
            int n4;
            if (((IntervalSelectionModel)jTable.getColumnModel().getSelectionModel()).getMultiVariableSelection()) {
                n4 = n2 == 0 || !bl3 && !jTable.isColumnSelected(n2 - 1) || bl3 && !importTable.isColumnTemporarilySelected(n2 - 1) ? 2 : 1;
                n3 = n == jTable.getRowCount() - 1 || !bl3 && !jTable.isColumnSelected(n2 + 1) || bl3 && !importTable.isColumnSelected(n2 + 1) ? 2 : 1;
            } else {
                n4 = n2 == 0 || !bl3 && !jTable.isColumnSelected(n2 - 1) || bl3 && !importTable.isColumnTemporarilySelected(n2 - 1) ? 2 : 0;
                n3 = n2 == jTable.getColumnCount() - 1 || !bl3 && !jTable.isColumnSelected(n2 + 1) || bl3 && !importTable.isColumnTemporarilySelected(n2 + 1) ? 2 : 0;
            }
            int n5 = n == jTable.getRowCount() - 1 || !bl3 && !jTable.isRowSelected(n + 1) || bl3 && !importTable.isRowTemporarilySelected(n + 1) ? 2 : 0;
            int n6 = n == 0 || !bl3 && !jTable.isRowSelected(n - 1) || bl3 && !importTable.isRowTemporarilySelected(n - 1) ? 2 : 0;
            boolean bl6 = (this.fGlowBorderBounds[0] == n || this.fGlowBorderBounds[1] == n) && n2 >= this.fGlowBorderBounds[2] && n2 <= this.fGlowBorderBounds[3];
            boolean bl7 = (this.fGlowBorderBounds[2] == n2 || this.fGlowBorderBounds[3] == n2) && n >= this.fGlowBorderBounds[0] && n <= this.fGlowBorderBounds[1];
            Color color3 = bl6 || bl7 ? GLOWING_BORDER_COLOR : SELECTION_BORDER_COLOR;
            MatteBorder matteBorder = BorderFactory.createMatteBorder(n6, n4, n5, n3, bl3 ? TEMPORARY_SELECTION_COLOR : color3);
            Border border = BorderFactory.createEmptyBorder(2 - n6, 2 - n4, 2 - n5, 2 - n3);
            boolean bl8 = importTable.isRowExcluded(n);
            boolean bl9 = importTable.isColumnExcluded(n2);
            if (bl8) {
                color = WorksheetRule.RuleType.ROWEXCLUDE.getColor();
                if (this.fBorderedRow == n) {
                    this.fOverlayLabel.setBorder(ImportCellRenderer.overlayHorizontal(BorderFactory.createCompoundBorder(matteBorder, border), color.darker(), (Component)((Object)this.fOverlayLabel)));
                } else {
                    this.fOverlayLabel.setBorder(BorderFactory.createCompoundBorder(matteBorder, border));
                }
                color2 = BAD_CEL_FG_COLOR;
            } else if (bl9) {
                color = WorksheetRule.RuleType.COLUMNEXCLUDE.getColor();
                if (this.fBorderedColumn == n2) {
                    this.fOverlayLabel.setBorder(ImportCellRenderer.overlayVertical(BorderFactory.createCompoundBorder(matteBorder, border), color.darker(), (Component)((Object)this.fOverlayLabel)));
                } else {
                    this.fOverlayLabel.setBorder(BorderFactory.createCompoundBorder(matteBorder, border));
                }
                color2 = BAD_CEL_FG_COLOR;
            } else {
                this.fOverlayLabel.setBorder(BorderFactory.createCompoundBorder(matteBorder, border));
                color = SEL_NUM_BG_COLOR;
            }
            boolean bl10 = bl5 = n >= this.fHighlightBounds[0] && n <= this.fHighlightBounds[1] && n2 >= this.fHighlightBounds[2] && n2 <= this.fHighlightBounds[3];
            if (!(object instanceof AbstractFileTableModel.TempData || bl8 || bl9)) {
                Object object2 = abstractFileTableModel.getConvertedValueAt(n, n2);
                Object object3 = abstractFileTableModel.getReplacedValueAt(n, n2);
                Object object4 = null;
                if (abstractFileTableModel instanceof AbstractFileTableModel) {
                    object4 = abstractFileTableModel.getParsedValueAt(n, n2);
                }
                if (object3 != null && object4 == null) {
                    color = WorksheetRule.RuleType.REPLACE.getColor();
                    color2 = Color.black;
                    if (n == this.fHoverRow && n2 == this.fHoverColumn) {
                        this.fOverlayLabel.setOverlayTextColor(OVERLAY_TEXT_COLOR);
                        if (object3 instanceof Double) {
                            this.fOverlayLabel.setOverlayText(ImportCellRenderer.formatDouble((Double)object3), true);
                        } else if (object3.toString().length() > 0) {
                            this.fOverlayLabel.setOverlayText(object3.toString(), true);
                        }
                    }
                } else if (object2 != null) {
                    color = WorksheetRule.RuleType.CONVERT.getColor();
                    color2 = BAD_CEL_FG_COLOR;
                    if (n == this.fHoverRow && n2 == this.fHoverColumn) {
                        this.fOverlayLabel.setOverlayTextColor(OVERLAY_TEXT_COLOR);
                        if (object2 instanceof Double) {
                            this.fOverlayLabel.setOverlayText(ImportCellRenderer.formatDouble((Double)object2), true);
                        } else if (object2.toString().length() > 0) {
                            this.fOverlayLabel.setOverlayText(object2.toString(), true);
                        }
                    }
                } else if (object4 != null) {
                    if (n == this.fHoverRow && n2 == this.fHoverColumn) {
                        color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), 50);
                        this.fOverlayLabel.setOverlayTextColor(PARSED_OVERLAY_TEXT_COLOR);
                        if (object4 instanceof Double) {
                            this.fOverlayLabel.setOverlayText(ImportCellRenderer.formatDouble((Double)object4), (String)abstractFileTableModel.getValueAt(n, n2), false);
                        } else if (object4.toString().length() > 0) {
                            this.fOverlayLabel.setOverlayText(object4.toString(), false);
                        }
                    }
                } else if (abstractFileTableModel.isUntreatedAt(n, n2)) {
                    color = UNTREATED_BG_COLOR;
                    color2 = BAD_CEL_FG_COLOR;
                }
            }
            if (bl5 && color.equals(SEL_NUM_BG_COLOR)) {
                color = SEL_NUM_BG_GLOW_COLOR;
            }
        } else if (jTable.getSelectionModel().getLeadSelectionIndex() == n && jTable.getColumnModel().getSelectionModel().getLeadSelectionIndex() == n2) {
            this.fOverlayLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.gray, 1), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        } else {
            this.fOverlayLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
        if (jTable.getModel() instanceof AbstractFileTableModel && ((AbstractFileTableModel)jTable.getModel()).isTransitionaryValue()) {
            if (bl) {
                color = SEL_NUM_BG_COLOR;
                color2 = TRANSITIONAL_TEXT_COLOR;
            } else {
                color = TRANSITIONAL_UNSEL_TEXT_COLOR;
                color2 = Color.BLACK;
            }
        }
        if (object instanceof AbstractFileTableModel.TempData) {
            object = ((AbstractFileTableModel.TempData)object).getData();
        }
        if (object instanceof ComplexScalar || object instanceof DateCell) {
            this.fOverlayLabel.setHorizontalAlignment(11);
        } else {
            this.fOverlayLabel.setHorizontalAlignment(10);
        }
        if (jTable.getSelectionModel().getAnchorSelectionIndex() == n && jTable.getColumnModel().getSelectionModel().getAnchorSelectionIndex() == n2) {
            this.fOverlayLabel.setBackground(Color.WHITE);
        }
        this.fOverlayLabel.setBackground(color);
        this.fOverlayLabel.setForeground(color2);
        this.fOverlayLabel.setFont(this.getFont());
        this.fOverlayLabel.setEnabled(bl);
        return this.fOverlayLabel;
    }

    protected static int getNumCharsInPrefix(String string) {
        int n = 0;
        if (string != null) {
            char[] cArray;
            for (char c : cArray = string.toCharArray()) {
                if (Character.isDigit(c)) break;
                ++n;
            }
            if (n == cArray.length) {
                n = 0;
            }
        }
        return n;
    }

    protected static int getOffsetForPrefix(String string, JComponent jComponent, int n) {
        FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
        String string2 = string.substring(0, n);
        return fontMetrics.stringWidth(string2);
    }

    static {
        if (MJUtilities.isHighContrast()) {
            ImportCellRenderer.setHighContrast();
        }
    }

    public static class OverlayLabel
    extends MJLabel {
        private String iOverlayText;
        private String iOriginalText;
        private Font iOverlayFont;
        private Point iOverlayStringOffset = new Point(0, 0);
        private Color fOverlayTextColor = new Color(1.0f, 1.0f, 1.0f, 0.9f);
        private JTable fTable = null;
        private boolean fVariableNameHighlight = false;
        protected Color fLineColor;
        private boolean iBoldFont;

        public OverlayLabel(JTable jTable) {
            super("", false);
            this.setOpaque(true);
            this.setTable(jTable);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.iOverlayFont = jTable.getFont();
        }

        public void setOverlayTextColor(Color color) {
            this.fOverlayTextColor = color;
        }

        public void setTable(JTable jTable) {
            if (jTable.equals(this.fTable)) {
                return;
            }
            this.fTable = jTable;
            if (Matlab.isMatlabAvailable() && this.fTable != null) {
                SpreadsheetColor spreadsheetColor = new SpreadsheetColor(this.fTable);
                this.fLineColor = spreadsheetColor.getHeaderUnselectedLine();
            } else {
                this.fLineColor = Color.LIGHT_GRAY;
            }
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            Rectangle rectangle = this.getBounds();
            if (this.iOverlayText != null) {
                int n = 2;
                if (this.iBoldFont) {
                    graphics2D.setColor(this.getBackground());
                    graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
                    graphics2D.setColor(this.fOverlayTextColor);
                    graphics2D.setFont(this.iOverlayFont);
                    graphics2D.drawString(this.iOverlayText, n, rectangle.height / 2 + this.iOverlayStringOffset.y - 1);
                } else {
                    int n2;
                    int n3 = 20;
                    graphics2D.setColor(HOVER_BG_COLOR);
                    graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
                    graphics2D.setColor(Color.BLACK);
                    graphics2D.setFont(this.fTable.getFont().deriveFont(12.0f));
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                    if (this.iOriginalText != null && (n2 = ImportCellRenderer.getNumCharsInPrefix(this.iOriginalText)) > 0) {
                        int n4 = ImportCellRenderer.getOffsetForPrefix(this.iOriginalText, (JComponent)((Object)this), n2);
                        graphics2D.drawString(this.iOverlayText, n + n4, rectangle.height / 2 + this.iOverlayStringOffset.y - 1);
                    } else {
                        graphics2D.drawString(this.iOverlayText, n, rectangle.height / 2 + this.iOverlayStringOffset.y - 1);
                    }
                }
            }
            if (this.fVariableNameHighlight) {
                graphics2D.setColor(VARIABLE_NAME_HIGHLIGHT_COLOR);
                graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
            }
            graphics2D.dispose();
        }

        void setOverlayText(String string, boolean bl) {
            this.setOverlayText(string, null, bl);
        }

        public void setOverlayText(String string, String string2, boolean bl) {
            this.iOverlayText = string;
            this.iOriginalText = string2;
            this.iBoldFont = bl;
            if (string == null) {
                return;
            }
            if (bl) {
                this.iOverlayFont = this.getFont().deriveFont(1);
            }
            this.iOverlayStringOffset = new Point(-this.getFontMetrics(this.iOverlayFont).stringWidth(this.iOverlayText) / 2, this.getFontMetrics(this.iOverlayFont).getAscent() / 2);
        }

        public void setVariableNameHighlightRow(boolean bl) {
            this.fVariableNameHighlight = bl;
        }

        public boolean isVariableNameHighlightRow() {
            return this.fVariableNameHighlight;
        }
    }
}

