/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.importtool.GeneratedCode;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ImportCodeFactory {
    protected static String getTimeStampComment() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append(ImportToolUtils.getResourceString("codeGen.timestamp"));
        stringBuilder.append(" ");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        stringBuilder.append(simpleDateFormat.format(date));
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    protected static String getStartRowString(List<int[]> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int[] nArray : list) {
            arrayList.add(nArray[0]);
        }
        return GeneratedCode.createMatlabIntegerArrayString(arrayList, 1);
    }

    protected static String getEndRowString(List<int[]> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int[] nArray : list) {
            arrayList.add(nArray[1]);
        }
        return GeneratedCode.createMatlabIntegerArrayString(arrayList, 1);
    }

    protected static String stringArrayToOutputArray(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0 || stringArray[0].trim().length() == 0) {
            return "";
        }
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        String string = "[";
        for (int i = 0; i < stringArray.length - 1; ++i) {
            string = string + stringArray[i] + ",";
        }
        string = string + stringArray[stringArray.length - 1] + "]";
        return string;
    }

    private static boolean isMatlabReserved(String string) {
        try {
            double[] dArray = (double[])Matlab.mtFeval((String)"exist", (Object[])new Object[]{string}, (int)1);
            return dArray[0] > 1.5;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String[] validateVariableNames(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = 1;
            String string = stringArray[i];
            while (arrayList.contains(string) || ImportCodeFactory.isMatlabReserved(string)) {
                string = stringArray[i] + n;
                ++n;
            }
            arrayList.add(string);
            stringArray[i] = string;
        }
        return stringArray;
    }

    public static String validateVariableName(String string) {
        String[] stringArray = ImportCodeFactory.validateVariableNames(new String[]{string});
        return stringArray[0];
    }

    protected static void addDatenumCommentToGeneratedCode(GeneratedCode generatedCode, StringBuilder stringBuilder) {
        generatedCode.addCode(String.format("%% %s%n%n", ImportToolUtils.getResourceString("codeGen.datetimeToDatenum")));
        generatedCode.addCode("% " + stringBuilder);
        generatedCode.addCode("\n\n");
    }

    protected static String getDatenumFormattedComment(String string, int n) {
        String string2 = String.format("%s=datenum(%s);", string, string);
        return String.format("%-" + n + "s", string2);
    }
}

