/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.client.Client;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorApplication;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlwidgets.importtool.ImportDataSource;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.Importer;
import com.mathworks.mlwidgets.importtool.ReverseSpinner;
import com.mathworks.mlwidgets.importtool.WorksheetRangeEditBox;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.mlwidgets.importtool.WorksheetRuleList;
import com.mathworks.mlwidgets.importtool.WorksheetRuleListener;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolstrip.DefaultToolstripTab;
import com.mathworks.toolstrip.ToolstripSection;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.components.ButtonOrientation;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSButton;
import com.mathworks.toolstrip.components.TSLabel;
import com.mathworks.toolstrip.components.TSList;
import com.mathworks.toolstrip.components.TSScrollPane;
import com.mathworks.toolstrip.components.TSSplitButton;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.sections.ToolstripSections;
import com.mathworks.widgets.text.matlab.comment.CommentWrappingUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.text.JTextComponent;

public abstract class ImportToolstripTab
extends DefaultToolstripTab
implements ImportDataSource {
    protected WorksheetRangeEditBox fRangeEditBox;
    protected WorksheetRuleList fWorksheetRuleList;
    protected TSSplitButton fImportSBtn;
    protected TSButton fImportBtn;
    protected Importer fImporter;
    protected MJAbstractAction fGenerateScript;
    protected MJAbstractAction fGenerateFunction;
    protected TSList fTargetList;
    protected ReverseSpinner fHeaderRowSpinner;
    protected boolean fShowCodeGeneration = true;
    private ToolstripSection fUnimportableToolstripSection;
    private TSScrollPane fUnimportableScrollPane;

    ImportToolstripTab() {
        super("importData", MJUtilities.exciseMnemonic((String)ImportToolUtils.getResourceString("toolstrip.importtabtitle")));
        char c = MJUtilities.findMnemonic((String)ImportToolUtils.getResourceString("toolstrip.importtabtitle"));
        if (c != '\u0000') {
            this.setAttribute((Attribute)ToolstripTab.MNEMONIC, "" + c);
        }
    }

    boolean getShowCodeGeneration() {
        return this.fShowCodeGeneration;
    }

    void setShowCodeGeneration(boolean bl) {
        this.fShowCodeGeneration = bl;
    }

    protected void addImportedDataSection() {
        this.fTargetList = new TSList(new DefaultListModel());
        this.fTargetList.setSelectionMode(0);
        this.fTargetList.setName("WorkspaceToolstrip:ImportAsCombo");
        this.fTargetList.setToolTipText(ImportToolUtils.getResourceString("toolstrip.targettooltip"));
        this.fTargetList.setEnabled(false);
        TSScrollPane tSScrollPane = new TSScrollPane((Component)this.fTargetList);
        tSScrollPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        tSScrollPane.setHorizontalScrollBarPolicy(31);
        tSScrollPane.setPreferredSize(new Dimension(130, tSScrollPane.getPreferredSize().height));
        this.getModel().add((Client)ToolstripSections.newSectionBuilder((String)"importedData", (String)ImportToolUtils.getResourceString("toolstrip.importdatalabel")).add((JComponent)tSScrollPane).build());
    }

    protected void addSelectionSection(String string) {
        this.fRangeEditBox = new WorksheetRangeEditBox(string);
        this.fRangeEditBox.setComponentNames("WorksheetToolstrip:Range");
        FormLayout formLayout = new FormLayout("left:pref,5px,80px", "5px,pref,5px,pref");
        MJPanel mJPanel = new MJPanel((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        mJPanel.add((Component)new TSLabel(ImportToolUtils.getResourceString("toolstrip.rangelabel")), (Object)cellConstraints.xy(1, 2, CellConstraints.RIGHT, CellConstraints.CENTER));
        mJPanel.add((Component)new TSLabel(ImportToolUtils.getResourceString("toolstrip.variablenameslabel")), (Object)cellConstraints.xy(1, 4, CellConstraints.RIGHT, CellConstraints.CENTER));
        mJPanel.add((Component)((Object)this.fRangeEditBox), (Object)cellConstraints.xy(3, 2, CellConstraints.FILL, CellConstraints.CENTER));
        this.fHeaderRowSpinner = ImportToolstripTab.setupHeaderRowSpinner();
        mJPanel.add((Component)((Object)this.fHeaderRowSpinner), (Object)cellConstraints.xy(3, 4, CellConstraints.FILL, CellConstraints.CENTER));
        this.getModel().add((Client)ToolstripSections.newSectionBuilder((String)"selection", (String)ImportToolUtils.getResourceString("toolstrip.selectionheading")).add((JComponent)mJPanel).build());
    }

    protected void addUnimportableCellsSection() {
        this.fWorksheetRuleList = new WorksheetRuleList();
        this.fUnimportableScrollPane = new TSScrollPane((Component)((Object)this.fWorksheetRuleList));
        this.fUnimportableScrollPane.setVerticalScrollBarPolicy(22);
        this.fUnimportableToolstripSection = ToolstripSections.newSectionBuilder((String)"unimportableCells", (String)ImportToolUtils.getResourceString("toolstrip.rulesheading")).add((JComponent)this.fUnimportableScrollPane).build();
        this.getModel().add((Client)this.fUnimportableToolstripSection);
        this.fWorksheetRuleList.addWorksheetRuleListener(new WorksheetRuleListener(){

            @Override
            public void ruleChanged(List<WorksheetRule> list) {
                ImportToolstripTab.this.updateUnimportableSection();
            }
        });
    }

    void updateUnimportableSection() {
        this.fUnimportableScrollPane.revalidate();
        this.fUnimportableScrollPane.repaint();
        this.fUnimportableToolstripSection.getComponent().validate();
        this.fUnimportableToolstripSection.getComponent().repaint();
        this.getComponent().revalidate();
        this.getComponent().repaint();
    }

    protected void addImportSection() {
        if (this.fShowCodeGeneration) {
            this.addImportSectionWithCodeGeneration();
        } else {
            this.addImportSectionWithNoCodeGeneration();
        }
    }

    private void addImportSectionWithCodeGeneration() {
        this.fImportSBtn = new TSSplitButton(ImportToolUtils.getResourceString("toolstrip.importbtntitle"), (Icon)new ImageIcon(ImportToolstripTab.class.getResource("/com/mathworks/mlwidgets/importtool/resources/import.png")));
        this.fImportSBtn.setToolTipText(ImportToolUtils.getResourceString("toolstrip.importbtntooltip"));
        this.fImportSBtn.setName("WorksheetToolstrip:fImportBtn");
        this.fImportSBtn.setFocusable(true);
        this.fGenerateScript = new MJAbstractAction(ImportToolUtils.getResourceString("toolstrip.scriptmenulabel")){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportToolstripTab.this.generateScript();
            }
        };
        this.fGenerateScript.setComponentName("WorksheetToolstrip:GenerateScriptMenu");
        this.fGenerateFunction = new MJAbstractAction(ImportToolUtils.getResourceString("toolstrip.functionmenulabel")){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportToolstripTab.this.generateFunction();
            }
        };
        this.fGenerateFunction.setComponentName("WorksheetToolstrip:GenerateFunctionMenu");
        this.fImportSBtn.setPopupListener((PopupListener)new ImportPopupListener());
        this.fImportSBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportToolstripTab.this.importData();
            }
        });
        this.getModel().add((Client)ToolstripSections.newSectionBuilder((String)"ImportButton", (String)ImportToolUtils.getResourceString("toolstrip.importheading"), (int)1).add((JComponent)this.fImportSBtn.setOrientation(ButtonOrientation.VERTICAL)).build());
    }

    private void addImportSectionWithNoCodeGeneration() {
        this.fImportBtn = new TSButton(ImportToolUtils.getResourceString("toolstrip.importbtntitle"), (Icon)new ImageIcon(ImportToolstripTab.class.getResource("/com/mathworks/mlwidgets/importtool/resources/import.png")));
        this.fImportBtn.setToolTipText(ImportToolUtils.getResourceString("toolstrip.importbtntooltip"));
        this.fImportBtn.setName("WorksheetToolstrip:fImportBtn");
        this.fImportBtn.setFocusable(true);
        this.fImportBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportToolstripTab.this.importData();
            }
        });
        this.getModel().add((Client)ToolstripSections.newSectionBuilder((String)"ImportButton", (String)ImportToolUtils.getResourceString("toolstrip.importheading"), (int)1).add((JComponent)this.fImportBtn.setOrientation(ButtonOrientation.VERTICAL)).build());
    }

    public void cleanup() {
        this.fHeaderRowSpinner.cleanup();
        this.fRangeEditBox.cleanup();
    }

    MJSpinner getHeaderSpinner() {
        return this.fHeaderRowSpinner;
    }

    MJAbstractAction getScriptGenerationAction() {
        return this.fGenerateScript;
    }

    MJAbstractAction getFunctionGenerationAction() {
        return this.fGenerateFunction;
    }

    JList getTargetList() {
        return this.fTargetList;
    }

    protected void init(String string) {
        this.addSelectionSection(string);
        this.addImportedDataSection();
        this.addUnimportableCellsSection();
        this.addImportSection();
    }

    protected void generateScript() {
        this.fImporter.generateMatlabScript();
    }

    protected void generateFunction() {
        MatlabWorker<String> matlabWorker = new MatlabWorker<String>(){

            private boolean fileExistsOnPath(String string) {
                try {
                    double[] dArray = (double[])Matlab.mtFeval((String)"exist", (Object[])new Object[]{string, "file"}, (int)1);
                    return dArray != null && dArray.length == 1 && 2 == (int)dArray[0];
                }
                catch (Exception exception) {
                    return false;
                }
            }

            public String runOnMatlabThread() {
                String string = "importfile";
                int n = 1;
                while (this.fileExistsOnPath(string)) {
                    string = "importfile" + Integer.toString(n);
                    ++n;
                }
                return string;
            }

            public void runOnAWTEventDispatchThread(String string) {
                ImportToolstripTab.this.fImporter.generateMatlabFunction(string);
            }
        };
        if (Matlab.isMatlabAvailable()) {
            matlabWorker.start();
        } else {
            matlabWorker.runOnAWTEventDispatchThread((Object)"importfile");
        }
    }

    static Editor editGeneratedCode(String string) {
        Editor editor = null;
        if (Matlab.isMatlabAvailable() && string != null) {
            EditorApplication editorApplication = MLEditorServices.getEditorApplication();
            editor = editorApplication.newEditor(string);
            editor.getTextComponent().selectAll();
            CommentWrappingUtils.wrapComments((JTextComponent)editor.getTextComponent());
            editor.smartIndentContents();
            editor.getTextComponent().select(0, 0);
            editor.bringToFront();
        }
        return editor;
    }

    void setImporter(Importer importer) {
        this.fImporter = importer;
    }

    void setImportButtonEnabled(boolean bl) {
        if (this.fShowCodeGeneration) {
            this.fImportSBtn.setEnabled(bl);
        } else {
            this.fImportBtn.setEnabled(bl);
        }
    }

    void setImportButtonIcon(boolean bl) {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/com/mathworks/mlwidgets/importtool/resources/import.png"));
        if (this.fShowCodeGeneration) {
            if (bl) {
                this.fImportSBtn.setIcon((Icon)imageIcon);
            } else {
                this.fImportSBtn.setIcon(LAFUtil.getDisabledIcon((JComponent)this.fImportSBtn, (Icon)imageIcon));
            }
        } else if (bl) {
            this.fImportBtn.setIcon((Icon)imageIcon);
        } else {
            this.fImportBtn.setIcon(LAFUtil.getDisabledIcon((JComponent)this.fImportBtn, (Icon)imageIcon));
        }
    }

    void setPromptLabelText(String string) {
        this.fWorksheetRuleList.setPromptLabelText(string);
    }

    WorksheetRangeEditBox getRangeEditBox() {
        return this.fRangeEditBox;
    }

    protected void importData() {
        this.fRangeEditBox.commit();
        this.fWorksheetRuleList.commit();
        this.setEnabled(false);
        this.fImporter.importData(this);
    }

    @Override
    public JComponent getImportingComponent() {
        if (this.fShowCodeGeneration) {
            return this.fImportSBtn;
        }
        return this.fImportBtn;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.fTargetList.setEnabled(bl);
        this.setImportButtonEnabled(bl);
        this.setImportButtonIcon(bl);
        this.fWorksheetRuleList.setEnabled(bl);
        this.fRangeEditBox.setEnabled(bl);
        if (bl) {
            this.getComponent().setCursor(null);
        } else {
            this.getComponent().setCursor(new Cursor(3));
        }
    }

    WorksheetRuleList getWorksheetRuleList() {
        return this.fWorksheetRuleList;
    }

    static ReverseSpinner setupHeaderRowSpinner() {
        return new ReverseSpinner(1, 1, 1000, 1, true);
    }

    private class ImportPopupListener
    implements PopupListener,
    ListActionListener {
        static final String TOOLSTRIP_SCRIPT_MENU_LABEL = "toolstrip.scriptmenulabel";
        static final String TOOLSTRIP_FUNCTION_MENU_LABEL = "toolstrip.functionmenulabel";
        static final String TOOLSTRIP_IMPORT_MENU_LABEL = "toolstrip.importmenulabel";

        private ImportPopupListener() {
        }

        public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
            popupCallback.show((JComponent)this.createList());
        }

        private PopupList createList() {
            ArrayList<ListItem> arrayList = new ArrayList<ListItem>();
            arrayList.add(ListItem.newItem((String)TOOLSTRIP_IMPORT_MENU_LABEL, (String)ImportToolUtils.getResourceString(TOOLSTRIP_IMPORT_MENU_LABEL)));
            if (ImportToolstripTab.this.fGenerateScript.isEnabled()) {
                arrayList.add(ListItem.newItem((String)TOOLSTRIP_SCRIPT_MENU_LABEL, (String)ImportToolUtils.getResourceString(TOOLSTRIP_SCRIPT_MENU_LABEL)));
            }
            if (ImportToolstripTab.this.fGenerateFunction.isEnabled()) {
                arrayList.add(ListItem.newItem((String)TOOLSTRIP_FUNCTION_MENU_LABEL, (String)ImportToolUtils.getResourceString(TOOLSTRIP_FUNCTION_MENU_LABEL)));
            }
            PopupList popupList = new PopupList(arrayList.toArray(new ListItem[arrayList.size()]));
            popupList.setListStyle(ListStyle.TEXT_ONLY);
            popupList.addListActionListener((ListActionListener)this);
            popupList.setName("WorksheetToolstrip:ImportDataMenu");
            return popupList;
        }

        public void listItemSelected(ListActionEvent listActionEvent) {
            String string = listActionEvent.getListItem().getName();
            if (string.equals(TOOLSTRIP_IMPORT_MENU_LABEL)) {
                ImportToolstripTab.this.importData();
            } else if (string.equals(TOOLSTRIP_SCRIPT_MENU_LABEL)) {
                ImportToolstripTab.this.generateScript();
            } else if (string.equals(TOOLSTRIP_FUNCTION_MENU_LABEL)) {
                ImportToolstripTab.this.generateFunction();
            }
        }
    }
}

