/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.IntervalSet;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListSelectionModel;

class IntervalSelectionModel
extends DefaultListSelectionModel {
    private boolean fMultiVariableSelection = false;
    private IntervalSet fIntervalSet = new IntervalSet();

    IntervalSelectionModel() {
        this.setSelectionMode(2);
    }

    @Override
    public void addSelectionInterval(int n, int n2) {
        this.fIntervalSet.addInterval(n, n2);
        super.addSelectionInterval(n, n2);
    }

    @Override
    public void clearSelection() {
        this.fIntervalSet.clear();
        super.clearSelection();
    }

    List<int[]> getSelectedIntervals() {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (IntervalSet.Interval interval : this.fIntervalSet) {
            arrayList.add(interval.toArray());
        }
        return arrayList;
    }

    @Override
    public void setLeadSelectionIndex(int n) {
        if (this.isSelectedIndex(this.getAnchorSelectionIndex())) {
            this.fIntervalSet.removeInterval(this.getAnchorSelectionIndex(), this.getLeadSelectionIndex());
            this.fIntervalSet.addInterval(this.getAnchorSelectionIndex(), n);
        } else {
            this.fIntervalSet.addInterval(this.getAnchorSelectionIndex(), this.getLeadSelectionIndex());
            this.fIntervalSet.removeInterval(this.getAnchorSelectionIndex(), n);
        }
        super.setLeadSelectionIndex(n);
    }

    @Override
    public void removeSelectionInterval(int n, int n2) {
        this.fIntervalSet.removeInterval(n, n2);
        super.removeSelectionInterval(n, n2);
    }

    int[] getSelectedCellBlock(int n) {
        if (!this.isSelectedIndex(n)) {
            return null;
        }
        for (IntervalSet.Interval interval : this.fIntervalSet) {
            if (!interval.contains(n)) continue;
            return interval.toArray();
        }
        return null;
    }

    @Override
    public void setSelectionInterval(int n, int n2) {
        this.fIntervalSet.clear();
        this.fIntervalSet.addInterval(n, n2);
        super.setSelectionInterval(n, n2);
    }

    int getSelectionCount() {
        int n = 0;
        for (IntervalSet.Interval interval : this.fIntervalSet) {
            n = n + interval.iEnd - interval.iStart + 1;
        }
        return n;
    }

    public void setMultiVariableSelection(boolean bl) {
        this.fMultiVariableSelection = bl;
    }

    boolean getMultiVariableSelection() {
        return this.fMultiVariableSelection;
    }
}

