/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.GeneratedCode;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import java.util.List;

public class NonNumericRowExcludeRule
extends WorksheetRule {
    @Override
    public WorksheetRule.RuleType getType() {
        return WorksheetRule.RuleType.ROWEXCLUDE;
    }

    public static WorksheetRule.RuleType getRuleType() {
        return WorksheetRule.RuleType.ROWEXCLUDE;
    }

    @Override
    public Object clone() {
        return new NonNumericRowExcludeRule();
    }

    @Override
    public String getSummaryComment() {
        return ImportToolUtils.getResourceString("codeGen.nonnumrowexcludesummary");
    }

    @Override
    public void generateMatlabCode(List<WorksheetRule> list, GeneratedCode generatedCode) {
        boolean bl = WorksheetRule.isRuleFollowedByDateRule(list, this);
        generatedCode.addCode("\n%% ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.excluderownonnumeric"));
        generatedCode.addCode("\n");
        if (generatedCode.isNumericDatetime()) {
            this.generateCodeNumericDates(list, generatedCode, bl);
        } else {
            this.generateCodeMatlabDatetimes(list, generatedCode, bl);
        }
    }

    private void generateCodeNumericDates(List<WorksheetRule> list, GeneratedCode generatedCode, boolean bl) {
        generatedCode.addCode(generatedCode.getRowExclusionIndex());
        if (bl && WorksheetRule.isOnlyDatetimesSelected()) {
            generatedCode.addCode(" = ~(all(cellfun(@isnumeric,");
            generatedCode.addCode(generatedCode.getDateArray());
            generatedCode.addCode("),2)); % ");
        } else if (bl) {
            if (WorksheetRule.rulesNeedNaNConvert(list)) {
                generatedCode.addCode(" = ~(all(cellfun(@(x) isnumeric(x) || islogical(x),");
            } else {
                generatedCode.addCode(" = ~(all(cellfun(@(x) (isnumeric(x) || islogical(x)) && ~isnan(x),");
            }
            generatedCode.addCode(generatedCode.getRawCellArray());
            generatedCode.addCode("),2) & all(cellfun(@isnumeric,");
            generatedCode.addCode(generatedCode.getDateArray());
            generatedCode.addCode("),2)); % ");
        } else {
            if (WorksheetRule.rulesNeedNaNConvert(list)) {
                generatedCode.addCode(" = ~all(cellfun(@(x) isnumeric(x) || islogical(x),");
            } else {
                generatedCode.addCode(" = ~all(cellfun(@(x) (isnumeric(x) || islogical(x)) && ~isnan(x),");
            }
            generatedCode.addCode(generatedCode.getRawCellArray());
            generatedCode.addCode("),2); % ");
        }
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.findnonnumcellrow"));
        generatedCode.addCode("\n");
        NonNumericRowExcludeRule.generateExcludeRows(generatedCode, generatedCode.getRawCellArray());
        if (generatedCode.usesCellVectors()) {
            NonNumericRowExcludeRule.generateExcludeRows(generatedCode, generatedCode.getCellVectors());
        }
        if (bl) {
            NonNumericRowExcludeRule.generateExcludeRows(generatedCode, generatedCode.getDateArray());
        }
    }

    private static void generateExcludeRows(GeneratedCode generatedCode, String string) {
        generatedCode.addCode(string);
        generatedCode.addCode("(");
        generatedCode.addCode(generatedCode.getRowExclusionIndex());
        generatedCode.addCode(",:) = [];\n");
    }

    private void generateCodeMatlabDatetimes(List<WorksheetRule> list, GeneratedCode generatedCode, boolean bl) {
        generatedCode.addCode(generatedCode.getRowExclusionIndex());
        String string = generatedCode.getNextExclusionIndex();
        String string2 = generatedCode.getNextExclusionIndex();
        if (bl && WorksheetRule.isOnlyDatetimesSelected()) {
            generatedCode.addCode(" = cellfun(@(x) any(isnan(x.Hour), 2), ");
            generatedCode.addCode(generatedCode.getDateArray());
            generatedCode.addCode(", 'UniformOutput', false);  % ");
            generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.findnonnumcellrow"));
            generatedCode.addCode("\n");
            generatedCode.addCode(string);
            generatedCode.addCode(String.format(" = any([%1$s{:}], 2); %n", generatedCode.getRowExclusionIndex()));
            generatedCode.addCode(String.format("%1$s = cellfun(@(x) x(~%2$s,:), %1$s, 'UniformOutput', false); %n", generatedCode.getDateArray(), string));
        } else if (bl) {
            if (WorksheetRule.rulesNeedNaNConvert(list)) {
                generatedCode.addCode(" = ~all(cellfun(@(x) isnumeric(x) || islogical(x),");
            } else {
                generatedCode.addCode(" = ~all(cellfun(@(x) (isnumeric(x) || islogical(x)) && ~isnan(x),");
            }
            generatedCode.addCode(generatedCode.getRawCellArray());
            generatedCode.addCode("),2);  %");
            generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.findnonnumcellrow"));
            generatedCode.addCode("\n");
            if (generatedCode.isBlanksExcluded()) {
                generatedCode.addCode(String.format("%1$s = %2$s | anyInvalidDates;%n", string2, generatedCode.getRowExclusionIndex()));
            } else {
                generatedCode.addCode(String.format("%1$s = %2$s | anyInvalidDates | anyBlankDates;%n", string2, generatedCode.getRowExclusionIndex()));
            }
            generatedCode.setRowExclusionIndex(string2);
            if (!generatedCode.isNumericDatetime()) {
                generatedCode.addCode(generatedCode.getDateArray());
                generatedCode.addCode(" = cellfun(@(x) x(~" + string2 + ",:), " + generatedCode.getDateArray() + ", 'UniformOutput', false);\n");
            }
        } else {
            if (WorksheetRule.rulesNeedNaNConvert(list)) {
                generatedCode.addCode(" = ~all(cellfun(@(x) isnumeric(x) || islogical(x),");
            } else {
                generatedCode.addCode(" = ~all(cellfun(@(x) (isnumeric(x) || islogical(x)) && ~isnan(x),");
            }
            generatedCode.addCode(generatedCode.getRawCellArray());
            generatedCode.addCode("),2); % ");
            generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.findnonnumcellrow"));
            generatedCode.addCode("\n");
        }
        if (!WorksheetRule.isOnlyDatetimesSelected()) {
            NonNumericRowExcludeRule.generateExcludeRows(generatedCode, generatedCode.getRawCellArray());
        }
        if (generatedCode.usesCellVectors()) {
            NonNumericRowExcludeRule.generateExcludeRows(generatedCode, generatedCode.getCellVectors());
        }
    }

    @Override
    public String getApplyFcn() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(AbstractSpreadsheetPath);
        stringBuilder.append(".");
        stringBuilder.append("excludeRowFcn");
        return stringBuilder.toString();
    }

    public String toString() {
        return ImportToolUtils.getResourceString("RuleType.nonnumericcells");
    }
}

