/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.ImportClient;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.NumericParsingRule;
import com.mathworks.mlwidgets.importtool.SpreadsheetTableHeaderRenderer;
import com.mathworks.mlwidgets.importtool.TimeParsingRule;
import com.mathworks.mlwidgets.importtool.WorksheetRule;

public abstract class ParseRule
extends WorksheetRule {
    private String fID = "";

    public String getID() {
        return this.fID;
    }

    protected void setID(String string) {
        this.fID = string;
    }

    @Override
    public WorksheetRule.RuleType getType() {
        return WorksheetRule.RuleType.CONVERT;
    }

    public static WorksheetRule.RuleType getRuleType() {
        return WorksheetRule.RuleType.CONVERT;
    }

    public String getParseTargetType() {
        return ImportToolUtils.getResourceString(this.fID);
    }

    public String getDescription() {
        return ImportToolUtils.getResourceString(this.fID + "description");
    }

    public String toString() {
        return ImportToolUtils.getResourceString(this.fID);
    }

    public String getHeader() {
        return ImportToolUtils.getResourceString(this.fID + "header");
    }

    public String getName() {
        return this.getID();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return !(this.getTextscanFormat() != null && !this.getTextscanFormat().equals(((ParseRule)object).getTextscanFormat()) || this.getDecimalSeparator() != null && !this.getDecimalSeparator().equals(((ParseRule)object).getDecimalSeparator()));
    }

    public int hashCode() {
        int n = 7;
        return n + (null == this.fID ? 0 : 11 * this.fID.hashCode()) + (",".equals(this.getDecimalSeparator()) ? 101 : 0);
    }

    public abstract String getDecimalSeparator();

    public abstract void setDecimalSeparator(String var1);

    public abstract String getTextscanFormat();

    public abstract SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType getColumnTargetType();

    public abstract boolean isSupportedByTargetType(ImportClient.TargetType var1);

    public static ParseRule getDefaultRuleForTargetType(ImportClient.TargetType targetType) {
        switch (targetType) {
            case CELLARRAY: {
                return null;
            }
            case COLUMNVECTORS: {
                return null;
            }
            case MATRIX: {
                return new NumericParsingRule();
            }
            case DATASET: {
                return null;
            }
            case TABLE: {
                return null;
            }
            case TIMESERIES: {
                return new NumericParsingRule();
            }
        }
        return null;
    }

    public static ParseRule[][] getColumnParsingRules(ImportClient.TargetType targetType, ParseRule[] parseRuleArray) {
        switch (targetType) {
            case CELLARRAY: {
                return new ParseRule[][]{{null}, {new NumericParsingRule()}};
            }
            case COLUMNVECTORS: {
                return new ParseRule[][]{{null}, {new NumericParsingRule()}, parseRuleArray};
            }
            case MATRIX: {
                return new ParseRule[][]{{new NumericParsingRule()}};
            }
            case DATASET: {
                return new ParseRule[][]{{null}, {new NumericParsingRule()}, parseRuleArray};
            }
            case TABLE: {
                return new ParseRule[][]{{null}, {new NumericParsingRule()}, parseRuleArray};
            }
            case TIMESERIES: {
                return new ParseRule[][]{{new NumericParsingRule()}, {new TimeParsingRule()}, parseRuleArray};
            }
        }
        return null;
    }
}

