/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.GeneratedCode;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.WorksheetCellRenderer;
import com.mathworks.mlwidgets.importtool.WorksheetReplacementRule;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import java.util.List;

public class StringReplacementRule
extends WorksheetReplacementRule {
    private String fTargetString;

    public StringReplacementRule(WorksheetRule worksheetRule) {
        super(worksheetRule);
    }

    public static WorksheetRule.RuleType getRuleType() {
        return WorksheetRule.RuleType.REPLACE;
    }

    public StringReplacementRule() {
    }

    @Override
    public String getSummaryComment() {
        return ImportToolUtils.getResourceString("codeGen.stringreplacesummary") + " " + this.getTargetString() + "->" + Double.toString(this.getReplacementNumber());
    }

    @Override
    public Object clone() {
        return new StringReplacementRule(this);
    }

    public void setTargetString(String string) {
        this.fTargetString = string;
    }

    public String getTargetString() {
        return this.fTargetString;
    }

    @Override
    public void generateMatlabCode(List<WorksheetRule> list, GeneratedCode generatedCode) {
        generatedCode.addCode("\n%% ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.replacespecified"));
        generatedCode.addCode(" ");
        generatedCode.addCode(Double.toString(this.fReplacementNumber));
        generatedCode.addCode("\n");
        if (this.fTargetString.matches(".*\\*.*") || this.fTargetString.matches(".*\\?.*")) {
            generatedCode.addNewVariableName("regexpString");
            generatedCode.addCode("regexpString = regexptranslate('wildcard','");
            generatedCode.addCode(this.fTargetString.replaceAll("'", "''"));
            generatedCode.addCode("');\n");
            generatedCode.addCode(generatedCode.getReplacementIndex());
            generatedCode.addCode(" = cellfun(@(x) ischar(x) && isequal(regexp(x,regexpString,'once'),1),");
        } else {
            generatedCode.addCode(generatedCode.getReplacementIndex());
            generatedCode.addCode(" = cellfun(@(x) ischar(x) && strcmp(x,'");
            generatedCode.addCode(this.fTargetString.replaceAll("'", "''"));
            generatedCode.addCode("'),");
        }
        generatedCode.addCode(generatedCode.getRawCellArray());
        generatedCode.addCode("); % ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.findnonnumcell"));
        generatedCode.addCode("\n");
        generatedCode.addCode(generatedCode.getRawCellArray());
        generatedCode.addCode("(");
        generatedCode.addCode(generatedCode.getReplacementIndex());
        generatedCode.addCode(") = {");
        if (Double.isInfinite(this.fReplacementNumber)) {
            generatedCode.addCode(WorksheetCellRenderer.formatDouble(this.fReplacementNumber));
        } else {
            generatedCode.addCode(Double.toString(this.fReplacementNumber));
        }
        generatedCode.addCode("}; % ");
        generatedCode.addCode(ImportToolUtils.getResourceString("CodeGen.replacenonnumcomment"));
        generatedCode.addCode("\n");
    }

    @Override
    public String getApplyFcn() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(AbstractSpreadsheetPath);
        stringBuilder.append(".");
        stringBuilder.append("stringReplaceFcn");
        return stringBuilder.toString();
    }

    static Object getTargetType() {
        return null;
    }

    public String toString() {
        return this.fTargetString;
    }
}

