/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.DateParsingRule;
import com.mathworks.mlwidgets.importtool.GeneratedCode;
import com.mathworks.mlwidgets.importtool.ImportCodeFactory;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.NumericParsingRule;
import com.mathworks.mlwidgets.importtool.ParseRule;
import com.mathworks.mlwidgets.importtool.TextImportUIState;
import com.mathworks.mlwidgets.importtool.WorksheetReplacementRule;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.widgets.text.matlab.comment.CommentWrappingPreferences;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class TextCodeFactory
extends ImportCodeFactory {
    private TextCodeFactory() {
    }

    public static void generateScript(GeneratedCode generatedCode, TextImportUIState textImportUIState) {
        TextCodeFactory.generateCode(generatedCode, textImportUIState, CodeType.SCRIPT, null);
    }

    public static void generateFunction(GeneratedCode generatedCode, TextImportUIState textImportUIState, String string) {
        TextCodeFactory.generateCode(generatedCode, textImportUIState, CodeType.FUNCTION, string);
    }

    public static void generateCode(GeneratedCode generatedCode, TextImportUIState textImportUIState, CodeType codeType, String string) {
        if (codeType == CodeType.SCRIPT) {
            TextCodeFactory.generateMatlabScriptCommentHeader(generatedCode, textImportUIState.getFile().getPath().replaceAll("'", "''"));
        } else {
            TextCodeFactory.generateFunctionHeader(generatedCode, textImportUIState, string);
        }
        TextCodeFactory.generateMatlabVariableInitialization(generatedCode, textImportUIState, codeType);
        TextCodeFactory.generateCodeBody(generatedCode, textImportUIState, codeType);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n = 0;
        for (ParseRule parseRule : textImportUIState.getSelectedColumnParseRules()) {
            if (parseRule instanceof DateParsingRule) {
                arrayList.add(n);
            } else if (parseRule instanceof NumericParsingRule) {
                arrayList2.add(n);
            }
            ++n;
        }
        WorksheetRule.setColumnVectorPositions(arrayList, arrayList2);
        WorksheetRule.setOnlyDatetimesSelected(textImportUIState.getSelectedColumns().length == arrayList.size());
        TextCodeFactory.splitNumericCellColumns(generatedCode, textImportUIState);
        if (!textImportUIState.useFastPath()) {
            TextCodeFactory.generateRulePostProcess(generatedCode, textImportUIState, codeType);
        }
        if (codeType == CodeType.SCRIPT) {
            TextCodeFactory.generateScriptOutputAllocation(generatedCode, textImportUIState);
        } else if (textImportUIState.isColumnVectors()) {
            TextCodeFactory.generateFunctionOutputAllocation(generatedCode, textImportUIState, textImportUIState.getValidatedSelectedColumnNames());
        } else {
            TextCodeFactory.generateFunctionOutputAllocation(generatedCode, textImportUIState, textImportUIState.getSelectedColumnNames());
        }
        if (codeType == CodeType.SCRIPT && generatedCode.hasVariablesToClear()) {
            generatedCode.addCode("%% ");
            generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.clearvars"));
            generatedCode.addCode("\n");
            generatedCode.addClearCode();
        }
    }

    public static void generateMatlabScriptCommentHeader(GeneratedCode generatedCode, String string) {
        generatedCode.addCode("%% ");
        generatedCode.addCode(ImportToolUtils.getResourceString("textCodeGen.scriptcellheader"));
        generatedCode.addCode("\n");
        generatedCode.addCode(ImportToolUtils.getResourceString("textCodeGen.scriptheading"));
        generatedCode.addCode("\n%\n%    ");
        generatedCode.addCode(string);
        generatedCode.addCode("\n%\n% ");
        generatedCode.addCode(ImportToolUtils.getResourceString("textCodeGen.extendcommentline"));
        generatedCode.addCode("\n");
        generatedCode.addCode(TextCodeFactory.getTimeStampComment());
        generatedCode.addCode("\n");
    }

    public static void generateMatlabVariableInitialization(GeneratedCode generatedCode, TextImportUIState textImportUIState, CodeType codeType) {
        List<int[]> list = textImportUIState.getSelectedRowIntervals();
        int[] nArray = textImportUIState.getDimensions();
        int n = nArray[0];
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.initVars")));
        if (codeType == CodeType.SCRIPT) {
            generatedCode.addCode(String.format("filename = '%s';%n", textImportUIState.getFile().getPath().replaceAll("'", "''")));
            generatedCode.addNewVariableName("filename");
        }
        if (!textImportUIState.isFixedWidth()) {
            generatedCode.addCode(String.format("delimiter = %s;%n", TextCodeFactory.getDelimiterString(textImportUIState.getDelimiters())));
            generatedCode.addNewVariableName("delimiter");
        }
        if (codeType == CodeType.FUNCTION) {
            generatedCode.addCode("if nargin<=2\n");
        }
        if (list.size() == 1 && (codeType == CodeType.FUNCTION || list.get(0)[0] > 0)) {
            generatedCode.addCode(String.format("startRow = %d;%n", list.get(0)[0] + 1));
            generatedCode.addNewVariableName("startRow");
        } else if (list.size() > 1) {
            generatedCode.addCode(String.format("startRow = %s;%n", TextCodeFactory.getStartRowString(list)));
            generatedCode.addNewVariableName("startRow");
        }
        if (list.size() == 1 && (codeType == CodeType.FUNCTION || list.get(0)[1] < n - 1)) {
            if (list.get(0)[1] >= n - 1) {
                generatedCode.addCode("endRow = inf;\n");
            } else {
                generatedCode.addCode(String.format("endRow = %s;%n", Integer.toString(list.get(0)[1] + 1)));
            }
            generatedCode.addNewVariableName("endRow");
        } else if (list.size() > 1) {
            generatedCode.addCode(String.format("endRow = %s;%n", TextCodeFactory.getEndRowString(list)));
            generatedCode.addNewVariableName("endRow");
        }
        if (codeType == CodeType.FUNCTION) {
            generatedCode.addCode("end\n");
        }
        generatedCode.addCode(String.format("%n", new Object[0]));
        if (textImportUIState.useFastPath()) {
            generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.formatComment")));
            int[] nArray2 = textImportUIState.getSelectedColumns();
            for (int i = 0; i < textImportUIState.getSelectedColumnParseRules().size(); ++i) {
                String string;
                String string2 = string = i % 2 == 0 ? "   " : "\t";
                if (textImportUIState.getSelectedColumnParseRules().get(i) instanceof NumericParsingRule) {
                    generatedCode.addCode(String.format("%%%1$s%2$s%3$d: %4$s (%5$s)%n", string, ImportToolUtils.getResourceString("textCodeGen.column"), nArray2[i] + 1, ImportToolUtils.getResourceString("textCodeGen.double"), textImportUIState.getSelectedColumnParseRules().get(i).getTextscanFormat()));
                    continue;
                }
                if (textImportUIState.getSelectedColumnParseRules().get(i) instanceof DateParsingRule) {
                    generatedCode.addCode(String.format("%%%1$s%2$s%3$d: %4$s (%5$s)%n", string, ImportToolUtils.getResourceString("textCodeGen.column"), nArray2[i] + 1, ImportToolUtils.getResourceString("textCodeGen.datestrings"), textImportUIState.getSelectedColumnParseRules().get(i).getTextscanFormat()));
                    continue;
                }
                generatedCode.addCode(String.format("%%%1$s%2$s%3$d: %4$s (%%s)%n", string, ImportToolUtils.getResourceString("textCodeGen.column"), nArray2[i] + 1, ImportToolUtils.getResourceString("textCodeGen.text")));
            }
            generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.textscanDocComment")));
        } else {
            generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.formatStringComment")));
            generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.textscanDocComment")));
        }
        generatedCode.addCode(String.format("formatSpec = '%s';%n%n", textImportUIState.getTextscanFormat()));
        generatedCode.addNewVariableName("formatSpec");
    }

    static void generateFunctionHeader(GeneratedCode generatedCode, TextImportUIState textImportUIState, String string) {
        String string2 = TextCodeFactory.getStartRowString(textImportUIState.getSelectedRowIntervals());
        String string3 = TextCodeFactory.getEndRowString(textImportUIState.getSelectedRowIntervals());
        generatedCode.addNewVariableName("filename");
        generatedCode.addNewVariableName("startRows");
        generatedCode.addNewVariableName("endRows");
        String string4 = "";
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string5 = "";
        if (textImportUIState.isColumnVectors()) {
            String[] stringArray = textImportUIState.getValidatedSelectedColumnNames();
            string5 = TextCodeFactory.stringArrayToOutputArray(stringArray);
            stringBuilder.append(String.format("%1$s = %2$s(filename, startRow, endRow)%n", string5, string));
            stringBuilder2.append(String.format("%1$s = %2$s('", string5, string));
            generatedCode.addCode(String.format("function %s", stringBuilder.toString()));
            stringBuilder2.append(textImportUIState.getFile().getName());
            stringBuilder2.append(String.format("',%1$s, %2$s);%n", string2, string3));
            string4 = ImportToolUtils.getResourceString("textCodeGen.h1columnvectors");
        } else if (textImportUIState.isMatrix() || textImportUIState.isCellArray() || textImportUIState.isDataset() || textImportUIState.isTable()) {
            string5 = textImportUIState.getValidatedGlobalVariableName();
            generatedCode.addOutputVariableName(string5);
            stringBuilder.append(String.format("%1$s = %2$s(filename, startRow, endRow)%n", string5, string));
            stringBuilder2.append(String.format("%1$s = %2$s('", string5, string));
            generatedCode.addCode(String.format("function %s", stringBuilder.toString()));
            stringBuilder2.append(textImportUIState.getFile().getName());
            stringBuilder2.append(String.format("', %1$s, %2$s);%n", string2, string3));
            string4 = ImportToolUtils.getResourceString("textCodeGen.h1matrix");
        }
        generatedCode.addCode("%");
        generatedCode.addCode(string.toUpperCase());
        generatedCode.addCode(" ");
        generatedCode.addCode(string4);
        generatedCode.addCode("\n");
        generatedCode.addCode(String.format("%%   %1$s = %2$s(FILENAME)%n", string5.toUpperCase(), string.toUpperCase()));
        generatedCode.addCode(String.format("%%   %s%n", ImportToolUtils.getResourceString("textCodeGen.fcnhelpdefaultselection")));
        generatedCode.addCode("%\n");
        generatedCode.addCode(String.format("%%   %s", stringBuilder.toString().toUpperCase()));
        generatedCode.addCode(String.format("%%   %s%n", ImportToolUtils.getResourceString("textCodeGen.fcnhelp")));
        generatedCode.addCode("%\n");
        generatedCode.addCode(String.format("%% Example:%n%%   ", new Object[0]));
        generatedCode.addCode(stringBuilder2.toString());
        generatedCode.addCode(String.format("%%%n%%    %s%n", ImportToolUtils.getResourceString("textCodeGen.seealso")));
        generatedCode.addCode(TextCodeFactory.getTimeStampComment());
        generatedCode.addCode("\n");
    }

    public static void generateCodeBody(GeneratedCode generatedCode, TextImportUIState textImportUIState, CodeType codeType) {
        boolean bl;
        Double d;
        List<int[]> list = textImportUIState.getSelectedRowIntervals();
        int[] nArray = textImportUIState.getDimensions();
        int n = nArray[0];
        boolean bl2 = textImportUIState.useFastPath();
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.openComment")));
        generatedCode.addCode(String.format("fileID = fopen(filename,'r');%n%n", new Object[0]));
        generatedCode.addNewVariableName("fileID");
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.formatReadComment")));
        generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.textscanreuse")));
        String string = textImportUIState.isFixedWidth() ? "'Delimiter', '', 'WhiteSpace', '', " : (textImportUIState.isMultipleDelimsAsOne() ? "'Delimiter', delimiter, 'MultipleDelimsAsOne', true, " : "'Delimiter', delimiter, ");
        if (bl2 && (d = WorksheetReplacementRule.getSingleReplacementValueFromRules(textImportUIState.getActiveRules())) != null) {
            string = string + "'EmptyValue' ," + Double.toString(d) + ",";
        }
        boolean bl3 = bl = textImportUIState.getEmptyRowCount() > 0;
        if (codeType == CodeType.SCRIPT && list.size() == 1) {
            if (list.get(0)[0] == 0 && list.get(0)[1] == n - 1) {
                generatedCode.addCode(String.format("dataArray = textscan(fileID, formatSpec, %1$s 'ReturnOnError', false);%n%n", string));
            } else if (list.get(0)[1] == n - 1) {
                if (bl) {
                    generatedCode.addCode("textscan(fileID, '%[^\\n\\r]', startRow-1, 'ReturnOnError', false);\n");
                    generatedCode.addCode(String.format("dataArray = textscan(fileID, formatSpec, %1$s'ReturnOnError', false);%n%n", string));
                } else {
                    generatedCode.addCode(String.format("dataArray = textscan(fileID, formatSpec, %1$s'HeaderLines' ,startRow-1, 'ReturnOnError', false);%n%n", string));
                }
            } else if (list.get(0)[0] == 0) {
                generatedCode.addCode(String.format("dataArray = textscan(fileID, formatSpec, endRow, %1$s'ReturnOnError', false);%n%n", string));
            } else if (bl) {
                generatedCode.addCode("textscan(fileID, '%[^\\n\\r]', startRow-1, 'ReturnOnError', false);\n");
                generatedCode.addCode(String.format("dataArray = textscan(fileID, formatSpec, endRow-startRow+1, %1$s'ReturnOnError', false);%n%n", string));
            } else {
                generatedCode.addCode(String.format("dataArray = textscan(fileID, formatSpec, endRow-startRow+1, %1$s'HeaderLines', startRow-1, 'ReturnOnError', false);%n%n", string));
            }
        } else {
            if (bl) {
                generatedCode.addCode("textscan(fileID, '%[^\\n\\r]', startRow(1)-1, 'ReturnOnError', false);\n");
                generatedCode.addCode(String.format("dataArray = textscan(fileID, formatSpec, endRow(1)-startRow(1)+1, %1$s'ReturnOnError', false);%n", string));
            } else {
                generatedCode.addCode(String.format("dataArray = textscan(fileID, formatSpec, endRow(1)-startRow(1)+1, %1$s'HeaderLines', startRow(1)-1, 'ReturnOnError', false);%n", string));
            }
            generatedCode.addCode(String.format("for block=2:length(startRow)%n", new Object[0]));
            generatedCode.addNewVariableName("block");
            generatedCode.addCode("frewind(fileID);\n");
            if (bl) {
                generatedCode.addCode("textscan(fileID, '%[^\\n\\r]', startRow(block)-1, 'ReturnOnError', false);\n");
                generatedCode.addCode(String.format("dataArrayBlock = textscan(fileID, formatSpec, endRow(block)-startRow(block)+1, %1$s'ReturnOnError', false);%n", string));
            } else {
                generatedCode.addCode(String.format("dataArrayBlock = textscan(fileID, formatSpec, endRow(block)-startRow(block)+1, %1$s'HeaderLines', startRow(block)-1, 'ReturnOnError', false);%n", string));
            }
            generatedCode.addNewVariableName("dataArrayBlock");
            if (textImportUIState.getSelectedColumns().length > 1) {
                generatedCode.addCode(String.format("for col=1:length(dataArray)%n", new Object[0]));
                generatedCode.addNewVariableName("col");
                generatedCode.addCode(String.format("dataArray{col} = [dataArray{col};dataArrayBlock{col}];%nend%nend%n", new Object[0]));
            } else {
                generatedCode.addCode(String.format("dataArray{1} = [dataArray{1};dataArrayBlock{1}];%nend%n", new Object[0]));
            }
            generatedCode.addCode(String.format("%n", new Object[0]));
        }
        generatedCode.addNewVariableName("dataArray");
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.closeComment")));
        generatedCode.addNewVariableName("ans");
        generatedCode.addCode(String.format("fclose(fileID);%n%n", new Object[0]));
        if (bl2) {
            generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.norules")));
            generatedCode.addCode(String.format("%% %s%n%n", ImportToolUtils.getResourceString("textCodeGen.norulesmsg")));
        } else {
            TextCodeFactory.generateSlowPathPostProcessing(generatedCode, textImportUIState);
        }
    }

    private static void generateRulePostProcess(GeneratedCode generatedCode, TextImportUIState textImportUIState, CodeType codeType) {
        List<Integer> list = TextCodeFactory.getCellColumns(textImportUIState);
        List<Integer> list2 = TextCodeFactory.getDatetimeColumns(textImportUIState);
        if (!list.isEmpty() || !list2.isEmpty()) {
            generatedCode.setRawCellArray("rawNumericColumns");
        }
        for (WorksheetRule worksheetRule : textImportUIState.getActiveRules()) {
            worksheetRule.generateMatlabCode(textImportUIState.getActiveRules(), generatedCode);
            if (!worksheetRule.isRowExcludeType() || TextCodeFactory.getCellColumns(textImportUIState).isEmpty()) continue;
            generatedCode.addCode(String.format("rawCellColumns(%s,:) = [];%n", generatedCode.getRowExclusionIndex()));
        }
        generatedCode.addCode("\n");
    }

    private static void generateSlowPathPostProcessing(GeneratedCode generatedCode, TextImportUIState textImportUIState) {
        String string;
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.convertNumericColumns")));
        generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.replaceWithNaN")));
        List<ParseRule> list = textImportUIState.getSelectedColumnParseRules();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        boolean bl = false;
        List<Integer> list2 = TextCodeFactory.getCellColumns(textImportUIState);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof NumericParsingRule) {
                arrayList.add(i);
                continue;
            }
            if (!(list.get(i) instanceof DateParsingRule)) continue;
            arrayList2.add(i);
            arrayList3.add(((DateParsingRule)list.get(i)).getFormat());
            string = ((DateParsingRule)list.get(i)).getDatetimeLocale();
            arrayList4.add(string);
            if (string == null) continue;
            bl = true;
        }
        if (!(arrayList.isEmpty() && arrayList2.isEmpty() && list2.isEmpty())) {
            generatedCode.addNewVariableName("raw");
            generatedCode.addNewVariableName("col");
            generatedCode.addCode("raw = repmat({''},length(dataArray{1}),length(dataArray)-1);\n");
            generatedCode.addCode("for col=1:length(dataArray)-1\n");
            generatedCode.addCode("raw(1:length(dataArray{col}),col) = dataArray{col};\nend\n");
        }
        generatedCode.addNewVariableName("numericData");
        generatedCode.addCode("numericData = NaN(size(dataArray{1},1),size(dataArray,2));\n\n");
        if (!arrayList.isEmpty()) {
            if (arrayList.size() >= 2) {
                generatedCode.addNewVariableName("col");
                generatedCode.addCode("for col=");
                generatedCode.addCode(GeneratedCode.createMatlabIntegerArrayString(arrayList, 1));
                generatedCode.addCode("\n");
                TextCodeFactory.generateNumericParse(generatedCode, textImportUIState, "col");
                generatedCode.addCode("end\n");
            } else {
                TextCodeFactory.generateNumericParse(generatedCode, textImportUIState, Integer.toString((Integer)arrayList.get(0) + 1));
            }
            generatedCode.addCode("\n");
        }
        if (!arrayList2.isEmpty()) {
            String string2 = GeneratedCode.createMatlabIntegerArrayString(arrayList2, 1);
            if (arrayList2.size() >= 2) {
                String string3;
                string = (String)arrayList3.get(0);
                String string4 = "{'" + string + "'";
                boolean bl2 = true;
                for (int i = 1; i < arrayList3.size(); ++i) {
                    string4 = string4 + ", '" + (String)arrayList3.get(i) + "'";
                    if (string.equals(arrayList3.get(i))) continue;
                    bl2 = false;
                }
                string4 = string4 + "}";
                if (!bl2) {
                    generatedCode.addNewVariableName("dateFormats");
                    generatedCode.addCode("dateFormats = " + string4 + ";\n");
                    string = String.format("dateFormats{col==%s}", string2);
                } else {
                    string = "'" + string + "'";
                }
                String string5 = null;
                if (bl) {
                    string3 = Locale.getDefault().toString().substring(0, 2);
                    String string6 = "{'" + (arrayList4.get(0) == null ? string3 : (String)arrayList4.get(0)) + "'";
                    for (int i = 1; i < arrayList4.size(); ++i) {
                        string6 = string6 + ", '" + (arrayList4.get(i) == null ? string3 : (String)arrayList4.get(i)) + "'";
                    }
                    string6 = string6 + "};";
                    generatedCode.addNewVariableName("dateLocales");
                    generatedCode.addCode("dateLocales = " + string6 + "\n");
                    string5 = String.format("dateLocales{col==%s}", string2);
                }
                string3 = "dateFormatIndex";
                generatedCode.addNewVariableName(string3);
                generatedCode.addCode("dateFormatIndex = 1;\n");
                generatedCode.addCode("blankDates = cell(1,size(raw,2));\n");
                generatedCode.addCode("anyBlankDates = false(size(raw,1),1);\n");
                generatedCode.addCode("invalidDates = cell(1,size(raw,2));\n");
                generatedCode.addCode("anyInvalidDates = false(size(raw,1),1);\n");
                generatedCode.addNewVariableName("col");
                generatedCode.addCode("for col=");
                generatedCode.addCode(string2);
                TextCodeFactory.generateDateParse(generatedCode, "col", string, string3, string5);
                generatedCode.addCode("end\n");
            } else {
                string = Integer.toString((Integer)arrayList2.get(0) + 1);
                TextCodeFactory.generateDateParse(generatedCode, string, "'" + (String)arrayList3.get(0) + "'", null, (String)arrayList4.get(0));
                string2 = string;
                generatedCode.addCode("anyBlankDates = cellfun(@isempty, dataArray{" + string + "});\n");
                generatedCode.addCode("anyInvalidDates = isnan(dates{" + string + "}.Hour) - anyBlankDates;\n");
            }
            generatedCode.addNewVariableName("blankDates");
            generatedCode.addNewVariableName("anyBlankDates");
            generatedCode.addNewVariableName("invalidDates");
            generatedCode.addNewVariableName("anyInvalidDates");
            generatedCode.addCode(generatedCode.getDateArray());
            generatedCode.addCode(" = ");
            generatedCode.addCode(generatedCode.getDateArray());
            generatedCode.addCode("(:,");
            generatedCode.addCode(string2);
            generatedCode.addCode(");\n");
            if (arrayList2.size() >= 2) {
                generatedCode.addCode("blankDates = blankDates(:,");
                generatedCode.addCode(string2);
                generatedCode.addCode(");\n");
                generatedCode.addCode("invalidDates = invalidDates(:,");
                generatedCode.addCode(string2);
                generatedCode.addCode(");\n");
            }
        }
    }

    private static List<Integer> getNumericColumns(TextImportUIState textImportUIState) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < textImportUIState.getSelectedColumnParseRules().size(); ++i) {
            if (textImportUIState.getSelectedColumnParseRules().get(i) == null || !(textImportUIState.getSelectedColumnParseRules().get(i) instanceof NumericParsingRule)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    private static List<Integer> getCellColumns(TextImportUIState textImportUIState) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < textImportUIState.getSelectedColumnParseRules().size(); ++i) {
            if (textImportUIState.getSelectedColumnParseRules().get(i) != null) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    private static List<Integer> getDatetimeColumns(TextImportUIState textImportUIState) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < textImportUIState.getSelectedColumnParseRules().size(); ++i) {
            if (textImportUIState.getSelectedColumnParseRules().get(i) == null || !(textImportUIState.getSelectedColumnParseRules().get(i) instanceof DateParsingRule)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    private static void splitNumericCellColumns(GeneratedCode generatedCode, TextImportUIState textImportUIState) {
        if (textImportUIState.useFastPath()) {
            return;
        }
        List<Integer> list = TextCodeFactory.getCellColumns(textImportUIState);
        List<Integer> list2 = TextCodeFactory.getDatetimeColumns(textImportUIState);
        if (list.isEmpty() && list2.isEmpty()) {
            return;
        }
        generatedCode.addCode(String.format("%n%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.numericCellSplit")));
        List<Integer> list3 = TextCodeFactory.getNumericColumns(textImportUIState);
        if (!list3.isEmpty()) {
            generatedCode.addNewVariableName("rawNumericColumns");
            generatedCode.addCode("rawNumericColumns = raw(:, ");
            generatedCode.addCode(GeneratedCode.createMatlabIntegerArrayString(list3, 1));
            generatedCode.addCode(");\n");
        } else {
            generatedCode.addCode("rawNumericColumns = {};\n");
        }
        if (!list.isEmpty()) {
            generatedCode.addNewVariableName("rawCellColumns");
            generatedCode.addCode("rawCellColumns = raw(:, ");
            generatedCode.addCode(GeneratedCode.createMatlabIntegerArrayString(list, 1));
            generatedCode.addCode(");\n\n");
        }
    }

    private static void generateNumericParse(GeneratedCode generatedCode, TextImportUIState textImportUIState, String string) {
        String string2 = textImportUIState.getDecimalSeparator();
        String string3 = ".".equals(string2) ? "," : ".";
        generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.parseToNums")));
        generatedCode.addNewVariableName("rawData");
        generatedCode.addCode(String.format("rawData = dataArray{%s};%n", string));
        generatedCode.addNewVariableName("row");
        generatedCode.addCode("for row=1:size(rawData, 1);\n");
        generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.createRegex")));
        generatedCode.addNewVariableName("regexstr");
        generatedCode.addCode(String.format("regexstr = '(?<prefix>.*?)(?<numbers>([-]*(\\d+[\\%2$s]*)+[\\%1$s]{0,1}\\d*[eEdD]{0,1}[-+]*\\d*[i]{0,1})|([-]*(\\d+[\\%2$s]*)*[\\%1$s]{1,1}\\d+[eEdD]{0,1}[-+]*\\d*[i]{0,1}))(?<suffix>.*)';%n", string2, string3));
        generatedCode.addCode("try\n");
        generatedCode.addNewVariableName("result");
        generatedCode.addCode("result = regexp(rawData{row}, regexstr, 'names');\n");
        generatedCode.addNewVariableName("numbers");
        generatedCode.addCode("numbers = result.numbers;\n\n");
        generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.detectedThousands")));
        generatedCode.addNewVariableName("invalidThousandsSeparator");
        generatedCode.addCode("invalidThousandsSeparator = false;\n");
        generatedCode.addCode(String.format("if any(numbers=='%s');%n", string3));
        generatedCode.addNewVariableName("thousandsRegExp");
        generatedCode.addCode(String.format("thousandsRegExp = '^\\d+?(\\%2$s\\d{3})*\\%1$s{0,1}\\d*$';%n", string2, string3));
        generatedCode.addCode(String.format("if isempty(regexp(thousandsRegExp, '%s', 'once'));%n", string3));
        generatedCode.addCode("numbers = NaN;\n");
        generatedCode.addCode("invalidThousandsSeparator = true;\n");
        generatedCode.addCode("end\n");
        generatedCode.addCode("end\n");
        generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.convertNumbers")));
        generatedCode.addCode("if ~invalidThousandsSeparator;\n");
        if (",".equals(string2)) {
            generatedCode.addCode("numbers = strrep(numbers, '.', '');\n");
            generatedCode.addCode("numbers = strrep(numbers, ',', '.');\n");
            generatedCode.addCode("numbers = textscan(numbers, '%f');\n");
        } else {
            generatedCode.addCode(String.format("numbers = textscan(strrep(numbers, '%s', ''), '%%f');%n", string3));
        }
        generatedCode.addCode(String.format("numericData(row, %s) = numbers{1};%n", string));
        generatedCode.addCode(String.format("raw{row, %s} = numbers{1};%n", string));
        generatedCode.addCode("end\n");
        generatedCode.addNewVariableName("me");
        generatedCode.addCode("catch me\n");
        generatedCode.addCode("end\n");
        generatedCode.addCode("end\n");
    }

    public static void generateDateParse(GeneratedCode generatedCode, String string, String string2, String string3, String string4) {
        generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.convertDates")));
        generatedCode.addCode("try\n");
        generatedCode.addCode(generatedCode.getDateArray());
        generatedCode.addCode("{" + string + "} = datetime(dataArray{");
        generatedCode.addCode(string);
        generatedCode.addCode("}, 'Format', ");
        if (string3 != null) {
            generatedCode.addCode(string2);
            generatedCode.addCode(", 'InputFormat', ");
            generatedCode.addCode(string2);
            TextCodeFactory.addDatetimeLocale(generatedCode, string3, string4);
            generatedCode.addCode("); %#ok<SAGROW>\n");
            generatedCode.addCode("catch\ntry\n");
            generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.convertDatesQuotes")));
            generatedCode.addCode(String.format("dataArray{%1$s} = cellfun(@(x) x(2:end-1), dataArray{%1$s}, 'UniformOutput', false);%n", string));
            generatedCode.addCode(String.format("dates{%1$s} = datetime(dataArray{%1$s}, 'Format', %2$s, 'InputFormat', %2$s", string, string2));
            TextCodeFactory.addDatetimeLocale(generatedCode, string3, string4);
            generatedCode.addCode("); %%#ok<SAGROW>\n");
            generatedCode.addCode("catch\ndates{col} = repmat(datetime([NaN NaN NaN]), size(dataArray{" + string + "})); %#ok<SAGROW>\nend\nend\n\n");
            generatedCode.addCode(string3);
            generatedCode.addCode(" = ");
            generatedCode.addCode(string3);
            generatedCode.addCode(" + 1;\n");
            generatedCode.addCode("blankDates{");
            generatedCode.addCode(string);
            generatedCode.addCode("} = cellfun(@isempty, dataArray{");
            generatedCode.addCode(string);
            generatedCode.addCode("});\n");
            generatedCode.addCode("anyBlankDates = blankDates{");
            generatedCode.addCode(string);
            generatedCode.addCode("} | anyBlankDates;\n");
            generatedCode.addCode("invalidDates{");
            generatedCode.addCode(string);
            generatedCode.addCode("} = isnan(dates{");
            generatedCode.addCode(string);
            generatedCode.addCode("}.Hour) - blankDates{");
            generatedCode.addCode(string);
            generatedCode.addCode("};\n");
            generatedCode.addCode("anyInvalidDates = invalidDates{");
            generatedCode.addCode(string);
            generatedCode.addCode("} | anyInvalidDates;\n");
        } else {
            generatedCode.addCode(string2);
            generatedCode.addCode(", 'InputFormat', ");
            generatedCode.addCode(string2);
            TextCodeFactory.addDatetimeLocale(generatedCode, string4);
            generatedCode.addCode(");\n");
            generatedCode.addCode("catch\ntry\n");
            generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("textCodeGen.convertDatesQuotes")));
            generatedCode.addCode(String.format("dataArray{%1$s} = cellfun(@(x) x(2:end-1), dataArray{%1$s}, 'UniformOutput', false);%n", string));
            generatedCode.addCode(String.format("dates{%1$s} = datetime(dataArray{%1$s}, 'Format', %2$s, 'InputFormat', %2$s", string, string2));
            TextCodeFactory.addDatetimeLocale(generatedCode, string4);
            generatedCode.addCode(");\n");
            generatedCode.addCode("catch\ndates{" + string + "} = repmat(datetime([NaN NaN NaN]), size(dataArray{" + string + "}));\nend\nend\n\n");
        }
    }

    private static void addDatetimeLocale(GeneratedCode generatedCode, String string) {
        if (string != null) {
            generatedCode.addCode(", 'locale', '");
            generatedCode.addCode(string);
            generatedCode.addCode("'");
        }
    }

    private static void addDatetimeLocale(GeneratedCode generatedCode, String string, String string2) {
        if (string2 != null) {
            generatedCode.addCode(", 'locale', dateLocales{");
            generatedCode.addCode(string);
            generatedCode.addCode("}");
        }
    }

    private static void generateDatsetAllocation(GeneratedCode generatedCode, TextImportUIState textImportUIState, String string, String[] stringArray) {
        TextCodeFactory.generateObjectAllocation(generatedCode, textImportUIState, "dataset", "VarNames", string, stringArray);
    }

    private static void generateTableAllocation(GeneratedCode generatedCode, TextImportUIState textImportUIState, String string, String[] stringArray) {
        TextCodeFactory.generateObjectAllocation(generatedCode, textImportUIState, "table", "VariableNames", string, stringArray);
    }

    private static void generateObjectAllocation(GeneratedCode generatedCode, TextImportUIState textImportUIState, String string, String string2, String string3, String[] stringArray) {
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("codeGen.createoutput")));
        generatedCode.addOutputVariableName(string3);
        if (textImportUIState.useFastPath()) {
            generatedCode.addCode(String.format("%s = %s(dataArray{1:end-1}, '%s', %s);%n%n", string3, string, string2, TextCodeFactory.stringArrayToCellArray(stringArray)));
            StringBuilder stringBuilder = new StringBuilder();
            int n = CommentWrappingPreferences.getMaximumCommentWidth();
            List<Integer> list = TextCodeFactory.getDatetimeColumns(textImportUIState);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!list.contains(i)) continue;
                stringBuilder.append(TextCodeFactory.getDatenumFormattedComment(string3 + "." + stringArray[i], n));
            }
            if (stringBuilder.length() != 0) {
                TextCodeFactory.addDatenumCommentToGeneratedCode(generatedCode, stringBuilder);
            }
        } else {
            generatedCode.addCode(String.format("%s = %s;%n", string3, string));
            TextCodeFactory.generateVectorAllocation(generatedCode, textImportUIState, textImportUIState.getSelectedColumnNames(), string3 + ".");
        }
    }

    private static void generateCellArrayAllocation(GeneratedCode generatedCode, TextImportUIState textImportUIState, String string) {
        generatedCode.addOutputVariableName(string);
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("codeGen.createoutput")));
        if (textImportUIState.useFastPath()) {
            List<Integer> list = TextCodeFactory.getNumericColumns(textImportUIState);
            if (!list.isEmpty()) {
                String string2;
                if (TextCodeFactory.getCellColumns(textImportUIState).isEmpty()) {
                    string2 = "";
                } else if (list.size() == 1) {
                    string2 = "(" + Integer.toString(list.get(0) + 1) + ")";
                } else {
                    string2 = "([" + Integer.toString(list.get(0) + 1);
                    for (int i = 1; i < list.size(); ++i) {
                        string2 = string2 + ", " + Integer.toString(list.get(i) + 1);
                    }
                    string2 = string2 + "])";
                }
                generatedCode.addCode(String.format("dataArray%1$s = cellfun(@(x) num2cell(x), dataArray%1$s, 'UniformOutput', false);%n", string2));
            }
            generatedCode.addCode(String.format("%s = [dataArray{1:end-1}];%n", string));
        } else {
            generatedCode.addCode(String.format("%s = raw;%n", string));
        }
    }

    private static void generateMatrixAllocation(GeneratedCode generatedCode, TextImportUIState textImportUIState, String string) {
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("codeGen.createoutput")));
        generatedCode.addOutputVariableName(string);
        if (textImportUIState.useFastPath()) {
            generatedCode.addCode(String.format("%s = [dataArray{1:end-1}];%n", string));
        } else {
            generatedCode.addCode(String.format("%s = cell2mat(raw);%n", string));
        }
    }

    private static void generateVectorAllocation(GeneratedCode generatedCode, TextImportUIState textImportUIState, String[] stringArray, String string) {
        List<Integer> list = TextCodeFactory.getCellColumns(textImportUIState);
        List<Integer> list2 = TextCodeFactory.getDatetimeColumns(textImportUIState);
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        boolean bl = textImportUIState.getActiveColumnExclusionRuleCount() > 0;
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = CommentWrappingPreferences.getMaximumCommentWidth();
        for (int i = 0; i < stringArray.length; ++i) {
            if (textImportUIState.useFastPath()) {
                generatedCode.addCode(String.format("%1$s%2$s = dataArray{:, %3$d};%n", string, stringArray[i], i + 1));
                if (!list2.contains(i)) continue;
                stringBuilder.append(TextCodeFactory.getDatenumFormattedComment(string + stringArray[i], n4));
                continue;
            }
            if (list.isEmpty() && list2.isEmpty()) {
                if (bl) {
                    if (list2.contains(i)) {
                        generatedCode.addCode(String.format("if ~%1$s(%2$d)%n", generatedCode.getDatetimeColumnExclusionIndex(), n3));
                        generatedCode.addCode(String.format("%1$s%2$s = %3$s{:, datetimeColumnIndices(%4$d)};%n", string, stringArray[i], generatedCode.getDateArray(), n3++));
                    } else {
                        generatedCode.addCode(String.format("if ~%1$s(%2$d)%n", generatedCode.getColumnExclusionIndex(), i + 1));
                        generatedCode.addCode(String.format("%1$s%2$s = cell2mat(raw(:, columnIndices(%3$d)));%n", string, stringArray[i], i + 1));
                    }
                    generatedCode.addCode("end\n");
                    continue;
                }
                if (list2.contains(i)) {
                    generatedCode.addCode(String.format("%1$s%2$s = %3$s{:, %4$d};%n", string, stringArray[i], generatedCode.getDateArray(), n3++));
                    continue;
                }
                generatedCode.addCode(String.format("%1$s%2$s = cell2mat(raw(:, %3$d));%n", string, stringArray[i], i + 1));
                continue;
            }
            if (list.contains(i)) {
                generatedCode.addCode(String.format("%1$s%2$s = rawCellColumns(:, %3$d);%n", string, stringArray[i], n2));
                ++n2;
                continue;
            }
            if (list2.contains(i)) {
                if (bl) {
                    if (list2.contains(i)) {
                        generatedCode.addCode(String.format("if ~%1$s(%2$d)%n", generatedCode.getDatetimeColumnExclusionIndex(), n3));
                        generatedCode.addCode(String.format("%1$s%2$s = %3$s{:, datetimeColumnIndices(%4$d)};%n", string, stringArray[i], generatedCode.getDateArray(), n3++));
                    } else {
                        generatedCode.addCode(String.format("if ~%1$s(%2$d)%n", generatedCode.getColumnExclusionIndex(), i + 1));
                        generatedCode.addCode(String.format("%1$s%2$s = cell2mat(raw(:, columnIndices(%3$d)));%n", string, stringArray[i], i + 1));
                    }
                    generatedCode.addCode("end\n");
                } else {
                    generatedCode.addCode(String.format("%1$s%2$s = %3$s{:, %4$d};%n", string, stringArray[i], generatedCode.getDateArray(), n3++));
                }
                stringBuilder.append(TextCodeFactory.getDatenumFormattedComment(string + stringArray[i], n4));
                continue;
            }
            if (bl) {
                generatedCode.addCode(String.format("if ~%1$s(%2$d)%n", generatedCode.getColumnExclusionIndex(), n));
                generatedCode.addCode(String.format("%1$s%2$s = cell2mat(rawNumericColumns(:, columnIndices(%3$d)));%n", string, stringArray[i], n));
                generatedCode.addCode("end\n");
            } else {
                generatedCode.addCode(String.format("%1$s%2$s = cell2mat(rawNumericColumns(:, %3$d));%n", string, stringArray[i], n));
            }
            ++n;
        }
        generatedCode.addCode("\n");
        if (stringBuilder.length() != 0) {
            TextCodeFactory.addDatenumCommentToGeneratedCode(generatedCode, stringBuilder);
        }
    }

    private static void generateColumnAllocation(GeneratedCode generatedCode, TextImportUIState textImportUIState, String[] stringArray) {
        for (String string : stringArray) {
            generatedCode.addOutputVariableName(string);
        }
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("codeGen.allocheading")));
        TextCodeFactory.generateVectorAllocation(generatedCode, textImportUIState, stringArray, "");
        generatedCode.addCode("\n");
    }

    public static void generateFunctionOutputAllocation(GeneratedCode generatedCode, TextImportUIState textImportUIState, String[] stringArray) {
        if (textImportUIState.isColumnVectors() && textImportUIState.getActiveColumnExclusionRuleCount() > 0) {
            List<Integer> list = TextCodeFactory.getNumericColumns(textImportUIState);
            for (int n : list) {
                generatedCode.addCode(String.format("%s = [];%n", stringArray[n]));
            }
        }
        TextCodeFactory.generateOutputAllocation(generatedCode, textImportUIState, false);
    }

    public static void generateScriptOutputAllocation(GeneratedCode generatedCode, TextImportUIState textImportUIState) {
        TextCodeFactory.generateOutputAllocation(generatedCode, textImportUIState, true);
    }

    public static void generateOutputAllocation(GeneratedCode generatedCode, TextImportUIState textImportUIState, boolean bl) {
        if (textImportUIState.getActiveColumnExclusionRuleCount() > 0) {
            generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("textCodeGen.columnOutputDeclare")));
            generatedCode.addNewVariableName("columnIndices");
            generatedCode.addCode("columnIndices = cumsum(~");
            generatedCode.addCode(generatedCode.getColumnExclusionIndex());
            generatedCode.addCode(");\n");
            if (!WorksheetRule.getDatetimeColumnVectorPositions().isEmpty()) {
                generatedCode.addNewVariableName("datetimeColumnIndices");
                generatedCode.addCode("datetimeColumnIndices = cumsum(~");
                generatedCode.addCode(generatedCode.getDatetimeColumnExclusionIndex());
                generatedCode.addCode(");\n");
            }
            generatedCode.addCode("\n");
        }
        if (textImportUIState.isColumnVectors()) {
            TextCodeFactory.generateColumnAllocation(generatedCode, textImportUIState, bl ? textImportUIState.getSelectedColumnNames() : textImportUIState.getValidatedSelectedColumnNames());
        } else if (textImportUIState.isMatrix()) {
            TextCodeFactory.generateMatrixAllocation(generatedCode, textImportUIState, bl ? textImportUIState.getGlobalVariableName() : textImportUIState.getValidatedGlobalVariableName());
        } else if (textImportUIState.isCellArray()) {
            TextCodeFactory.generateCellArrayAllocation(generatedCode, textImportUIState, bl ? textImportUIState.getGlobalVariableName() : textImportUIState.getValidatedGlobalVariableName());
        } else if (textImportUIState.isDataset()) {
            TextCodeFactory.generateDatsetAllocation(generatedCode, textImportUIState, bl ? textImportUIState.getGlobalVariableName() : textImportUIState.getValidatedGlobalVariableName(), textImportUIState.getSelectedColumnNames());
        } else if (textImportUIState.isTable()) {
            TextCodeFactory.generateTableAllocation(generatedCode, textImportUIState, bl ? textImportUIState.getGlobalVariableName() : textImportUIState.getValidatedGlobalVariableName(), textImportUIState.getSelectedColumnNames());
        }
    }

    public static String stringArrayToCellArray(String[] stringArray) {
        String string = "{";
        for (int i = 0; i < stringArray.length - 1; ++i) {
            string = string + "'" + stringArray[i] + "',";
        }
        string = string + "'" + stringArray[stringArray.length - 1] + "'}";
        return string;
    }

    private static String getDelimiterString(List<String> list) {
        String string;
        if (list.size() == 1) {
            String string2 = list.get(0);
            string2 = string2.replaceAll("'", "''");
            string2 = string2.replace("\\", "\\\\");
            string2 = string2.replace("\t", "\\t");
            string = "'" + string2 + "'";
        } else {
            String string3;
            string = "{";
            for (int i = 0; i < list.size() - 1; ++i) {
                string3 = list.get(i);
                string3 = string3.replaceAll("'", "''");
                string3 = string3.replace("\\", "\\\\");
                string3 = string3.replace("\t", "\\t");
                string = string + "'" + string3 + "',";
            }
            string3 = list.get(list.size() - 1);
            string3 = string3.replaceAll("'", "''");
            string3 = string3.replace("\\", "\\\\");
            string3 = string3.replace("\t", "\\t");
            string = string + "'" + string3 + "'}";
        }
        return string;
    }

    public static enum CodeType {
        SCRIPT,
        FUNCTION;

    }
}

