/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.DataTypeDropDownButton;
import com.mathworks.mlwidgets.importtool.DateParsingRule;
import com.mathworks.mlwidgets.importtool.ImportClient;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.ParseRule;
import com.mathworks.mlwidgets.importtool.TextCellRenderer;
import com.mathworks.mlwidgets.importtool.TextTable;
import com.mathworks.mlwidgets.importtool.VariableHeaderRenderer;
import com.mathworks.mlwidgets.importtool.popuplist.EditablePopupList;
import com.mathworks.mwswing.MJPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;

public class TextTableHeaderRenderer
extends VariableHeaderRenderer {
    private DataTypeDropDownButton fDataTypeViewTSDropDownButton;
    private RulerPanel fRulerPaddingFiller;
    private DataTypeDropDownButton fDataTypeEditTSDropDownButton;
    private RulerPanel fEditRulerPaddingFiller;
    private TextImportDataHeader fLastEditedImportDataHeader;
    private int fHoverSplitterColumn = -1;
    private boolean fFixedWidth = false;
    private int fLastItemListColumn = -1;
    private static final int RulerFillerHeight = 30;
    private int fDataTypeHoverColumn = -1;

    public TextTableHeaderRenderer(TextTable textTable) {
        this(textTable, false);
    }

    TextTableHeaderRenderer(TextTable textTable, boolean bl) {
        super((JTable)((Object)textTable));
        this.fFixedWidth = bl;
        this.fRulerPaddingFiller = new RulerPanel();
        this.fEditRulerPaddingFiller = new RulerPanel();
        this.fRulerPaddingFiller.setAlignmentX(0.5f);
        this.fEditRulerPaddingFiller.setAlignmentX(0.5f);
        if (!bl) {
            this.getVarNameLabel().setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            this.getVarNameEditorTextField().setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        }
        this.fDataTypeViewTSDropDownButton = new DataTypeDropDownButton(textTable.getTableHeader());
        this.fDataTypeEditTSDropDownButton = new DataTypeDropDownButton(textTable.getTableHeader());
        this.getPanel().add((Component)((Object)this.fDataTypeViewTSDropDownButton));
        this.getPanel().add((Component)((Object)this.fRulerPaddingFiller));
        this.getEditorPanel().add((Component)((Object)this.fDataTypeEditTSDropDownButton));
        this.getEditorPanel().add((Component)((Object)this.fEditRulerPaddingFiller));
    }

    @Override
    protected void updatePanelLayout() {
        super.updatePanelLayout();
        this.getPanel().add((Component)((Object)this.fDataTypeViewTSDropDownButton));
        if (this.fFixedWidth) {
            this.getPanel().add((Component)((Object)this.fRulerPaddingFiller));
        }
        this.getEditorPanel().add((Component)((Object)this.fDataTypeEditTSDropDownButton));
        if (this.fFixedWidth) {
            this.getEditorPanel().add((Component)((Object)this.fEditRulerPaddingFiller));
        }
        this.getPanel().validate();
        this.getEditorPanel().validate();
    }

    public int getRulerLabelHeight() {
        if (!this.fFixedWidth) {
            return 0;
        }
        return this.fRulerPaddingFiller.getHeight();
    }

    public void showListItemPopup(int n, ImportClient.TargetType targetType) {
        this.updateDataTypeViewTSDropDownButton(n);
        this.fDataTypeViewTSDropDownButton.showListItemPopup(n, targetType);
        this.fLastItemListColumn = n;
    }

    private void updateDataTypeViewTSDropDownButton(int n) {
        TextImportDataHeader textImportDataHeader = (TextImportDataHeader)this.getTable().getColumnModel().getColumn(n).getHeaderValue();
        this.fDataTypeViewTSDropDownButton.removeAllItems();
        if (textImportDataHeader.getParseRule() == null) {
            this.fDataTypeViewTSDropDownButton.addItem(ImportToolUtils.getResourceString("datatypes.text"));
            this.fDataTypeViewTSDropDownButton.setText(ImportToolUtils.getResourceString("datatypes.text"));
        } else {
            this.fDataTypeViewTSDropDownButton.addItem(textImportDataHeader.getParseRule().getParseTargetType());
            this.fDataTypeViewTSDropDownButton.setText(textImportDataHeader.getParseRule().getParseTargetType());
        }
        this.fDataTypeViewTSDropDownButton.validate();
    }

    public void hideListItemPopup() {
        this.fDataTypeViewTSDropDownButton.hideListItem();
        this.fLastItemListColumn = -1;
    }

    public int getLastItemListColumn() {
        return this.fLastItemListColumn;
    }

    public boolean clickInListPopup(Point point) {
        EditablePopupList editablePopupList = this.fDataTypeViewTSDropDownButton.getPopupList();
        if (editablePopupList != null && editablePopupList.isVisible()) {
            return editablePopupList.containsScreenPoint(point);
        }
        return false;
    }

    public boolean isFixedWidth() {
        return this.fFixedWidth;
    }

    public void setFixedWidth(boolean bl) {
        this.fFixedWidth = bl;
        this.updatePanelLayout();
    }

    public Rectangle getDataTypeDropDownBounds(int n, Object object) {
        Rectangle rectangle = this.getTable().getTableHeader().getHeaderRect(n);
        this.getPanel().setSize(new Dimension(rectangle.width, rectangle.height));
        this.getTableCellRendererComponent(this.getTable(), object, false, false, 0, n);
        this.getPanel().getLayout().layoutContainer((Container)this.getPanel());
        return this.fDataTypeViewTSDropDownButton.getBounds();
    }

    public Rectangle getRulerDropDownBounds(int n, Object object) {
        if (!this.fFixedWidth) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle = this.getTable().getTableHeader().getHeaderRect(n);
        this.getPanel().setSize(new Dimension(rectangle.width, rectangle.height));
        this.getTableCellRendererComponent(this.getTable(), object, false, false, 0, n);
        this.getPanel().getLayout().layoutContainer((Container)this.getPanel());
        return this.fRulerPaddingFiller.getBounds();
    }

    @Override
    public boolean isSelectionArea(Point point, int n, Object object) {
        Rectangle rectangle = this.getTable().getTableHeader().getHeaderRect(n);
        this.getPanel().setSize(new Dimension(rectangle.width, rectangle.height));
        this.getTableCellRendererComponent(this.getTable(), object, false, false, 0, n);
        this.getPanel().getLayout().layoutContainer((Container)this.getPanel());
        Rectangle rectangle2 = this.fDataTypeViewTSDropDownButton.getBounds();
        Rectangle rectangle3 = this.getVarNameLabel().getBounds();
        Rectangle rectangle4 = this.getRulerDropDownBounds(n, object);
        return !rectangle3.contains(point) && !rectangle2.contains(point) && !rectangle4.contains(point);
    }

    public int getHoverSplitterColumn() {
        return this.fHoverSplitterColumn;
    }

    public void setHoverSplitterColumn(int n) {
        this.fHoverSplitterColumn = n;
    }

    public int getDataTypeHoverColumn() {
        return this.fDataTypeHoverColumn;
    }

    public void setDataTypeHoverColumn(int n) {
        this.fDataTypeHoverColumn = n;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        TextTable textTable = (TextTable)((Object)jTable);
        if (this.getTable() != null) {
            textTable = (TextTable)((Object)this.getTable());
        }
        this.fRulerPaddingFiller.setColumn(n2);
        if (object instanceof TextImportDataHeader) {
            TextImportDataHeader textImportDataHeader = (TextImportDataHeader)object;
            this.fDataTypeViewTSDropDownButton.removeAllItems();
            if (textImportDataHeader.getParseRule() == null) {
                this.fDataTypeViewTSDropDownButton.addItem(ImportToolUtils.getResourceString("datatypes.text"));
                this.fDataTypeViewTSDropDownButton.setText(ImportToolUtils.getResourceString("datatypes.text"));
            } else {
                this.fDataTypeViewTSDropDownButton.addItem(textImportDataHeader.getParseRule().getParseTargetType());
                this.fDataTypeViewTSDropDownButton.setText(textImportDataHeader.getParseRule().getParseTargetType());
            }
        }
        if (n2 == this.fDataTypeViewTSDropDownButton.getPopupColumn()) {
            this.fDataTypeViewTSDropDownButton.listVisibilityChanged(true);
            this.fDataTypeEditTSDropDownButton.listVisibilityChanged(true);
        } else {
            this.fDataTypeViewTSDropDownButton.listVisibilityChanged(false);
            this.fDataTypeEditTSDropDownButton.listVisibilityChanged(false);
        }
        if (this.fDataTypeHoverColumn == n2) {
            this.fDataTypeViewTSDropDownButton.setBackground(Color.WHITE);
            this.fDataTypeViewTSDropDownButton.setBorder(this.fBevelBorder);
        } else {
            this.fDataTypeViewTSDropDownButton.setBackground(this.getTable().isColumnSelected(n2) ? this.fRowHeaderColorSelected : this.fRowHeaderColorUnselected);
            this.fDataTypeViewTSDropDownButton.setBorder(null);
        }
        this.getPanel().revalidate();
        return this.getPanel();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        if (object instanceof TextImportDataHeader) {
            TextImportDataHeader textImportDataHeader = (TextImportDataHeader)object;
            this.fEditRulerPaddingFiller.setColumn(n2);
            this.fDataTypeEditTSDropDownButton.removeAllItems();
            if (textImportDataHeader.getParseRule() == null) {
                this.fDataTypeEditTSDropDownButton.addItem(ImportToolUtils.getResourceString("datatypes.text"));
                this.fDataTypeEditTSDropDownButton.setText(ImportToolUtils.getResourceString("datatypes.text"));
            } else {
                this.fDataTypeEditTSDropDownButton.addItem(textImportDataHeader.getParseRule().getParseTargetType());
                this.fDataTypeEditTSDropDownButton.setText(textImportDataHeader.getParseRule().getParseTargetType());
            }
            this.fLastEditedImportDataHeader = (TextImportDataHeader)object;
            return this.getEditorPanel();
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        return new TextImportDataHeader(this.fLastEditedImportDataHeader.getColumn(), this.getVarNameEditorTextField().getText(), this.fLastEditedImportDataHeader.getParseRule(), this.fLastEditedImportDataHeader.getDateParseRules());
    }

    @Override
    protected void setLabelState(boolean bl) {
        super.setLabelState(bl);
        if (bl) {
            this.fDataTypeViewTSDropDownButton.setBackground(this.getPanel().getBackground());
            this.fDataTypeEditTSDropDownButton.setBackground(this.getPanel().getBackground());
        } else {
            this.fDataTypeViewTSDropDownButton.setBackground(new Color(250, 250, 250));
            this.fDataTypeEditTSDropDownButton.setBackground(new Color(250, 250, 250));
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.fDataTypeViewTSDropDownButton != null) {
            this.fDataTypeViewTSDropDownButton.cleanup();
        }
        if (this.fDataTypeEditTSDropDownButton != null) {
            this.fDataTypeEditTSDropDownButton.cleanup();
        }
    }

    protected class RulerPanel
    extends MJPanel {
        private int fColumn = -1;
        private static final int RulerHeight = 12;

        public RulerPanel() {
            this.setOpaque(true);
            this.setPreferredSize(new Dimension(0, 30));
        }

        public int getColumn() {
            return this.fColumn;
        }

        public void setColumn(int n) {
            this.fColumn = n;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle rectangle = graphics2D.getClipBounds();
            if (TextTableHeaderRenderer.this.fFixedWidth) {
                int n = TextTableHeaderRenderer.this.getTable().getColumnModel().getColumn(this.fColumn).getWidth();
                graphics2D.setColor(TextTableHeaderRenderer.this.getTable().getTableHeader().getBackground());
                graphics2D.fillRect(0, rectangle.height - TextTableHeaderRenderer.this.fRulerPaddingFiller.getHeight(), n, TextTableHeaderRenderer.this.fRulerPaddingFiller.getHeight());
                graphics2D.setColor(TextTableHeaderRenderer.this.getTable().getGridColor());
                graphics2D.drawLine(0, rectangle.height - 1, n, rectangle.height - 1);
                int n2 = rectangle.height - TextTableHeaderRenderer.this.fRulerPaddingFiller.getHeight() / 2;
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillRect(0, n2 - 6, n, 12);
                graphics2D.setColor(Color.BLACK);
                Object object = TextTableHeaderRenderer.this.getTable().getValueAt(0, this.fColumn);
                Component component = TextTableHeaderRenderer.this.getTable().getCellRenderer(0, this.fColumn).getTableCellRendererComponent(TextTableHeaderRenderer.this.getTable(), object, false, false, 0, this.fColumn);
                if (component != null && component instanceof JLabel) {
                    int n3 = ((TextCellRenderer)TextTableHeaderRenderer.this.getTable().getCellRenderer(0, this.fColumn)).getFixedWidthCharacterWidth();
                    int n4 = ((TextTable)((Object)TextTableHeaderRenderer.this.getTable())).getNumCharactersForColumn(this.fColumn);
                    for (int i = 0; i < n4; ++i) {
                        graphics2D.drawLine(i * n3 + 1, n2 - 1, i * n3 + 1, n2 + 1);
                        if (i != 0) continue;
                        graphics2D.drawLine(i * n3, n2 - 2, i * n3, n2 + 2);
                        graphics2D.drawLine(i * n3 + 1, n2 - 2, i * n3 + 1, n2 + 2);
                        graphics2D.drawLine(i * n3, n2 + 2, i * n3 + 3, n2 + 2);
                        graphics2D.drawLine(i * n3, n2 + 3, i * n3 + 3, n2 + 3);
                        if (this.fColumn != TextTableHeaderRenderer.this.fHoverSplitterColumn) continue;
                        graphics2D.setColor(new Color(0, 0, 255, 50));
                        graphics2D.fillRoundRect(i * n3 - 1, n2 - 3, 4, 6, 2, 2);
                        graphics2D.fillRoundRect(i * n3 - 1, n2 + 4, 6, 4, 2, 2);
                        graphics2D.setColor(Color.BLACK);
                    }
                    if (n - (n3 * n4 + 1) > n3) {
                        graphics2D.setColor(Color.LIGHT_GRAY);
                        graphics2D.fillRect(n3 * n4 + 1, n2 - 6, n, 12);
                    }
                }
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawLine(0, n2 - 6, n, n2 - 6);
                graphics2D.drawLine(0, n2 + 6, n, n2 + 6);
                if (this.fColumn == 0) {
                    graphics2D.drawLine(0, n2 - 6, 0, n2 + 6);
                }
                if (this.fColumn == TextTableHeaderRenderer.this.getTable().getColumnCount() - 1) {
                    graphics2D.drawLine(n - 1, n2 - 6, n - 1, n2 + 6);
                }
            }
        }
    }

    public static class TextImportDataHeader
    extends VariableHeaderRenderer.ImportDataHeader {
        private ParseRule iParseRule = null;
        private DateParsingRule[] iDateParseRules;

        public TextImportDataHeader(int n, String string, ParseRule parseRule, DateParsingRule[] dateParsingRuleArray) {
            super(n, string);
            this.iParseRule = parseRule;
            this.iDateParseRules = dateParsingRuleArray;
        }

        ParseRule getParseRule() {
            return this.iParseRule;
        }

        void setParseRule(ParseRule parseRule) {
            this.iParseRule = parseRule;
        }

        DateParsingRule[] getDateParseRules() {
            return this.iDateParseRules;
        }

        void setDateParseRules(DateParsingRule[] dateParsingRuleArray) {
            this.iDateParseRules = dateParsingRuleArray;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof TextImportDataHeader) || !super.equals(object)) {
                return false;
            }
            if (this.iParseRule == null && this.iDateParseRules == null) {
                return this.getParseRule() == null && this.getDateParseRules() == null;
            }
            if (this.iDateParseRules == null) {
                return this.getDateParseRules() == null && this.iParseRule.equals(this.getParseRule());
            }
            if (this.iParseRule == null) {
                return this.getParseRule() == null && this.iDateParseRules.equals(this.getDateParseRules());
            }
            return this.iDateParseRules.equals(((TextImportDataHeader)object).getDateParseRules()) && this.iParseRule.equals(((TextImportDataHeader)object).getParseRule());
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            if (this.iParseRule != null) {
                n += 10000 * this.iParseRule.hashCode();
            }
            if (this.iDateParseRules != null) {
                n += 100000 * this.iDateParseRules.hashCode();
            }
            return n;
        }
    }
}

