/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.WorksheetSelectionListener;
import com.mathworks.mlwidgets.importtool.popuplist.EditablePopupButton;
import com.mathworks.mlwidgets.importtool.popuplist.EditablePopupListItem;
import com.mathworks.mwswing.MJUtilities;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class WorksheetRangeEditBox
extends EditablePopupButton
implements WorksheetSelectionListener {
    private boolean fAdjusting = false;
    private List<WorksheetSelectionListener> fRangeSelectionListeners = new ArrayList<WorksheetSelectionListener>();
    private EditablePopupButton.EditablePopupListSelectionListener fSelectionListener;
    private EditablePopupListItem fDefaultItem;

    public WorksheetRangeEditBox(String string) {
        super("", false);
        this.getItemList().setName("RangeWindow");
        this.setSingleSelectionEnabled(true);
        this.setEditable(true);
        this.setCloseOnSelection(true);
        EditablePopupListItem editablePopupListItem = new EditablePopupListItem(ImportToolUtils.getResourceString("toolstrip.selectionhistory"), "", EditablePopupListItem.ITEM_TYPE.HEADER, false);
        this.addItem(editablePopupListItem);
        if (MJUtilities.isHighContrast()) {
            this.setBackground(Color.black);
        }
        this.fSelectionListener = new EditablePopupButton.EditablePopupListSelectionListener(){

            @Override
            public void selectionChanged(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
                if (!WorksheetRangeEditBox.this.fAdjusting && editablePopupEvent.getItem().isSelected()) {
                    WorksheetRangeEditBox.this.fAdjusting = true;
                    String string = editablePopupEvent.getItem().getValue().toString();
                    WorksheetRangeEditBox.this.commit(string);
                    WorksheetRangeEditBox.this.fireTemporarySelectionChanged("");
                    WorksheetRangeEditBox.this.fAdjusting = false;
                    if (WorksheetRangeEditBox.this.fDefaultItem == null) {
                        WorksheetRangeEditBox.this.fDefaultItem = editablePopupEvent.getItem();
                        WorksheetRangeEditBox.this.fDefaultItem.setDisplayName(WorksheetRangeEditBox.this.fDefaultItem.getDisplayName() + ImportToolUtils.getResourceString("rangeedit.default"));
                    }
                    if (editablePopupEvent.getItem().equals((Object)WorksheetRangeEditBox.this.fDefaultItem)) {
                        WorksheetRangeEditBox.this.setText(editablePopupEvent.getItem().getValue().toString());
                    }
                }
            }

            @Override
            public void temporarySelectionChanged(EditablePopupButton.EditablePopupEvent editablePopupEvent) {
                if (WorksheetRangeEditBox.this.isListVisible()) {
                    if (editablePopupEvent.getItem().isTemporarilySelected()) {
                        WorksheetRangeEditBox.this.fireTemporarySelectionChanged(editablePopupEvent.getItem().getValue().toString());
                    } else {
                        WorksheetRangeEditBox.this.fireTemporarySelectionChanged("");
                    }
                }
            }
        };
        this.addListeners();
    }

    public void addWorksheetSelectionListener(WorksheetSelectionListener worksheetSelectionListener) {
        this.fRangeSelectionListeners.remove(worksheetSelectionListener);
        this.fRangeSelectionListeners.add(worksheetSelectionListener);
    }

    public void removeWorksheetSelectionListener(WorksheetSelectionListener worksheetSelectionListener) {
        this.fRangeSelectionListeners.remove(worksheetSelectionListener);
    }

    void commit() {
        if (!this.isEditing()) {
            return;
        }
        for (WorksheetSelectionListener worksheetSelectionListener : this.fRangeSelectionListeners) {
            worksheetSelectionListener.selectedDataChanged(this.getCoalescedString());
        }
    }

    void commit(String string) {
        for (WorksheetSelectionListener worksheetSelectionListener : this.fRangeSelectionListeners) {
            worksheetSelectionListener.selectedDataChanged(string);
        }
    }

    void fireTemporarySelectionChanged(String string) {
        for (WorksheetSelectionListener worksheetSelectionListener : this.fRangeSelectionListeners) {
            worksheetSelectionListener.temporarySelectionDataChanged(string);
        }
    }

    @Override
    public void selectedDataChanged(String string) {
        this.selectedDataChanged(string, false);
    }

    @Override
    public void selectedDataChanged(String string, boolean bl) {
        if (!(bl || string != null && string.length() > 0)) {
            this.setText("");
            this.makeAllItemsUnselected();
            this.makeAllItemsVisible();
            return;
        }
        Pattern pattern = Pattern.compile("(.*?):\\1");
        if (pattern.matcher(string).matches()) {
            this.setText(string);
            this.makeAllItemsUnselected();
            this.makeAllItemsVisible();
            return;
        }
        if (!bl) {
            EditablePopupListItem editablePopupListItem;
            this.removeListeners();
            int n = -1;
            String string2 = "RangeItem:";
            if (this.containsItem(string)) {
                editablePopupListItem = this.getItem(string);
                string2 = editablePopupListItem.getName();
                this.removeItem(string);
            } else {
                string2 = string2 + (this.getItemCount() - 1);
            }
            this.addItemAt(string, 1);
            this.setSelectedItem(string);
            editablePopupListItem = this.getItem(string);
            editablePopupListItem.setName(string2);
            this.addListeners();
            if (this.fDefaultItem == null || editablePopupListItem.getValue().equals(this.fDefaultItem.getValue())) {
                this.fDefaultItem = editablePopupListItem;
                this.fDefaultItem.setDisplayName(this.fDefaultItem.getDisplayName() + ImportToolUtils.getResourceString("rangeedit.default"));
                this.setText(editablePopupListItem.getValue().toString());
            }
            this.makeAllItemsVisible();
            if (this.getItemCount() > 2) {
                editablePopupListItem.setVisible(false);
            }
            this.getItemList().revalidate();
        }
        this.setText(string);
    }

    private void makeAllItemsUnselected() {
        this.removeListeners();
        for (int i = 0; i < this.getItemCount(); ++i) {
            this.getItemAt(i).setSelected(false);
            this.getItemAt(i).setTemporarilySelected(false);
        }
        this.addListeners();
    }

    private void makeAllItemsVisible() {
        for (int i = 0; i < this.getItemCount(); ++i) {
            EditablePopupListItem editablePopupListItem = this.getItemAt(i);
            editablePopupListItem.setVisible(true);
        }
        this.getItemList().revalidate();
    }

    @Override
    protected void saveAndDisableEditor() {
        this.commit(this.getText());
        this.fLabel.setText(this.getText());
        if (this.fStopEditingOnFocusLost) {
            this.remove((Component)this.fTextField);
            this.add((Component)this.fLabel, "Center");
        }
        this.removeFocusListener();
        this.validate();
        this.repaint();
    }

    @Override
    public void temporarySelectionDataChanged(String string) {
    }

    private void addListeners() {
        this.addSelectionListener(this.fSelectionListener);
    }

    private void removeListeners() {
        this.removeSelectionListener(this.fSelectionListener);
    }
}

