/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.mdt.MatlabCallable;
import com.mathworks.jmi.mdt.MatlabEventQueue;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.mlwidgets.importtool.WorksheetRuleListener;
import com.mathworks.mwswing.MJTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.BorderFactory;

public abstract class WorksheetReplacementRule
extends WorksheetRule {
    protected double fReplacementNumber = Double.NaN;
    protected String fLastText = "";
    protected MJTextField fEditor;
    private List<WorksheetRuleListener> fWorksheetRuleListeners = new ArrayList<WorksheetRuleListener>();

    protected WorksheetReplacementRule(WorksheetRule worksheetRule) {
        if (worksheetRule instanceof WorksheetReplacementRule) {
            this.fReplacementNumber = ((WorksheetReplacementRule)worksheetRule).getReplacementNumber();
        }
    }

    protected WorksheetReplacementRule() {
    }

    @Override
    public WorksheetRule.RuleType getType() {
        return WorksheetRule.RuleType.REPLACE;
    }

    public static WorksheetRule.RuleType getRuleType() {
        return WorksheetRule.RuleType.REPLACE;
    }

    public void setReplacementNumber(double d) {
        this.fReplacementNumber = d;
    }

    public double getReplacementNumber() {
        return this.fReplacementNumber;
    }

    @Override
    public boolean codeGenNeedsNaNConvert() {
        return Double.isNaN(this.fReplacementNumber);
    }

    private void parseScalar() {
        Object var2_2;
        if (this.fLastText.equals(this.fEditor.getText())) {
            return;
        }
        Future future = MatlabEventQueue.invoke((MatlabCallable)new MatlabCallable<Object>(){

            public void callOnEdt(Object object, boolean bl) {
            }

            public Object call() throws Exception {
                try {
                    return Matlab.mtFeval((String)"eval", (Object[])new Object[]{WorksheetReplacementRule.this.fEditor.getText()}, (int)1);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
        try {
            var2_2 = future.get(3000L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            var2_2 = null;
        }
        catch (InterruptedException interruptedException) {
            var2_2 = null;
        }
        catch (Exception exception) {
            var2_2 = null;
        }
        this.updateReplacementNumberFromMatlab(var2_2);
    }

    protected void updateReplacementNumberFromMatlab(Object object) {
        if (object != null && object instanceof double[] && ((double[])object).length == 1 && Double.doubleToLongBits(((double[])object)[0]) != Double.doubleToLongBits(this.fReplacementNumber)) {
            this.fReplacementNumber = ((double[])object)[0];
            this.fireWorksheetRuleChanged();
        }
        this.fLastText = Double.isInfinite(this.fReplacementNumber) ? (this.fReplacementNumber > 0.0 ? "inf" : "-inf") : Double.toString(this.fReplacementNumber);
        if (this.fEditor != null) {
            this.fEditor.setText(this.fLastText);
            this.fEditor.setCaretPosition(0);
        }
    }

    @Override
    Component getEditor() {
        if (this.fEditor == null) {
            this.fEditor = new MJTextField(Double.toString(this.fReplacementNumber));
            if (this.fEditor.getPreferredSize().width < 60) {
                this.fEditor.setPreferredSize(new Dimension(60, this.fEditor.getPreferredSize().height));
            }
            this.fEditor.setName("StringReplacementRule:fEditor");
            this.fEditor.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            this.fEditor.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    WorksheetReplacementRule.this.parseScalar();
                }
            });
            this.fEditor.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        WorksheetReplacementRule.this.parseScalar();
                    }
                }
            });
        }
        return this.fEditor;
    }

    @Override
    void addWorksheetRuleListener(WorksheetRuleListener worksheetRuleListener) {
        this.fWorksheetRuleListeners.remove(worksheetRuleListener);
        this.fWorksheetRuleListeners.add(worksheetRuleListener);
    }

    @Override
    void removeWorksheetRuleListener(WorksheetRuleListener worksheetRuleListener) {
        this.fWorksheetRuleListeners.remove(worksheetRuleListener);
    }

    protected void fireWorksheetRuleChanged() {
        ArrayList<WorksheetRule> arrayList = new ArrayList<WorksheetRule>();
        arrayList.add(this);
        for (WorksheetRuleListener worksheetRuleListener : this.fWorksheetRuleListeners) {
            worksheetRuleListener.ruleChanged(arrayList);
        }
    }

    public static Double getSingleReplacementValueFromRules(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        ArrayList<WorksheetRule> arrayList = new ArrayList<WorksheetRule>();
        for (Object object : objectArray) {
            arrayList.add((WorksheetRule)object);
        }
        return WorksheetReplacementRule.getSingleReplacementValueFromRules(arrayList);
    }

    public static Double getSingleReplacementValueFromRules(List<WorksheetRule> list) {
        if (list == null || list.size() != 1 || !(list.get(0) instanceof WorksheetReplacementRule)) {
            return null;
        }
        return ((WorksheetReplacementRule)list.get(0)).getReplacementNumber();
    }
}

