/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector;

import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.PropertyTableModel;
import com.jidesoft.grid.StyleModel;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import java.awt.Color;
import javax.swing.SwingUtilities;

class InspectorPropertyTableModel
extends PropertyTableModel
implements StyleModel,
PrefListener {
    private Color backgroundColor;
    private Color foregroundColor;
    private final CellStyle cellStyle = new CellStyle();

    InspectorPropertyTableModel() {
        this.backgroundColor = Prefs.getColorPref((String)"BackgroundColor", (Color)Color.WHITE);
        this.foregroundColor = Prefs.getColorPref((String)"TextColor", (Color)Color.BLACK);
        ColorPrefs.addColorListener((String)"ColorsBackground", (PrefListener)this);
        ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)this);
    }

    public CellStyle getCellStyleAt(int n, int n2) {
        this.cellStyle.setBackground(this.backgroundColor);
        this.cellStyle.setForeground(this.foregroundColor);
        return this.cellStyle;
    }

    public boolean isCellStyleOn() {
        return true;
    }

    public void prefChanged(PrefEvent prefEvent) {
        if (prefEvent.getEventType() != 1) {
            return;
        }
        System.out.println(prefEvent.getPrefKey());
        String string = prefEvent.getPrefKey();
        if (string == "ColorsBackground") {
            final Color color = ColorPrefs.getBackgroundColor();
            System.out.println(color);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InspectorPropertyTableModel.this.backgroundColor = color;
                    InspectorPropertyTableModel.this.fireTableDataChanged();
                }
            });
            return;
        }
        if (string == "ColorsText") {
            final Color color = ColorPrefs.getTextColor();
            System.out.println(color);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InspectorPropertyTableModel.this.foregroundColor = color;
                    InspectorPropertyTableModel.this.fireTableDataChanged();
                }
            });
        }
    }
}

