/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.bean.UDDListener;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.mlwidgets.inspector.AbstractTreeTableNode;
import com.mathworks.mlwidgets.inspector.IPropertyTreeTableNode;
import com.mathworks.mlwidgets.inspector.PropertyCell;
import com.mathworks.mlwidgets.inspector.PropertyRootNode;
import com.mathworks.mlwidgets.inspector.PropertyView;
import com.mathworks.mwswing.MJPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class PropertyItemNode
extends AbstractTreeTableNode {
    private PropertyCell fCell;
    private boolean fHasChildren;
    private List<PropertyItemNode> fChildrenList = null;
    private int fColumn;
    private String fGroupName;
    protected Vector<UDDListener> fUDDListeners;
    protected final Map<String, PropertyItemNode> fPropertyHash = new HashMap<String, PropertyItemNode>();
    protected JTable view;
    protected static Object sSceneViewerListener;

    public PropertyItemNode() {
    }

    public PropertyItemNode(int n, PropertyCell propertyCell, boolean bl) {
        this.fCell = propertyCell;
        this.fCell.setItemNode(this);
        this.fHasChildren = bl;
        this.fColumn = n;
        this.view = (JTable)propertyCell.getTreeTableView();
        this.fTarget = propertyCell.fTarget;
    }

    public void registerDestroyListeners(UDDObject[] uDDObjectArray) {
        for (UDDObject uDDObject : uDDObjectArray) {
            ChildDestroyListener childDestroyListener = PropertyItemNode.createChildDestroyListener(this.fCell, uDDObject, uDDObject);
            this.fUDDListeners.add(childDestroyListener);
        }
    }

    public void registerPropertyChangeListeners(UDDObject[] uDDObjectArray, Vector<UDDObject> vector) {
        if (Matlab.isMatlabAvailable() && vector != null && !vector.isEmpty()) {
            UDDObject[] uDDObjectArray2 = vector.toArray(new UDDObject[1]);
            for (UDDObject uDDObject : uDDObjectArray) {
                if (!PropertyView.isAutoUpdate()) continue;
                this.fUDDListeners.add(new PropertyListener(this, uDDObject, uDDObjectArray2, "PropertyPostSet"));
            }
        }
    }

    public Map<PropertyItemNode, Object> getPropertyUpdateMap(UDDObject[] uDDObjectArray) {
        HashMap<PropertyItemNode, Object> hashMap = new HashMap<PropertyItemNode, Object>();
        for (String string : this.fPropertyHash.keySet()) {
            if (uDDObjectArray != null) {
                if (uDDObjectArray.length == 1) {
                    hashMap.put(this.fPropertyHash.get(string), uDDObjectArray[0].getPropertyValue(string));
                    continue;
                }
                hashMap.put(this.fPropertyHash.get(string), this.getTarget().getMultiValue(string));
                continue;
            }
            hashMap.put(this.fPropertyHash.get(string), this.getTarget().getMultiValue(string).getValue());
        }
        return hashMap;
    }

    public void registerPropertyListeners(UDDObject[] uDDObjectArray, Vector<UDDObject> vector) {
        if (this.fUDDListeners == null) {
            this.fUDDListeners = new Vector();
        }
        this.registerDestroyListeners(uDDObjectArray);
        this.registerPropertyChangeListeners(uDDObjectArray, vector);
    }

    public static ChildDestroyListener createChildDestroyListener(PropertyCell propertyCell, UDDObject uDDObject, UDDObject uDDObject2) {
        return new ChildDestroyListener(propertyCell, uDDObject, uDDObject2, "ObjectBeingDestroyed");
    }

    public void refresh() {
    }

    @Override
    public PropertyCell getPropertyCell() {
        return this.fCell;
    }

    @Override
    public JComponent getRendererComponent() {
        if (this.fCell != null) {
            MJPanel mJPanel = this.fCell.getRendererComponent();
            if (mJPanel != null) {
                mJPanel.setName(this.fCell.getName());
            }
            return mJPanel;
        }
        return null;
    }

    @Override
    public JComponent getEditorComponent() {
        if (this.fCell != null) {
            MJPanel mJPanel = this.fCell.getEditorComponent();
            if (mJPanel != null) {
                mJPanel.setName(this.fCell.getName());
            }
            return mJPanel;
        }
        return null;
    }

    @Override
    public boolean isLeaf() {
        return !this.fHasChildren;
    }

    void setGroupName(String string) {
        this.fGroupName = string;
    }

    String getGroupName() {
        return this.fGroupName;
    }

    public synchronized void expand() {
        this.loadChildrenMatlabThread();
    }

    public static boolean isBeingDeleted(Object object) {
        try {
            boolean[] blArray = (boolean[])Matlab.mtFeval((String)"isobject", (Object[])new Object[]{object}, (int)1);
            if (blArray.length == 1 && blArray[0]) {
                boolean[] blArray2 = (boolean[])Matlab.mtFeval((String)"matlab.graphics.internal.SceneViewerListener.isBeingDeleted", (Object[])new Object[]{object}, (int)1);
                return blArray2[0];
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void addUDDListener(Object[] objectArray, String string) {
        Vector<UDDObject> vector = new Vector<UDDObject>();
        UDDObject[] uDDObjectArray = PropertyItemNode.castObjectToUDDArray(objectArray);
        if (uDDObjectArray != null) {
            for (int i = 0; i < uDDObjectArray.length; ++i) {
                UDDObject uDDObject;
                if (uDDObjectArray[i] == null || !(uDDObject = uDDObjectArray[i].findProperty(string)).isValid()) continue;
                vector.add(uDDObjectArray[i].findProperty(string));
            }
            this.registerPropertyListeners(uDDObjectArray, vector);
        }
    }

    protected Object getCachedAbstractTreeTableModelFromPropName(String string) {
        return this.fPropertyHash.get(string);
    }

    protected static UDDObject[] castObjectToUDDArray(Object[] objectArray) {
        ArrayList<UDDObject> arrayList = new ArrayList<UDDObject>();
        for (Object object : objectArray) {
            UDDObject uDDObject;
            if (!(object instanceof UDDObject) || !(uDDObject = (UDDObject)object).isValid()) continue;
            arrayList.add(uDDObject);
        }
        Object[] objectArray2 = arrayList.toArray(new UDDObject[0]);
        return objectArray2;
    }

    protected void updateProperty_AnyThread(final PropertyItemNode propertyItemNode, final Object object) {
        final PropertyCell propertyCell = propertyItemNode.getPropertyCell();
        if (object != null) {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    PropertyItemNode.this.updateProperty_MATLABThread(propertyCell, propertyItemNode, object);
                }
            });
        }
    }

    private void updateProperty_MATLABThread(final PropertyCell propertyCell, PropertyItemNode propertyItemNode, Object object) {
        if (propertyItemNode.getTarget() != null) {
            propertyItemNode.getTarget().setPropertyValue(propertyItemNode, object);
            if (propertyCell.getChildTarget() != null) {
                propertyCell.getChildTarget().pullInPropertyValuesFromMatlab_MatlabThread();
            }
        }
        final IPropertyTreeTableNode[] iPropertyTreeTableNodeArray = propertyItemNode.getChildren();
        if (Matlab.isMatlabAvailable()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    propertyCell.updateComponent_EventThread();
                    for (int i = 0; iPropertyTreeTableNodeArray != null && i < iPropertyTreeTableNodeArray.length; ++i) {
                        iPropertyTreeTableNodeArray[i].getPropertyCell().updateComponent_EventThread();
                    }
                    TableModel tableModel = PropertyItemNode.this.view.getModel();
                    assert (tableModel instanceof AbstractTableModel);
                    ((AbstractTableModel)tableModel).fireTableDataChanged();
                }
            });
        }
    }

    public void removeChildrenMatlabThread() {
        assert (NativeMatlab.nativeIsMatlabThread());
        this.setQueriedChildren(true);
        this.fPropertyHash.clear();
        if (this.fHasChildren && this.fChildrenList != null) {
            this.fChildrenList.clear();
            this.setChildren(null);
        }
    }

    @Override
    public synchronized void loadChildrenMatlabThread() {
        assert (NativeMatlab.nativeIsMatlabThread());
        this.setQueriedChildren(true);
        this.fPropertyHash.clear();
        if (this.fHasChildren && this.fChildrenList == null) {
            this.fChildrenList = new ArrayList<PropertyItemNode>();
            Vector vector = this.fCell.expand(this.fColumn);
            for (PropertyCell propertyCell : vector) {
                if (propertyCell == null) continue;
                PropertyItemNode propertyItemNode = new PropertyItemNode(this.fColumn + 1, propertyCell, propertyCell.hasChildren());
                this.fPropertyHash.put(propertyCell.getName(), propertyItemNode);
                this.fChildrenList.add(propertyItemNode);
                this.addUDDListener(propertyCell.fTarget.getObjects(), propertyCell.getName());
            }
            this.setChildren(PropertyItemNode.castToAbstractTreeTableNode(this.fChildrenList.toArray()));
        }
    }

    @Override
    public String getName() {
        return this.fCell.getName();
    }

    public String toString() {
        return this.getName();
    }

    public static void setSceneViewerListener(Object object) {
        sSceneViewerListener = object;
    }

    public void updateProperties(PropertyItemNode[] propertyItemNodeArray, Object[] objectArray) {
        for (int i = 0; i < propertyItemNodeArray.length; ++i) {
            this.updateProperty_AnyThread(propertyItemNodeArray[i], objectArray[i]);
        }
    }

    public static class PropertyListener
    extends UDDListener {
        Timer fTimer;
        private boolean fDoIgnoreEvents = false;
        protected Vector<PropertyItemNode> fUpdateNodes = new Vector();
        private Map<PropertyItemNode, Object> fNewPropertyValueHash = new HashMap<PropertyItemNode, Object>();
        protected PropertyItemNode fPropertyItemNode;

        public void setDoIgnoreEvents(boolean bl) {
            this.fDoIgnoreEvents = bl;
        }

        public boolean getDoIgnoreEvents() {
            return this.fDoIgnoreEvents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void timerCallback() {
            Vector<PropertyItemNode> vector = this.fUpdateNodes;
            synchronized (vector) {
                Enumeration<PropertyItemNode> enumeration = this.fUpdateNodes.elements();
                ArrayList<PropertyItemNode> arrayList = new ArrayList<PropertyItemNode>();
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                while (enumeration.hasMoreElements()) {
                    PropertyItemNode propertyItemNode = enumeration.nextElement();
                    arrayList.add(propertyItemNode);
                    arrayList2.add(this.fNewPropertyValueHash.get(propertyItemNode));
                }
                if (!arrayList.isEmpty()) {
                    this.fPropertyItemNode.updateProperties(arrayList.toArray(new PropertyItemNode[1]), arrayList2.toArray(new Object[1]));
                }
                this.fUpdateNodes.clear();
                this.fNewPropertyValueHash.clear();
            }
        }

        public PropertyListener(PropertyItemNode propertyItemNode, UDDObject uDDObject, UDDObject[] uDDObjectArray, String string) {
            super(uDDObject, uDDObjectArray, string);
            this.fPropertyItemNode = propertyItemNode;
            int n = 250;
            this.fTimer = new Timer(n, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PropertyListener.this.timerCallback();
                }
            });
            this.fTimer.setCoalesce(true);
            this.fTimer.setRepeats(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void execute(UDDObject uDDObject, UDDObject uDDObject2) {
            if (uDDObject == null) return;
            Object object = uDDObject2.getPropertyValue("AffectedObject");
            if (sSceneViewerListener != null) {
                if (PropertyItemNode.isBeingDeleted(object)) return;
                UDDObject[] uDDObjectArray = PropertyItemNode.castObjectToUDDArray(new Object[]{object});
                this.fNewPropertyValueHash = this.fPropertyItemNode.getPropertyUpdateMap(uDDObjectArray);
                this.fUpdateNodes = new Vector();
                this.fUpdateNodes.addAll(this.fNewPropertyValueHash.keySet());
            } else {
                Object object2 = null;
                String string = (String)uDDObject.getPropertyValue("Name");
                if (object instanceof UDDObject) {
                    UDDObject uDDObject3 = (UDDObject)object;
                    object2 = uDDObject3.getPropertyValue(string);
                }
                if (object2 == null) return;
                Object object3 = this.fPropertyItemNode.getCachedAbstractTreeTableModelFromPropName(string);
                if (object3 instanceof PropertyItemNode) {
                    PropertyItemNode propertyItemNode = (PropertyItemNode)object3;
                    Vector<PropertyItemNode> vector = this.fUpdateNodes;
                    synchronized (vector) {
                        this.fUpdateNodes.add(propertyItemNode);
                        this.fNewPropertyValueHash.put(propertyItemNode, object2);
                    }
                }
            }
            if (PropertyRootNode.isTestingMode()) {
                this.timerCallback();
                return;
            } else {
                if (this.fTimer.isRunning()) return;
                this.fTimer.start();
                this.setDoIgnoreEvents(false);
            }
        }
    }

    public static class ChildDestroyListener
    extends UDDListener {
        protected PropertyCell iPropertyCell;

        protected ChildDestroyListener(PropertyCell propertyCell, UDDObject uDDObject, UDDObject uDDObject2, String string) {
            super(uDDObject, uDDObject2, string);
            this.iPropertyCell = propertyCell;
        }

        public void execute(UDDObject uDDObject, UDDObject uDDObject2) {
            this.iPropertyCell.removeAllChildren();
        }
    }
}

