/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector;

import com.mathworks.beans.editors.DynamicBeanInfo;
import com.mathworks.beans.editors.EditorManager;
import com.mathworks.beans.editors.MWPropertyEditorUtils;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlwidgets.inspector.IPropertyTreeTableNode;
import com.mathworks.mlwidgets.inspector.JidePropertyViewTable;
import com.mathworks.mlwidgets.inspector.MultiValue;
import com.mathworks.mlwidgets.inspector.NamedEditor;
import com.mathworks.mlwidgets.inspector.PropertyItemNode;
import com.mathworks.mlwidgets.inspector.PropertyRootNode;
import com.mathworks.mlwidgets.inspector.PropertyView;
import com.mathworks.mlwidgets.util.GrayBoxTestingListenerGroup;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.util.DebugUtils;
import com.mathworks.util.Log;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import com.mathworks.widgets.spreadsheet.format.Formatter;
import java.awt.Component;
import java.awt.Frame;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class PropertyTarget
implements PropertyChangeListener {
    private static ResourceBundle sBundle = ResourceBundle.getBundle("com.mathworks.mlwidgets.inspector.resources.RES_PropView");
    public Object[] fObjects;
    private PropertyTarget fParent;
    private String fPropertyName;
    private JTable fTreeTable;
    private ObjectRegistry fRegistry;
    private Hashtable fProperties;
    private PropertyDescriptor[] fMergedProperties;
    public NamedEditor[] fEditors;
    private int fEnumCounter;
    private boolean fShowHidden;
    private int fIndex;
    private static final int NO_INDEX = -1;
    private IPropertyTreeTableNode fNode;
    public static final String NULL_VALUE = "null";
    Formatter fFormat;

    JTable getTableView() {
        return this.fTreeTable;
    }

    final void setNode(IPropertyTreeTableNode iPropertyTreeTableNode) {
        this.fNode = iPropertyTreeTableNode;
    }

    final IPropertyTreeTableNode getNode() {
        return this.fNode;
    }

    PropertyTarget(Object[] objectArray, JTable jTable, ObjectRegistry objectRegistry, PropertyTarget propertyTarget, String string, boolean bl, int n) {
        this.fObjects = objectArray;
        this.fTreeTable = jTable;
        this.fEnumCounter = 0;
        this.fParent = propertyTarget;
        this.fPropertyName = string;
        this.fShowHidden = bl;
        this.fIndex = n;
        this.fRegistry = objectRegistry;
        assert (this.fRegistry != null);
        this.buildPropertyList();
    }

    PropertyTarget(Object[] objectArray, JTable jTable, ObjectRegistry objectRegistry, PropertyTarget propertyTarget, String string, boolean bl) {
        this(objectArray, jTable, objectRegistry, propertyTarget, string, bl, -1);
    }

    public PropertyTarget(Object[] objectArray, JTable jTable, ObjectRegistry objectRegistry, boolean bl) {
        this(objectArray, jTable, objectRegistry, null, null, bl, -1);
    }

    private ObjectRegistry getRegistry() {
        return this.fRegistry;
    }

    protected void buildPropertyList() {
        if (this.fObjects != null) {
            this.fProperties = new Hashtable();
            for (int i = 0; i < this.fObjects.length; ++i) {
                if (this.fObjects[i] != null) {
                    Class<?> clazz = this.fObjects[i].getClass();
                    if (this.fProperties.containsKey(clazz.getName())) continue;
                    this.fProperties.put(clazz.getName(), this.getProperties(this.fObjects[i]));
                    continue;
                }
                if (this.fProperties.containsKey(NULL_VALUE)) continue;
                this.fProperties.put(NULL_VALUE, new PropertyDescriptor[0]);
            }
            if (!this.fProperties.isEmpty()) {
                Enumeration enumeration = this.fProperties.elements();
                this.fMergedProperties = (PropertyDescriptor[])enumeration.nextElement();
                while (enumeration.hasMoreElements()) {
                    PropertyDescriptor[] propertyDescriptorArray = (PropertyDescriptor[])enumeration.nextElement();
                    this.fMergedProperties = this.mergeProperties(this.fMergedProperties, propertyDescriptorArray);
                }
                if (this.fProperties.containsKey(NULL_VALUE)) {
                    this.fProperties.remove(NULL_VALUE);
                }
                if (this.fObjects.length > 1) {
                    this.fMergedProperties = this.removeDynamicProperties(this.fMergedProperties);
                }
                this.fMergedProperties = this.filterProperties(this.fMergedProperties);
                this.fMergedProperties = this.removeNoInspectProperties(this.fMergedProperties);
                this.fMergedProperties = this.removeUngettableProperties(this.fMergedProperties);
                this.fEditors = new NamedEditor[this.fMergedProperties.length];
                for (int i = 0; i < this.fMergedProperties.length; ++i) {
                    Method method = this.fMergedProperties[i].getReadMethod();
                    Method method2 = this.fMergedProperties[i].getWriteMethod();
                    if (method != null) {
                        PropertyEditor propertyEditor = this.getEditor(this.fMergedProperties[i]);
                        this.fEditors[i] = new NamedEditor(this.fMergedProperties[i].getDisplayName(), propertyEditor, method2 != null);
                        continue;
                    }
                    this.fEditors[i] = null;
                }
            }
            if (Matlab.isMatlabAvailable()) {
                this.pullInPropertyValuesFromMatlab_ThreadSafe();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullInPropertyValuesFromMatlab_ThreadSafe() {
        if (!NativeMatlab.nativeIsMatlabThread()) {
            Runner runner;
            Runner runner2 = runner = new Runner();
            synchronized (runner2) {
                Matlab.whenMatlabIdle((Runnable)runner);
                while (!runner.isDone) {
                    try {
                        runner.wait();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            this.pullInPropertyValuesFromMatlab_MatlabThread();
        }
    }

    public void setPropertyValue(PropertyEditor propertyEditor, Object object) {
        if (propertyEditor != null) {
            propertyEditor.removePropertyChangeListener(this);
            try {
                propertyEditor.setValue(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            propertyEditor.addPropertyChangeListener(this);
        }
    }

    public void setPropertyValue(PropertyItemNode propertyItemNode, Object object) {
        if (propertyItemNode.getPropertyCell().getEditor() != null) {
            propertyItemNode.getPropertyCell().getEditor().removePropertyChangeListener(this);
            if (this.fObjects != null && this.fObjects.length > 1 && this.fMergedProperties != null) {
                for (int i = 0; i < this.fMergedProperties.length; ++i) {
                    if (!this.fMergedProperties[i].getName().equals(propertyItemNode.getPropertyCell().getName())) continue;
                    this.updateMergedPropAt(i);
                }
            } else {
                try {
                    propertyItemNode.getPropertyCell().getEditor().setValue(object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            propertyItemNode.getPropertyCell().getEditor().addPropertyChangeListener(this);
        }
    }

    void pullInPropertyValuesFromMatlab_MatlabThread() {
        Object[] objectArray;
        assert (NativeMatlab.nativeIsMatlabThread());
        if (this.fParent != null && this.fPropertyName != null && (objectArray = this.fIndex != -1 ? this.fParent.getValuesAsArray(this.fPropertyName, this.fIndex) : this.fParent.getValuesAsArray(this.fPropertyName)).length == this.fObjects.length) {
            this.fObjects = objectArray;
        }
        if (this.fMergedProperties != null) {
            for (int i = 0; i < this.fMergedProperties.length; ++i) {
                PropertyEditor propertyEditor;
                if (this.fEditors == null || this.fEditors[i] == null || (propertyEditor = this.fEditors[i].getEditor()) == null) continue;
                propertyEditor.removePropertyChangeListener(this);
                try {
                    this.updateMergedPropAt(i);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                propertyEditor.addPropertyChangeListener(this);
            }
        }
    }

    private void updateMergedPropAt(int n) {
        PropertyEditor propertyEditor = this.fEditors[n].getEditor();
        MultiValue multiValue = this.getMultiValue(this.fMergedProperties[n].getDisplayName());
        propertyEditor.setValue(multiValue.getValue());
        GrayBoxTestingListenerGroup.fireGrayBoxTestingEvent(PropertyTarget.class, "PropertyTarget:updateMergedPropAt", this.fMergedProperties[n].getDisplayName(), multiValue.getValue());
        this.fEditors[n].setMixed(multiValue.isMixed());
    }

    private PropertyDescriptor[] getProperties(Object object) {
        Class<?> clazz = null;
        BeanInfo beanInfo = null;
        PropertyDescriptor[] propertyDescriptorArray = new PropertyDescriptor[]{};
        try {
            if (object instanceof DynamicBeanInfo) {
                DynamicBeanInfo dynamicBeanInfo = (DynamicBeanInfo)object;
                propertyDescriptorArray = dynamicBeanInfo.getDynamicPropertyDescriptors();
                this.filterHGProperties(object.getClass(), propertyDescriptorArray);
            } else {
                if (object != null) {
                    clazz = object.getClass();
                }
                if (clazz != null) {
                    beanInfo = Introspector.getBeanInfo(clazz);
                }
                if (beanInfo != null) {
                    propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                    this.filterHGProperties(clazz, propertyDescriptorArray);
                }
            }
            if (propertyDescriptorArray != null) {
                this.sortProperties(propertyDescriptorArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return propertyDescriptorArray;
    }

    private void filterHGProperties(Class clazz, PropertyDescriptor[] propertyDescriptorArray) {
        if (UDDObject.class.isAssignableFrom(clazz)) {
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                Class<?> clazz2;
                block4: {
                    if (!PropertyTarget.isUIContextMenuPropertyDescriptor(propertyDescriptorArray[i])) continue;
                    clazz2 = null;
                    try {
                        clazz2 = Class.forName("com.mathworks.hg.types.ContextMenuPropertyEditor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if ($assertionsDisabled || DebugUtils.outputException((Throwable)classNotFoundException)) break block4;
                        throw new AssertionError();
                    }
                }
                if (clazz2 == null) continue;
                propertyDescriptorArray[i].setPropertyEditorClass(clazz2);
            }
        }
    }

    private static boolean isUIContextMenuPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getName().equals("UIContextMenu") && (propertyDescriptor.getPropertyType().getName().equals("com.mathworks.hg.types.HGHandle") || propertyDescriptor.getPropertyType().getName().equals("com.mathworks.jmi.bean.UDDObject"));
    }

    private static Object filterHGPropertyValue(PropertyDescriptor propertyDescriptor, Object object) {
        if (!PropertyTarget.isUIContextMenuPropertyDescriptor(propertyDescriptor) && object == null) {
            return new MLArrayRef();
        }
        return object;
    }

    private String sortKey(PropertyDescriptor propertyDescriptor) {
        String string = (String)propertyDescriptor.getValue("BeanUtils.SortKey");
        if (string == null) {
            string = propertyDescriptor.getDisplayName().toLowerCase();
        }
        return string;
    }

    private int compare(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
        return this.sortKey(propertyDescriptor).compareTo(this.sortKey(propertyDescriptor2));
    }

    private void sortProperties(PropertyDescriptor[] propertyDescriptorArray) {
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            int n = i;
            for (int j = i + 1; j < propertyDescriptorArray.length; ++j) {
                if (this.compare(propertyDescriptorArray[j], propertyDescriptorArray[n]) >= 0) continue;
                n = j;
            }
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n];
            propertyDescriptorArray[n] = propertyDescriptorArray[i];
            propertyDescriptorArray[i] = propertyDescriptor;
        }
    }

    private boolean propertiesMatch(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
        String string = propertyDescriptor.getDisplayName().toLowerCase();
        String string2 = propertyDescriptor2.getDisplayName().toLowerCase();
        String string3 = "unknown";
        PropertyEditor propertyEditor = this.getEditor(propertyDescriptor);
        PropertyEditor propertyEditor2 = this.getEditor(propertyDescriptor2);
        String string4 = NULL_VALUE;
        String string5 = NULL_VALUE;
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (propertyDescriptor.getPropertyType() != null) {
            string3 = propertyDescriptor.getPropertyType().getName();
        }
        if (propertyEditor != null) {
            string4 = propertyEditor.getClass().getName();
            stringArray = propertyEditor.getTags();
        }
        if (propertyEditor2 != null) {
            string5 = propertyEditor2.getClass().getName();
            stringArray2 = propertyEditor2.getTags();
        }
        boolean bl = true;
        if (propertyEditor == null || propertyEditor2 == null) {
            bl = false;
        } else if (!string4.equals(string5)) {
            bl = false;
        } else if (stringArray == null ^ stringArray2 == null) {
            bl = false;
        } else if (stringArray != null && stringArray2 != null) {
            if (stringArray.length != stringArray2.length) {
                bl = false;
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals(stringArray2[i])) continue;
                    bl = false;
                    break;
                }
            }
        }
        return string.equals(string2) && string3.equals(string3) && bl;
    }

    protected PropertyDescriptor[] removeUngettableProperties(PropertyDescriptor[] propertyDescriptorArray) {
        if (this.fObjects == null || this.fObjects.length == 0 || propertyDescriptorArray == null || propertyDescriptorArray.length == 0) {
            return propertyDescriptorArray;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            for (Object object : this.fObjects) {
                boolean[] object2 = (boolean[])Matlab.mtFeval((String)"ishghandle", (Object[])new Object[]{object}, (int)1);
                if (!object2[0] || !(object instanceof UDDObject)) continue;
                arrayList.add(object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (arrayList.isEmpty()) {
            return propertyDescriptorArray;
        }
        ArrayList arrayList2 = new ArrayList();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
            try {
                for (Object e : arrayList) {
                    ((UDDObject)e).getPropertyValue(propertyDescriptor.getName());
                }
                arrayList2.add(propertyDescriptor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList2.toArray(new PropertyDescriptor[1]);
    }

    PropertyDescriptor[] removeDynamicProperties(PropertyDescriptor[] propertyDescriptorArray) {
        if (propertyDescriptorArray != null) {
            Vector<PropertyDescriptor> vector = new Vector<PropertyDescriptor>(propertyDescriptorArray.length);
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                Class<?> clazz = propertyDescriptorArray[i].getPropertyType();
                if (clazz == null || DynamicBeanInfo.class.isAssignableFrom(clazz)) continue;
                vector.addElement(propertyDescriptorArray[i]);
            }
            Object[] objectArray = new PropertyDescriptor[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return propertyDescriptorArray;
    }

    PropertyDescriptor[] filterProperties(PropertyDescriptor[] propertyDescriptorArray) {
        return propertyDescriptorArray;
    }

    PropertyDescriptor[] removeNoInspectProperties(PropertyDescriptor[] propertyDescriptorArray) {
        ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
            boolean bl;
            boolean bl2;
            boolean bl3 = bl2 = propertyDescriptor.getValue("BeanUtils.NoInspectKey") == null;
            if (!bl2) continue;
            boolean bl4 = bl = propertyDescriptor.isHidden() && !this.fShowHidden;
            if (bl) continue;
            arrayList.add(propertyDescriptor);
        }
        PropertyDescriptor[] propertyDescriptorArray2 = arrayList.toArray(new PropertyDescriptor[0]);
        return propertyDescriptorArray2;
    }

    private PropertyDescriptor[] mergeProperties(PropertyDescriptor[] propertyDescriptorArray, PropertyDescriptor[] propertyDescriptorArray2) {
        PropertyDescriptor[] propertyDescriptorArray3 = new PropertyDescriptor[Math.min(propertyDescriptorArray.length, propertyDescriptorArray2.length)];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n < propertyDescriptorArray.length && n2 < propertyDescriptorArray2.length) {
            String string = propertyDescriptorArray[n].getDisplayName().toLowerCase();
            String string2 = propertyDescriptorArray[n].getDisplayName().toLowerCase();
            if (this.propertiesMatch(propertyDescriptorArray[n], propertyDescriptorArray2[n2])) {
                propertyDescriptorArray3[n3++] = propertyDescriptorArray[n];
                ++n;
                ++n2;
                continue;
            }
            if (string.compareTo(string2) < 0) {
                ++n;
                continue;
            }
            if (n >= propertyDescriptorArray.length || ++n2 < propertyDescriptorArray2.length) continue;
            ++n;
            n2 = 0;
        }
        PropertyDescriptor[] propertyDescriptorArray4 = new PropertyDescriptor[n3];
        if (n3 > 0) {
            System.arraycopy(propertyDescriptorArray3, 0, propertyDescriptorArray4, 0, n3);
        }
        return propertyDescriptorArray4;
    }

    private PropertyEditor getEditor(PropertyDescriptor propertyDescriptor) {
        PropertyEditor propertyEditor = null;
        if (propertyDescriptor != null) {
            PropertyEditor propertyEditor2;
            Class<?> clazz = propertyDescriptor.getPropertyType();
            Class<?> clazz2 = propertyDescriptor.getPropertyEditorClass();
            if (clazz2 != null) {
                try {
                    propertyEditor = (PropertyEditor)clazz2.newInstance();
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
            if (propertyEditor == null && clazz != null) {
                propertyEditor = PropertyEditorManager.findEditor(clazz);
            }
            Object object = this.fObjects[0];
            if (this.fObjects[0] instanceof UDDObject) {
                object = ((UDDObject)this.fObjects[0]).getClassName();
            }
            if ((propertyEditor2 = EditorManager.getCustomEditor((Object)object, (PropertyDescriptor)propertyDescriptor, (PropertyEditor)propertyEditor)) != null) {
                propertyEditor = propertyEditor2;
            }
            if (propertyEditor != null) {
                if (this.fObjects != null && this.fObjects.length > 0) {
                    MWPropertyEditorUtils.setEditObject((PropertyEditor)propertyEditor, (Object[])this.fObjects);
                }
                MWPropertyEditorUtils.setFrame((PropertyEditor)propertyEditor, (Frame)this.getParentFrame(this.fTreeTable));
                if (MWPropertyEditorUtils.hasAttachedData((PropertyEditor)propertyEditor)) {
                    String string = MWPropertyEditorUtils.getDataKey((PropertyEditor)propertyEditor);
                    MWPropertyEditorUtils.setData((PropertyEditor)propertyEditor, (Object)propertyDescriptor.getValue(string));
                }
                propertyEditor.addPropertyChangeListener(this);
            }
        }
        return propertyEditor;
    }

    private Frame getParentFrame(Component component) {
        Component component2;
        for (component2 = component; component2 != null && !(component2 instanceof Frame); component2 = component2.getParent()) {
        }
        if (component2 instanceof Frame) {
            return (Frame)component2;
        }
        return null;
    }

    protected PropertyDescriptor getDescriptor(Class clazz, String string) {
        String string2 = string.toLowerCase();
        PropertyDescriptor propertyDescriptor = null;
        String string3 = clazz.getName();
        PropertyDescriptor[] propertyDescriptorArray = (PropertyDescriptor[])this.fProperties.get(string3);
        if (propertyDescriptorArray != null) {
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (!propertyDescriptorArray[i].getDisplayName().toLowerCase().equals(string2)) continue;
                propertyDescriptor = propertyDescriptorArray[i];
                break;
            }
        }
        return propertyDescriptor;
    }

    protected Object getPropertyValue(Object object, PropertyDescriptor propertyDescriptor) {
        Object object2 = null;
        Method method = propertyDescriptor.getReadMethod();
        Object[] objectArray = new Object[]{};
        if (method != null) {
            try {
                object2 = method.invoke(object, objectArray);
                if (this.fIndex != -1) {
                    Object[] objectArray2 = (Object[])object2;
                    object2 = objectArray2[this.fIndex];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object2;
    }

    private void cleanNumericData(Object object) {
        if (object instanceof double[]) {
            double[] dArray = (double[])object;
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.cleanDouble(dArray[i]);
            }
        }
    }

    private double cleanDouble(double d) {
        if (this.fFormat == null) {
            this.fFormat = FormatIdentifier.LONG.getEditorIdentifier().getFormatter();
        }
        String string = this.fFormat.format((Number)new Double(d));
        return Double.parseDouble(string);
    }

    MultiValue getMultiValue(String string) {
        Object object = null;
        boolean bl = false;
        if (this.fObjects != null && this.fObjects.length > 0) {
            PropertyDescriptor propertyDescriptor = this.getDescriptor(this.fObjects[0].getClass(), string);
            object = this.getPropertyValue(this.fObjects[0], propertyDescriptor);
            this.cleanNumericData(object);
            for (int i = 1; i < this.fObjects.length; ++i) {
                Object object2 = this.getPropertyValue(this.fObjects[i], this.getDescriptor(this.fObjects[i].getClass(), string));
                if (object == null) {
                    if (object2 == null) continue;
                    bl = true;
                    break;
                }
                if (object2 == null) {
                    object = null;
                    bl = true;
                    break;
                }
                if (this.fObjects[0] instanceof UDDObject && this.fObjects[i] instanceof UDDObject) {
                    try {
                        boolean[] blArray = (boolean[])Matlab.mtFeval((String)"internal.matlab.inspector.Utils.compare", (Object[])new Object[]{this.fObjects[0], this.fObjects[i], string}, (int)1);
                        if (blArray[0]) continue;
                        object = null;
                        bl = true;
                        break;
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                        continue;
                    }
                }
                if (object2 != null && object2.equals(object)) continue;
                object = null;
                bl = true;
                break;
            }
        }
        return new MultiValue(object, bl);
    }

    String getPropertyName() {
        return this.fPropertyName;
    }

    void updateValues() {
    }

    private Object[] getValuesAsArray(String string) {
        return this.getValuesAsArray(string, -1);
    }

    PropertyTarget getValues_MatlabThread(String string) {
        PropertyTarget propertyTarget = null;
        assert (NativeMatlab.nativeIsMatlabThread());
        if (this.fObjects != null && this.fObjects[0] != null) {
            propertyTarget = new PropertyTarget(this.getValuesAsArray(string), this.fTreeTable, this.getRegistry(), this, string, this.fShowHidden);
        }
        return propertyTarget;
    }

    private Object[] getValuesAsArray(String string, int n) {
        Object[] objectArray = new Object[]{};
        Object[] objectArray2 = new Object[]{};
        Object[] objectArray3 = JidePropertyViewTable.filterOutInvalidObjects(this.fObjects);
        if (objectArray3 != null && objectArray3.length > 0 && objectArray3[0] != null) {
            PropertyEditor propertyEditor;
            objectArray = new Object[objectArray3.length];
            PropertyDescriptor propertyDescriptor = this.getDescriptor(objectArray3[0].getClass(), string);
            if (propertyDescriptor != null && (propertyEditor = this.getEditor(propertyDescriptor)) != null) {
                propertyEditor.removePropertyChangeListener(this);
                for (int i = 0; i < objectArray3.length; ++i) {
                    propertyDescriptor = this.getDescriptor(objectArray3[i].getClass(), string);
                    Method method = propertyDescriptor.getReadMethod();
                    try {
                        objectArray[i] = method.invoke(objectArray3[i], objectArray2);
                        if (n != -1) {
                            Object[] objectArray4 = (Object[])objectArray[i];
                            objectArray[i] = objectArray4[n];
                        }
                    }
                    catch (Exception exception) {
                        objectArray[i] = null;
                    }
                    if (!MWPropertyEditorUtils.canExpand((PropertyEditor)propertyEditor)) continue;
                    try {
                        propertyEditor.setValue(objectArray[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    objectArray[i] = MWPropertyEditorUtils.getIntrospectableValue((PropertyEditor)propertyEditor);
                }
            }
        }
        return objectArray;
    }

    PropertyTarget getValues_MatlabThread(String string, int n) {
        PropertyTarget propertyTarget = null;
        assert (NativeMatlab.nativeIsMatlabThread());
        if (this.fObjects != null && this.fObjects[0] != null) {
            propertyTarget = new PropertyTarget(this.getValuesAsArray(string, n), this.fTreeTable, this.getRegistry(), this, string, this.fShowHidden, n);
            propertyTarget.setNode(this.fNode);
        }
        return propertyTarget;
    }

    public Object[] getObjects() {
        return this.fObjects;
    }

    int getPropertyCount() {
        return this.fEditors.length;
    }

    int getIndexCount(String string) {
        Object[] objectArray = this.getValuesAsArray(string);
        if (objectArray == null || objectArray[0] == null) {
            return 0;
        }
        return ((Object[])objectArray[0]).length;
    }

    void setFilter(Object object) {
    }

    void resetEnumeration() {
        this.fEnumCounter = 0;
    }

    NamedEditor nextProperty() {
        if (this.fEditors != null) {
            return this.fEditors[this.fEnumCounter++];
        }
        return null;
    }

    boolean hasMoreProperties() {
        if (this.fEditors != null) {
            return this.fEnumCounter < this.fEditors.length;
        }
        return false;
    }

    public int getIndex() {
        return this.fIndex;
    }

    public void setIndex(int n) {
        this.fIndex = n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        Method method = null;
        if (object instanceof PropertyEditor) {
            int n;
            PropertyEditor propertyEditor = (PropertyEditor)object;
            for (n = 0; n < this.fEditors.length && (this.fEditors[n] == null || propertyEditor != this.fEditors[n].getEditor()); ++n) {
            }
            if (n >= this.fEditors.length) {
                return;
            }
            if (propertyEditor == this.fEditors[n].getEditor()) {
                void clazz;
                HashSet hashSet = new HashSet();
                Object hashMap = this.fObjects;
                int n2 = ((Object[])hashMap).length;
                boolean bl = false;
                while (clazz < n2) {
                    Object objectArray5 = hashMap[clazz];
                    hashSet.add(objectArray5.getClass());
                    ++clazz;
                }
                hashMap = new HashMap();
                for (Class clazz2 : hashSet) {
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    for (int i = 0; i < this.fObjects.length; ++i) {
                        if (clazz2 != this.fObjects[i].getClass()) continue;
                        arrayList.add(i);
                    }
                    hashMap.put(clazz2, arrayList.toArray(new Object[arrayList.size()]));
                }
                for (Class propertyEditor2 : hashSet) {
                    PropertyDescriptor propertyDescriptor = this.getDescriptor(propertyEditor2, this.fEditors[n].getName());
                    method = propertyDescriptor.getWriteMethod();
                    if (method == null) continue;
                    Object[] objectArray = new Object[]{PropertyTarget.filterHGPropertyValue(propertyDescriptor, propertyEditor.getValue())};
                    Object[] objectArray2 = (Object[])hashMap.get(propertyEditor2);
                    Object[] objectArray3 = new Object[objectArray2.length];
                    for (int i = 0; i < objectArray3.length; ++i) {
                        objectArray3[i] = this.fObjects[(Integer)objectArray2[i]];
                    }
                    this.invokeSetter(method, objectArray3, objectArray, new PostPropertyChange(this.fParent, this.fTreeTable, objectArray3, this, hashMap.get(propertyEditor2)));
                }
            }
        } else if (object instanceof PropertyTarget) {
            int n;
            PropertyTarget propertyTarget = (PropertyTarget)object;
            String string = propertyTarget.getPropertyName();
            Object object2 = propertyChangeEvent.getPropagationId();
            for (n = 0; !(n >= this.fEditors.length || this.fEditors[n] != null && this.fEditors[n].getName().equals(string)); ++n) {
            }
            if (n < this.fEditors.length && propertyTarget.getIndex() == -1) {
                Object[] objectArray = propertyTarget.getObjects();
                if (objectArray.length == this.fObjects.length) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object3;
                        if (i != (Integer)object2) continue;
                        PropertyEditor propertyEditor = this.fEditors[n].getEditor();
                        if (MWPropertyEditorUtils.canExpand((PropertyEditor)propertyEditor)) {
                            propertyEditor.removePropertyChangeListener(this);
                            MWPropertyEditorUtils.setIntrospectableValue((PropertyEditor)propertyEditor, (Object)objectArray[i]);
                            object3 = propertyEditor.getValue();
                            propertyEditor.addPropertyChangeListener(this);
                        } else {
                            object3 = objectArray[i];
                        }
                        PropertyDescriptor propertyDescriptor = this.getDescriptor(this.fObjects[i].getClass(), this.fEditors[n].getName());
                        method = propertyDescriptor.getWriteMethod();
                        if (method == null) continue;
                        Object[] objectArray4 = new Object[]{object3};
                        this.invokeSetter(method, this.fObjects[i], objectArray4, new PostPropertyChange(this.fParent, this.fTreeTable, new Object[]{this.fObjects[i]}, this, object2));
                    }
                } else {
                    System.out.println("value & object arrays not of same length");
                }
            }
        }
    }

    protected void invokeSetter(Method method, final Object object, Object[] objectArray, PostPropertyChange postPropertyChange) {
        final Method method2 = method;
        final Object[] objectArray2 = objectArray;
        Matlab.whenMatlabIdle((Runnable)new Runnable(){

            @Override
            public void run() {
                PropertyTarget.invokePropertySet(PropertyTarget.this.fNode, object, method2, objectArray2, PropertyTarget.this.fTreeTable);
            }
        });
        Matlab.whenMatlabIdle((Runnable)postPropertyChange);
    }

    public static void invokePropertySet(IPropertyTreeTableNode iPropertyTreeTableNode, Object object, Method method, Object[] objectArray, final Component component) {
        try {
            if (object instanceof Object[]) {
                Object[] objectArray2 = (Object[])object;
                if (iPropertyTreeTableNode instanceof PropertyRootNode && objectArray2.length > 1) {
                    ((PropertyRootNode)iPropertyTreeTableNode).setUDDListenersEnabled(false);
                }
                for (Object object2 : objectArray2) {
                    method.invoke(object2, objectArray);
                }
                if (iPropertyTreeTableNode instanceof PropertyRootNode && objectArray2.length > 1) {
                    ((PropertyRootNode)iPropertyTreeTableNode).setUDDListenersEnabled(true);
                }
            } else {
                method.invoke(object, objectArray);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    MJOptionPane.showMessageDialog((Component)component, (Object)invocationTargetException.getTargetException().getLocalizedMessage(), (String)sBundle.getString("frame.title"), (int)0);
                }
            };
            if (NativeMatlab.nativeIsMatlabThread()) {
                SwingUtilities.invokeLater(runnable);
            } else {
                runnable.run();
            }
        }
        catch (Exception exception) {
            Log.log((String)exception.toString());
        }
    }

    void removePropertyListeners() {
        if (this.fEditors == null) {
            return;
        }
        for (NamedEditor namedEditor : this.fEditors) {
            namedEditor.getEditor().removePropertyChangeListener(this);
        }
        this.fEditors = null;
    }

    private class PostChangeRedraw
    implements Runnable {
        private final Vector fRedraws;

        private PostChangeRedraw(Vector vector) {
            this.fRedraws = vector;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.fRedraws.size(); ++i) {
                Component component = (Component)this.fRedraws.elementAt(i);
                component.repaint(5L);
            }
            if (PropertyTarget.this.fTreeTable != null) {
                PropertyTarget.this.fTreeTable.repaint(5L);
            }
        }
    }

    protected class PostPropertyChange
    implements Runnable {
        private final PropertyTarget fParent;
        private final JComponent fView;
        private final Object[] fObjects;
        private final PropertyTarget fTarget;
        private final Object fPropagationId;

        private PostPropertyChange(PropertyTarget propertyTarget2, JComponent jComponent, Object[] objectArray, PropertyTarget propertyTarget3, Object object) {
            this.fParent = propertyTarget2;
            this.fView = jComponent;
            this.fObjects = objectArray;
            this.fTarget = propertyTarget3;
            this.fPropagationId = object;
        }

        @Override
        public void run() {
            Object object;
            if (PropertyView.DEBUG) {
                MLExecuteServices.consoleEval((String)"disp('PropertyTarget.PostPropertyChange.run')");
                System.out.println("PropertyTarget.PostPropertyChange.run");
            }
            ObjectRegistry objectRegistry = PropertyTarget.this.getRegistry();
            if (this.fParent == null && objectRegistry != null) {
                objectRegistry.change(this.fObjects, (Object)this.fTarget);
            }
            if (this.fParent != null) {
                if (this.fPropagationId instanceof Object[]) {
                    for (Object object2 : (Object[])this.fPropagationId) {
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.fTarget, null, null, null);
                        propertyChangeEvent.setPropagationId(object2);
                        this.fParent.propertyChange(propertyChangeEvent);
                    }
                } else {
                    object = new PropertyChangeEvent(this.fTarget, null, null, null);
                    ((PropertyChangeEvent)object).setPropagationId(this.fPropagationId);
                    this.fParent.propertyChange((PropertyChangeEvent)object);
                }
            }
            if (NativeMatlab.nativeIsMatlabThread() && this.fTarget.getNode() != null) {
                this.fTarget.getNode().refreshChildren_MatlabThread();
            }
            if (this.fObjects != null) {
                object = new Vector();
                for (int i = 0; i < this.fObjects.length; ++i) {
                    Object object3 = null;
                    try {
                        object3 = PropertyTarget.this.getRegistry().getParent(this.fObjects[i]);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    if (!(object3 instanceof Component) || ((Vector)object).contains(object3)) continue;
                    ((Vector)object).addElement(object3);
                }
                SwingUtilities.invokeLater(new PostChangeRedraw((Vector)object));
            }
        }
    }

    private class Runner
    implements Runnable {
        public boolean isDone = false;

        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PropertyTarget.this.pullInPropertyValuesFromMatlab_MatlabThread();
            this.isDone = true;
            Runner runner = this;
            synchronized (runner) {
                this.notifyAll();
            }
        }
    }
}

