/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector.colorarrayeditor;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.swing.JideButton;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.inspector.Resources;
import com.mathworks.mlwidgets.inspector.colorarrayeditor.ColorArrayEditorTestFrame;
import com.mathworks.mlwidgets.inspector.colorarrayeditor.ColorArrayTable;
import com.mathworks.mlwidgets.inspector.colorarrayeditor.ColorArrayTableModel;
import com.mathworks.mlwidgets.inspector.guiutils.FaderFactory;
import com.mathworks.mlwidgets.inspector.guiutils.IFader;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.util.EmptyIcon;
import com.mathworks.widgets.util.GUIUtils;
import com.mathworks.widgets.util.Gbc;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public final class ColorArrayEditorDialog
extends JDialog {
    private final List<Color> dataModel;
    private final Action helpAction;
    private final JTable colorsTable;
    private final AbstractTableModel colorsTableModel;
    private int result = 2;
    private JButton okButton;
    private final ListSelectionListener tableSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            assert (listSelectionModel != null);
            int n = ColorArrayEditorDialog.this.colorsTable.getSelectedRowCount();
            if (!listSelectionModel.isSelectionEmpty() && n < ColorArrayEditorDialog.this.dataModel.size()) {
                if (!ColorArrayEditorDialog.this.removeColorAction.isEnabled()) {
                    ColorArrayEditorDialog.this.removeColorAction.setEnabled(true);
                }
            } else {
                ColorArrayEditorDialog.this.removeColorAction.setEnabled(false);
            }
            if (ColorArrayEditorDialog.this.colorsTable.getSelectionModel().getMinSelectionIndex() > 0 && n == 1) {
                ColorArrayEditorDialog.this.upAction.setEnabled(true);
            } else {
                ColorArrayEditorDialog.this.upAction.setEnabled(false);
            }
            if (ColorArrayEditorDialog.this.colorsTable.getSelectionModel().getMinSelectionIndex() != ColorArrayEditorDialog.this.dataModel.size() - 1 && n == 1) {
                ColorArrayEditorDialog.this.downAction.setEnabled(true);
            } else {
                ColorArrayEditorDialog.this.downAction.setEnabled(false);
            }
        }
    };
    private final WindowListener winListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            ColorArrayEditorDialog.this.result = -1;
            ColorArrayEditorDialog.this.customDispose();
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            ColorArrayEditorDialog.this.okButton.requestFocusInWindow();
        }
    };
    private final Action okAction = new AbstractAction(){
        private final String okString = GUIUtils.getStandardDialogString((GUIUtils.DialogStringType)GUIUtils.DialogStringType.OK_BUTTON);
        {
            this.putValue("Name", this.okString);
            this.putValue("ShortDescription", this.okString);
            this.putValue("SmallIcon", IconsFactory.getImageIcon(Resources.class, (String)"resources/check2_16x16.png"));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ColorArrayEditorDialog.this.commitCurrentEdit()) {
                return;
            }
            ColorArrayEditorDialog.this.result = 0;
            ColorArrayEditorDialog.this.customDispose();
        }
    };
    private final Action cancelAction = new AbstractAction(){
        private final String cancelString = GUIUtils.getStandardDialogString((GUIUtils.DialogStringType)GUIUtils.DialogStringType.CANCEL_BUTTON);
        {
            this.putValue("Name", this.cancelString);
            this.putValue("ShortDescription", this.cancelString);
            this.putValue("SmallIcon", new EmptyIcon(16, 16));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColorArrayEditorDialog.this.result = 2;
            ColorArrayEditorDialog.this.customDispose();
        }
    };
    private final Action addColorAction = new AbstractAction(){
        {
            this.putValue("Name", Resources.getBundle().getString("coloreditordialog.button.addcolor.name"));
            this.putValue("ShortDescription", Resources.getBundle().getString("coloreditordialog.button.addcolor.name"));
            this.putValue("SmallIcon", IconsFactory.getImageIcon(Resources.class, (String)"resources/add16x16.png"));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ColorArrayEditorDialog.this.commitCurrentEdit()) {
                return;
            }
            ColorArrayEditorDialog.this.dataModel.add(Color.BLACK);
            ColorArrayEditorDialog.this.colorsTableModel.fireTableRowsInserted(ColorArrayEditorDialog.this.dataModel.size() - 1, ColorArrayEditorDialog.this.dataModel.size() - 1);
            ColorArrayEditorDialog.this.colorsTable.getSelectionModel().setSelectionInterval(ColorArrayEditorDialog.this.dataModel.size() - 1, ColorArrayEditorDialog.this.dataModel.size() - 1);
        }
    };
    private final Action removeColorAction = new AbstractAction(){
        {
            this.putValue("Name", Resources.getBundle().getString("coloreditordialog.button.removecolor.name"));
            this.putValue("ShortDescription", Resources.getBundle().getString("coloreditordialog.button.removecolor.shortdescription"));
            this.putValue("SmallIcon", IconsFactory.getImageIcon(Resources.class, (String)"resources/delete16x16.png"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (!ColorArrayEditorDialog.this.commitCurrentEdit()) {
                return;
            }
            int n2 = ColorArrayEditorDialog.this.colorsTable.getSelectionModel().getMinSelectionIndex();
            int n3 = ColorArrayEditorDialog.this.colorsTable.getSelectionModel().getMaxSelectionIndex();
            int[] nArray = ColorArrayEditorDialog.this.colorsTable.getSelectedRows();
            assert (nArray.length > 0) : "Empty selection";
            assert (nArray.length < ColorArrayEditorDialog.this.dataModel.size()) : "Removing all colors is not allowed";
            Arrays.sort(nArray);
            for (n = nArray.length - 1; n >= 0; --n) {
                int n4 = nArray[n];
                ColorArrayEditorDialog.this.dataModel.remove(n4);
            }
            assert (!ColorArrayEditorDialog.this.dataModel.isEmpty());
            ColorArrayEditorDialog.this.colorsTableModel.fireTableRowsDeleted(n2, n3);
            n = n2 < ColorArrayEditorDialog.this.dataModel.size() ? n2 : ColorArrayEditorDialog.this.dataModel.size() - 1;
            ColorArrayEditorDialog.this.colorsTable.getSelectionModel().setSelectionInterval(n, n);
        }
    };
    private final Action upAction = new AbstractAction(){
        {
            this.putValue("Name", Resources.getBundle().getString("coloreditordialog.button.moveup.name"));
            this.putValue("ShortDescription", Resources.getBundle().getString("coloreditordialog.button.moveup.shortdescription"));
            this.putValue("SmallIcon", IconsFactory.getImageIcon(Resources.class, (String)"resources/arrow_up_green16x16.png"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ColorArrayEditorDialog.this.commitCurrentEdit()) {
                return;
            }
            int n = ColorArrayEditorDialog.this.colorsTable.getSelectionModel().getMinSelectionIndex();
            assert (n != -1);
            assert (n < ColorArrayEditorDialog.this.dataModel.size()) : "Selected index=" + n;
            if (n > 0) {
                int n2 = n;
                int n3 = n2 - 1;
                Collections.swap(ColorArrayEditorDialog.this.dataModel, n2, n3);
                ColorArrayEditorDialog.this.colorsTableModel.fireTableRowsUpdated(n2, n3);
                ColorArrayEditorDialog.this.colorsTable.getSelectionModel().setSelectionInterval(n3, n3);
            }
        }
    };
    private final Action downAction = new AbstractAction(){
        {
            this.putValue("Name", Resources.getBundle().getString("coloreditordialog.button.movedown.name"));
            this.putValue("ShortDescription", Resources.getBundle().getString("coloreditordialog.button.movedown.shortdescription"));
            this.putValue("SmallIcon", IconsFactory.getImageIcon(Resources.class, (String)"resources/arrow_down_green16x16.png"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ColorArrayEditorDialog.this.commitCurrentEdit()) {
                return;
            }
            int n = ColorArrayEditorDialog.this.colorsTable.getSelectionModel().getMinSelectionIndex();
            assert (n != -1);
            assert (n < ColorArrayEditorDialog.this.dataModel.size()) : "Selected index=" + n;
            if (n <= ColorArrayEditorDialog.this.dataModel.size() - 2) {
                int n2 = n;
                int n3 = n2 + 1;
                Collections.swap(ColorArrayEditorDialog.this.dataModel, n2, n3);
                ColorArrayEditorDialog.this.colorsTableModel.fireTableRowsUpdated(n2, n3);
                ColorArrayEditorDialog.this.colorsTable.getSelectionModel().setSelectionInterval(n3, n3);
            }
        }
    };

    public static ColorArrayEditorDialog newInstance(Frame frame, String string, Dialog.ModalityType modalityType, Action action, List<Color> list) {
        assert (SwingUtilities.isEventDispatchThread());
        if (modalityType == null) {
            throw new IllegalArgumentException("Argument modalityType must not be null");
        }
        ColorArrayEditorDialog colorArrayEditorDialog = null;
        colorArrayEditorDialog = Toolkit.getDefaultToolkit().isModalityTypeSupported(modalityType) ? new ColorArrayEditorDialog(frame, string, modalityType, action, list) : new ColorArrayEditorDialog(frame, string, Dialog.ModalityType.APPLICATION_MODAL, action, list);
        colorArrayEditorDialog.colorsTable.getSelectionModel().addListSelectionListener(colorArrayEditorDialog.tableSelectionListener);
        return colorArrayEditorDialog;
    }

    private ColorArrayEditorDialog(Frame frame, String string, Dialog.ModalityType modalityType, Action action, List<Color> list) {
        super((Window)frame, string, modalityType);
        if (list == null) {
            throw new IllegalArgumentException("Data model must not be null.");
        }
        this.dataModel = list;
        this.helpAction = action;
        this.colorsTableModel = new ColorArrayTableModel(list);
        this.colorsTable = new ColorArrayTable(this.colorsTableModel);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = this.createColorArrayPanel();
        jPanel.add((Component)jPanel2, "Center");
        this.getContentPane().add(jPanel);
        this.setResizable(true);
        this.addWindowListener(this.winListener);
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(new Dimension(300, 310));
        this.installKeyBindings();
        this.getRootPane().setDefaultButton(this.okButton);
        this.setName("colorarrayeditor.dialog");
    }

    public int getResult() {
        return this.result;
    }

    private void customDispose() {
        IFader iFader = FaderFactory.newOutFader(this, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorArrayEditorDialog.this.dispose();
            }
        });
        iFader.start();
    }

    private boolean commitCurrentEdit() {
        if (this.colorsTable.isEditing()) {
            boolean bl = this.colorsTable.getCellEditor().stopCellEditing();
            return bl;
        }
        return true;
    }

    private void installKeyBindings() {
        KeyStroke keyStroke;
        String string;
        ActionMap actionMap = this.getRootPane().getActionMap();
        InputMap inputMap = this.getRootPane().getInputMap(1);
        String string2 = "ColorArrayEditorDialog.key.escape";
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(27, 0);
        inputMap.put(keyStroke2, string2);
        actionMap.put(string2, this.cancelAction);
        if (this.helpAction != null) {
            string = "ColorArrayEditorDialog.key.f1";
            keyStroke = KeyStroke.getKeyStroke(112, 0);
            inputMap.put(keyStroke, string);
            actionMap.put(string, this.helpAction);
        }
        string = "ColorArrayEditorDialog.key.del";
        keyStroke = KeyStroke.getKeyStroke(127, 0);
        inputMap.put(keyStroke, string);
        actionMap.put(string, this.removeColorAction);
        String string3 = "ColorArrayEditorDialog.key.ins";
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(155, 0);
        inputMap.put(keyStroke3, string3);
        actionMap.put(string3, this.addColorAction);
    }

    private JPanel createColorArrayPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = this.helpAction != null ? 7 : 6;
        Insets insets = new Insets(5, 10, 5, 10);
        JScrollPane jScrollPane = new JScrollPane(this.colorsTable);
        this.colorsTable.setTableHeader(null);
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.add((Component)jScrollPane, new Gbc(0, 0, 1, n + 1).setFill(1).setWeight(100.0, 100.0));
        this.okButton = this.createButton(this.okAction);
        this.okButton.setName("colorarrayeditor.ok");
        JButton jButton = this.createButton(this.cancelAction);
        jButton.setName("colorarrayeditor.cancel");
        JButton jButton2 = this.createButton(this.addColorAction);
        jButton2.setName("colorarrayeditor.addcolor");
        JButton jButton3 = this.createButton(this.removeColorAction);
        jButton3.setName("colorarrayeditor.removecolor");
        JButton jButton4 = this.createButton(this.upAction);
        jButton4.setName("colorarrayeditor.moveup");
        JButton jButton5 = this.createButton(this.downAction);
        jButton5.setName("colorarrayeditor.movedown");
        jPanel.add((Component)this.okButton, new Gbc(1, 0).setFill(2).setInsets(new Insets(15, insets.left, insets.bottom, insets.right)));
        Insets insets2 = new Insets(insets.top, insets.left, 30, insets.right);
        if (this.helpAction != null) {
            jPanel.add((Component)jButton, new Gbc(1, -1).setFill(2).setInsets(insets));
            JButton jButton6 = this.createButton(this.helpAction);
            jPanel.add((Component)jButton6, new Gbc(1, -1).setFill(2).setInsets(insets2));
        } else {
            jPanel.add((Component)jButton, new Gbc(1, -1).setFill(2).setInsets(insets2));
        }
        jPanel.add((Component)jButton2, new Gbc(1, -1).setFill(2).setInsets(insets));
        jPanel.add((Component)jButton3, new Gbc(1, -1).setFill(2).setInsets(insets));
        jPanel.add((Component)jButton4, new Gbc(1, -1).setFill(2).setInsets(insets));
        jPanel.add((Component)jButton5, new Gbc(1, -1).setFill(2).setInsets(insets));
        return jPanel;
    }

    private JButton createButton(Action action) {
        JideButton jideButton = new JideButton();
        jideButton.setButtonStyle(1);
        jideButton.setHorizontalAlignment(2);
        jideButton.setAction(action);
        return jideButton;
    }

    public static void main(String[] stringArray) {
        ColorArrayEditorDialog.doShow(null);
    }

    public static void showInMatlab() {
        Desktop desktop = MatlabDesktopServices.getDesktop();
        assert (desktop != null);
        ColorArrayEditorDialog.doShow((JFrame)desktop.getMainFrame());
    }

    private static void doShow(final JFrame jFrame) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColorArrayEditorDialog.setLookAndFeel();
                ColorArrayEditorTestFrame colorArrayEditorTestFrame = new ColorArrayEditorTestFrame(jFrame);
                colorArrayEditorTestFrame.setSize(300, 400);
                if (jFrame != null) {
                    colorArrayEditorTestFrame.setLocationRelativeTo(jFrame);
                    colorArrayEditorTestFrame.setDefaultCloseOperation(2);
                } else {
                    colorArrayEditorTestFrame.setDefaultCloseOperation(3);
                }
                colorArrayEditorTestFrame.setVisible(true);
            }
        });
    }

    private static void setLookAndFeel() {
        MJUtilities.initJIDE();
        try {
            UIManager.setLookAndFeel(WindowsLookAndFeel.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        LookAndFeelFactory.installJideExtension((int)0);
    }
}

