/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.path;

import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.path.PathModel;
import com.mathworks.mlwidgets.path.PathUtils;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJHelpButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontListener;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.FileUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.recordlist.IRecordlistListener;
import com.mathworks.widgets.recordlist.IRecordlistModel;
import com.mathworks.widgets.recordlist.RecordlistList;
import com.mathworks.widgets.recordlist.RecordlistModelEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PathBrowser
implements IRecordlistListener {
    private static PathBrowser sThis;
    private PathModel fPathModel = null;
    private MJButton fToTop;
    private MJButton fUp;
    private MJButton fDown;
    private MJButton fToBottom;
    private MJButton fRemove;
    private MJButton fSave;
    private MJButton fRevert;
    private JMenuItem fToTopMenuItem;
    private JMenuItem fUpMenuItem;
    private JMenuItem fDownMenuItem;
    private JMenuItem fToBottomMenuItem;
    private JMenuItem fRemoveMenuItem;
    private volatile boolean fAddRecursive;
    private static boolean sShowConfirmations;
    private MJFrame fFrame;
    private PathList fPathList;
    private PathBrowserActionListener fActionListener;
    private PathBrowserPrefsListener fPrefsListener;
    private PathBrowserFontListener fFontListener;
    private WindowListener fWindowListener;
    private ListSelectionListener fListSelectionListener;
    private PopupListener fPopupListener;
    private static final String PATHBROWSER_WINDOWBOUNDS = "PathBrowserBounds";
    private static ResourceBundle fRes;

    static PathBrowser getPathBrowser() {
        PathBrowser pathBrowser;
        if (sThis != null) {
            PathBrowser.getFrame().toFront();
            pathBrowser = sThis;
        } else {
            pathBrowser = new PathBrowser();
        }
        return pathBrowser;
    }

    private PathBrowser() {
        sThis = this;
        this.fFrame = new MJFrame(fRes.getString("pathbrowser.title"));
        this.fFrame.setDefaultCloseOperation(0);
        this.fFrame.setName("Path Browser");
        this.fFrame.getAccessibleContext().setAccessibleName(fRes.getString("pathbrowser.title"));
        WindowUtils.setSizeInDlus((Window)this.fFrame, (int)400, (int)300);
        WindowUtils.centerWindowOnScreen((Window)this.fFrame);
        Desktop desktop = MatlabDesktopServices.getDesktop();
        WindowUtils.setChildLocationWithinParent(desktop != null && desktop.hasMainFrame() ? desktop.getMainFrame() : null, (Window)this.fFrame);
        Rectangle rectangle = Prefs.getRectanglePref((String)PATHBROWSER_WINDOWBOUNDS, (Rectangle)this.fFrame.getBounds());
        this.fFrame.setBounds(rectangle);
        WindowUtils.ensureOnScreen((Window)this.fFrame);
        this.fWindowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PathBrowser.this.closePathBrowser();
            }
        };
        this.fFrame.addWindowListener(this.fWindowListener);
        this.fActionListener = new PathBrowserActionListener();
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new FlowLayout(0));
        MJLabel mJLabel = new MJLabel(fRes.getString("label.immediate"));
        mJLabel.setName("ImmediateLabel");
        mJLabel.getAccessibleContext().setAccessibleName(fRes.getString("label.immediate"));
        mJPanel.add((Component)mJLabel);
        MJButton mJButton = new MJButton(fRes.getString("button.add"));
        mJButton.setEnabled(true);
        mJButton.addActionListener((ActionListener)this.fActionListener);
        mJButton.setActionCommand("Add");
        mJButton.setName("Add");
        mJButton.getAccessibleContext().setAccessibleName(fRes.getString("button.add"));
        MJButton mJButton2 = new MJButton(fRes.getString("button.addsubs"));
        mJButton2.setEnabled(true);
        mJButton2.addActionListener((ActionListener)this.fActionListener);
        mJButton2.setActionCommand("AddSubs");
        mJButton2.setName("AddSubs");
        mJButton2.getAccessibleContext().setAccessibleName(fRes.getString("button.addsubs"));
        ButtonStackBuilder buttonStackBuilder = new ButtonStackBuilder();
        buttonStackBuilder.getPanel().setBorder(Borders.DLU7_BORDER);
        buttonStackBuilder.addButtons(new JButton[]{mJButton, mJButton2});
        buttonStackBuilder.addGlue();
        this.fToTop = this.createActionButton("button.top", "Top", false);
        this.fUp = this.createActionButton("button.up", "Up", false);
        this.fDown = this.createActionButton("button.down", "Down", false);
        this.fToBottom = this.createActionButton("button.bottom", "Bottom", false);
        buttonStackBuilder.addButtons(new JButton[]{this.fToTop, this.fUp, this.fDown, this.fToBottom});
        buttonStackBuilder.addGlue();
        this.fRemove = new MJButton();
        buttonStackBuilder.addGridded((JComponent)this.fRemove);
        this.fSave = this.createActionButton("button.save", "Save", true);
        MJButton mJButton3 = this.createActionButton("button.close", "Close", true);
        this.fRevert = this.createActionButton("button.revert", "Revert", false);
        MJButton mJButton4 = this.createActionButton("button.default", "Default", true);
        MJHelpButton mJHelpButton = new MJHelpButton();
        mJHelpButton.setActionCommand("Help");
        mJHelpButton.addActionListener((ActionListener)this.fActionListener);
        JPanel jPanel = PlatformInfo.isMacintosh() ? ButtonBarFactory.buildHelpBar((JButton)mJHelpButton, (JButton)mJButton4, (JButton)this.fRevert, (JButton)mJButton3, (JButton)this.fSave) : ButtonBarFactory.buildRightAlignedBar((JButton)this.fSave, (JButton)mJButton3, (JButton)this.fRevert, (JButton)mJButton4, (JButton)mJHelpButton);
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout());
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel2.add((Component)buttonStackBuilder.getPanel());
        mJPanel3.add((Component)mJPanel2, (Object)"Center");
        MJPanel mJPanel4 = new MJPanel();
        mJPanel4.setLayout((LayoutManager)new BoxLayout((Container)mJPanel4, 1));
        this.fPathModel = new PathModel();
        this.fPathModel.setShowConfirm(sShowConfirmations);
        this.fPathList = new PathList(this.fPathModel);
        this.fPathList.setName("Path RecordlistList");
        this.fPathList.getAccessibleContext().setAccessibleName(fRes.getString("label.list"));
        MJScrollPane mJScrollPane = new MJScrollPane((Component)((Object)this.fPathList));
        mJPanel4.add((Component)mJScrollPane);
        mJPanel4.setBorder((Border)BorderFactory.createTitledBorder(Borders.DLU4_BORDER, fRes.getString("label.list")));
        this.fRemove.setAction((Action)this.fPathList.getAction(20));
        this.fRemove.setText(fRes.getString("button.remove"));
        this.fRemove.setToolTipText(null);
        this.fRemove.setEnabled(false);
        this.fRemove.setName("Remove");
        this.fRemove.getAccessibleContext().setAccessibleName(fRes.getString("button.remove"));
        MJPanel mJPanel5 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel5.setBorder(Borders.DIALOG_BORDER);
        mJPanel5.add((Component)mJPanel, (Object)"North");
        mJPanel5.add((Component)mJPanel3, (Object)"West");
        mJPanel5.add((Component)mJPanel4, (Object)"Center");
        mJPanel5.add((Component)jPanel, (Object)"South");
        this.fFrame.setContentPane((Container)mJPanel5);
        this.fPrefsListener = new PathBrowserPrefsListener();
        Prefs.addListener((PrefListener)this.fPrefsListener, (String)"UseDesktopFont");
        this.fFontListener = new PathBrowserFontListener();
        String string = ResourceBundle.getBundle("com.mathworks.mde.desk.resources.RES_Desktop").getString("title.CurrentDirectory");
        FontPrefs.addFontListener((String)string, (FontListener)this.fFontListener);
        this.setPathBrowserFont(FontPrefs.getFontForComponent((String)string));
        ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)this.fPrefsListener);
        ColorPrefs.addColorListener((String)"ColorsBackground", (PrefListener)this.fPrefsListener);
        this.setPathBrowserColors();
        this.pathBrowserListPopupMenu();
        this.fListSelectionListener = new PathBrowserListSelectionListener();
        this.fPathList.addListSelectionListener(this.fListSelectionListener);
        this.fPathList.setSelectedIndex(0);
        this.fPathModel.addRecordlistListener(this);
        this.fPathModel.addActionListener(new PathBrowserActionListener());
        this.fFrame.setVisible(true);
    }

    private MJButton createActionButton(String string, String string2, boolean bl) {
        MJButton mJButton = new MJButton(fRes.getString(string));
        mJButton.addActionListener((ActionListener)this.fActionListener);
        mJButton.setActionCommand(string2);
        mJButton.setEnabled(bl);
        mJButton.setName(string2);
        mJButton.getAccessibleContext().setAccessibleName(fRes.getString(string));
        return mJButton;
    }

    public void recordlistChanged(RecordlistModelEvent recordlistModelEvent) {
        if (this.fPathModel != null) {
            this.fRevert.setEnabled(!this.fPathModel.isOriginalPath());
            this.setSaveButtonEnabled(true);
            this.setBusyCursor(false);
        }
    }

    private void pathBrowserListPopupMenu() {
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        this.fToTopMenuItem = new MJMenuItem(fRes.getString("button.top"));
        this.fToTopMenuItem.addActionListener(this.fActionListener);
        this.fToTopMenuItem.getAccessibleContext().setAccessibleName(fRes.getString("button.top"));
        this.fToTopMenuItem.setActionCommand("Top");
        this.fToTopMenuItem.setName("TopMenuItem");
        this.fUpMenuItem = new MJMenuItem(fRes.getString("button.up"));
        this.fUpMenuItem.addActionListener(this.fActionListener);
        this.fUpMenuItem.getAccessibleContext().setAccessibleName(fRes.getString("button.up"));
        this.fUpMenuItem.setActionCommand("Up");
        this.fUpMenuItem.setName("UpMenuItem");
        this.fDownMenuItem = new MJMenuItem(fRes.getString("button.down"));
        this.fDownMenuItem.addActionListener(this.fActionListener);
        this.fDownMenuItem.getAccessibleContext().setAccessibleName(fRes.getString("button.down"));
        this.fDownMenuItem.setActionCommand("Down");
        this.fDownMenuItem.setName("DownMenuItem");
        this.fToBottomMenuItem = new MJMenuItem(fRes.getString("button.bottom"));
        this.fToBottomMenuItem.addActionListener(this.fActionListener);
        this.fToBottomMenuItem.getAccessibleContext().setAccessibleName(fRes.getString("button.bottom"));
        this.fToBottomMenuItem.setActionCommand("Bottom");
        this.fToBottomMenuItem.setName("BottomMenuItem");
        this.fRemoveMenuItem = new MJMenuItem();
        this.fRemoveMenuItem.setAction((Action)this.fPathList.getAction(20));
        this.fRemoveMenuItem.getAccessibleContext().setAccessibleName(fRes.getString("button.remove"));
        this.fRemoveMenuItem.setText(fRes.getString("button.remove"));
        this.fRemoveMenuItem.setName("RemoveMenuItem");
        mJPopupMenu.add(this.fToTopMenuItem);
        mJPopupMenu.add(this.fUpMenuItem);
        mJPopupMenu.add(this.fDownMenuItem);
        mJPopupMenu.add(this.fToBottomMenuItem);
        mJPopupMenu.addSeparator();
        mJPopupMenu.add(this.fRemoveMenuItem);
        this.fPopupListener = new PopupListener((JPopupMenu)mJPopupMenu);
        this.fPathList.addMouseListener(this.fPopupListener);
    }

    private void setBusyCursor(boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new CursorHandler(bl));
        } else {
            Cursor cursor = bl ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor();
            this.fFrame.setCursor(cursor);
            this.fPathList.setCursor(cursor);
        }
    }

    private void setSaveButtonEnabled(boolean bl) {
        SwingUtilities.invokeLater(new SaveButtonSetter(bl));
    }

    private void addPath(String string) {
        this.setBusyCursor(true);
        String[] stringArray = new String[]{string};
        if (this.fAddRecursive) {
            this.fPathList.prependRecursively(stringArray);
        } else {
            this.fPathList.prepend(stringArray);
        }
    }

    private static int[] getPathSelectedIndices() {
        return PathBrowser.sThis.fPathList.getSelectedIndices();
    }

    static MJFrame getFrame() {
        return PathBrowser.sThis.fFrame;
    }

    private void setPathBrowserFont(Font font) {
        if (this.fPathList != null) {
            this.fPathList.setFont(font);
        }
    }

    private void setPathBrowserColors() {
        this.setPathBrowserBgColor();
        this.setPathBrowserFgColor();
    }

    private void setPathBrowserFgColor() {
        this.fPathList.setForeground(ColorPrefs.getTextColor());
    }

    private void setPathBrowserBgColor() {
        this.fPathList.setBackground(ColorPrefs.getBackgroundColor());
    }

    private void closePathBrowser() {
        int n;
        if (this.fSave.isEnabled() && !this.fPathModel.isOriginalPath() && sShowConfirmations && (n = MJOptionPane.showConfirmDialog((Component)this.fFrame, (Object)fRes.getString("dialog.save.message"), (String)fRes.getString("dialog.save.title"), (int)0, (int)-1)) == 0) {
            this.fPathList.save(new ClosingChangeListener());
            return;
        }
        this.reallyClose();
    }

    private static void setShowConfirmationDialogs(boolean bl) {
        sShowConfirmations = bl;
        if (sThis != null) {
            PathBrowser.sThis.fPathModel.setShowConfirm(bl);
        }
    }

    private static boolean getShowConfirmationDialogs() {
        return sShowConfirmations;
    }

    private void reallyClose() {
        Prefs.setRectanglePref((String)PATHBROWSER_WINDOWBOUNDS, (Rectangle)this.fFrame.getBounds());
        this.fPathModel.removeAllListeners();
        this.fFrame.removeWindowListener(this.fWindowListener);
        this.fWindowListener = null;
        FontPrefs.removeFontListener((String)"Current Directory", (FontListener)this.fFontListener);
        this.fFontListener = null;
        Prefs.removeListener((PrefListener)this.fPrefsListener, (String)"UseDesktopFont");
        ColorPrefs.removeColorListener((String)"ColorsText", (PrefListener)this.fPrefsListener);
        ColorPrefs.removeColorListener((String)"ColorsBackground", (PrefListener)this.fPrefsListener);
        this.fPrefsListener = null;
        this.fActionListener = null;
        this.fFrame.getContentPane().removeAll();
        this.fFrame.dispose();
        this.fFrame = null;
        this.fPathList.removeListSelectionListener(this.fListSelectionListener);
        this.fPathList.removeMouseListener(this.fPopupListener);
        this.fPopupListener.cleanup();
        this.fListSelectionListener = null;
        this.fPopupListener = null;
        this.fRemove.setAction(null);
        this.fRemoveMenuItem.setAction(null);
        this.fPathList = null;
        this.fPathModel = null;
        sThis = null;
    }

    static {
        sShowConfirmations = true;
        fRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.path.resources.RES_PathBrowser");
    }

    private class ClosingChangeListener
    implements ChangeListener {
        private ClosingChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            PathBrowser.this.reallyClose();
        }
    }

    private class PathBrowserPrefsListener
    implements PrefListener {
        private PathBrowserPrefsListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getPrefKey().equals("ColorsText")) {
                PathBrowser.this.setPathBrowserFgColor();
            } else if (prefEvent.getPrefKey().equals("ColorsBackground")) {
                PathBrowser.this.setPathBrowserBgColor();
            }
        }
    }

    private class PathBrowserFontListener
    implements FontListener {
        private PathBrowserFontListener() {
        }

        public void fontChanged(Font font) {
            PathBrowser.this.setPathBrowserFont(font);
        }
    }

    private class SaveButtonSetter
    implements Runnable {
        private boolean iEnableSave;

        SaveButtonSetter(boolean bl) {
            this.iEnableSave = bl;
        }

        @Override
        public void run() {
            PathBrowser.this.fSave.setEnabled(this.iEnableSave);
        }
    }

    private class CursorHandler
    implements Runnable {
        private boolean fBusy;

        CursorHandler(boolean bl) {
            this.fBusy = bl;
        }

        @Override
        public void run() {
            PathBrowser.this.setBusyCursor(this.fBusy);
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private JPopupMenu iPopup;

        PopupListener(JPopupMenu jPopupMenu) {
            this.iPopup = jPopupMenu;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                PathBrowser.this.fToTopMenuItem.setEnabled(!PathBrowser.this.fPathList.isSelectedIndex(0));
                PathBrowser.this.fUpMenuItem.setEnabled(!PathBrowser.this.fPathList.isSelectedIndex(0));
                PathBrowser.this.fDownMenuItem.setEnabled(!PathBrowser.this.fPathList.isSelectedIndex(PathBrowser.this.fPathList.getRecordCount() - 1));
                PathBrowser.this.fToBottomMenuItem.setEnabled(!PathBrowser.this.fPathList.isSelectedIndex(PathBrowser.this.fPathList.getRecordCount() - 1));
                this.iPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                mouseEvent.consume();
            } else if (mouseEvent.getModifiers() == 16 && this.iPopup.isShowing()) {
                this.iPopup.setVisible(false);
            }
        }

        void cleanup() {
            this.iPopup.removeAll();
            this.iPopup = null;
        }
    }

    private class PathBrowserListSelectionListener
    implements ListSelectionListener {
        private PathBrowserListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl = !PathBrowser.this.fPathList.isSelectionEmpty();
            PathBrowser.this.fRemove.setEnabled(bl);
            if (bl) {
                boolean bl2 = PathBrowser.this.fPathList.isSelectedIndex(0);
                PathBrowser.this.fToTop.setEnabled(!bl2);
                PathBrowser.this.fUp.setEnabled(!bl2);
                boolean bl3 = PathBrowser.this.fPathList.isSelectedIndex(PathBrowser.this.fPathList.getRecordCount() - 1);
                PathBrowser.this.fDown.setEnabled(!bl3);
                PathBrowser.this.fToBottom.setEnabled(!bl3);
            } else {
                PathBrowser.this.fToTop.setEnabled(false);
                PathBrowser.this.fUp.setEnabled(false);
                PathBrowser.this.fDown.setEnabled(false);
                PathBrowser.this.fToBottom.setEnabled(false);
            }
        }
    }

    private class PathBrowserActionListener
    implements ActionListener {
        private PathBrowserActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string == null) {
                return;
            }
            if (actionEvent.getSource() == PathBrowser.this.fPathModel) {
                if (string.equals("BUSY_CURSOR")) {
                    PathBrowser.this.setBusyCursor(true);
                } else if (string.equals("FREE_CURSOR")) {
                    PathBrowser.this.setBusyCursor(false);
                } else if (string.equals("DISABLE_SAVE")) {
                    PathBrowser.this.setSaveButtonEnabled(false);
                } else if (string.equals("CHANGE_NOTIFICATION_WARNING")) {
                    PathUtils.showChangeNotificationDialog((Frame)PathBrowser.this.fFrame, 2);
                } else if (string.equals("DELETED") && !PathBrowser.this.fPathList.getSelectionModel().isSelectionEmpty()) {
                    PathBrowser.this.fPathList.getSelectionModel().clearSelection();
                }
            } else if (string.equals("Add")) {
                this.showFolderChooser(fRes.getString("dialog.add.title"), false);
            } else if (string.equals("AddSubs")) {
                this.showFolderChooser(fRes.getString("dialog.addsubs.title"), true);
            } else if (string.equals("Top")) {
                PathBrowser.this.setBusyCursor(true);
                PathBrowser.this.fPathList.prependSelection();
            } else if (string.equals("Up")) {
                PathBrowser.this.setBusyCursor(true);
                PathBrowser.this.fPathList.promoteSelection();
            } else if (string.equals("Down")) {
                PathBrowser.this.setBusyCursor(true);
                PathBrowser.this.fPathList.demoteSelection();
            } else if (string.equals("Bottom")) {
                PathBrowser.this.setBusyCursor(true);
                PathBrowser.this.fPathList.appendSelection();
            } else if (string.equals("Save")) {
                PathBrowser.this.fPathList.save();
            } else if (string.equals("Close")) {
                PathBrowser.this.closePathBrowser();
            } else if (string.equals("Revert")) {
                PathBrowser.this.setBusyCursor(true);
                PathBrowser.this.fPathList.revertAllChanges();
            } else if (string.equals("Default")) {
                PathBrowser.this.setBusyCursor(true);
                PathBrowser.this.fPathList.restoreDefault();
            } else if (string.equals("Help")) {
                String string2 = MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env");
                MLHelpServices.displayTopic((String)string2, (String)"matlabenvironment_pathbrowser");
            } else if (string.indexOf(47) != -1 || string.indexOf(92) != -1 || string.indexOf(58) != -1) {
                PathBrowser.this.addPath(FileUtils.toJavaPath((String)string));
            }
        }

        public void showFolderChooser(String string, boolean bl) {
            File file;
            PathBrowser.this.fAddRecursive = bl;
            MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
            mJFileChooserPerPlatform.setDialogTitle(string);
            mJFileChooserPerPlatform.setFileSelectionMode(1);
            mJFileChooserPerPlatform.showOpenDialog((Component)PathBrowser.this.fFrame);
            if (mJFileChooserPerPlatform.getState() == 0 && (file = mJFileChooserPerPlatform.getSelectedFile()) != null) {
                PathBrowser.this.addPath(file.getAbsolutePath());
            }
        }
    }

    private static class PathList
    extends RecordlistList {
        private PathModel iPathModel;

        PathList(PathModel pathModel) {
            super((IRecordlistModel)pathModel);
            this.iPathModel = pathModel;
        }

        public void selectAll() {
        }

        private void prependSelection() {
            this.iPathModel.prepend(this.getSelectedDirs());
        }

        private void prepend(String[] stringArray) {
            this.prepSelectionTrackerForCreate();
            this.iPathModel.prepend(stringArray);
        }

        private void prependRecursively(String[] stringArray) {
            this.prepSelectionTrackerForCreate();
            this.iPathModel.prependRecursively(stringArray);
        }

        private void appendSelection() {
            this.iPathModel.append(this.getSelectedDirs());
        }

        private void promoteSelection() {
            this.iPathModel.promote(this.getSelectedIndices());
        }

        private void demoteSelection() {
            this.iPathModel.demote(this.getSelectedIndices());
        }

        private void revertAllChanges() {
            this.iPathModel.revertAllChanges();
        }

        private void save() {
            this.iPathModel.saveAs(null);
        }

        private void save(ChangeListener changeListener) {
            this.iPathModel.saveAs(null, changeListener);
        }

        private void restoreDefault() {
            this.iPathModel.restoreDefaultPath();
        }

        private String[] getSelectedDirs() {
            Object[] objectArray = this.getSelectedValues();
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = (String)objectArray[i];
            }
            return stringArray;
        }
    }
}

